/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs;

import edu.umd.cs.findbugs.BugPattern;
import edu.umd.cs.findbugs.BugReportDispatcher;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.CategoryFilteringBugReporter;
import edu.umd.cs.findbugs.ClassScreener;
import edu.umd.cs.findbugs.ConfigurableBugReporter;
import edu.umd.cs.findbugs.DetectorFactory;
import edu.umd.cs.findbugs.DetectorFactoryCollection;
import edu.umd.cs.findbugs.EmacsBugReporter;
import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.FindBugsCommandLine;
import edu.umd.cs.findbugs.HTMLBugReporter;
import edu.umd.cs.findbugs.IFindBugsEngine;
import edu.umd.cs.findbugs.Plugin;
import edu.umd.cs.findbugs.PrintingBugReporter;
import edu.umd.cs.findbugs.Project;
import edu.umd.cs.findbugs.SortedBugCollection;
import edu.umd.cs.findbugs.SortingBugReporter;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.TextUIBugReporter;
import edu.umd.cs.findbugs.TextUIProgressCallback;
import edu.umd.cs.findbugs.XDocsBugReporter;
import edu.umd.cs.findbugs.XMLBugReporter;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.config.UserPreferences;
import edu.umd.cs.findbugs.filter.FilterException;
import edu.umd.cs.findbugs.sarif.SarifBugReporter;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.GZIPOutputStream;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextUICommandLine
extends FindBugsCommandLine {
    private static final String USER_PREFS = "-userPrefs";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final boolean DEBUG = Boolean.getBoolean("textui.debug");
    private static final int PRINTING_REPORTER = 0;
    private static final int SORTING_REPORTER = 1;
    private static final int XML_REPORTER = 2;
    private static final int EMACS_REPORTER = 3;
    private static final int HTML_REPORTER = 4;
    private static final int XDOCS_REPORTER = 5;
    private static final int SARIF_REPORTER = 6;
    private int bugReporterType = 0;
    private boolean relaxedReportingMode = false;
    private boolean useLongBugCodes = false;
    private boolean showProgress = false;
    private boolean xmlWithAbridgedMessages = false;
    private boolean quiet = false;
    private final ClassScreener classScreener = new ClassScreener();
    private final Set<String> enabledBugReporterDecorators = new LinkedHashSet<String>();
    private final Set<String> disabledBugReporterDecorators = new LinkedHashSet<String>();
    private boolean setExitCode = false;
    private boolean noClassOk = false;
    private int priorityThreshold = 2;
    private int rankThreshold = SystemProperties.getInt("findbugs.maxRank", 20);
    private PrintStream outputStream = null;
    private Set<String> bugCategorySet = null;
    private String trainingOutputDir;
    private String trainingInputDir;
    private String releaseName = "";
    private String projectName = "";
    private String sourceInfoFile = null;
    private String redoAnalysisFile = null;
    private boolean mergeSimilarWarnings = true;
    private boolean xargs = false;
    private boolean scanNestedArchives = true;
    private boolean applySuppression;
    private boolean printConfiguration;
    private boolean printVersion;
    Map<String, String> parsedOptions = new LinkedHashMap<String, String>();
    private List<TextUIBugReporter> reporters = new ArrayList<TextUIBugReporter>();
    @CheckForNull
    protected File outputFile;

    public TextUICommandLine() {
        this.addSwitch("-showPlugins", "show list of available detector plugins");
        this.addOption(USER_PREFS, "filename", "user preferences file, e.g /path/to/project/.settings/edu.umd.cs.findbugs.core.prefs for Eclipse projects");
        this.startOptionGroup("Output options:");
        this.addSwitch("-justListOptions", "throw an exception that lists the provided options");
        this.makeOptionUnlisted("-justListOptions");
        this.addSwitch("-timestampNow", "set timestamp of results to be current time");
        this.addSwitch("-quiet", "suppress error messages");
        this.addSwitch("-longBugCodes", "report long bug codes");
        this.addSwitch("-progress", "display progress in terminal window");
        this.addOption("-release", "release name", "set the release name of the analyzed application");
        this.addSwitch("-experimental", "report of any confidence level including experimental bug patterns");
        this.addSwitch("-low", "report warnings of any confidence level");
        this.addSwitch("-medium", "report only medium and high confidence warnings [default]");
        this.addSwitch("-high", "report only high confidence warnings");
        this.addOption("-maxRank", "rank", "only report issues with a bug rank at least as scary as that provided");
        this.addSwitch("-dontCombineWarnings", "Don't combine warnings that differ only in line number");
        this.addSwitch("-sortByClass", "sort warnings by class");
        this.addSwitchWithOptionalExtraPart("-xml", "withMessages", "XML output (optionally with messages)");
        this.addSwitch("-xdocs", "xdoc XML output to use with Apache Maven");
        this.addSwitch("-sarif", "SARIF 2.1.0 output");
        this.addSwitchWithOptionalExtraPart("-html", "stylesheet", "Generate HTML output (default stylesheet is default.xsl)");
        this.addSwitch("-emacs", "Use emacs reporting format");
        this.addSwitch("-relaxed", "Relaxed reporting mode (more false positives!)");
        this.addSwitchWithOptionalExtraPart("-train", "outputDir", "Save training data (experimental); output dir defaults to '.'");
        this.addSwitchWithOptionalExtraPart("-useTraining", "inputDir", "Use training data (experimental); input dir defaults to '.'");
        this.addOption("-redoAnalysis", "filename", "Redo analysis using configuration from previous analysis");
        this.addOption("-sourceInfo", "filename", "Specify source info file (line numbers for fields/classes)");
        this.addOption("-projectName", "project name", "Descriptive name of project");
        this.addOption("-reanalyze", "filename", "redo analysis in provided file");
        this.addOption("-outputFile", "filename", "Save output in named file");
        this.addOption("-output", "filename", "Save output in named file");
        this.makeOptionUnlisted("-outputFile");
        this.addSwitchWithOptionalExtraPart("-nested", "true|false", "analyze nested jar/zip archives (default=true)");
        this.startOptionGroup("Output filtering options:");
        this.addOption("-bugCategories", "cat1[,cat2...]", "only report bugs in given categories");
        this.addOption("-onlyAnalyze", "classes/packages", "only analyze given classes and packages; end with .* to indicate classes in a package, .- to indicate a package prefix");
        this.addOption("-excludeBugs", "baseline bugs", "exclude bugs that are also reported in the baseline xml output");
        this.addOption("-exclude", "filter file", "exclude bugs matching given filter");
        this.addOption("-include", "filter file", "include only bugs matching given filter");
        this.addSwitch("-applySuppression", "Exclude any bugs that match suppression filter loaded from fbp file");
        this.startOptionGroup("Detector (visitor) configuration options:");
        this.addOption("-visitors", "v1[,v2...]", "run only named visitors");
        this.addOption("-omitVisitors", "v1[,v2...]", "omit named visitors");
        this.addOption("-chooseVisitors", "+v1,-v2,...", "selectively enable/disable detectors");
        this.addOption("-choosePlugins", "+p1,-p2,...", "selectively enable/disable plugins");
        this.addOption("-adjustPriority", "v1=(raise|lower)[,...]", "raise/lower priority of warnings for given visitor(s)");
        this.startOptionGroup("Project configuration options:");
        this.addOption("-auxclasspath", "classpath", "set aux classpath for analysis");
        this.addSwitch("-auxclasspathFromInput", "read aux classpath from standard input");
        this.addOption("-auxclasspathFromFile", "filepath", "read aux classpaths from a designated file");
        this.addOption("-sourcepath", "source path", "set source path for analyzed classes");
        this.addSwitch("-exitcode", "set exit code of process");
        this.addSwitch("-noClassOk", "output empty warning file if no classes are specified");
        this.addSwitch("-xargs", "get list of classfiles/jarfiles from standard input rather than command line");
        this.addOption("-analyzeFromFile", "filepath", "get the list of class/jar files from a designated file");
        this.addOption("-bugReporters", "name,name2,-name3", "bug reporter decorators to explicitly enable/disable");
        this.addSwitch("-printConfiguration", "print configuration and exit, without running analysis");
        this.addSwitch("-version", "print version, check for updates and exit, without running analysis");
    }

    @Override
    @Nonnull
    public Project getProject() {
        return this.project;
    }

    public boolean getXargs() {
        return this.xargs;
    }

    public boolean setExitCode() {
        return this.setExitCode;
    }

    public boolean noClassOk() {
        return this.noClassOk;
    }

    public boolean quiet() {
        return this.quiet;
    }

    public boolean applySuppression() {
        return this.applySuppression;
    }

    public boolean justPrintConfiguration() {
        return this.printConfiguration;
    }

    public boolean justPrintVersion() {
        return this.printVersion;
    }

    String handleOutputFilePath(TextUIBugReporter reporter, String optionExtraPart) {
        int index = optionExtraPart.indexOf(61);
        if (index >= 0) {
            Path path = Path.of(optionExtraPart.substring(index + 1), new String[0]).normalize().toAbsolutePath();
            reporter.setOutputTarget(path.toString());
            try {
                OutputStream oStream = Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
                if ("gz".equals(Util.getFileExtension(path.toFile()))) {
                    oStream = new GZIPOutputStream(oStream);
                }
                reporter.setOutputStream(UTF8.printStream(oStream));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            optionExtraPart = optionExtraPart.substring(0, index);
        }
        return optionExtraPart;
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"})
    protected void handleOption(String option, String optionExtraPart) {
        this.parsedOptions.put(option, optionExtraPart);
        if (DEBUG) {
            if (optionExtraPart != null) {
                System.out.println("option " + option + ":" + optionExtraPart);
            } else {
                System.out.println("option " + option);
            }
        }
        if ("-showPlugins".equals(option)) {
            System.out.println("Available plugins:");
            int count = 0;
            Iterator<Plugin> i = DetectorFactoryCollection.instance().pluginIterator();
            while (i.hasNext()) {
                Plugin plugin = i.next();
                System.out.println("  " + plugin.getPluginId() + " (default: " + (plugin.isEnabledByDefault() ? "enabled" : "disabled") + ")");
                if (plugin.getShortDescription() != null) {
                    System.out.println("    Description: " + plugin.getShortDescription());
                }
                if (plugin.getProvider() != null) {
                    System.out.println("    Provider: " + plugin.getProvider());
                }
                if (plugin.getWebsite() != null) {
                    System.out.println("    Website: " + plugin.getWebsite());
                }
                ++count;
            }
            if (count == 0) {
                System.out.println("  No plugins are available (SpotBugs installed incorrectly?)");
            }
            System.exit(0);
        } else if ("-experimental".equals(option)) {
            this.priorityThreshold = 4;
        } else if ("-longBugCodes".equals(option)) {
            this.useLongBugCodes = true;
        } else if ("-progress".equals(option)) {
            this.showProgress = true;
        } else if ("-timestampNow".equals(option)) {
            this.project.setTimestamp(System.currentTimeMillis());
        } else if ("-low".equals(option)) {
            this.priorityThreshold = 3;
        } else if ("-medium".equals(option)) {
            this.priorityThreshold = 2;
        } else if ("-high".equals(option)) {
            this.priorityThreshold = 1;
        } else if ("-dontCombineWarnings".equals(option)) {
            this.mergeSimilarWarnings = false;
        } else if ("-sortByClass".equals(option)) {
            this.bugReporterType = 1;
            SortingBugReporter sortingBugReporter = new SortingBugReporter();
            this.handleOutputFilePath(sortingBugReporter, optionExtraPart);
            this.addDistinctBugReporter(sortingBugReporter);
        } else if ("-xml".equals(option)) {
            this.bugReporterType = 2;
            XMLBugReporter xmlBugReporter = new XMLBugReporter(this.project);
            optionExtraPart = this.handleOutputFilePath(xmlBugReporter, optionExtraPart);
            boolean xmlWithMessages = false;
            boolean xmlMinimal = false;
            if (!"".equals(optionExtraPart)) {
                if ("withMessages".equals(optionExtraPart)) {
                    xmlWithMessages = true;
                } else if ("withAbridgedMessages".equals(optionExtraPart)) {
                    xmlWithMessages = true;
                    this.xmlWithAbridgedMessages = true;
                } else if ("minimal".equals(optionExtraPart)) {
                    xmlMinimal = true;
                } else {
                    throw new IllegalArgumentException("Unknown option: -xml:" + optionExtraPart);
                }
            }
            xmlBugReporter.setAddMessages(xmlWithMessages);
            xmlBugReporter.setMinimalXML(xmlMinimal);
            this.addDistinctBugReporter(xmlBugReporter);
        } else if ("-emacs".equals(option)) {
            EmacsBugReporter emacsBugReporter = new EmacsBugReporter();
            this.handleOutputFilePath(emacsBugReporter, optionExtraPart);
            this.addDistinctBugReporter(emacsBugReporter);
            this.bugReporterType = 3;
        } else if ("-relaxed".equals(option)) {
            this.relaxedReportingMode = true;
        } else if ("-train".equals(option)) {
            this.trainingOutputDir = !"".equals(optionExtraPart) ? optionExtraPart : ".";
        } else if ("-useTraining".equals(option)) {
            this.trainingInputDir = !"".equals(optionExtraPart) ? optionExtraPart : ".";
        } else if ("-html".equals(option)) {
            this.bugReporterType = 4;
            HTMLBugReporter htmlBugReporter = new HTMLBugReporter(this.project, "default.xsl");
            if (!"".equals(optionExtraPart = this.handleOutputFilePath(htmlBugReporter, optionExtraPart))) {
                htmlBugReporter.setStylesheet(optionExtraPart);
            }
            this.addDistinctBugReporter(htmlBugReporter);
        } else if ("-xdocs".equals(option)) {
            this.bugReporterType = 5;
            XDocsBugReporter xDocsBugReporter = new XDocsBugReporter(this.project);
            this.handleOutputFilePath(xDocsBugReporter, optionExtraPart);
            this.addDistinctBugReporter(xDocsBugReporter);
        } else if ("-sarif".equals(option)) {
            this.bugReporterType = 6;
            SarifBugReporter sarifBugReporter = new SarifBugReporter(this.project);
            this.handleOutputFilePath(sarifBugReporter, optionExtraPart);
            this.addDistinctBugReporter(sarifBugReporter);
        } else if ("-applySuppression".equals(option)) {
            this.applySuppression = true;
        } else if ("-quiet".equals(option)) {
            this.quiet = true;
        } else if ("-nested".equals(option)) {
            this.scanNestedArchives = "".equals(optionExtraPart) || Boolean.parseBoolean(optionExtraPart);
        } else if ("-exitcode".equals(option)) {
            this.setExitCode = true;
        } else if ("-auxclasspathFromInput".equals(option)) {
            try {
                String s;
                BufferedReader in = UTF8.bufferedReader(System.in);
                while ((s = in.readLine()) != null) {
                    this.addAuxClassPathEntries(s);
                }
                in.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        } else if ("-noClassOk".equals(option)) {
            this.noClassOk = true;
        } else if ("-xargs".equals(option)) {
            this.xargs = true;
        } else {
            if ("-justListOptions".equals(option)) {
                throw new RuntimeException("textui options are: " + String.valueOf(this.parsedOptions));
            }
            if ("-printConfiguration".equals(option)) {
                this.printConfiguration = true;
            } else if ("-version".equals(option)) {
                this.printVersion = true;
            } else {
                if (DEBUG) {
                    System.out.println("XXX: " + option);
                }
                super.handleOption(option, optionExtraPart);
            }
        }
    }

    @Override
    @SuppressFBWarnings(value={"DM_EXIT"})
    protected void handleOptionWithArgument(String option, String argument) throws IOException {
        this.parsedOptions.put(option, argument);
        if (DEBUG) {
            System.out.println("option " + option + " is " + argument);
        }
        if ("-outputFile".equals(option) || "-output".equals(option)) {
            if (this.outputFile != null) {
                throw new IllegalArgumentException("output set twice; to " + String.valueOf(this.outputFile) + " and to " + argument);
            }
            this.outputFile = new File(argument);
            String fileName = this.outputFile.getName();
            String extension = Util.getFileExtensionIgnoringGz(this.outputFile);
            if (this.bugReporterType == 0 && ("xml".equals(extension) || "fba".equals(extension))) {
                this.bugReporterType = 2;
            }
            try {
                FilterOutputStream oStream = new BufferedOutputStream(new FileOutputStream(this.outputFile));
                if (fileName.endsWith(".gz")) {
                    oStream = new GZIPOutputStream(oStream);
                }
                this.outputStream = UTF8.printStream(oStream);
            }
            catch (IOException e) {
                System.err.println("Couldn't open " + String.valueOf(this.outputFile) + " for output: " + e.toString());
                System.exit(1);
            }
        } else if ("-bugReporters".equals(option)) {
            for (String s : argument.split(",")) {
                if (s.charAt(0) == '-') {
                    this.disabledBugReporterDecorators.add(s.substring(1));
                    continue;
                }
                if (s.charAt(0) == '+') {
                    this.enabledBugReporterDecorators.add(s.substring(1));
                    continue;
                }
                this.enabledBugReporterDecorators.add(s);
            }
        } else if ("-maxRank".equals(option)) {
            this.rankThreshold = Integer.parseInt(argument);
        } else if ("-projectName".equals(option)) {
            this.projectName = argument;
        } else if ("-release".equals(option)) {
            this.releaseName = argument;
        } else if ("-redoAnalysis".equals(option)) {
            this.redoAnalysisFile = argument;
        } else if ("-sourceInfo".equals(option)) {
            this.sourceInfoFile = argument;
        } else if ("-visitors".equals(option) || "-omitVisitors".equals(option)) {
            boolean omit = "-omitVisitors".equals(option);
            if (!omit) {
                this.getUserPreferences().enableAllDetectors(false);
            }
            StringTokenizer tok = new StringTokenizer(argument, ",");
            while (tok.hasMoreTokens()) {
                String visitorName = tok.nextToken().trim();
                DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(visitorName);
                if (factory == null) {
                    throw new IllegalArgumentException("Unknown detector: " + visitorName);
                }
                this.getUserPreferences().enableDetector(factory, !omit);
            }
        } else if ("-chooseVisitors".equals(option)) {
            this.choose(argument, "Detector choices", (enabled, what) -> {
                DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(what);
                if (factory == null) {
                    throw new IllegalArgumentException("Unknown detector: " + what);
                }
                if (FindBugs.DEBUG) {
                    System.err.println("Detector " + factory.getShortName() + " " + (enabled ? "enabled" : "disabled") + ", userPreferences=" + System.identityHashCode(this.getUserPreferences()));
                }
                this.getUserPreferences().enableDetector(factory, enabled);
            });
        } else if ("-choosePlugins".equals(option)) {
            this.choose(argument, "Plugin choices", (enabled, what) -> {
                Plugin plugin = DetectorFactoryCollection.instance().getPluginById(what);
                if (plugin == null) {
                    throw new IllegalArgumentException("Unknown plugin: " + what);
                }
                plugin.setGloballyEnabled(enabled);
            });
        } else if ("-adjustPriority".equals(option)) {
            StringTokenizer tok = new StringTokenizer(argument, ",");
            while (tok.hasMoreTokens()) {
                int adjustmentAmount;
                String token = tok.nextToken();
                int eq = token.indexOf(61);
                if (eq < 0) {
                    throw new IllegalArgumentException("Illegal priority adjustment: " + token);
                }
                String adjustmentTarget = token.substring(0, eq);
                String adjustment = token.substring(eq + 1);
                if ("raise".equals(adjustment)) {
                    adjustmentAmount = -1;
                } else if ("lower".equals(adjustment)) {
                    adjustmentAmount = 1;
                } else if ("suppress".equals(adjustment)) {
                    adjustmentAmount = 100;
                } else {
                    throw new IllegalArgumentException("Illegal priority adjustment value: " + adjustment);
                }
                DetectorFactory factory = DetectorFactoryCollection.instance().getFactory(adjustmentTarget);
                if (factory != null) {
                    factory.setPriorityAdjustment(adjustmentAmount);
                    continue;
                }
                DetectorFactoryCollection i18n = DetectorFactoryCollection.instance();
                BugPattern pattern = i18n.lookupBugPattern(adjustmentTarget);
                if (pattern == null) {
                    throw new IllegalArgumentException("Unknown detector: " + adjustmentTarget);
                }
                pattern.adjustPriority(adjustmentAmount);
            }
        } else if ("-bugCategories".equals(option)) {
            this.bugCategorySet = FindBugs.handleBugCategories(argument);
        } else if ("-onlyAnalyze".equals(option)) {
            StringTokenizer tok = new StringTokenizer(argument, ",");
            while (tok.hasMoreTokens()) {
                String item = tok.nextToken();
                if (item.endsWith(".-")) {
                    this.classScreener.addAllowedPrefix(item.substring(0, item.length() - 1));
                    continue;
                }
                if (item.endsWith(".*")) {
                    this.classScreener.addAllowedPackage(item.substring(0, item.length() - 1));
                    continue;
                }
                this.classScreener.addAllowedClass(item);
            }
        } else if ("-exclude".equals(option)) {
            this.project.getConfiguration().getExcludeFilterFiles().put(argument, true);
        } else if ("-excludeBugs".equals(option)) {
            this.project.getConfiguration().getExcludeBugsFiles().put(argument, true);
        } else if ("-include".equals(option)) {
            this.project.getConfiguration().getIncludeFilterFiles().put(argument, true);
        } else if ("-auxclasspathFromFile".equals(option)) {
            this.handleAuxClassPathFromFile(argument);
        } else if ("-analyzeFromFile".equals(option)) {
            this.handleAnalyzeFromFile(argument);
        } else if ("-auxclasspath".equals(option)) {
            this.addAuxClassPathEntries(argument);
        } else if ("-sourcepath".equals(option)) {
            StringTokenizer tok = new StringTokenizer(argument, File.pathSeparator);
            ArrayList<String> sourceDirs = new ArrayList<String>();
            while (tok.hasMoreTokens()) {
                sourceDirs.add(new File(tok.nextToken()).getAbsolutePath());
            }
            this.project.addSourceDirs(sourceDirs);
        } else if (USER_PREFS.equals(option)) {
            UserPreferences prefs = UserPreferences.createDefaultUserPreferences();
            prefs.read(new FileInputStream(argument));
            this.project.setConfiguration(prefs);
        } else {
            super.handleOptionWithArgument(option, argument);
        }
    }

    private void addAuxClassPathEntries(String argument) {
        StringTokenizer tok = new StringTokenizer(argument, File.pathSeparator);
        while (tok.hasMoreTokens()) {
            this.project.addAuxClasspathEntry(tok.nextToken());
        }
    }

    private void choose(String argument, String desc, Chooser chooser) {
        StringTokenizer tok = new StringTokenizer(argument, ",");
        while (tok.hasMoreTokens()) {
            String what = tok.nextToken().trim();
            if (!what.startsWith("+") && !what.startsWith("-")) {
                throw new IllegalArgumentException(desc + " must start with \"+\" or \"-\" (saw " + what + ")");
            }
            boolean enabled = what.startsWith("+");
            chooser.choose(enabled, what.substring(1));
        }
    }

    public void configureEngine(IFindBugsEngine findBugs) throws IOException, FilterException {
        ConfigurableBugReporter textuiBugReporter;
        findBugs.setDetectorFactoryCollection(DetectorFactoryCollection.instance());
        if (this.redoAnalysisFile != null) {
            SortedBugCollection bugs = new SortedBugCollection();
            try {
                bugs.readXML(this.redoAnalysisFile);
            }
            catch (DocumentException e) {
                IOException ioe = new IOException("Unable to parse " + this.redoAnalysisFile);
                ioe.initCause(e);
                throw ioe;
            }
            this.project = bugs.getProject().duplicate();
        }
        switch (this.bugReporterType) {
            case 0: {
                this.addDistinctBugReporter(new PrintingBugReporter());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        if (this.reporters.isEmpty()) {
            throw new IllegalStateException("No bug reporter configured");
        }
        ConfigurableBugReporter configurableBugReporter = textuiBugReporter = this.reporters.size() == 1 ? (ConfigurableBugReporter)this.reporters.get(0) : new BugReportDispatcher(this.reporters);
        if (this.quiet) {
            textuiBugReporter.setErrorVerbosity(0);
        }
        textuiBugReporter.setPriorityThreshold(this.priorityThreshold);
        textuiBugReporter.setRankThreshold(this.rankThreshold);
        textuiBugReporter.setUseLongBugCodes(this.useLongBugCodes);
        findBugs.setRankThreshold(this.rankThreshold);
        if (this.outputStream != null) {
            this.logger.warn("-output option and -outputFile option are deprecated. Set file path to each option for reporter.");
            textuiBugReporter.setOutputStream(this.outputStream);
        }
        BugReporter bugReporter = textuiBugReporter;
        if (this.bugCategorySet != null) {
            bugReporter = new CategoryFilteringBugReporter(bugReporter, this.bugCategorySet);
        }
        findBugs.setBugReporter(bugReporter);
        findBugs.setProject(this.project);
        if (this.showProgress) {
            findBugs.setProgressCallback(new TextUIProgressCallback(System.out));
        }
        findBugs.setClassScreener(this.classScreener);
        findBugs.setRelaxedReportingMode(this.relaxedReportingMode);
        findBugs.setAbridgedMessages(this.xmlWithAbridgedMessages);
        if (this.trainingOutputDir != null) {
            findBugs.enableTrainingOutput(this.trainingOutputDir);
        }
        if (this.trainingInputDir != null) {
            findBugs.enableTrainingInput(this.trainingInputDir);
        }
        if (this.sourceInfoFile != null) {
            findBugs.setSourceInfoFile(this.sourceInfoFile);
        }
        findBugs.setAnalysisFeatureSettings(this.settingList);
        findBugs.setMergeSimilarWarnings(this.mergeSimilarWarnings);
        findBugs.setReleaseName(this.releaseName);
        findBugs.setProjectName(this.projectName);
        findBugs.setScanNestedArchives(this.scanNestedArchives);
        findBugs.setNoClassOk(this.noClassOk);
        findBugs.setBugReporterDecorators(this.enabledBugReporterDecorators, this.disabledBugReporterDecorators);
        if (this.applySuppression) {
            findBugs.setApplySuppression(true);
        }
        UserPreferences userPreferences = this.getUserPreferences();
        if (this.parsedOptions.containsKey(USER_PREFS)) {
            textuiBugReporter.setPriorityThreshold(userPreferences.getUserDetectorThreshold());
            textuiBugReporter.setRankThreshold(userPreferences.getFilterSettings().getMinRank());
            findBugs.setAnalysisFeatureSettings(userPreferences.getAnalysisFeatureSettings());
            findBugs.setMergeSimilarWarnings(userPreferences.getMergeSimilarWarnings());
            userPreferences.resolveRelativePaths(this.parsedOptions.get(USER_PREFS));
            List<String> overriddenOptions = List.of("-maxRank", "-low", "-medium", "-high", "-dontCombineWarnings");
            if (this.parsedOptions.keySet().stream().anyMatch(option -> overriddenOptions.contains(option))) {
                FindBugs.LOG.warning("Following given command line options are overridden by the user preferences file: '" + String.valueOf(overriddenOptions) + "'. Options from file " + this.parsedOptions.get(USER_PREFS) + " will be used.");
            }
        }
        findBugs.setUserPreferences(userPreferences);
        findBugs.finishSettings();
    }

    public void handleXArgs() throws IOException {
        if (this.getXargs()) {
            try (BufferedReader in = UTF8.bufferedReader(System.in);){
                String s;
                while ((s = in.readLine()) != null) {
                    this.project.addFile(s);
                }
            }
        }
    }

    private void handleAuxClassPathFromFile(String filePath) throws IOException {
        try (BufferedReader in = new BufferedReader(UTF8.fileReader(filePath));){
            String s;
            while ((s = in.readLine()) != null) {
                this.project.addAuxClasspathEntry(s);
            }
        }
    }

    private void handleAnalyzeFromFile(String filePath) throws IOException {
        try (BufferedReader in = new BufferedReader(UTF8.fileReader(filePath));){
            String s;
            while ((s = in.readLine()) != null) {
                this.project.addFile(s);
            }
        }
    }

    private UserPreferences getUserPreferences() {
        return this.project.getConfiguration();
    }

    private void addDistinctBugReporter(TextUIBugReporter reporter) {
        for (TextUIBugReporter known : this.reporters) {
            if (!known.isDuplicateOf(reporter)) continue;
            this.logger.warn("Attempted to add multiple reporters writing to the same file at {}. First reporter wins.", (Object)known.getOutputTarget());
            return;
        }
        this.reporters.add(reporter);
    }

    private static interface Chooser {
        public void choose(boolean var1, String var2);
    }
}

