/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicAbstractDataflowAnalysis;
import edu.umd.cs.findbugs.ba.BasicBlock;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Edge;
import edu.umd.cs.findbugs.ba.EdgeChooser;
import java.util.BitSet;
import java.util.Iterator;
import javax.annotation.CheckForNull;
import org.apache.bcel.generic.InstructionHandle;

public abstract class AbstractDominatorsAnalysis
extends BasicAbstractDataflowAnalysis<BitSet> {
    private final CFG cfg;
    private final EdgeChooser edgeChooser;

    protected AbstractDominatorsAnalysis(CFG cfg, boolean ignoreExceptionEdges) {
        this(cfg, edge -> !ignoreExceptionEdges || !edge.isExceptionEdge());
    }

    protected AbstractDominatorsAnalysis(CFG cfg, EdgeChooser edgeChooser) {
        this.cfg = cfg;
        this.edgeChooser = edgeChooser;
    }

    @Override
    public BitSet createFact() {
        return new BitSet();
    }

    @Override
    public void copy(BitSet source, BitSet dest) {
        dest.clear();
        dest.or(source);
    }

    @Override
    public void initEntryFact(BitSet result) {
        result.clear();
    }

    @Override
    public boolean isTop(BitSet fact) {
        return fact.get(this.cfg.getNumBasicBlocks());
    }

    @Override
    public void makeFactTop(BitSet fact) {
        fact.set(this.cfg.getNumBasicBlocks());
    }

    @Override
    public boolean same(BitSet fact1, BitSet fact2) {
        return fact1.equals(fact2);
    }

    @Override
    public void transfer(BasicBlock basicBlock, @CheckForNull InstructionHandle end, BitSet start, BitSet result) throws DataflowAnalysisException {
        this.copy(start, result);
        if (!this.isTop(result)) {
            result.set(basicBlock.getLabel());
        }
    }

    @Override
    public void meetInto(BitSet fact, Edge edge, BitSet result) throws DataflowAnalysisException {
        if (!this.edgeChooser.choose(edge)) {
            return;
        }
        if (this.isTop(fact)) {
            return;
        }
        if (this.isTop(result)) {
            this.copy(fact, result);
        } else {
            result.and(fact);
        }
    }

    public BitSet getAllDominatorsOf(BasicBlock block) {
        return (BitSet)this.getResultFact(block);
    }

    public BitSet getAllDominatedBy(BasicBlock dominator) {
        BitSet allDominated = new BitSet();
        Iterator<BasicBlock> i = this.cfg.blockIterator();
        while (i.hasNext()) {
            BasicBlock block = i.next();
            BitSet dominators = (BitSet)this.getResultFact(block);
            if (!dominators.get(dominator.getLabel())) continue;
            allDominated.set(block.getLabel());
        }
        return allDominated;
    }
}

