/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.ba.BasicBlock;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.bcel.generic.InstructionHandle;

public class Location
implements Comparable<Location> {
    private final InstructionHandle handle;
    private final BasicBlock basicBlock;
    private int hash;

    public Location(@Nonnull InstructionHandle handle, @Nonnull BasicBlock basicBlock) {
        Objects.requireNonNull(handle, "handle cannot be null");
        Objects.requireNonNull(basicBlock, "basicBlock cannot be null");
        this.handle = handle;
        this.basicBlock = basicBlock;
    }

    public static Location getFirstLocation(@Nonnull BasicBlock basicBlock) {
        InstructionHandle location = basicBlock.getFirstInstruction();
        if (location == null) {
            return null;
        }
        return new Location(location, basicBlock);
    }

    public static Location getLastLocation(@Nonnull BasicBlock basicBlock) {
        InstructionHandle lastInstruction = basicBlock.getLastInstruction();
        if (lastInstruction == null) {
            return null;
        }
        return new Location(lastInstruction, basicBlock);
    }

    @Nonnull
    public InstructionHandle getHandle() {
        return this.handle;
    }

    @Nonnull
    public BasicBlock getBasicBlock() {
        return this.basicBlock;
    }

    public boolean isFirstInstructionInBasicBlock() {
        return !this.basicBlock.isEmpty() && this.handle == this.basicBlock.getFirstInstruction();
    }

    public boolean isLastInstructionInBasicBlock() {
        return !this.basicBlock.isEmpty() && this.handle == this.basicBlock.getLastInstruction();
    }

    @Override
    public int compareTo(Location other) {
        return this.handle.getPosition() - other.handle.getPosition();
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = System.identityHashCode(this.basicBlock) + this.handle.getPosition();
            return this.hash;
        }
        return this.hash;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Location)) {
            return false;
        }
        Location other = (Location)o;
        return this.basicBlock == other.basicBlock && this.handle == other.handle;
    }

    public String toString() {
        return this.handle.toString() + " in basic block " + this.basicBlock.getLabel();
    }

    public String toCompactString() {
        return this.basicBlock.getLabel() + ":" + this.handle.getPosition();
    }
}

