/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.ba.URLClassPathRepository;
import edu.umd.cs.findbugs.util.Archive;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class URLClassPath
implements AutoCloseable,
Serializable {
    private static final long serialVersionUID = 1L;
    private final List<Entry> entryList;
    private final Set<String> classesThatCantBeFound = new HashSet<String>();

    public URLClassPath() {
        this.entryList = new LinkedList<Entry>();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addURL(String fileName) throws IOException {
        void var5_11;
        String fileExtension;
        boolean isArchive;
        String protocol = URLClassPath.getURLProtocol((String)fileName);
        if (protocol == null) {
            fileName = "file:" + (String)fileName;
            protocol = "file";
        }
        boolean bl = isArchive = (fileExtension = URLClassPath.getFileExtension((String)fileName)) != null && URLClassPath.isArchiveExtension(fileExtension);
        if ("file".equals(protocol)) {
            String localFileName = ((String)fileName).substring("file:".length());
            if (((String)fileName).endsWith("/") || new File(localFileName).isDirectory()) {
                LocalDirectoryEntry localDirectoryEntry = new LocalDirectoryEntry(localFileName);
            } else {
                if (!isArchive) throw new IOException("Classpath entry " + (String)fileName + " is not a directory or archive file");
                LocalArchiveEntry localArchiveEntry = new LocalArchiveEntry(localFileName);
            }
        } else if (((String)fileName).endsWith("/")) {
            RemoteDirectoryEntry remoteDirectoryEntry = new RemoteDirectoryEntry(new URL((String)fileName));
        } else {
            if (!isArchive) throw new IOException("Classpath entry " + (String)fileName + "  is not a remote directory or archive file");
            RemoteArchiveEntry remoteArchiveEntry = new RemoteArchiveEntry(new URL((String)fileName));
        }
        this.entryList.add((Entry)var5_11);
    }

    public String getClassPath() {
        StringBuilder buf = new StringBuilder();
        for (Entry entry : this.entryList) {
            if (buf.length() > 0) {
                buf.append(File.pathSeparator);
            }
            buf.append(entry.getURL());
        }
        return buf.toString();
    }

    private InputStream getInputStreamForResource(String resourceName) {
        for (Entry entry : this.entryList) {
            try {
                InputStream in = entry.openStream(resourceName);
                if (in == null) continue;
                if (URLClassPathRepository.DEBUG) {
                    System.out.println("\t==> found " + resourceName + " in " + entry.getURL());
                }
                return in;
            }
            catch (IOException iOException) {
            }
        }
        if (URLClassPathRepository.DEBUG) {
            System.out.println("\t==> could not find " + resourceName + " on classpath");
        }
        return null;
    }

    public JavaClass lookupClass(String className) throws ClassNotFoundException {
        if (this.classesThatCantBeFound.contains(className)) {
            throw new ClassNotFoundException("Error while looking for class " + className + ": class not found");
        }
        String resourceName = ClassName.toSlashedClassName(className) + ".class";
        InputStream in = null;
        boolean parsedClass = false;
        try {
            in = this.getInputStreamForResource(resourceName);
            if (in == null) {
                this.classesThatCantBeFound.add(className);
                throw new ClassNotFoundException("Error while looking for class " + className + ": class not found");
            }
            ClassParser classParser = new ClassParser(in, resourceName);
            JavaClass javaClass = classParser.parse();
            parsedClass = true;
            JavaClass javaClass2 = javaClass;
            return javaClass2;
        }
        catch (IOException e) {
            this.classesThatCantBeFound.add(className);
            throw new ClassNotFoundException("IOException while looking for class " + className, e);
        }
        finally {
            if (in != null && !parsedClass) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    @Override
    public void close() {
        for (Entry entry : this.entryList) {
            entry.close();
        }
        this.entryList.clear();
    }

    public static String getURLProtocol(String urlString) {
        String specifiedProtocol;
        String protocol = null;
        int firstColon = urlString.indexOf(58);
        if (firstColon >= 0 && FindBugs.knownURLProtocolSet.contains(specifiedProtocol = urlString.substring(0, firstColon))) {
            protocol = specifiedProtocol;
        }
        return protocol;
    }

    public static String getFileExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        return lastDot >= 0 ? fileName.substring(lastDot) : null;
    }

    public static boolean isArchiveExtension(String fileExtension) {
        return Archive.ARCHIVE_EXTENSION_SET.contains(fileExtension);
    }

    private static class LocalDirectoryEntry
    implements Entry {
        private final String dirName;

        public LocalDirectoryEntry(String dirName) throws IOException {
            this.dirName = dirName;
            if (!new File(dirName).isDirectory()) {
                throw new IOException(dirName + " is not a directory");
            }
        }

        @Override
        public InputStream openStream(String resourceName) throws IOException {
            File file = new File(this.dirName, resourceName);
            if (!file.exists()) {
                return null;
            }
            return new BufferedInputStream(new FileInputStream(file));
        }

        @Override
        public String getURL() {
            return this.dirName;
        }

        @Override
        public void close() {
        }
    }

    private static class LocalArchiveEntry
    implements Entry {
        private ZipFile zipFile;

        public LocalArchiveEntry(String fileName) throws IOException {
            try {
                this.zipFile = new ZipFile(fileName);
            }
            catch (IOException e) {
                IOException ioe = new IOException("Could not open archive file " + fileName);
                ioe.initCause(e);
                throw ioe;
            }
        }

        @Override
        public InputStream openStream(String resourceName) throws IOException {
            ZipEntry zipEntry = this.zipFile.getEntry(resourceName);
            if (zipEntry == null) {
                return null;
            }
            return this.zipFile.getInputStream(zipEntry);
        }

        @Override
        public String getURL() {
            return this.zipFile.getName();
        }

        @Override
        public void close() {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class RemoteDirectoryEntry
    implements Entry {
        private final URL remoteDirURL;

        public RemoteDirectoryEntry(URL remoteDirURL) {
            this.remoteDirURL = remoteDirURL;
        }

        @Override
        public InputStream openStream(String resourceName) throws IOException {
            URL remoteFileURL = new URL(this.remoteDirURL.toString() + resourceName);
            try {
                return remoteFileURL.openStream();
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public String getURL() {
            return this.remoteDirURL.toString();
        }

        @Override
        public void close() {
        }
    }

    private static class RemoteArchiveEntry
    implements Entry {
        private final URL remoteArchiveURL;

        public RemoteArchiveEntry(URL remoteArchiveURL) {
            this.remoteArchiveURL = remoteArchiveURL;
        }

        @Override
        public InputStream openStream(String resourceName) throws IOException {
            URL remoteFileURL = new URL("jar:" + this.remoteArchiveURL.toString() + "/" + resourceName);
            try {
                return remoteFileURL.openStream();
            }
            catch (IOException e) {
                return null;
            }
        }

        @Override
        public String getURL() {
            return this.remoteArchiveURL.toString();
        }

        @Override
        public void close() {
        }
    }

    private static interface Entry
    extends AutoCloseable {
        public InputStream openStream(String var1) throws IOException;

        public String getURL();

        @Override
        public void close();
    }
}

