/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.ba.Frame;
import edu.umd.cs.findbugs.ba.npe.IsNullConditionDecision;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysisFeatures;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import edu.umd.cs.findbugs.util.Strings;
import edu.umd.cs.findbugs.util.Util;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class IsNullValueFrame
extends Frame<IsNullValue> {
    private IsNullConditionDecision decision;
    private final boolean trackValueNumbers;
    private Map<ValueNumber, IsNullValue> knownValueMap;

    public boolean isTrackValueNumbers() {
        return this.trackValueNumbers;
    }

    public IsNullValueFrame(int numLocals, boolean trackValueNumbers) {
        super(numLocals);
        this.trackValueNumbers = trackValueNumbers;
        if (trackValueNumbers) {
            this.knownValueMap = new HashMap<ValueNumber, IsNullValue>(3);
        }
    }

    public void cleanStaleKnowledge(ValueNumberFrame vnaFrameAfter) {
        if (vnaFrameAfter.isTop() && !this.isTop()) {
            throw new IllegalArgumentException("VNA frame is top");
        }
        if (!this.trackValueNumbers) {
            return;
        }
        if (!ValueNumberAnalysisFeatures.REDUNDANT_LOAD_ELIMINATION) {
            return;
        }
        Iterator<ValueNumber> i = this.knownValueMap.keySet().iterator();
        while (i.hasNext()) {
            ValueNumber v = i.next();
            if (vnaFrameAfter.getLoad(v) != null) continue;
            if (IsNullValueAnalysis.DEBUG) {
                System.out.println("PURGING " + String.valueOf(v));
            }
            i.remove();
        }
    }

    @Override
    public void setTop() {
        super.setTop();
        if (this.trackValueNumbers) {
            this.knownValueMap.clear();
        }
        this.decision = null;
    }

    public void toExceptionValues() {
        for (int i = 0; i < this.getNumSlots(); ++i) {
            this.setValue(i, ((IsNullValue)this.getValue(i)).toExceptionValue());
        }
        if (this.trackValueNumbers) {
            HashMap<ValueNumber, IsNullValue> replaceMap = new HashMap<ValueNumber, IsNullValue>();
            for (Map.Entry<ValueNumber, IsNullValue> entry : this.knownValueMap.entrySet()) {
                replaceMap.put(entry.getKey(), entry.getValue().toExceptionValue());
            }
            this.knownValueMap = replaceMap;
        }
    }

    public void setDecision(@CheckForNull IsNullConditionDecision decision) {
        this.decision = decision;
    }

    @CheckForNull
    public IsNullConditionDecision getDecision() {
        return this.decision;
    }

    public void setKnownValue(@Nonnull ValueNumber valueNumber, @Nonnull IsNullValue knownValue) {
        assert (this.trackValueNumbers);
        if (valueNumber == null || knownValue == null) {
            throw new NullPointerException();
        }
        this.knownValueMap.put(valueNumber, knownValue);
        if (IsNullValueAnalysis.DEBUG) {
            System.out.println("Updated information for " + String.valueOf(valueNumber));
            System.out.println("                    now " + String.valueOf(this));
        }
    }

    public void useNewValueNumberForLoad(ValueNumber oldValueNumber, ValueNumber newValueNumber) {
        if (oldValueNumber == null || newValueNumber == null) {
            throw new NullPointerException();
        }
        if (newValueNumber.equals(oldValueNumber) || !this.trackValueNumbers) {
            return;
        }
        IsNullValue isNullValue = this.knownValueMap.get(oldValueNumber);
        if (isNullValue != null) {
            this.knownValueMap.put(newValueNumber, isNullValue);
            this.knownValueMap.remove(oldValueNumber);
        }
    }

    @CheckForNull
    public IsNullValue getKnownValue(ValueNumber valueNumber) {
        assert (this.trackValueNumbers);
        return this.knownValueMap.get(valueNumber);
    }

    public Collection<ValueNumber> getKnownValues() {
        if (this.trackValueNumbers) {
            return this.knownValueMap.keySet();
        }
        return Collections.emptySet();
    }

    public Collection<Map.Entry<ValueNumber, IsNullValue>> getKnownValueMapEntrySet() {
        if (this.trackValueNumbers) {
            return this.knownValueMap.entrySet();
        }
        return Collections.emptySet();
    }

    public void mergeKnownValuesWith(IsNullValueFrame otherFrame) {
        assert (this.trackValueNumbers);
        if (IsNullValueAnalysis.DEBUG) {
            System.out.println("merge");
            System.out.println("     " + String.valueOf(this));
            System.out.println(" with" + String.valueOf(otherFrame));
        }
        HashMap<ValueNumber, IsNullValue> replaceMap = new HashMap<ValueNumber, IsNullValue>();
        for (Map.Entry<ValueNumber, IsNullValue> entry : this.knownValueMap.entrySet()) {
            IsNullValue otherKnownValue = otherFrame.knownValueMap.get(entry.getKey());
            if (otherKnownValue == null) {
                if (!IsNullValueAnalysis.DEBUG) continue;
                System.out.println("No match for " + String.valueOf(entry.getKey()));
                continue;
            }
            IsNullValue mergedValue = IsNullValue.merge(entry.getValue(), otherKnownValue);
            replaceMap.put(entry.getKey(), mergedValue);
            if (!IsNullValueAnalysis.DEBUG || mergedValue.equals(entry.getValue())) continue;
            System.out.println("Updated information for " + String.valueOf(entry.getKey()));
            System.out.println("                    was " + String.valueOf(entry.getValue()));
            System.out.println("           merged value " + String.valueOf(mergedValue));
        }
        this.knownValueMap.clear();
        this.knownValueMap.putAll(replaceMap);
        if (IsNullValueAnalysis.DEBUG) {
            System.out.println("resulting in " + String.valueOf(this));
        }
    }

    @Override
    public void copyFrom(Frame<IsNullValue> other) {
        super.copyFrom(other);
        this.decision = ((IsNullValueFrame)other).decision;
        if (this.trackValueNumbers) {
            this.knownValueMap = Util.makeSmallHashMap(((IsNullValueFrame)other).knownValueMap);
        }
    }

    @Override
    public boolean sameAs(Frame<IsNullValue> other) {
        if (!(other instanceof IsNullValueFrame)) {
            return false;
        }
        if (!super.sameAs(other)) {
            return false;
        }
        IsNullValueFrame o2 = (IsNullValueFrame)other;
        if (!Objects.equals(this.decision, o2.decision)) {
            return false;
        }
        return !this.trackValueNumbers || Objects.equals(this.knownValueMap, o2.knownValueMap);
    }

    @Override
    public String toString() {
        Object result = super.toString();
        if (this.decision != null) {
            result = (String)result + ", [decision=" + this.decision.toString() + "]";
        }
        if (this.knownValueMap != null) {
            StringBuilder buf = new StringBuilder();
            buf.append("{");
            boolean first = true;
            for (Map.Entry<ValueNumber, IsNullValue> entry : this.knownValueMap.entrySet()) {
                if (!first) {
                    buf.append(", ");
                } else {
                    first = false;
                }
                buf.append(Strings.trimComma(entry.getKey().toString()));
                buf.append("->");
                buf.append(Strings.trimComma(entry.getValue().toString()));
            }
            buf.append("}");
            result = (String)result + ", [known=" + buf.toString() + "]";
        }
        return result;
    }

    public void downgradeOnControlSplit() {
        int numSlots = this.getNumSlots();
        for (int i = 0; i < numSlots; ++i) {
            IsNullValue value = (IsNullValue)this.getValue(i);
            value = value.downgradeOnControlSplit();
            this.setValue(i, value);
        }
        if (this.knownValueMap != null) {
            for (Map.Entry<ValueNumber, IsNullValue> entry : this.knownValueMap.entrySet()) {
                entry.setValue(entry.getValue().downgradeOnControlSplit());
            }
        }
    }

    static class PointerEqualityInfo {
        final ValueNumber addr1;
        final ValueNumber addr2;
        final boolean areEqual;

        public PointerEqualityInfo(ValueNumber addr1, ValueNumber addr2, boolean areEqual) {
            if (addr1.getNumber() > addr2.getNumber()) {
                ValueNumber tmp = addr1;
                addr1 = addr2;
                addr2 = tmp;
            }
            this.addr1 = addr1;
            this.addr2 = addr2;
            this.areEqual = areEqual;
        }

        public int hashCode() {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof PointerEqualityInfo)) {
                return false;
            }
            PointerEqualityInfo other = (PointerEqualityInfo)obj;
            return this.addr1.equals(other.addr1) && this.addr2.equals(other.addr2) && this.areEqual == other.areEqual;
        }
    }
}

