/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.SystemProperties;
import edu.umd.cs.findbugs.ba.AbstractFrameModelingVisitor;
import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.AssertionMethods;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Hierarchy2;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.NullnessAnnotation;
import edu.umd.cs.findbugs.ba.XFactory;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.XMethod;
import edu.umd.cs.findbugs.ba.deref.UnconditionalValueDerefAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValue;
import edu.umd.cs.findbugs.ba.npe.IsNullValueAnalysis;
import edu.umd.cs.findbugs.ba.npe.IsNullValueFrame;
import edu.umd.cs.findbugs.ba.type.TypeDataflow;
import edu.umd.cs.findbugs.ba.type.TypeFrame;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysisFeatures;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import java.util.Map;
import java.util.Set;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.ANEWARRAY;
import org.apache.bcel.generic.CHECKCAST;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.FieldInstruction;
import org.apache.bcel.generic.GETFIELD;
import org.apache.bcel.generic.GETSTATIC;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.INVOKEINTERFACE;
import org.apache.bcel.generic.INVOKESPECIAL;
import org.apache.bcel.generic.INVOKESTATIC;
import org.apache.bcel.generic.INVOKEVIRTUAL;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.LDC;
import org.apache.bcel.generic.LDC2_W;
import org.apache.bcel.generic.MULTIANEWARRAY;
import org.apache.bcel.generic.NEW;
import org.apache.bcel.generic.NEWARRAY;
import org.apache.bcel.generic.PUTFIELD;
import org.apache.bcel.generic.ReferenceType;
import org.apache.bcel.generic.Type;

public class IsNullValueFrameModelingVisitor
extends AbstractFrameModelingVisitor<IsNullValue, IsNullValueFrame> {
    private static final boolean NO_ASSERT_HACK = SystemProperties.getBoolean("inva.noAssertHack");
    private static final boolean MODEL_NONNULL_RETURN = SystemProperties.getBoolean("fnd.modelNonnullReturn", true);
    private final AssertionMethods assertionMethods;
    private final ValueNumberDataflow vnaDataflow;
    private final TypeDataflow typeDataflow;
    private final boolean trackValueNumbers;
    private int slotContainingNewNullValue;

    public IsNullValueFrameModelingVisitor(ConstantPoolGen cpg, AssertionMethods assertionMethods, ValueNumberDataflow vnaDataflow, TypeDataflow typeDataflow, boolean trackValueNumbers) {
        super(cpg);
        this.assertionMethods = assertionMethods;
        this.vnaDataflow = vnaDataflow;
        this.trackValueNumbers = trackValueNumbers;
        this.typeDataflow = typeDataflow;
    }

    @Override
    public void analyzeInstruction(Instruction ins) throws DataflowAnalysisException {
        if (!((IsNullValueFrame)this.getFrame()).isValid()) {
            return;
        }
        this.slotContainingNewNullValue = -1;
        super.analyzeInstruction(ins);
        if (!((IsNullValueFrame)this.getFrame()).isValid()) {
            return;
        }
        if (!NO_ASSERT_HACK && this.assertionMethods.isAssertionHandle(this.getLocation().getHandle(), this.cpg)) {
            IsNullValueFrame frame = (IsNullValueFrame)this.getFrame();
            for (int i = 0; i < frame.getNumSlots(); ++i) {
                IsNullValue value = (IsNullValue)frame.getValue(i);
                if (!value.isDefinitelyNull() && !value.isNullOnSomePath()) continue;
                frame.setValue(i, IsNullValue.nonReportingNotNullValue());
            }
            for (Map.Entry<ValueNumber, IsNullValue> e : frame.getKnownValueMapEntrySet()) {
                IsNullValue value = e.getValue();
                if (!value.isDefinitelyNull() && !value.isNullOnSomePath()) continue;
                e.setValue(IsNullValue.nonReportingNotNullValue());
            }
        }
    }

    public int getSlotContainingNewNullValue() {
        return this.slotContainingNewNullValue;
    }

    @Override
    public IsNullValue getDefaultValue() {
        return IsNullValue.nonReportingNotNullValue();
    }

    private void produce(IsNullValue value) {
        IsNullValueFrame frame = (IsNullValueFrame)this.getFrame();
        frame.pushValue(value);
        this.newValueOnTOS();
    }

    private void produce2(IsNullValue value) {
        IsNullValueFrame frame = (IsNullValueFrame)this.getFrame();
        frame.pushValue(value);
        frame.pushValue(value);
    }

    private void handleInvoke(InvokeInstruction obj) {
        boolean modelCallReturnValue;
        if (obj instanceof INVOKEDYNAMIC) {
            return;
        }
        Type returnType = obj.getReturnType(this.getCPG());
        Location location = this.getLocation();
        if (this.trackValueNumbers) {
            try {
                ValueNumberFrame vnaFrame = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(location);
                Set<ValueNumber> nonnullParameters = UnconditionalValueDerefAnalysis.checkAllNonNullParams(location, vnaFrame, this.cpg, null, null, this.typeDataflow);
                if (!nonnullParameters.isEmpty()) {
                    IsNullValue kaboom = IsNullValue.noKaboomNonNullValue(location);
                    IsNullValueFrame frame = (IsNullValueFrame)this.getFrame();
                    for (ValueNumber vn : nonnullParameters) {
                        IsNullValue knownValue = frame.getKnownValue(vn);
                        if (knownValue != null && !knownValue.isDefinitelyNotNull()) {
                            if (knownValue.isDefinitelyNull()) {
                                frame.setTop();
                                return;
                            }
                            frame.setKnownValue(vn, kaboom);
                        }
                        for (int i = 0; i < vnaFrame.getNumSlots(); ++i) {
                            IsNullValue value = (IsNullValue)frame.getValue(i);
                            if (!((ValueNumber)vnaFrame.getValue(i)).equals(vn) || value.isDefinitelyNotNull()) continue;
                            frame.setValue(i, kaboom);
                            if (!value.isDefinitelyNull()) continue;
                            frame.setTop();
                            return;
                        }
                    }
                }
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("Error looking up nonnull parameters for invoked method", e);
            }
        }
        boolean bl = modelCallReturnValue = MODEL_NONNULL_RETURN && returnType instanceof ReferenceType;
        if (!modelCallReturnValue) {
            this.handleNormalInstruction((Instruction)obj);
        } else {
            IsNullValue result = null;
            try {
                TypeFrame typeFrame = (TypeFrame)this.typeDataflow.getFactAtLocation(location);
                Set<XMethod> targetSet = Hierarchy2.resolveMethodCallTargets(obj, typeFrame, this.cpg);
                if (targetSet.isEmpty()) {
                    XMethod calledMethod = XFactory.createXMethod(obj, this.getCPG());
                    result = this.getReturnValueNullness(calledMethod);
                } else {
                    for (XMethod calledMethod : targetSet) {
                        IsNullValue pushValue = this.getReturnValueNullness(calledMethod);
                        if (result == null) {
                            result = pushValue;
                            continue;
                        }
                        result = IsNullValue.merge(result, pushValue);
                    }
                }
            }
            catch (DataflowAnalysisException | ClassNotFoundException e) {
                result = IsNullValue.nonReportingNotNullValue();
            }
            this.modelInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), this.getNumWordsProduced((Instruction)obj), result);
            this.newValueOnTOS();
        }
    }

    public IsNullValue getReturnValueNullness(XMethod calledMethod) {
        IsNullValue pushValue;
        if (IsNullValueAnalysis.DEBUG) {
            System.out.println("Check " + String.valueOf(calledMethod) + " for null return...");
        }
        NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(calledMethod, false);
        Boolean alwaysNonNull = (Boolean)AnalysisContext.currentAnalysisContext().getReturnValueNullnessPropertyDatabase().getProperty(calledMethod.getMethodDescriptor());
        if (annotation == NullnessAnnotation.CHECK_FOR_NULL) {
            if (IsNullValueAnalysis.DEBUG) {
                System.out.println("Null value returned from " + String.valueOf(calledMethod));
            }
            pushValue = IsNullValue.nullOnSimplePathValue().markInformationAsComingFromReturnValueOfMethod(calledMethod, annotation);
        } else if (annotation == NullnessAnnotation.NULLABLE) {
            pushValue = IsNullValue.nonReportingNotNullValue();
        } else if (annotation == NullnessAnnotation.NONNULL || alwaysNonNull != null && alwaysNonNull.booleanValue()) {
            if (IsNullValueAnalysis.DEBUG) {
                System.out.println("NonNull value return from " + String.valueOf(calledMethod));
            }
            pushValue = IsNullValue.nonNullValue().markInformationAsComingFromReturnValueOfMethod(calledMethod, annotation);
        } else {
            pushValue = IsNullValue.nonReportingNotNullValue();
        }
        return pushValue;
    }

    private void newValueOnTOS() {
        IsNullValueFrame frame = (IsNullValueFrame)this.getFrame();
        if (frame.getStackDepth() < 1) {
            return;
        }
        int tosSlot = frame.getNumSlots() - 1;
        IsNullValue tos = (IsNullValue)frame.getValue(tosSlot);
        if (tos.isDefinitelyNull()) {
            this.slotContainingNewNullValue = tosSlot;
        }
        if (this.trackValueNumbers) {
            try {
                ValueNumberFrame vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(this.getLocation());
                if (vnaFrameAfter.isValid()) {
                    ValueNumber tosVN = (ValueNumber)vnaFrameAfter.getTopValue();
                    ((IsNullValueFrame)this.getFrame()).setKnownValue(tosVN, tos);
                }
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("error", e);
            }
        }
    }

    @Override
    public void visitPUTFIELD(PUTFIELD obj) {
        if (this.getNumWordsConsumed((Instruction)obj) != 2) {
            super.visitPUTFIELD(obj);
            return;
        }
        IsNullValue nullValueStored = null;
        try {
            nullValueStored = (IsNullValue)((IsNullValueFrame)this.getFrame()).getTopValue();
        }
        catch (DataflowAnalysisException e1) {
            AnalysisContext.logError("Oops", e1);
        }
        super.visitPUTFIELD(obj);
        XField field = XFactory.createXField((FieldInstruction)obj, this.cpg);
        if (nullValueStored != null && ValueNumberAnalysisFeatures.REDUNDANT_LOAD_ELIMINATION) {
            try {
                ValueNumberFrame vnaFrameBefore = (ValueNumberFrame)this.vnaDataflow.getFactAtLocation(this.getLocation());
                ValueNumber refValue = (ValueNumber)vnaFrameBefore.getStackValue(1);
                AvailableLoad load = new AvailableLoad(refValue, field);
                ValueNumberFrame vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(this.getLocation());
                ValueNumber[] newValueNumbersForField = vnaFrameAfter.getAvailableLoad(load);
                if (newValueNumbersForField != null && this.trackValueNumbers) {
                    for (ValueNumber v : newValueNumbersForField) {
                        ((IsNullValueFrame)this.getFrame()).setKnownValue(v, nullValueStored);
                    }
                }
            }
            catch (DataflowAnalysisException e) {
                AnalysisContext.logError("Oops", e);
            }
        }
    }

    @Override
    public void visitGETFIELD(GETFIELD obj) {
        if (this.getNumWordsProduced((Instruction)obj) != 1) {
            super.visitGETFIELD(obj);
            return;
        }
        if (this.checkForKnownValue((Instruction)obj)) {
            return;
        }
        XField field = XFactory.createXField((FieldInstruction)obj, this.cpg);
        NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(field, false);
        if (annotation == NullnessAnnotation.NONNULL) {
            this.modelNormalInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), 0);
            this.produce(IsNullValue.nonNullValue());
        } else if (annotation == NullnessAnnotation.CHECK_FOR_NULL) {
            this.modelNormalInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), 0);
            this.produce(IsNullValue.nullOnSimplePathValue().markInformationAsComingFromFieldValue(field));
        } else {
            super.visitGETFIELD(obj);
        }
    }

    @Override
    public void visitGETSTATIC(GETSTATIC obj) {
        OpcodeStack.Item summary;
        if (this.getNumWordsProduced((Instruction)obj) != 1) {
            super.visitGETSTATIC(obj);
            return;
        }
        if (this.checkForKnownValue((Instruction)obj)) {
            return;
        }
        XField field = XFactory.createXField((FieldInstruction)obj, this.cpg);
        if (field.isFinal() && (summary = AnalysisContext.currentAnalysisContext().getFieldSummary().getSummary(field)).isNull()) {
            this.produce(IsNullValue.nullValue());
            return;
        }
        if ("java.util.logging.Level".equals(field.getClassName()) && "SEVERE".equals(field.getName()) || "org.apache.log4j.Level".equals(field.getClassName()) && ("ERROR".equals(field.getName()) || "FATAL".equals(field.getName()))) {
            ((IsNullValueFrame)this.getFrame()).toExceptionValues();
        }
        if (field.getName().startsWith("class$")) {
            this.produce(IsNullValue.nonNullValue());
            return;
        }
        NullnessAnnotation annotation = AnalysisContext.currentAnalysisContext().getNullnessAnnotationDatabase().getResolvedAnnotation(field, false);
        if (annotation == NullnessAnnotation.NONNULL) {
            this.modelNormalInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), 0);
            this.produce(IsNullValue.nonNullValue());
        } else if (annotation == NullnessAnnotation.CHECK_FOR_NULL) {
            this.modelNormalInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), 0);
            this.produce(IsNullValue.nullOnSimplePathValue().markInformationAsComingFromFieldValue(field));
        } else {
            super.visitGETSTATIC(obj);
        }
    }

    private boolean checkForKnownValue(Instruction obj) {
        if (this.trackValueNumbers) {
            try {
                ValueNumberFrame vnaFrameAfter = (ValueNumberFrame)this.vnaDataflow.getFactAfterLocation(this.getLocation());
                if (vnaFrameAfter.isValid()) {
                    ValueNumber tosVN = (ValueNumber)vnaFrameAfter.getTopValue();
                    IsNullValue knownValue = ((IsNullValueFrame)this.getFrame()).getKnownValue(tosVN);
                    if (knownValue != null) {
                        this.modelNormalInstruction(obj, this.getNumWordsConsumed(obj), 0);
                        this.produce(knownValue);
                        return true;
                    }
                }
            }
            catch (DataflowAnalysisException dataflowAnalysisException) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    public void visitACONST_NULL(ACONST_NULL obj) {
        this.produce(IsNullValue.nullValue());
    }

    @Override
    public void visitNEW(NEW obj) {
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitNEWARRAY(NEWARRAY obj) {
        this.modelNormalInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), 0);
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitANEWARRAY(ANEWARRAY obj) {
        this.modelNormalInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), 0);
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitMULTIANEWARRAY(MULTIANEWARRAY obj) {
        this.modelNormalInstruction((Instruction)obj, this.getNumWordsConsumed((Instruction)obj), 0);
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitLDC(LDC obj) {
        this.produce(IsNullValue.nonNullValue());
    }

    @Override
    public void visitLDC2_W(LDC2_W obj) {
        this.produce2(IsNullValue.nonNullValue());
    }

    @Override
    public void visitCHECKCAST(CHECKCAST obj) {
    }

    @Override
    public void visitINVOKESTATIC(INVOKESTATIC obj) {
        this.handleInvoke((InvokeInstruction)obj);
    }

    @Override
    public void visitINVOKESPECIAL(INVOKESPECIAL obj) {
        this.handleInvoke((InvokeInstruction)obj);
    }

    @Override
    public void visitINVOKEINTERFACE(INVOKEINTERFACE obj) {
        this.handleInvoke((InvokeInstruction)obj);
    }

    @Override
    public void visitINVOKEVIRTUAL(INVOKEVIRTUAL obj) {
        this.handleInvoke((InvokeInstruction)obj);
    }
}

