/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.npe;

import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.npe.DerefFinder;
import edu.umd.cs.findbugs.ba.npe.PointerUsageRequiringNonNullValue;
import edu.umd.cs.findbugs.ba.vna.MergeTree;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberAnalysis;
import edu.umd.cs.findbugs.ba.vna.ValueNumberDataflow;
import edu.umd.cs.findbugs.util.MultiMap;
import java.util.BitSet;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import javax.annotation.CheckForNull;

public class UsagesRequiringNonNullValues {
    MultiMap<Integer, Pair> map = new MultiMap(LinkedList.class);

    public String toString() {
        StringBuilder buf = new StringBuilder();
        for (Map.Entry<Integer, Collection<Pair>> e : this.map.asMap().entrySet()) {
            buf.append(e).append("\n");
        }
        return buf.toString();
    }

    public void add(Location loc, ValueNumber vn, PointerUsageRequiringNonNullValue usage) {
        Pair p = new Pair(vn, usage);
        if (DerefFinder.DEBUG) {
            System.out.println("At " + String.valueOf(loc) + " adding dereference " + String.valueOf(p));
        }
        this.map.add(loc.getHandle().getPosition(), p);
    }

    @CheckForNull
    public PointerUsageRequiringNonNullValue get(Location loc, ValueNumber vn, ValueNumberDataflow vnaDataflow) {
        MergeTree mergeTree = ((ValueNumberAnalysis)vnaDataflow.getAnalysis()).getMergeTree();
        for (Pair p : this.map.get(loc.getHandle().getPosition())) {
            BitSet inputs;
            if (p.vn.equals(vn)) {
                return p.pu;
            }
            if (!p.vn.hasFlag(8) || !(inputs = mergeTree.getTransitiveInputSet(p.vn)).get(vn.getNumber())) continue;
            return p.pu;
        }
        return null;
    }

    public Collection<? extends Pair> getPairs(Integer loc) {
        return this.map.get(loc);
    }

    public static class Pair {
        public final ValueNumber vn;
        public final PointerUsageRequiringNonNullValue pu;

        Pair(ValueNumber vn, PointerUsageRequiringNonNullValue pu) {
            this.vn = vn;
            this.pu = pu;
        }

        public String toString() {
            return this.vn.toString();
        }
    }
}

