/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.ba.vna;

import edu.umd.cs.findbugs.BugAnnotation;
import edu.umd.cs.findbugs.FieldAnnotation;
import edu.umd.cs.findbugs.LocalVariableAnnotation;
import edu.umd.cs.findbugs.StringAnnotation;
import edu.umd.cs.findbugs.ba.CFGBuilderException;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.XField;
import edu.umd.cs.findbugs.ba.vna.AvailableLoad;
import edu.umd.cs.findbugs.ba.vna.ValueNumber;
import edu.umd.cs.findbugs.ba.vna.ValueNumberFrame;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ACONST_NULL;
import org.apache.bcel.generic.InstructionHandle;

public abstract class ValueNumberSourceInfo {
    @CheckForNull
    public static BugAnnotation findAnnotationFromValueNumber(Method method, Location location, ValueNumber valueNumber, ValueNumberFrame vnaFrame, @CheckForNull String partialRole) {
        if (location.getHandle().getInstruction() instanceof ACONST_NULL) {
            StringAnnotation nullConstant = new StringAnnotation("null");
            nullConstant.setDescription("STRING_NONSTRING_CONSTANT");
            return nullConstant;
        }
        LocalVariableAnnotation ann = ValueNumberSourceInfo.findLocalAnnotationFromValueNumber(method, location, valueNumber, vnaFrame);
        if (ann != null && partialRole != null) {
            ann.setDescription("LOCAL_VARIABLE_" + partialRole);
        }
        if (ann != null && ann.isSignificant()) {
            return ann;
        }
        FieldAnnotation field = ValueNumberSourceInfo.findFieldAnnotationFromValueNumber(method, location, valueNumber, vnaFrame);
        if (field != null) {
            if (partialRole != null) {
                field.setDescription("FIELD_" + partialRole);
            }
            return field;
        }
        if (ann != null) {
            return ann;
        }
        return null;
    }

    @Nonnull
    public static BugAnnotation findRequiredAnnotationFromValueNumber(Method method, Location location, ValueNumber valueNumber, ValueNumberFrame vnaFrame, @CheckForNull String partialRole) {
        BugAnnotation result = ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, valueNumber, vnaFrame, partialRole);
        if (result != null) {
            return result;
        }
        return new LocalVariableAnnotation("?", -1, location.getHandle().getPosition());
    }

    public static LocalVariableAnnotation findLocalAnnotationFromValueNumber(Method method, Location location, ValueNumber valueNumber, ValueNumberFrame vnaFrame) {
        if (vnaFrame == null || vnaFrame.isBottom() || vnaFrame.isTop()) {
            return null;
        }
        LocalVariableAnnotation localAnnotation = null;
        for (int i = 0; i < vnaFrame.getNumLocals(); ++i) {
            int position2;
            int position1;
            InstructionHandle handle;
            InstructionHandle prev;
            if (!valueNumber.equals(vnaFrame.getValue(i)) || (prev = (handle = location.getHandle()).getPrev()) == null || (localAnnotation = LocalVariableAnnotation.getLocalVariableAnnotation(method, i, position1 = prev.getPosition(), position2 = handle.getPosition())) == null) continue;
            return localAnnotation;
        }
        return null;
    }

    public static FieldAnnotation findFieldAnnotationFromValueNumber(Method method, Location location, ValueNumber valueNumber, ValueNumberFrame vnaFrame) {
        XField field = ValueNumberSourceInfo.findXFieldFromValueNumber(method, location, valueNumber, vnaFrame);
        if (field == null) {
            return null;
        }
        return FieldAnnotation.fromXField(field);
    }

    public static XField findXFieldFromValueNumber(Method method, Location location, ValueNumber valueNumber, ValueNumberFrame vnaFrame) {
        if (vnaFrame == null || vnaFrame.isBottom() || vnaFrame.isTop()) {
            return null;
        }
        AvailableLoad load = vnaFrame.getLoad(valueNumber);
        if (load != null) {
            return load.getField();
        }
        return null;
    }

    @CheckForNull
    public static BugAnnotation getFromValueNumber(ClassContext classContext, Method method, Location location, int stackPos) throws DataflowAnalysisException, CFGBuilderException {
        ValueNumberFrame vnaFrame = (ValueNumberFrame)classContext.getValueNumberDataflow(method).getFactAtLocation(location);
        if (!vnaFrame.isValid()) {
            return null;
        }
        ValueNumber valueNumber = (ValueNumber)vnaFrame.getStackValue(stackPos);
        if (valueNumber.hasFlag(4)) {
            return null;
        }
        return ValueNumberSourceInfo.findAnnotationFromValueNumber(method, location, valueNumber, vnaFrame, "VALUE_OF");
    }
}

