/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.BytecodeScanningDetector;
import edu.umd.cs.findbugs.NonReportingDetector;
import edu.umd.cs.findbugs.SourceLineAnnotation;
import edu.umd.cs.findbugs.ba.AccessMethodDatabase;
import edu.umd.cs.findbugs.classfile.Global;
import edu.umd.cs.findbugs.classfile.MethodDescriptor;

public class BuildAccessMethodsDatabase
extends BytecodeScanningDetector
implements NonReportingDetector {
    private AccessMethodDatabase database = new AccessMethodDatabase();

    public BuildAccessMethodsDatabase(BugReporter bugReporter) {
        Global.getAnalysisCache().eagerlyPutDatabase(AccessMethodDatabase.class, this.database);
    }

    @Override
    public void sawOpcode(int seen) {
        if (seen == 184 && this.getMethodDescriptorOperand().isAccessMethod()) {
            MethodDescriptor callerMethod = this.getMethodDescriptor();
            MethodDescriptor accessMethod = this.getMethodDescriptorOperand();
            SourceLineAnnotation sourceLineAnnotation = SourceLineAnnotation.fromVisitedMethod(this);
            this.database.addAccessMethod(accessMethod, callerMethod, sourceLineAnnotation);
        }
    }
}

