/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.ba.SignatureParser;
import edu.umd.cs.findbugs.detect.AbstractAssertDetector;
import edu.umd.cs.findbugs.util.MutableClasses;

public class FindAssertionsWithSideEffects
extends AbstractAssertDetector {
    public FindAssertionsWithSideEffects(BugReporter bugReporter) {
        super(bugReporter);
    }

    private boolean isMethodCall(int seen) {
        return seen == 184 || seen == 182 || seen == 185 || seen == 183 || seen == 186;
    }

    private boolean checkSeen(int seen) {
        return seen == 132 || seen == 54 || seen == 59 || seen == 60 || seen == 61 || seen == 62 || seen == 181 || seen == 179;
    }

    @Override
    protected void detect(int seen) {
        if (this.isMethodCall(seen) && this.getXClassOperand() != null && this.getXMethodOperand() != null) {
            String retSig = new SignatureParser(this.getXMethodOperand().getSignature()).getReturnTypeSignature();
            String classSig = this.getXClassOperand().getSourceSignature();
            if (MutableClasses.mutableSignature("L" + this.getClassConstantOperand() + ";") && MutableClasses.looksLikeASetter(this.getNameConstantOperand(), classSig, retSig)) {
                BugInstance bug = new BugInstance(this, "ASE_ASSERTION_WITH_SIDE_EFFECT_METHOD", 3).addClassAndMethod(this).addSourceLine(this, this.getPC());
                this.reportBug(bug);
            }
        } else if (this.checkSeen(seen)) {
            BugInstance bug = new BugInstance(this, "ASE_ASSERTION_WITH_SIDE_EFFECT", 3).addClassAndMethod(this).addSourceLine(this, this.getPC());
            this.reportBug(bug);
        }
    }
}

