/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.detect;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.BugReporter;
import edu.umd.cs.findbugs.OpcodeStack;
import edu.umd.cs.findbugs.bcel.OpcodeStackDetector;
import org.apache.bcel.classfile.Code;

public class IncompatMask
extends OpcodeStackDetector {
    private final BugReporter bugReporter;
    private int bitop = -1;
    private boolean equality;
    private Number arg1;
    private Number arg2;
    private OpcodeStack.Item bitresultItem;

    public IncompatMask(BugReporter bugReporter) {
        this.bugReporter = bugReporter;
    }

    static int populationCount(long i) {
        return Long.bitCount(i);
    }

    @Override
    public void visit(Code obj) {
        this.arg2 = null;
        this.arg1 = null;
        super.visit(obj);
    }

    private Number getArg() {
        Object constValue = this.stack.getStackItem(0).getConstant();
        if (!(constValue instanceof Number)) {
            constValue = this.stack.getStackItem(1).getConstant();
        }
        if (!(constValue instanceof Long) && !(constValue instanceof Integer)) {
            return null;
        }
        return (Number)constValue;
    }

    @Override
    public void sawOpcode(int seen) {
        switch (seen) {
            case 126: 
            case 127: {
                this.arg1 = this.getArg();
                this.bitop = 126;
                return;
            }
            case 128: 
            case 129: {
                this.arg1 = this.getArg();
                this.bitop = 128;
                return;
            }
            case 148: {
                if (this.checkItem(2)) {
                    this.arg2 = this.getArg();
                }
                return;
            }
            case 159: 
            case 160: {
                if (!this.checkItem(2)) break;
                this.arg2 = this.getArg();
                this.equality = true;
                break;
            }
            case 153: 
            case 154: {
                if (this.arg1 instanceof Integer && this.checkItem(1)) {
                    this.arg2 = 0;
                }
                this.equality = true;
                break;
            }
            case 155: 
            case 156: 
            case 157: 
            case 158: {
                if (this.arg1 instanceof Integer && this.checkItem(1)) {
                    this.arg2 = 0;
                }
                this.equality = false;
                break;
            }
            default: {
                return;
            }
        }
        if (this.arg1 == null || this.arg2 == null) {
            return;
        }
        boolean isLong = this.arg1 instanceof Long;
        if (!this.equality && this.arg2.longValue() == 0L) {
            boolean onlyLowBits;
            long bits = IncompatMask.getFlagBits(isLong, this.arg1.longValue());
            boolean highbit = !isLong && (bits & Integer.MIN_VALUE) != 0L || isLong && bits < 0L && bits << 1 == 0L;
            boolean bl = onlyLowBits = bits >>> 12 == 0L;
            BugInstance bug = highbit ? new BugInstance(this, "BIT_SIGNED_CHECK_HIGH_BIT", seen == 158 || seen == 157 ? 1 : 2) : new BugInstance(this, "BIT_SIGNED_CHECK", onlyLowBits ? 3 : 2);
            bug.addClassAndMethod(this).addString(IncompatMask.toHex(this.arg1) + " (" + String.valueOf(this.arg1) + ")").addSourceLine(this);
            this.bugReporter.reportBug(bug);
        }
        if (this.equality) {
            String t;
            long dif;
            long val1 = this.arg1.longValue();
            long val2 = this.arg2.longValue();
            if (this.bitop == 128) {
                dif = val1 & (val2 ^ 0xFFFFFFFFFFFFFFFFL);
                t = "BIT_IOR";
            } else if (val1 != 0L || val2 != 0L) {
                dif = val2 & (val1 ^ 0xFFFFFFFFFFFFFFFFL);
                t = "BIT_AND";
            } else {
                dif = 1L;
                t = "BIT_AND_ZZ";
            }
            if (dif != 0L) {
                BugInstance bug = new BugInstance(this, t, 1).addClassAndMethod(this);
                if (!"BIT_AND_ZZ".equals(t)) {
                    bug.addString(IncompatMask.toHex(this.arg1)).addString(IncompatMask.toHex(this.arg2));
                }
                bug.addSourceLine(this);
                this.bugReporter.reportBug(bug);
            }
        }
        this.arg2 = null;
        this.arg1 = null;
        this.bitresultItem = null;
    }

    private static String toHex(Number n) {
        return "0x" + (n instanceof Long ? Long.toHexString(n.longValue()) : Integer.toHexString(n.intValue()));
    }

    private boolean checkItem(int n) {
        if (this.bitresultItem != null) {
            for (int i = 0; i < n; ++i) {
                if (this.stack.getStackItem(i) != this.bitresultItem) continue;
                return true;
            }
        }
        this.arg2 = null;
        this.arg1 = null;
        this.bitresultItem = null;
        return false;
    }

    @Override
    public void afterOpcode(int seen) {
        super.afterOpcode(seen);
        switch (seen) {
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                if (this.stack.getStackDepth() <= 0) break;
                this.bitresultItem = this.stack.getStackItem(0);
                break;
            }
        }
    }

    static long getFlagBits(boolean isLong, long arg0) {
        long bits = arg0;
        if (isLong) {
            if (IncompatMask.populationCount(bits) > IncompatMask.populationCount(bits ^ 0xFFFFFFFFFFFFFFFFL)) {
                bits ^= 0xFFFFFFFFFFFFFFFFL;
            }
        } else if (IncompatMask.populationCount(0xFFFFFFFFL & bits) > IncompatMask.populationCount(0xFFFFFFFFL & (bits ^ 0xFFFFFFFFFFFFFFFFL))) {
            bits = 0xFFFFFFFFL & (bits ^ 0xFFFFFFFFFFFFFFFFL);
        }
        return bits;
    }
}

