/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.filter;

import edu.umd.cs.findbugs.BugInstance;
import edu.umd.cs.findbugs.filter.Matcher;
import edu.umd.cs.findbugs.filter.RelationalOp;
import edu.umd.cs.findbugs.filter.VersionMatcher;
import edu.umd.cs.findbugs.xml.XMLAttributeList;
import edu.umd.cs.findbugs.xml.XMLOutput;
import java.io.IOException;

public class LastVersionMatcher
extends VersionMatcher
implements Matcher {
    public static final LastVersionMatcher DEAD_BUG_MATCHER = new LastVersionMatcher(-1L, RelationalOp.NEQ);

    public LastVersionMatcher(String versionAsString, String relOpAsString) {
        this(Long.parseLong(versionAsString), RelationalOp.byName(relOpAsString));
    }

    public LastVersionMatcher(String versionAsString, RelationalOp relOp) {
        this(Long.parseLong(versionAsString), relOp);
    }

    public LastVersionMatcher(long version, RelationalOp relOp) {
        super(version, relOp);
    }

    @Override
    public boolean match(BugInstance bugInstance) {
        return this.relOp.check(bugInstance.getLastVersion(), this.version);
    }

    @Override
    public void writeXML(XMLOutput xmlOutput, boolean disabled) throws IOException {
        XMLAttributeList attributes = new XMLAttributeList().addAttribute("value", Long.toString(this.version)).addAttribute("relOp", this.relOp.getName());
        if (disabled) {
            attributes.addAttribute("disabled", "true");
        }
        xmlOutput.openCloseTag("LastVersion", attributes);
    }

    public String toString() {
        if (this.version == -1L && this.relOp == RelationalOp.EQ) {
            return "ActiveBugs";
        }
        if (this.version == -1L && this.relOp == RelationalOp.NEQ) {
            return "DeadBugs";
        }
        return "LastVersion(version " + String.valueOf(this.relOp) + this.version + ")";
    }
}

