/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.graph;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import edu.umd.cs.findbugs.graph.DFSEdgeTypes;
import edu.umd.cs.findbugs.graph.Graph;
import edu.umd.cs.findbugs.graph.GraphEdge;
import edu.umd.cs.findbugs.graph.GraphVertex;
import edu.umd.cs.findbugs.graph.SearchTreeCallback;
import edu.umd.cs.findbugs.graph.VertexChooser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public abstract class AbstractDepthFirstSearch<GraphType extends Graph<EdgeType, VertexType>, EdgeType extends GraphEdge<EdgeType, VertexType>, VertexType extends GraphVertex<VertexType>>
implements DFSEdgeTypes {
    public static final boolean DEBUG = false;
    private final GraphType graph;
    private final int[] colorList;
    private final int[] discoveryTimeList;
    private final int[] finishTimeList;
    private final int[] dfsEdgeTypeList;
    private int timestamp;
    private final LinkedList<VertexType> topologicalSortList;
    private VertexChooser<VertexType> vertexChooser;
    private SearchTreeCallback<VertexType> searchTreeCallback;
    protected static final int WHITE = 0;
    protected static final int GRAY = 1;
    protected static final int BLACK = 2;

    protected AbstractDepthFirstSearch(GraphType graph) {
        this.graph = graph;
        int numBlocks = graph.getNumVertexLabels();
        this.colorList = new int[numBlocks];
        this.discoveryTimeList = new int[numBlocks];
        this.finishTimeList = new int[numBlocks];
        int maxEdgeId = graph.getNumEdgeLabels();
        this.dfsEdgeTypeList = new int[maxEdgeId];
        this.timestamp = 0;
        this.topologicalSortList = new LinkedList();
    }

    protected abstract Iterator<EdgeType> outgoingEdgeIterator(GraphType var1, VertexType var2);

    protected abstract VertexType getTarget(EdgeType var1);

    protected abstract VertexType getSource(EdgeType var1);

    protected VertexType getNextSearchTreeRoot() {
        Iterator i = this.graph.vertexIterator();
        while (i.hasNext()) {
            GraphVertex vertex = (GraphVertex)i.next();
            if (!this.visitMe(vertex)) continue;
            return (VertexType)vertex;
        }
        return null;
    }

    public Collection<VertexType> unvisitedVertices() {
        LinkedList<GraphVertex> result = new LinkedList<GraphVertex>();
        Iterator i = this.graph.vertexIterator();
        while (i.hasNext()) {
            GraphVertex v = (GraphVertex)i.next();
            if (this.getColor(v) != 0) continue;
            result.add(v);
        }
        return result;
    }

    public void setVertexChooser(VertexChooser<VertexType> vertexChooser) {
        this.vertexChooser = vertexChooser;
    }

    public void setSearchTreeCallback(SearchTreeCallback<VertexType> searchTreeCallback) {
        this.searchTreeCallback = searchTreeCallback;
    }

    public AbstractDepthFirstSearch<GraphType, EdgeType, VertexType> search() {
        this.visitAll();
        this.classifyUnknownEdges();
        return this;
    }

    public boolean containsCycle() {
        Iterator i = this.graph.edgeIterator();
        while (i.hasNext()) {
            GraphEdge edge = (GraphEdge)i.next();
            if (this.getDFSEdgeType(edge) != 1) continue;
            return true;
        }
        return false;
    }

    public int getDFSEdgeType(EdgeType edge) {
        return this.dfsEdgeTypeList[edge.getLabel()];
    }

    public int getDiscoveryTime(VertexType vertex) {
        return this.discoveryTimeList[vertex.getLabel()];
    }

    public int getFinishTime(VertexType vertex) {
        return this.finishTimeList[vertex.getLabel()];
    }

    @SuppressFBWarnings(value={"EI"})
    public int[] getFinishTimeList() {
        return this.finishTimeList;
    }

    public Iterator<VertexType> topologicalSortIterator() {
        return this.topologicalSortList.iterator();
    }

    private void visitAll() {
        VertexType searchTreeRoot;
        while ((searchTreeRoot = this.getNextSearchTreeRoot()) != null) {
            if (this.searchTreeCallback != null) {
                this.searchTreeCallback.startSearchTree(searchTreeRoot);
            }
            ArrayList<Visit> stack = new ArrayList<Visit>(this.graph.getNumVertexLabels());
            stack.add(new Visit(this, searchTreeRoot));
            while (!stack.isEmpty()) {
                Visit visit = (Visit)stack.get(stack.size() - 1);
                if (visit.hasNextEdge()) {
                    Object edge = visit.getNextEdge();
                    this.visitSuccessor(stack, edge);
                    continue;
                }
                Object vertex = visit.getVertex();
                this.setColor(vertex, 2);
                this.topologicalSortList.addFirst(vertex);
                this.setFinishTime(vertex, this.timestamp++);
                stack.remove(stack.size() - 1);
            }
        }
    }

    private void visitSuccessor(ArrayList<Visit> stack, EdgeType edge) {
        VertexType succ = this.getTarget(edge);
        int succColor = this.getColor(succ);
        int dfsEdgeType = 0;
        switch (succColor) {
            case 0: {
                dfsEdgeType = 0;
                break;
            }
            case 1: {
                dfsEdgeType = 1;
                break;
            }
            case 2: {
                dfsEdgeType = -1;
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
        this.setDFSEdgeType(edge, dfsEdgeType);
        if (this.visitMe(succ)) {
            if (this.searchTreeCallback != null) {
                this.searchTreeCallback.addToSearchTree(this.getSource(edge), this.getTarget(edge));
            }
            stack.add(new Visit(this, succ));
        }
    }

    private void classifyUnknownEdges() {
        Iterator edgeIter = this.graph.edgeIterator();
        while (edgeIter.hasNext()) {
            int destDiscoveryTime;
            GraphEdge edge = (GraphEdge)edgeIter.next();
            int dfsEdgeType = this.getDFSEdgeType(edge);
            if (dfsEdgeType != -1) continue;
            int srcDiscoveryTime = this.getDiscoveryTime(this.getSource(edge));
            dfsEdgeType = srcDiscoveryTime < (destDiscoveryTime = this.getDiscoveryTime(this.getTarget(edge))) ? 2 : 3;
            this.setDFSEdgeType(edge, dfsEdgeType);
        }
    }

    private void setColor(VertexType vertex, int color) {
        this.colorList[vertex.getLabel()] = color;
    }

    protected int getColor(VertexType vertex) {
        return this.colorList[vertex.getLabel()];
    }

    protected boolean visitMe(VertexType vertex) {
        return this.getColor(vertex) == 0 && (this.vertexChooser == null || this.vertexChooser.isChosen(vertex));
    }

    private void setDiscoveryTime(VertexType vertex, int ts) {
        this.discoveryTimeList[vertex.getLabel()] = ts;
    }

    private void setFinishTime(VertexType vertex, int ts) {
        this.finishTimeList[vertex.getLabel()] = ts;
    }

    private void setDFSEdgeType(EdgeType edge, int dfsEdgeType) {
        this.dfsEdgeTypeList[edge.getLabel()] = dfsEdgeType;
    }

    private static class Visit {
        private final VertexType vertex;
        private final Iterator<EdgeType> outgoingEdgeIterator;
        final /* synthetic */ AbstractDepthFirstSearch this$0;

        public Visit(VertexType vertex) {
            this.this$0 = var1_1;
            if (vertex == null) {
                throw new IllegalStateException();
            }
            this.vertex = vertex;
            this.outgoingEdgeIterator = var1_1.outgoingEdgeIterator(var1_1.graph, vertex);
            var1_1.setColor(vertex, 1);
            var1_1.setDiscoveryTime(vertex, var1_1.timestamp++);
        }

        public VertexType getVertex() {
            return this.vertex;
        }

        public boolean hasNextEdge() {
            return this.outgoingEdgeIterator.hasNext();
        }

        public EdgeType getNextEdge() {
            return (GraphEdge)this.outgoingEdgeIterator.next();
        }
    }
}

