/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.io;

import edu.umd.cs.findbugs.annotations.CheckReturnValue;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.util.Util;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import javax.annotation.CheckForNull;
import javax.annotation.WillClose;
import javax.annotation.WillNotClose;

public class IO {
    static ThreadLocal<byte[]> myByteBuf = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[4096];
        }
    };
    static ThreadLocal<char[]> myCharBuf = new ThreadLocal<char[]>(){

        @Override
        protected char[] initialValue() {
            return new char[4096];
        }
    };

    public static byte[] readAll(@WillClose InputStream in) throws IOException {
        try {
            ByteArrayOutputStream byteSink = new ByteArrayOutputStream();
            IO.copy(in, byteSink);
            byte[] byArray = byteSink.toByteArray();
            return byArray;
        }
        finally {
            IO.close(in);
        }
    }

    static byte[] copyOf(byte[] original, int newLength) {
        byte[] copy = new byte[newLength];
        System.arraycopy(original, 0, copy, 0, Math.min(original.length, newLength));
        return copy;
    }

    public static byte[] readAll(@WillClose InputStream in, int size) throws IOException {
        try {
            if (size == 0) {
                throw new IllegalArgumentException();
            }
            byte[] result = new byte[size];
            int pos = 0;
            while (true) {
                int sz;
                if ((sz = in.read(result, pos, size - pos)) > 0) {
                    pos += sz;
                    continue;
                }
                if (pos < size) {
                    byte[] byArray = IO.copyOf(result, pos);
                    return byArray;
                }
                int nextByte = in.read();
                if (nextByte == -1) {
                    byte[] byArray = result;
                    return byArray;
                }
                size = size * 2 + 500;
                result = IO.copyOf(result, size);
                result[pos++] = (byte)nextByte;
            }
        }
        finally {
            IO.close(in);
        }
    }

    public static String readAll(Reader reader) throws IOException {
        BufferedReader r = new BufferedReader(reader);
        StringWriter w = new StringWriter();
        IO.copy(r, w);
        return w.toString();
    }

    public static long copy(@WillNotClose InputStream in, @WillNotClose OutputStream out) throws IOException {
        return IO.copy(in, out, Long.MAX_VALUE);
    }

    public static long copy(Reader in, Writer out) throws IOException {
        return IO.copy(in, out, Long.MAX_VALUE);
    }

    public static long copy(@WillNotClose InputStream in, @WillNotClose OutputStream out, long maxBytes) throws IOException {
        long total = 0L;
        int sz = 0;
        byte[] buf = myByteBuf.get();
        while (maxBytes > 0L && (sz = in.read(buf, 0, (int)Math.min(maxBytes, (long)buf.length))) > 0) {
            total += (long)sz;
            maxBytes -= (long)sz;
            out.write(buf, 0, sz);
        }
        return total;
    }

    public static long copy(Reader in, Writer out, long maxChars) throws IOException {
        int sz;
        long total = 0L;
        char[] buf = myCharBuf.get();
        while (maxChars > 0L && (sz = in.read(buf, 0, (int)Math.min(maxChars, (long)buf.length))) > 0) {
            total += (long)sz;
            maxChars -= (long)sz;
            out.write(buf, 0, sz);
        }
        return total;
    }

    public static void close(@CheckForNull AutoCloseable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void close(@CheckForNull Closeable c) {
        IO.close((AutoCloseable)c);
    }

    public static void close(@CheckForNull InputStream inputStream) {
        if (inputStream == null) {
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void close(@CheckForNull OutputStream outputStream) {
        if (outputStream == null) {
            return;
        }
        try {
            outputStream.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void skipFully(InputStream in, long bytes) throws IOException {
        long skipped;
        if (bytes < 0L) {
            throw new IllegalArgumentException("Can't skip " + bytes + " bytes");
        }
        for (long remaining = bytes; remaining > 0L; remaining -= skipped) {
            skipped = in.skip(remaining);
            if (skipped > 0L) continue;
            throw new EOFException("Reached EOF while trying to skip a total of " + bytes);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean verifyURL(URL u) {
        boolean bl;
        if (u == null) {
            return false;
        }
        InputStream i = null;
        try {
            URLConnection uc = IO.openNonCachedConnection(u);
            i = uc.getInputStream();
            int firstByte = i.read();
            i.close();
            bl = firstByte >= 0;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                Util.closeSilently(i);
                throw throwable;
            }
            Util.closeSilently(i);
            return bl2;
        }
        Util.closeSilently(i);
        return bl;
    }

    @CheckReturnValue
    @NonNull
    public static URLConnection openNonCachedConnection(@NonNull URL u) throws IOException {
        URLConnection uc = u.openConnection();
        if (uc instanceof JarURLConnection) {
            uc.setUseCaches(false);
        }
        return uc;
    }

    @CheckReturnValue
    @NonNull
    public static InputStream openNonCachedStream(@NonNull URL u) throws IOException {
        return IO.openNonCachedConnection(u).getInputStream();
    }
}

