/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.sarif;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.ba.SourceFinder;
import edu.umd.cs.findbugs.sarif.Location;
import java.net.URI;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

class Stack {
    final String message;
    final List<StackFrame> frames;

    Stack(@NonNull String message, @NonNull List<StackFrame> frames) {
        this.message = Objects.requireNonNull(Objects.requireNonNull(message));
        this.frames = Collections.unmodifiableList(Objects.requireNonNull(frames));
    }

    static Stack fromThrowable(Throwable throwable, @NonNull SourceFinder sourceFinder, @NonNull Map<URI, String> baseToId) {
        List<StackFrame> frames = Arrays.stream(Objects.requireNonNull(throwable).getStackTrace()).map(element -> StackFrame.fromStackTraceElement(element, sourceFinder, baseToId)).collect(Collectors.toList());
        String message = throwable.getMessage();
        if (message == null) {
            message = "no message given";
        }
        return new Stack(message, frames);
    }

    JsonObject toJsonObject() {
        JsonObject textJson = new JsonObject();
        textJson.addProperty("text", this.message);
        JsonObject result = new JsonObject();
        result.add("message", (JsonElement)textJson);
        JsonArray frameArray = new JsonArray();
        this.frames.forEach(stackFrame -> frameArray.add((JsonElement)stackFrame.toJsonObject()));
        if (frameArray.size() > 0) {
            result.add("frames", (JsonElement)frameArray);
        }
        return result;
    }

    static class StackFrame {
        @NonNull
        final Location location;

        StackFrame(@NonNull Location location) {
            this.location = Objects.requireNonNull(location);
        }

        static StackFrame fromStackTraceElement(@NonNull StackTraceElement element, @NonNull SourceFinder sourceFinder, @NonNull Map<URI, String> baseToId) {
            Location location = Location.fromStackTraceElement(element, sourceFinder, baseToId);
            return new StackFrame(location);
        }

        JsonObject toJsonObject() {
            JsonObject result = new JsonObject();
            result.add("location", (JsonElement)this.location.toJsonObject());
            return result;
        }
    }
}

