/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.internalAnnotations.StaticConstant;
import java.util.Locale;
import java.util.Set;

public class Archive {
    @StaticConstant
    public static final Set<String> ARCHIVE_EXTENSION_SET = Set.of(".jar", ".zip", ".war", ".ear", ".sar");

    public static boolean isArchiveFileName(String fileName) {
        String extension = Archive.getExtension(fileName);
        return ARCHIVE_EXTENSION_SET.contains(extension);
    }

    private static String getExtension(String fileName) {
        int lastDot = fileName.lastIndexOf(46);
        if (lastDot < 0) {
            return fileName;
        }
        return fileName.substring(lastDot).toLowerCase(Locale.ENGLISH);
    }

    @Deprecated
    public static boolean isLibraryFileName(String fileName) {
        String extension = Archive.getExtension(fileName);
        return ".jar".equals(extension);
    }
}

