/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class FutureValue<V>
implements Future<V> {
    final CountDownLatch latch = new CountDownLatch(1);
    V value;
    volatile boolean canceled;

    @Override
    public synchronized boolean cancel(boolean arg0) {
        if (this.latch.getCount() == 0L) {
            return false;
        }
        this.canceled = true;
        this.latch.countDown();
        return true;
    }

    @Override
    public synchronized V get() throws InterruptedException {
        this.latch.await();
        if (this.canceled) {
            throw new RuntimeException("Canceled");
        }
        return this.value;
    }

    @Override
    public synchronized V get(long arg0, TimeUnit arg1) throws InterruptedException, TimeoutException {
        if (!this.latch.await(arg0, arg1)) {
            throw new TimeoutException();
        }
        if (this.canceled) {
            throw new RuntimeException("Canceled");
        }
        return this.value;
    }

    public synchronized V get(long arg0, TimeUnit arg1, V valueOnTimeout) throws InterruptedException {
        if (!this.latch.await(arg0, arg1)) {
            return valueOnTimeout;
        }
        if (this.canceled) {
            throw new RuntimeException("Canceled");
        }
        return this.value;
    }

    @Override
    public boolean isCancelled() {
        return this.canceled;
    }

    @Override
    public boolean isDone() {
        return !this.canceled && this.latch.getCount() == 0L;
    }

    public synchronized void set(V value) {
        if (this.canceled) {
            throw new IllegalStateException("Already cancelled");
        }
        if (this.latch.getCount() == 0L) {
            throw new IllegalStateException("Already set");
        }
        this.value = value;
        this.latch.countDown();
    }
}

