/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.HTMLWriter;

public class HTML {
    private HTML() {
    }

    public static void convertHtmlToText(Reader reader, Writer writer) throws IOException, BadLocationException {
        HTMLEditorKit kit = new HTMLEditorKit();
        HTMLDocument doc = new HTMLDocument();
        ((EditorKit)kit).read(reader, (Document)doc, 0);
        HTMLtoPlainTextWriter2 x = new HTMLtoPlainTextWriter2(writer, doc);
        x.write();
        writer.close();
    }

    public static String convertHtmlSnippetToText(String htmlSnippet) throws IOException, BadLocationException {
        StringWriter writer = new StringWriter();
        StringReader reader = new StringReader("<HTML><BODY>" + htmlSnippet + "</BODY></HTML>");
        HTML.convertHtmlToText(reader, writer);
        return writer.toString();
    }

    private static final class HTMLtoPlainTextWriter2
    extends HTMLWriter {
        boolean inPre = false;
        boolean startingParagraph = false;

        public HTMLtoPlainTextWriter2(Writer w, HTMLDocument doc) {
            super(w, doc);
            this.setLineLength(80);
            this.setCanWrapLines(true);
        }

        @Override
        protected void startTag(Element elem) throws IOException {
            String name = elem.getName();
            this.startingParagraph = true;
            if ("ul".equals(name)) {
                super.incrIndent();
                this.write("  ");
            } else if ("pre".equals(name)) {
                this.inPre = true;
            } else if ("li".equals(name)) {
                super.incrIndent();
                this.write("* ");
            }
        }

        @Override
        protected void writeEmbeddedTags(AttributeSet attr) throws IOException {
        }

        @Override
        protected void endTag(Element elem) throws IOException {
            String name = elem.getName();
            if ("p".equals(name)) {
                this.writeLineSeparator();
                this.indent();
            } else if ("pre".equals(name)) {
                this.inPre = false;
            } else if ("ul".equals(name) || "li".equals(name)) {
                super.decrIndent();
                this.writeLineSeparator();
                this.indent();
            }
        }

        @Override
        protected void incrIndent() {
        }

        @Override
        protected void decrIndent() {
        }

        @Override
        protected void emptyTag(Element elem) throws IOException, BadLocationException {
            if ("content".equals(elem.getName())) {
                super.emptyTag(elem);
            }
        }

        @Override
        protected void text(Element elem) throws IOException, BadLocationException {
            String contentStr = this.getText(elem);
            if (!this.inPre) {
                contentStr = contentStr.replaceAll("\\s+", " ");
                if (this.startingParagraph) {
                    while (!contentStr.isEmpty() && contentStr.charAt(0) == ' ') {
                        contentStr = contentStr.substring(1);
                    }
                }
                this.startingParagraph = false;
            }
            if (!contentStr.isEmpty()) {
                this.setCanWrapLines(!this.inPre);
                this.write(contentStr);
            }
        }
    }
}

