/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.util;

import edu.umd.cs.findbugs.ba.AnalysisContext;
import edu.umd.cs.findbugs.ba.CFG;
import edu.umd.cs.findbugs.ba.ClassContext;
import edu.umd.cs.findbugs.ba.DataflowAnalysisException;
import edu.umd.cs.findbugs.ba.Location;
import edu.umd.cs.findbugs.ba.LockDataflow;
import edu.umd.cs.findbugs.ba.LockSet;
import edu.umd.cs.findbugs.ba.ch.Subtypes2;
import edu.umd.cs.findbugs.internalAnnotations.DottedClassName;
import edu.umd.cs.findbugs.util.ClassName;
import edu.umd.cs.findbugs.util.CollectionAnalysis;
import java.util.Collection;
import java.util.stream.Stream;
import org.apache.bcel.classfile.AnnotationEntry;
import org.apache.bcel.classfile.Field;
import org.apache.bcel.classfile.JavaClass;
import org.apache.bcel.classfile.LocalVariableTable;
import org.apache.bcel.classfile.Method;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.INVOKEDYNAMIC;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.InstructionHandle;
import org.apache.bcel.generic.InvokeInstruction;
import org.apache.bcel.generic.MONITORENTER;
import org.apache.bcel.generic.MethodGen;

public class MultiThreadedCodeIdentifierUtils {
    private static final String JAVA_LANG_RUNNABLE = "java.lang.Runnable";
    private static final String ATOMIC_PACKAGE = "java/util/concurrent/atomic";

    private MultiThreadedCodeIdentifierUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static boolean isPartOfMultiThreadedCode(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        if (Subtypes2.instanceOf(javaClass, JAVA_LANG_RUNNABLE) || Stream.of(javaClass.getFields()).anyMatch(MultiThreadedCodeIdentifierUtils::isFieldIndicatingMultiThreadedContainer)) {
            return true;
        }
        return Stream.of(javaClass.getMethods()).anyMatch(method -> MultiThreadedCodeIdentifierUtils.isMethodMultiThreaded(method, classContext));
    }

    public static boolean isMethodMultiThreaded(Method method, ClassContext classContext) {
        if (method.isSynchronized()) {
            return true;
        }
        LocalVariableTable lvt = method.getLocalVariableTable();
        if (lvt != null && Stream.of(lvt.getLocalVariableTable()).anyMatch(lv -> MultiThreadedCodeIdentifierUtils.isFromAtomicPackage(lv.getSignature()))) {
            return true;
        }
        MethodGen methodGen = classContext.getMethodGen(method);
        if (methodGen != null) {
            return MultiThreadedCodeIdentifierUtils.hasMultiThreadedInstruction(methodGen);
        }
        return false;
    }

    private static boolean hasMultiThreadedInstruction(MethodGen methodGen) {
        ConstantPoolGen cpg = methodGen.getConstantPool();
        for (InstructionHandle handle = methodGen.getInstructionList().getStart(); handle != null; handle = handle.getNext()) {
            String methodName;
            InvokeInstruction iins;
            String className;
            Instruction ins = handle.getInstruction();
            if (ins instanceof MONITORENTER) {
                return true;
            }
            if (!(ins instanceof InvokeInstruction) || ins instanceof INVOKEDYNAMIC || !MultiThreadedCodeIdentifierUtils.isConcurrentLockInterfaceCall(className = (iins = (InvokeInstruction)ins).getClassName(cpg), methodName = iins.getMethodName(cpg)) && !CollectionAnalysis.isSynchronizedCollection(className, methodName)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConcurrentLockInterfaceCall(@DottedClassName String className, String methodName) {
        return MultiThreadedCodeIdentifierUtils.isInstanceOfLock(className) && ("lock".equals(methodName) || "unlock".equals(methodName) || "tryLock".equals(methodName) || "lockInterruptibly".equals(methodName));
    }

    private static boolean isInstanceOfLock(@DottedClassName String className) {
        return className != null && Subtypes2.instanceOf(className, "java.util.concurrent.locks.Lock");
    }

    private static boolean isFieldIndicatingMultiThreadedContainer(Field field) {
        if (field.isSynthetic()) {
            return false;
        }
        return field.isVolatile() || MultiThreadedCodeIdentifierUtils.isFromAtomicPackage(field.getSignature()) || MultiThreadedCodeIdentifierUtils.isInstanceOfLock(ClassName.fromFieldSignatureToDottedClassName(field.getSignature()));
    }

    private static boolean isFromAtomicPackage(String signature) {
        return signature.contains(ATOMIC_PACKAGE);
    }

    public static boolean isLocked(Method currentMethod, CFG currentCFG, LockDataflow currentLockDataFlow, int pc) {
        try {
            if (currentMethod != null && currentLockDataFlow != null && currentCFG != null) {
                Collection<Location> tLocations = currentCFG.getLocationsContainingInstructionWithOffset(pc);
                for (Location tLoc : tLocations) {
                    LockSet lockSet = (LockSet)currentLockDataFlow.getFactAtLocation(tLoc);
                    if (lockSet.getNumLockedObjects() <= 0) continue;
                    return true;
                }
            }
        }
        catch (DataflowAnalysisException e) {
            AnalysisContext.logError(String.format("Synchronization check caught an error when analyzing %s method.", currentMethod.getName()), e);
        }
        return false;
    }

    public static boolean isNotThreadSafe(ClassContext classContext) {
        JavaClass javaClass = classContext.getJavaClass();
        for (AnnotationEntry annotationEntry : javaClass.getAnnotationEntries()) {
            if (!annotationEntry.getAnnotationType().endsWith("/NotThreadSafe;")) continue;
            return true;
        }
        return false;
    }
}

