/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.findbugs.workflow;

import edu.umd.cs.findbugs.FindBugs;
import edu.umd.cs.findbugs.charsets.UTF8;
import edu.umd.cs.findbugs.charsets.UserTextFile;
import edu.umd.cs.findbugs.config.CommandLine;
import edu.umd.cs.findbugs.util.ClassName;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;
import org.apache.bcel.classfile.ClassParser;
import org.apache.bcel.classfile.JavaClass;

public class RejarClassesForAnalysis {
    final RejarClassesForAnalysisCommandLine commandLine;
    final int argCount;
    final String[] args;
    SortedMap<String, ZipOutputStream> analysisOutputFiles = new TreeMap<String, ZipOutputStream>();
    int analysisCount = 1;
    int auxiliaryCount = 1;
    Map<String, Long> copied = new HashMap<String, Long>();
    Map<String, File> copyFrom = new HashMap<String, File>();
    Set<String> excluded = new HashSet<String>();
    TreeSet<String> filesToAnalyze = new TreeSet();
    int numFilesToAnalyze = 0;
    int auxiliaryClassCount = 0;
    ZipOutputStream auxiliaryOut;
    final byte[] buffer = new byte[8192];
    boolean classFileFound;

    public RejarClassesForAnalysis(RejarClassesForAnalysisCommandLine commandLine, int argCount, String[] args) {
        this.commandLine = commandLine;
        this.argCount = argCount;
        this.args = args;
    }

    public static void readFromStandardInput(Collection<String> result) throws IOException {
        RejarClassesForAnalysis.readFrom(result, UserTextFile.bufferedReader(System.in));
    }

    @Nonnull
    public ZipOutputStream getZipOutputFile(String path) {
        ZipOutputStream result = (ZipOutputStream)this.analysisOutputFiles.get(path);
        if (result != null) {
            return result;
        }
        SortedMap<String, ZipOutputStream> head = this.analysisOutputFiles.headMap(path);
        String matchingPath = head.lastKey();
        result = (ZipOutputStream)this.analysisOutputFiles.get(matchingPath);
        if (result == null) {
            throw new IllegalArgumentException("No zip output file for " + path);
        }
        return result;
    }

    public static void readFrom(Collection<String> result, @WillClose Reader r) throws IOException {
        BufferedReader in = new BufferedReader(r);
        while (true) {
            String s;
            if ((s = in.readLine()) == null) {
                in.close();
                return;
            }
            result.add(s);
        }
    }

    String getNextAuxiliaryFileOutput() {
        Object result = this.auxiliaryCount == 1 ? "auxiliary.jar" : "auxiliary" + this.auxiliaryCount + ".jar";
        ++this.auxiliaryCount;
        System.out.println("Starting " + (String)result);
        return result;
    }

    String getNextAnalyzeFileOutput() {
        Object result = this.analysisCount == 1 ? "analyze.jar" : "analyze" + this.analysisCount + ".jar";
        ++this.analysisCount;
        System.out.println("Starting " + (String)result);
        return result;
    }

    public static void main(String[] args) throws Exception {
        FindBugs.setNoAnalysis();
        RejarClassesForAnalysisCommandLine commandLine = new RejarClassesForAnalysisCommandLine();
        int argCount = commandLine.parse(args, 0, Integer.MAX_VALUE, "Usage: " + RejarClassesForAnalysis.class.getName() + " [options] [<jarFile>+] ");
        RejarClassesForAnalysis doit = new RejarClassesForAnalysis(commandLine, argCount, args);
        doit.execute();
    }

    private boolean exclude(String dottedName) {
        if (!Character.isJavaIdentifierStart(dottedName.charAt(0))) {
            return true;
        }
        if (this.commandLine.excludePatterns != null && this.commandLine.excludePatterns.matches(dottedName) || this.commandLine.exclude.matches(dottedName)) {
            this.excluded.add(dottedName);
            return true;
        }
        return false;
    }

    public void execute() throws IOException {
        int oldSize;
        File f;
        ArrayList<String> fileList = new ArrayList<String>();
        if (this.commandLine.inputFileList != null) {
            RejarClassesForAnalysis.readFrom(fileList, UTF8.fileReader(this.commandLine.inputFileList));
        } else if (this.argCount == this.args.length) {
            RejarClassesForAnalysis.readFromStandardInput(fileList);
        } else {
            fileList.addAll(Arrays.asList(this.args).subList(this.argCount, this.args.length));
        }
        ArrayList<String> auxFileList = new ArrayList<String>();
        if (this.commandLine.auxFileList != null) {
            RejarClassesForAnalysis.readFrom(auxFileList, UTF8.fileReader(this.commandLine.auxFileList));
            auxFileList.removeAll(fileList);
        }
        ArrayList<File> inputZipFiles = new ArrayList<File>(fileList.size());
        ArrayList<File> auxZipFiles = new ArrayList<File>(auxFileList.size());
        for (String fInName : fileList) {
            f = new File(fInName);
            if (f.lastModified() < this.commandLine.maxAge) {
                System.err.println("Skipping " + fInName + ", too old (" + String.valueOf(new Date(f.lastModified())) + ")");
                continue;
            }
            oldSize = this.copied.size();
            this.classFileFound = false;
            if (this.processZipEntries(f, new ZipElementHandler(){
                boolean checked = false;

                @Override
                public void handle(ZipFile file, ZipEntry ze) throws IOException {
                    if (RejarClassesForAnalysis.this.commandLine.skip(ze)) {
                        return;
                    }
                    String name = ze.getName();
                    String dottedName = ClassName.toDottedClassName(name);
                    if (RejarClassesForAnalysis.this.exclude(dottedName)) {
                        return;
                    }
                    if (!this.checked) {
                        this.checked = true;
                        if (RejarClassesForAnalysis.this.embeddedNameMismatch(file, ze)) {
                            System.out.println("Class name mismatch for " + name + " in " + file.getName());
                            throw new ClassFileNameMismatch();
                        }
                    }
                    if (!RejarClassesForAnalysis.this.commandLine.prefix.matches(dottedName)) {
                        return;
                    }
                    RejarClassesForAnalysis.this.classFileFound = true;
                    long timestamp = ze.getTime();
                    Long oldTimestamp = RejarClassesForAnalysis.this.copied.get(name);
                    if (oldTimestamp == null) {
                        RejarClassesForAnalysis.this.copied.put(name, timestamp);
                        RejarClassesForAnalysis.this.copyFrom.put(name, f);
                        RejarClassesForAnalysis.this.filesToAnalyze.add(name);
                        ++RejarClassesForAnalysis.this.numFilesToAnalyze;
                    } else if (!RejarClassesForAnalysis.this.commandLine.ignoreTimestamps && oldTimestamp < timestamp) {
                        System.out.printf("Found later version of %s; switching from %s to %s%n", name, RejarClassesForAnalysis.this.copyFrom.get(name), f);
                        RejarClassesForAnalysis.this.copied.put(name, timestamp);
                        RejarClassesForAnalysis.this.copyFrom.put(name, f);
                    }
                }
            }) && oldSize < this.copied.size()) {
                inputZipFiles.add(f);
                continue;
            }
            if (this.classFileFound) {
                System.err.println("Skipping " + fInName + ", no new classes found");
                continue;
            }
            System.err.println("Skipping " + fInName + ", no classes found");
        }
        for (String fInName : auxFileList) {
            f = new File(fInName);
            if (f.lastModified() < this.commandLine.maxAge) {
                System.err.println("Skipping " + fInName + ", too old (" + String.valueOf(new Date(f.lastModified())) + ")");
                continue;
            }
            oldSize = this.copied.size();
            this.classFileFound = false;
            if (this.processZipEntries(f, (file, ze) -> {
                if (this.commandLine.skip(ze)) {
                    return;
                }
                String name = ze.getName();
                String dottedName = ClassName.toDottedClassName(name);
                if (!this.exclude(dottedName)) {
                    this.classFileFound = true;
                    long timestamp = ze.getTime();
                    Long oldTimestamp = this.copied.get(name);
                    if (oldTimestamp == null || !this.commandLine.ignoreTimestamps && oldTimestamp < timestamp) {
                        this.copied.put(name, timestamp);
                        this.copyFrom.put(name, f);
                    }
                }
            }) && oldSize < this.copied.size()) {
                auxZipFiles.add(f);
                continue;
            }
            if (this.classFileFound) {
                System.err.println("Skipping aux file " + fInName + ", no new classes found");
                continue;
            }
            System.err.println("Skipping aux file" + fInName + ", no classes found");
        }
        System.out.printf("    # Zip/jar files: %2d%n", inputZipFiles.size());
        System.out.printf("# aux Zip/jar files: %2d%n", auxZipFiles.size());
        System.out.printf("Unique class files: %6d%n", this.copied.size());
        if (this.numFilesToAnalyze != this.copied.size()) {
            System.out.printf("  files to analyze: %6d%n", this.numFilesToAnalyze);
        }
        if (!this.excluded.isEmpty()) {
            System.out.printf("   excluded  files: %6d%n", this.excluded.size());
        }
        if (this.commandLine.onlyAnalyze) {
            return;
        }
        if (this.numFilesToAnalyze < this.copied.size() || this.numFilesToAnalyze > this.commandLine.maxClasses) {
            this.auxiliaryOut = this.createZipFile(this.getNextAuxiliaryFileOutput());
        }
        int count = Integer.MAX_VALUE;
        String oldBaseClass = "x x";
        String oldPackage = "x x";
        for (String path : this.filesToAnalyze) {
            String baseClass;
            int lastSlash = path.lastIndexOf(47);
            String packageName = lastSlash <= 0 ? "" : path.substring(0, lastSlash - 1);
            int firstDollar = path.indexOf(36, lastSlash);
            String string = baseClass = firstDollar < 0 ? path : path.substring(0, firstDollar - 1);
            boolean switchOutput = count > this.commandLine.maxClasses ? true : (count + 50 > this.commandLine.maxClasses && !baseClass.equals(oldBaseClass) ? true : count + 250 > this.commandLine.maxClasses && !packageName.equals(oldPackage));
            if (switchOutput) {
                String zipFileName = this.getNextAnalyzeFileOutput();
                this.analysisOutputFiles.put(path, this.createZipFile(zipFileName));
                System.out.printf("%s%n -> %s%n", path, zipFileName);
                count = 0;
            }
            ++count;
            oldPackage = packageName;
            oldBaseClass = baseClass;
        }
        for (File f2 : inputZipFiles) {
            System.err.println("Reading " + String.valueOf(f2));
            File ff = f2;
            this.processZipEntries(f2, (zipInputFile, ze) -> {
                if (this.commandLine.skip(ze)) {
                    return;
                }
                String name = ze.getName();
                String dottedName = ClassName.toDottedClassName(name);
                if (this.exclude(dottedName)) {
                    return;
                }
                if (!ff.equals(this.copyFrom.get(name))) {
                    return;
                }
                if (name.contains("DefaultProblem.class")) {
                    System.out.printf("%40s %40s%n", name, ff);
                }
                boolean writeToAnalyzeOut = false;
                boolean writeToAuxiliaryOut = false;
                if (this.commandLine.prefix.matches(dottedName)) {
                    writeToAnalyzeOut = true;
                    if (this.numFilesToAnalyze > this.commandLine.maxClasses) {
                        writeToAuxiliaryOut = true;
                    }
                } else {
                    writeToAuxiliaryOut = this.auxiliaryOut != null;
                }
                ZipOutputStream out = null;
                if (writeToAnalyzeOut) {
                    out = this.getZipOutputFile(name);
                    out.putNextEntry(this.newZipEntry(ze));
                }
                if (writeToAuxiliaryOut) {
                    ++this.auxiliaryClassCount;
                    if (this.auxiliaryClassCount > 29999) {
                        this.auxiliaryClassCount = 0;
                        this.advanceAuxiliaryOut();
                    }
                    this.auxiliaryOut.putNextEntry(this.newZipEntry(ze));
                }
                this.copyEntry(zipInputFile, ze, writeToAnalyzeOut, out, writeToAuxiliaryOut, this.auxiliaryOut);
            });
        }
        Iterator<Object> iterator = auxZipFiles.iterator();
        while (iterator.hasNext()) {
            File f2;
            File ff = f2 = (File)((Object)iterator.next());
            System.err.println("Opening aux file " + String.valueOf(f2));
            this.processZipEntries(f2, (zipInputFile, ze) -> {
                if (this.commandLine.skip(ze)) {
                    return;
                }
                String name = ze.getName();
                String dottedName = ClassName.toDottedClassName(name);
                if (this.exclude(dottedName)) {
                    return;
                }
                if (!ff.equals(this.copyFrom.get(name))) {
                    return;
                }
                ++this.auxiliaryClassCount;
                if (this.auxiliaryClassCount > 29999) {
                    this.auxiliaryClassCount = 0;
                    this.advanceAuxiliaryOut();
                }
                this.auxiliaryOut.putNextEntry(this.newZipEntry(ze));
                this.copyEntry(zipInputFile, ze, false, null, true, this.auxiliaryOut);
            });
        }
        if (this.auxiliaryOut != null) {
            this.auxiliaryOut.close();
        }
        for (ZipOutputStream out : this.analysisOutputFiles.values()) {
            out.close();
        }
        System.out.println("All done");
    }

    private ZipOutputStream createZipFile(String fileName) throws FileNotFoundException {
        File newFile = new File(this.commandLine.outputDir, fileName);
        return new ZipOutputStream(new BufferedOutputStream(new FileOutputStream(newFile)));
    }

    private boolean embeddedNameMismatch(ZipFile zipInputFile, ZipEntry ze) throws IOException {
        InputStream zipIn = zipInputFile.getInputStream(ze);
        String name = ze.getName();
        JavaClass j = new ClassParser(zipIn, name).parse();
        zipIn.close();
        String className = j.getClassName();
        String computedFileName = ClassName.toSlashedClassName(className) + ".class";
        if (name.charAt(0) == '1') {
            System.out.println(name);
            System.out.println("  " + className);
        }
        if (computedFileName.equals(name)) {
            return false;
        }
        System.out.println("In " + name + " found " + className);
        return true;
    }

    private void copyEntry(ZipFile zipInputFile, ZipEntry ze, boolean writeToAnalyzeOut, ZipOutputStream analyzeOut1, boolean writeToAuxiliaryOut, ZipOutputStream auxiliaryOut1) throws IOException {
        int bytesRead;
        InputStream zipIn = zipInputFile.getInputStream(ze);
        while ((bytesRead = zipIn.read(this.buffer)) >= 0) {
            if (writeToAnalyzeOut) {
                analyzeOut1.write(this.buffer, 0, bytesRead);
            }
            if (!writeToAuxiliaryOut) continue;
            auxiliaryOut1.write(this.buffer, 0, bytesRead);
        }
        if (writeToAnalyzeOut) {
            analyzeOut1.closeEntry();
        }
        if (writeToAuxiliaryOut) {
            auxiliaryOut1.closeEntry();
        }
        zipIn.close();
    }

    private void advanceAuxiliaryOut() throws IOException {
        this.auxiliaryOut.close();
        this.auxiliaryOut = this.createZipFile(this.getNextAuxiliaryFileOutput());
    }

    boolean processZipEntries(File f, ZipElementHandler handler) {
        if (!f.exists()) {
            System.out.println("file not found: '" + String.valueOf(f) + "'");
            return false;
        }
        if (!f.canRead() || f.isDirectory()) {
            System.out.println("not readable: '" + String.valueOf(f) + "'");
            return false;
        }
        if (!f.canRead() || f.isDirectory()) {
            System.out.println("not readable: '" + String.valueOf(f) + "'");
            return false;
        }
        if (f.length() == 0L) {
            System.out.println("empty zip file: '" + String.valueOf(f) + "'");
            return false;
        }
        try (ZipFile zipInputFile = new ZipFile(f);){
            Enumeration<? extends ZipEntry> e = zipInputFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry ze = e.nextElement();
                if (ze.isDirectory() || !ze.getName().endsWith(".class") || ze.getSize() == 0L) continue;
                handler.handle(zipInputFile, ze);
            }
        }
        catch (ClassFileNameMismatch e) {
            return false;
        }
        catch (IOException e) {
            System.out.println("Error processing '" + String.valueOf(f) + "'");
            return false;
        }
        return true;
    }

    public ZipEntry newZipEntry(ZipEntry ze) {
        ZipEntry ze2 = new ZipEntry(ze.getName());
        ze2.setComment(ze.getComment());
        ze2.setTime(ze.getTime());
        ze2.setExtra(ze.getExtra());
        return ze2;
    }

    static class RejarClassesForAnalysisCommandLine
    extends CommandLine {
        PrefixMatcher prefix = new PrefixMatcher("");
        PrefixMatcher exclude = new PrefixMatcher();
        PatternMatcher excludePatterns = null;
        int maxClasses = 29999;
        long maxAge = Long.MIN_VALUE;
        public String inputFileList;
        public String auxFileList;
        boolean onlyAnalyze = false;
        boolean ignoreTimestamps = false;
        File outputDir = new File(".");

        RejarClassesForAnalysisCommandLine() {
            this.addSwitch("-analyzeOnly", "only read the jars files and analyze them; don't produce new jar files");
            this.addOption("-maxAge", "days", "maximum age in days (ignore jar files older than this)");
            this.addOption("-inputFileList", "filename", "text file containing names of jar files");
            this.addOption("-auxFileList", "filename", "text file containing names of jar files for aux class path");
            this.addOption("-maxClasses", "num", "maximum number of classes per analysis*.jar file");
            this.addOption("-outputDir", "dir", "directory for the generated jar files");
            this.addSwitch("-ignoreTimestamps", "ignore timestamps on zip entries; use first version found");
            this.addOption("-prefix", "class name prefix", "comma separated list of class name prefixes that should be analyzed (e.g., edu.umd.cs.)");
            this.addOption("-exclude", "class name prefix", "comma separated list of class name prefixes that should be  excluded from both analyze and auxiliary jar files (e.g., java.)");
            this.addOption("-excludePattern", "class name pattern(s)", "comma separated list of regular expressions; all classes matching them are excluded");
        }

        @Override
        protected void handleOption(String option, String optionExtraPart) throws IOException {
            if ("-analyzeOnly".equals(option)) {
                this.onlyAnalyze = true;
            } else if ("-ignoreTimestamps".equals(option)) {
                this.ignoreTimestamps = true;
            } else {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
        }

        @Override
        protected void handleOptionWithArgument(String option, String argument) throws IOException {
            if ("-prefix".equals(option)) {
                this.prefix = new PrefixMatcher(argument);
            } else if ("-exclude".equals(option)) {
                this.exclude = new PrefixMatcher(argument);
            } else if ("-inputFileList".equals(option)) {
                this.inputFileList = argument;
            } else if ("-auxFileList".equals(option)) {
                this.auxFileList = argument;
            } else if ("-maxClasses".equals(option)) {
                this.maxClasses = Integer.parseInt(argument);
            } else if ("-maxAge".equals(option)) {
                this.maxAge = System.currentTimeMillis() - 86400000L * (long)Integer.parseInt(argument);
            } else if ("-outputDir".equals(option)) {
                this.outputDir = new File(argument);
            } else if ("-excludePattern".equals(option)) {
                this.excludePatterns = new PatternMatcher(argument);
            } else {
                throw new IllegalArgumentException("Unknown option : " + option);
            }
        }

        boolean skip(ZipEntry ze) {
            return ze.getSize() > 1000000L;
        }

        static class PrefixMatcher {
            final String[] prefixes;

            PrefixMatcher(String arg) {
                this.prefixes = arg.split(",");
            }

            PrefixMatcher() {
                this.prefixes = new String[0];
            }

            public boolean matches(String arg) {
                for (String p : this.prefixes) {
                    if (!arg.startsWith(p)) continue;
                    return true;
                }
                return false;
            }

            public boolean matchesEverything() {
                for (String p : this.prefixes) {
                    if (!p.isEmpty()) continue;
                    return true;
                }
                return false;
            }
        }

        static class PatternMatcher {
            final Pattern[] pattern;

            PatternMatcher(String arg) {
                String[] p = arg.split(",");
                this.pattern = new Pattern[p.length];
                for (int i = 0; i < p.length; ++i) {
                    this.pattern[i] = Pattern.compile(p[i]);
                }
            }

            public boolean matches(String arg) {
                for (Pattern p : this.pattern) {
                    if (!p.matcher(arg).find()) continue;
                    return true;
                }
                return false;
            }
        }
    }

    static interface ZipElementHandler {
        public void handle(ZipFile var1, ZipEntry var2) throws IOException;
    }

    static class ClassFileNameMismatch
    extends IOException {
        ClassFileNameMismatch() {
        }
    }
}

