/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson;

import com.google.gson.Gson;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.internal.ParameterizedTypeHandlerMap;
import com.google.gson.internal.Streams;
import com.google.gson.internal.bind.MiniGson;
import com.google.gson.internal.bind.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GsonToMiniGsonTypeAdapterFactory
implements TypeAdapter.Factory {
    private final ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers;
    private final ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers;
    private final JsonDeserializationContext deserializationContext;
    private final JsonSerializationContext serializationContext;

    public GsonToMiniGsonTypeAdapterFactory(final Gson gson, ParameterizedTypeHandlerMap<JsonSerializer<?>> serializers, ParameterizedTypeHandlerMap<JsonDeserializer<?>> deserializers) {
        this.serializers = serializers;
        this.deserializers = deserializers;
        this.deserializationContext = new JsonDeserializationContext(){

            @Override
            public <T> T deserialize(JsonElement json, Type typeOfT) throws JsonParseException {
                return gson.fromJson(json, typeOfT);
            }
        };
        this.serializationContext = new JsonSerializationContext(){

            public JsonElement serialize(Object src) {
                return gson.toJsonTree(src);
            }

            public JsonElement serialize(Object src, Type typeOfSrc) {
                return gson.toJsonTree(src, typeOfSrc);
            }
        };
    }

    @Override
    public <T> TypeAdapter<T> create(final MiniGson context, final TypeToken<T> typeToken) {
        final Type type = typeToken.getType();
        final JsonSerializer<?> serializer = this.serializers.getHandlerFor(type, false);
        final JsonDeserializer<?> deserializer = this.deserializers.getHandlerFor(type, false);
        if (serializer == null && deserializer == null) {
            return null;
        }
        return new TypeAdapter<T>(){
            private TypeAdapter<T> delegate;

            @Override
            public T read(JsonReader reader) throws IOException {
                if (deserializer == null) {
                    return this.delegate().read(reader);
                }
                JsonElement value = Streams.parse(reader);
                if (value.isJsonNull()) {
                    return null;
                }
                return deserializer.deserialize(value, type, GsonToMiniGsonTypeAdapterFactory.this.deserializationContext);
            }

            @Override
            public void write(JsonWriter writer, T value) throws IOException {
                if (serializer == null) {
                    this.delegate().write(writer, value);
                    return;
                }
                if (value == null) {
                    writer.nullValue();
                    return;
                }
                JsonElement element = serializer.serialize(value, type, GsonToMiniGsonTypeAdapterFactory.this.serializationContext);
                Streams.write(element, writer);
            }

            private TypeAdapter<T> delegate() {
                TypeAdapter d = this.delegate;
                return d != null ? d : (this.delegate = context.getNextAdapter(GsonToMiniGsonTypeAdapterFactory.this, typeToken));
            }
        };
    }
}

