/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal;

import com.google.gson.internal.$Gson$Types;
import com.google.gson.internal.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ParameterizedTypeHandlerMap<T> {
    private static final Logger logger = Logger.getLogger(ParameterizedTypeHandlerMap.class.getName());
    private final Map<Type, T> systemMap = new HashMap<Type, T>();
    private final Map<Type, T> userMap = new HashMap<Type, T>();
    private final List<Pair<Class<?>, T>> systemTypeHierarchyList = new ArrayList();
    private final List<Pair<Class<?>, T>> userTypeHierarchyList = new ArrayList();
    private boolean modifiable = true;

    public synchronized void registerForTypeHierarchy(Class<?> typeOfT, T value, boolean isSystem) {
        Pair pair = new Pair(typeOfT, value);
        this.registerForTypeHierarchy(pair, isSystem);
    }

    public synchronized void registerForTypeHierarchy(Pair<Class<?>, T> pair, boolean isSystem) {
        if (!this.modifiable) {
            throw new IllegalStateException("Attempted to modify an unmodifiable map.");
        }
        List<Pair<Class<?>, T>> typeHierarchyList = isSystem ? this.systemTypeHierarchyList : this.userTypeHierarchyList;
        int index = ParameterizedTypeHandlerMap.getIndexOfSpecificHandlerForTypeHierarchy((Class)pair.first, typeHierarchyList);
        if (index >= 0) {
            logger.log(Level.WARNING, "Overriding the existing type handler for {0}", pair.first);
            typeHierarchyList.remove(index);
        }
        if ((index = ParameterizedTypeHandlerMap.getIndexOfAnOverriddenHandler((Class)pair.first, typeHierarchyList)) >= 0) {
            throw new IllegalArgumentException("The specified type handler for type " + pair.first + " hides the previously registered type hierarchy handler for " + typeHierarchyList.get((int)index).first + ". Gson does not allow this.");
        }
        typeHierarchyList.add(0, pair);
    }

    private static <T> int getIndexOfAnOverriddenHandler(Class<?> type, List<Pair<Class<?>, T>> typeHierarchyList) {
        for (int i = typeHierarchyList.size() - 1; i >= 0; --i) {
            Pair<Class<?>, T> entry = typeHierarchyList.get(i);
            if (!type.isAssignableFrom((Class)entry.first)) continue;
            return i;
        }
        return -1;
    }

    public synchronized void register(Type typeOfT, T value, boolean isSystem) {
        if (!this.modifiable) {
            throw new IllegalStateException("Attempted to modify an unmodifiable map.");
        }
        if (this.hasSpecificHandlerFor(typeOfT)) {
            logger.log(Level.WARNING, "Overriding the existing type handler for {0}", typeOfT);
        }
        Map<Type, T> map = isSystem ? this.systemMap : this.userMap;
        map.put(typeOfT, value);
    }

    public synchronized void registerIfAbsent(ParameterizedTypeHandlerMap<T> other) {
        int index;
        int i;
        Map.Entry<Type, T> entry2;
        if (!this.modifiable) {
            throw new IllegalStateException("Attempted to modify an unmodifiable map.");
        }
        for (Map.Entry<Type, T> entry2 : other.userMap.entrySet()) {
            if (this.userMap.containsKey(entry2.getKey())) continue;
            this.register(entry2.getKey(), entry2.getValue(), false);
        }
        for (Map.Entry<Type, T> entry2 : other.systemMap.entrySet()) {
            if (this.systemMap.containsKey(entry2.getKey())) continue;
            this.register(entry2.getKey(), entry2.getValue(), true);
        }
        for (i = other.userTypeHierarchyList.size() - 1; i >= 0; --i) {
            entry2 = other.userTypeHierarchyList.get(i);
            index = ParameterizedTypeHandlerMap.getIndexOfSpecificHandlerForTypeHierarchy((Class)((Pair)((Object)entry2)).first, this.userTypeHierarchyList);
            if (index >= 0) continue;
            this.registerForTypeHierarchy((Pair<Class<?>, T>)((Object)entry2), false);
        }
        for (i = other.systemTypeHierarchyList.size() - 1; i >= 0; --i) {
            entry2 = other.systemTypeHierarchyList.get(i);
            index = ParameterizedTypeHandlerMap.getIndexOfSpecificHandlerForTypeHierarchy((Class)((Pair)((Object)entry2)).first, this.systemTypeHierarchyList);
            if (index >= 0) continue;
            this.registerForTypeHierarchy((Pair<Class<?>, T>)((Object)entry2), true);
        }
    }

    public synchronized ParameterizedTypeHandlerMap<T> makeUnmodifiable() {
        this.modifiable = false;
        return this;
    }

    public synchronized T getHandlerFor(Type type, boolean systemOnly) {
        T handler;
        if (!systemOnly && (handler = this.userMap.get(type)) != null) {
            return handler;
        }
        handler = this.systemMap.get(type);
        if (handler != null) {
            return handler;
        }
        Class<?> rawClass = $Gson$Types.getRawType(type);
        if (rawClass != type && (handler = this.getHandlerFor(rawClass, systemOnly)) != null) {
            return handler;
        }
        handler = this.getHandlerForTypeHierarchy(rawClass, systemOnly);
        return handler;
    }

    private T getHandlerForTypeHierarchy(Class<?> type, boolean systemOnly) {
        if (!systemOnly) {
            for (Pair<Class<?>, T> entry : this.userTypeHierarchyList) {
                if (!((Class)entry.first).isAssignableFrom(type)) continue;
                return (T)entry.second;
            }
        }
        for (Pair<Class<?>, T> entry : this.systemTypeHierarchyList) {
            if (!((Class)entry.first).isAssignableFrom(type)) continue;
            return (T)entry.second;
        }
        return null;
    }

    public synchronized boolean hasSpecificHandlerFor(Type type) {
        return this.userMap.containsKey(type) || this.systemMap.containsKey(type);
    }

    private static <T> int getIndexOfSpecificHandlerForTypeHierarchy(Class<?> type, List<Pair<Class<?>, T>> typeHierarchyList) {
        for (int i = typeHierarchyList.size() - 1; i >= 0; --i) {
            if (!type.equals(typeHierarchyList.get((int)i).first)) continue;
            return i;
        }
        return -1;
    }

    public synchronized ParameterizedTypeHandlerMap<T> copyOf() {
        ParameterizedTypeHandlerMap<T> copy = new ParameterizedTypeHandlerMap<T>();
        copy.systemMap.putAll(this.systemMap);
        copy.userMap.putAll(this.userMap);
        copy.systemTypeHierarchyList.addAll(this.systemTypeHierarchyList);
        copy.userTypeHierarchyList.addAll(this.userTypeHierarchyList);
        return copy;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("{userTypeHierarchyList:{");
        this.appendList(sb, this.userTypeHierarchyList);
        sb.append("},systemTypeHierarchyList:{");
        this.appendList(sb, this.systemTypeHierarchyList);
        sb.append("},userMap:{");
        this.appendMap(sb, this.userMap);
        sb.append("},systemMap:{");
        this.appendMap(sb, this.systemMap);
        sb.append("}");
        return sb.toString();
    }

    private void appendList(StringBuilder sb, List<Pair<Class<?>, T>> list) {
        boolean first = true;
        for (Pair<Class<?>, T> entry : list) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.typeToString((Type)entry.first)).append(':');
            sb.append(entry.second);
        }
    }

    private void appendMap(StringBuilder sb, Map<Type, T> map) {
        boolean first = true;
        for (Map.Entry<Type, T> entry : map.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(this.typeToString(entry.getKey())).append(':');
            sb.append(entry.getValue());
        }
    }

    private String typeToString(Type type) {
        return $Gson$Types.getRawType(type).getSimpleName();
    }
}

