/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.ExclusionStrategy;
import com.google.gson.internal.bind.MiniGson;
import com.google.gson.internal.bind.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExcludedTypeAdapterFactory
implements TypeAdapter.Factory {
    private final ExclusionStrategy serializationExclusionStrategy;
    private final ExclusionStrategy deserializationExclusionStrategy;

    public ExcludedTypeAdapterFactory(ExclusionStrategy serializationExclusionStrategy, ExclusionStrategy deserializationExclusionStrategy) {
        this.serializationExclusionStrategy = serializationExclusionStrategy;
        this.deserializationExclusionStrategy = deserializationExclusionStrategy;
    }

    @Override
    public <T> TypeAdapter<T> create(final MiniGson context, final TypeToken<T> type) {
        Class<T> rawType = type.getRawType();
        final boolean skipSerialize = this.serializationExclusionStrategy.shouldSkipClass(rawType);
        final boolean skipDeserialize = this.deserializationExclusionStrategy.shouldSkipClass(rawType);
        if (!skipSerialize && !skipDeserialize) {
            return null;
        }
        return new TypeAdapter<T>(){
            private TypeAdapter<T> delegate;

            @Override
            public T read(JsonReader reader) throws IOException {
                if (skipDeserialize) {
                    reader.skipValue();
                    return null;
                }
                return this.delegate().read(reader);
            }

            @Override
            public void write(JsonWriter writer, T value) throws IOException {
                if (skipSerialize) {
                    writer.nullValue();
                    return;
                }
                this.delegate().write(writer, value);
            }

            private TypeAdapter<T> delegate() {
                TypeAdapter d = this.delegate;
                return d != null ? d : (this.delegate = context.getNextAdapter(ExcludedTypeAdapterFactory.this, type));
            }
        };
    }
}

