/*
 * Decompiled with CFR 0.152.
 */
package com.google.gson.internal.bind;

import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.internal.bind.JsonElementReader;
import com.google.gson.internal.bind.JsonElementWriter;
import com.google.gson.internal.bind.MiniGson;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TypeAdapter<T> {
    public abstract T read(JsonReader var1) throws IOException;

    public abstract void write(JsonWriter var1, T var2) throws IOException;

    public final String toJson(T value) throws IOException {
        StringWriter stringWriter = new StringWriter();
        this.write(stringWriter, value);
        return stringWriter.toString();
    }

    public final void write(Writer out, T value) throws IOException {
        JsonWriter writer = new JsonWriter(out);
        this.write(writer, value);
    }

    public final T fromJson(String json) throws IOException {
        return this.read(new StringReader(json));
    }

    public final T read(Reader in) throws IOException {
        JsonReader reader = new JsonReader(in);
        reader.setLenient(true);
        return this.read(reader);
    }

    public JsonElement toJsonElement(T src) {
        try {
            JsonElementWriter jsonWriter = new JsonElementWriter();
            jsonWriter.setLenient(true);
            this.write(jsonWriter, src);
            return jsonWriter.get();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public T fromJsonElement(JsonElement json) {
        try {
            JsonElementReader jsonReader = new JsonElementReader(json);
            jsonReader.setLenient(true);
            return this.read(jsonReader);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public <T> TypeAdapter<T> create(MiniGson var1, TypeToken<T> var2);
    }
}

