/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.Replacement;
import com.google.errorprone.fixes.Replacements;
import com.sun.tools.javac.tree.EndPosTable;
import java.util.Set;
import org.jspecify.annotations.Nullable;

public record AppliedFix(String snippet, boolean isRemoveLine) {
    public static @Nullable AppliedFix apply(CharSequence source, EndPosTable endPositions, Fix suggestedFix) {
        ImmutableSet<Replacement> replacements = AppliedFix.ascending(suggestedFix.getReplacements(endPositions));
        if (replacements.isEmpty()) {
            return null;
        }
        String replaced = AppliedFix.applyReplacements(source, endPositions, suggestedFix);
        String snippet = AppliedFix.firstEditedLine(replaced, (Replacement)Iterables.get(replacements, (int)0));
        if (snippet.isEmpty()) {
            return new AppliedFix("to remove this line", true);
        }
        return new AppliedFix(snippet, false);
    }

    public static String applyReplacements(CharSequence source, EndPosTable endPositions, Fix fix) {
        StringBuilder replaced = new StringBuilder();
        int positionInOriginal = 0;
        for (Replacement repl : fix.getReplacements(endPositions)) {
            Preconditions.checkArgument((repl.endPosition() <= source.length() ? 1 : 0) != 0, (String)"End [%s] should not exceed source length [%s]", (int)repl.endPosition(), (int)source.length());
            replaced.append(source, positionInOriginal, repl.startPosition());
            replaced.append(repl.replaceWith());
            positionInOriginal = repl.endPosition();
        }
        replaced.append(source, positionInOriginal, source.length());
        return replaced.toString();
    }

    private static ImmutableSet<Replacement> ascending(Set<Replacement> set) {
        Replacements replacements = new Replacements();
        set.forEach(replacements::add);
        return replacements.ascending();
    }

    private static String firstEditedLine(String content, Replacement firstEdit) {
        int startOfFirstEditedLine = content.lastIndexOf("\n", firstEdit.startPosition() - 1);
        int endOfFirstEditedLine = content.indexOf("\n", firstEdit.startPosition());
        if (startOfFirstEditedLine == -1) {
            startOfFirstEditedLine = 0;
        }
        if (endOfFirstEditedLine == -1) {
            endOfFirstEditedLine = content.length();
        }
        String snippet = content.substring(startOfFirstEditedLine, endOfFirstEditedLine);
        if ((snippet = snippet.trim()).contains("//")) {
            snippet = snippet.substring(0, snippet.indexOf("//")).trim();
        }
        return snippet;
    }
}

