/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.auto.value.AutoValue;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.AutoValue_ErrorProneOptions_PatchingOptions;
import com.google.errorprone.CodeTransformer;
import com.google.errorprone.ErrorProneFlags;
import com.google.errorprone.ImportOrderParser;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.apply.ImportOrganizer;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

public class ErrorProneOptions {
    private static final String PREFIX = "-Xep";
    private static final String SEVERITY_PREFIX = "-Xep:";
    private static final String PATCH_CHECKS_PREFIX = "-XepPatchChecks:";
    private static final String PATCH_OUTPUT_LOCATION = "-XepPatchLocation:";
    private static final String PATCH_IMPORT_ORDER_PREFIX = "-XepPatchImportOrder:";
    private static final String EXCLUDED_PATHS_PREFIX = "-XepExcludedPaths:";
    private static final String IGNORE_LARGE_CODE_GENERATORS = "-XepIgnoreLargeCodeGenerators:";
    private static final String ERRORS_AS_WARNINGS_FLAG = "-XepAllErrorsAsWarnings";
    private static final String SUGGESTIONS_AS_WARNINGS_FLAG = "-XepAllSuggestionsAsWarnings";
    private static final String ENABLE_ALL_CHECKS = "-XepAllDisabledChecksAsWarnings";
    private static final String IGNORE_SUPPRESSION_ANNOTATIONS = "-XepIgnoreSuppressionAnnotations";
    private static final String DISABLE_ALL_CHECKS = "-XepDisableAllChecks";
    private static final String DISABLE_ALL_WARNINGS = "-XepDisableAllWarnings";
    private static final String IGNORE_UNKNOWN_CHECKS_FLAG = "-XepIgnoreUnknownCheckNames";
    private static final String DISABLE_WARNINGS_IN_GENERATED_CODE_FLAG = "-XepDisableWarningsInGeneratedCode";
    private static final String COMPILING_TEST_ONLY_CODE = "-XepCompilingTestOnlyCode";
    private static final String COMPILING_PUBLICLY_VISIBLE_CODE = "-XepCompilingPubliclyVisibleCode";
    private final ImmutableList<String> remainingArgs;
    private final ImmutableMap<String, Severity> severityMap;
    private final boolean ignoreUnknownChecks;
    private final boolean disableWarningsInGeneratedCode;
    private final boolean disableAllWarnings;
    private final boolean dropErrorsToWarnings;
    private final boolean suggestionsAsWarnings;
    private final boolean enableAllChecksAsWarnings;
    private final boolean disableAllChecks;
    private final boolean isTestOnlyTarget;
    private final boolean isPubliclyVisibleTarget;
    private final ErrorProneFlags flags;
    private final PatchingOptions patchingOptions;
    private final Pattern excludedPattern;
    private final boolean ignoreSuppressionAnnotations;
    private final boolean ignoreLargeCodeGenerators;
    private static final ErrorProneOptions EMPTY = new Builder().build((ImmutableList<String>)ImmutableList.of());

    public static int isSupportedOption(String option) {
        boolean isSupported = option.startsWith(SEVERITY_PREFIX) || option.startsWith("-XepOpt:") || option.startsWith(PATCH_OUTPUT_LOCATION) || option.startsWith(PATCH_CHECKS_PREFIX) || option.startsWith(EXCLUDED_PATHS_PREFIX) || option.equals(IGNORE_UNKNOWN_CHECKS_FLAG) || option.equals(DISABLE_WARNINGS_IN_GENERATED_CODE_FLAG) || option.equals(ERRORS_AS_WARNINGS_FLAG) || option.equals(SUGGESTIONS_AS_WARNINGS_FLAG) || option.equals(ENABLE_ALL_CHECKS) || option.equals(DISABLE_ALL_CHECKS) || option.equals(IGNORE_SUPPRESSION_ANNOTATIONS) || option.equals(COMPILING_TEST_ONLY_CODE) || option.equals(COMPILING_PUBLICLY_VISIBLE_CODE) || option.equals(DISABLE_ALL_WARNINGS);
        return isSupported ? 0 : -1;
    }

    public boolean isEnableAllChecksAsWarnings() {
        return this.enableAllChecksAsWarnings;
    }

    public boolean isDisableAllChecks() {
        return this.disableAllChecks;
    }

    private ErrorProneOptions(ImmutableMap<String, Severity> severityMap, ImmutableList<String> remainingArgs, boolean ignoreUnknownChecks, boolean disableWarningsInGeneratedCode, boolean disableAllWarnings, boolean dropErrorsToWarnings, boolean suggestionsAsWarnings, boolean enableAllChecksAsWarnings, boolean disableAllChecks, boolean isTestOnlyTarget, boolean isPubliclyVisibleTarget, ErrorProneFlags flags, PatchingOptions patchingOptions, Pattern excludedPattern, boolean ignoreSuppressionAnnotations, boolean ignoreLargeCodeGenerators) {
        this.severityMap = severityMap;
        this.remainingArgs = remainingArgs;
        this.ignoreUnknownChecks = ignoreUnknownChecks;
        this.disableWarningsInGeneratedCode = disableWarningsInGeneratedCode;
        this.disableAllWarnings = disableAllWarnings;
        this.dropErrorsToWarnings = dropErrorsToWarnings;
        this.suggestionsAsWarnings = suggestionsAsWarnings;
        this.enableAllChecksAsWarnings = enableAllChecksAsWarnings;
        this.disableAllChecks = disableAllChecks;
        this.isTestOnlyTarget = isTestOnlyTarget;
        this.isPubliclyVisibleTarget = isPubliclyVisibleTarget;
        this.flags = flags;
        this.patchingOptions = patchingOptions;
        this.excludedPattern = excludedPattern;
        this.ignoreSuppressionAnnotations = ignoreSuppressionAnnotations;
        this.ignoreLargeCodeGenerators = ignoreLargeCodeGenerators;
    }

    public ImmutableList<String> getRemainingArgs() {
        return this.remainingArgs;
    }

    public ImmutableMap<String, Severity> getSeverityMap() {
        return this.severityMap;
    }

    public boolean ignoreUnknownChecks() {
        return this.ignoreUnknownChecks;
    }

    public boolean disableWarningsInGeneratedCode() {
        return this.disableWarningsInGeneratedCode;
    }

    public boolean isDisableAllWarnings() {
        return this.disableAllWarnings;
    }

    public boolean isDropErrorsToWarnings() {
        return this.dropErrorsToWarnings;
    }

    public boolean isSuggestionsAsWarnings() {
        return this.suggestionsAsWarnings;
    }

    public boolean isTestOnlyTarget() {
        return this.isTestOnlyTarget;
    }

    public boolean isPubliclyVisibleTarget() {
        return this.isPubliclyVisibleTarget;
    }

    public boolean isIgnoreSuppressionAnnotations() {
        return this.ignoreSuppressionAnnotations;
    }

    public boolean ignoreLargeCodeGenerators() {
        return this.ignoreLargeCodeGenerators;
    }

    public ErrorProneFlags getFlags() {
        return this.flags;
    }

    public PatchingOptions patchingOptions() {
        return this.patchingOptions;
    }

    public Pattern getExcludedPattern() {
        return this.excludedPattern;
    }

    public static ErrorProneOptions empty() {
        return EMPTY;
    }

    public static ErrorProneOptions processArgs(Iterable<String> args) {
        Preconditions.checkNotNull(args);
        ImmutableList.Builder remainingArgs = ImmutableList.builder();
        boolean patchLocationSet = false;
        boolean patchCheckSet = false;
        Builder builder = new Builder();
        Iterator<String> iterator = args.iterator();
        block24: while (iterator.hasNext()) {
            String remaining;
            String arg;
            switch (arg = iterator.next()) {
                case "-XepIgnoreSuppressionAnnotations": {
                    builder.setIgnoreSuppressionAnnotations(true);
                    continue block24;
                }
                case "-XepIgnoreUnknownCheckNames": {
                    builder.setIgnoreUnknownChecks(true);
                    continue block24;
                }
                case "-XepDisableWarningsInGeneratedCode": {
                    builder.setDisableWarningsInGeneratedCode(true);
                    continue block24;
                }
                case "-XepAllErrorsAsWarnings": {
                    builder.setDropErrorsToWarnings(true);
                    continue block24;
                }
                case "-XepAllSuggestionsAsWarnings": {
                    builder.setSuggestionsAsWarnings(true);
                    continue block24;
                }
                case "-XepAllDisabledChecksAsWarnings": {
                    builder.setEnableAllChecksAsWarnings(true);
                    continue block24;
                }
                case "-XepDisableAllChecks": {
                    builder.setDisableAllChecks(true);
                    continue block24;
                }
                case "-XepCompilingTestOnlyCode": {
                    builder.setTestOnlyTarget(true);
                    continue block24;
                }
                case "-XepCompilingPubliclyVisibleCode": {
                    builder.setPubliclyVisibleTarget(true);
                    continue block24;
                }
                case "-XepDisableAllWarnings": {
                    builder.setDisableAllWarnings(true);
                    continue block24;
                }
            }
            if (arg.startsWith(SEVERITY_PREFIX)) {
                builder.parseSeverity(arg);
                continue;
            }
            if (arg.startsWith("-XepOpt:")) {
                builder.parseFlag(arg);
                continue;
            }
            if (arg.startsWith(PATCH_OUTPUT_LOCATION)) {
                patchLocationSet = true;
                remaining = arg.substring(PATCH_OUTPUT_LOCATION.length());
                if (remaining.equals("IN_PLACE")) {
                    builder.patchingOptionsBuilder().inPlace(true);
                    continue;
                }
                if (remaining.isEmpty()) {
                    throw new InvalidCommandLineOptionException("invalid flag: " + arg);
                }
                builder.patchingOptionsBuilder().baseDirectory(remaining);
                continue;
            }
            if (arg.startsWith(PATCH_CHECKS_PREFIX)) {
                patchCheckSet = true;
                remaining = arg.substring(PATCH_CHECKS_PREFIX.length());
                if (remaining.startsWith("refaster:")) {
                    builder.patchingOptionsBuilder().customRefactorer((Supplier<CodeTransformer>)((Supplier)() -> {
                        String path = remaining.substring("refaster:".length());
                        try (InputStream in = Files.newInputStream(FileSystems.getDefault().getPath(path, new String[0]), new OpenOption[0]);){
                            CodeTransformer codeTransformer;
                            try (ObjectInputStream ois = new ObjectInputStream(in);){
                                codeTransformer = (CodeTransformer)ois.readObject();
                            }
                            return codeTransformer;
                        }
                        catch (IOException | ClassNotFoundException e) {
                            throw new RuntimeException("Can't load Refaster rule from " + path, e);
                        }
                    }));
                    continue;
                }
                Iterable checks = Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)remaining);
                builder.patchingOptionsBuilder().namedCheckers((ImmutableSet<String>)ImmutableSet.copyOf((Iterable)checks));
                continue;
            }
            if (arg.startsWith(PATCH_IMPORT_ORDER_PREFIX)) {
                remaining = arg.substring(PATCH_IMPORT_ORDER_PREFIX.length());
                ImportOrganizer importOrganizer = ImportOrderParser.getImportOrganizer(remaining);
                builder.patchingOptionsBuilder().importOrganizer(importOrganizer);
                continue;
            }
            if (arg.startsWith(EXCLUDED_PATHS_PREFIX)) {
                String pathRegex = arg.substring(EXCLUDED_PATHS_PREFIX.length());
                builder.setExcludedPattern(Pattern.compile(pathRegex));
                continue;
            }
            if (arg.startsWith(PREFIX)) {
                throw new InvalidCommandLineOptionException("invalid flag: " + arg);
            }
            remainingArgs.add((Object)arg);
        }
        if (patchCheckSet && !patchLocationSet) {
            throw new InvalidCommandLineOptionException("-XepPatchLocation must be specified when -XepPatchChecks is");
        }
        return builder.build((ImmutableList<String>)remainingArgs.build());
    }

    public static ErrorProneOptions processArgs(String[] args) {
        Preconditions.checkNotNull((Object)args);
        return ErrorProneOptions.processArgs(Arrays.asList(args));
    }

    @AutoValue
    static abstract class PatchingOptions {
        PatchingOptions() {
        }

        final boolean doRefactor() {
            return this.inPlace() || !this.baseDirectory().isEmpty();
        }

        abstract ImmutableSet<String> namedCheckers();

        abstract boolean inPlace();

        abstract String baseDirectory();

        abstract Optional<Supplier<CodeTransformer>> customRefactorer();

        abstract ImportOrganizer importOrganizer();

        static Builder builder() {
            return new AutoValue_ErrorProneOptions_PatchingOptions.Builder().baseDirectory("").inPlace(false).namedCheckers((ImmutableSet<String>)ImmutableSet.of()).importOrganizer(ImportOrganizer.STATIC_FIRST_ORGANIZER);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder namedCheckers(ImmutableSet<String> var1);

            abstract Builder inPlace(boolean var1);

            abstract Builder baseDirectory(String var1);

            abstract Builder customRefactorer(Supplier<CodeTransformer> var1);

            abstract Builder importOrganizer(ImportOrganizer var1);

            abstract PatchingOptions build();
        }
    }

    private static class Builder {
        private boolean ignoreUnknownChecks = false;
        private boolean disableAllWarnings = false;
        private boolean disableWarningsInGeneratedCode = false;
        private boolean dropErrorsToWarnings = false;
        private boolean suggestionsAsWarnings = false;
        private boolean enableAllChecksAsWarnings = false;
        private boolean disableAllChecks = false;
        private boolean isTestOnlyTarget = false;
        private boolean isPubliclyVisibleTarget = false;
        private boolean ignoreSuppressionAnnotations = false;
        private boolean ignoreLargeCodeGenerators = true;
        private final Map<String, Severity> severityMap = new LinkedHashMap<String, Severity>();
        private final ErrorProneFlags.Builder flagsBuilder = ErrorProneFlags.builder();
        private final PatchingOptions.Builder patchingOptionsBuilder = PatchingOptions.builder();
        private Pattern excludedPattern;

        private Builder() {
        }

        private void parseSeverity(String arg) {
            Severity severity;
            String remaining = arg.substring(ErrorProneOptions.SEVERITY_PREFIX.length());
            List parts = Splitter.on((char)':').splitToList((CharSequence)remaining);
            if (parts.size() > 2 || ((String)parts.get(0)).isEmpty()) {
                throw new InvalidCommandLineOptionException("invalid flag: " + arg);
            }
            String checkName = (String)parts.get(0);
            if (parts.size() == 1) {
                severity = Severity.DEFAULT;
            } else {
                try {
                    severity = Severity.valueOf((String)parts.get(1));
                }
                catch (IllegalArgumentException e) {
                    throw new InvalidCommandLineOptionException("invalid flag: " + arg + " (" + (String)parts.get(1) + " was not a valid severity)");
                }
            }
            this.severityMap.put(checkName, severity);
        }

        void parseFlag(String flag) {
            this.flagsBuilder.parseFlag(flag);
        }

        void setIgnoreSuppressionAnnotations(boolean ignoreSuppressionAnnotations) {
            this.ignoreSuppressionAnnotations = ignoreSuppressionAnnotations;
        }

        void setIgnoreUnknownChecks(boolean ignoreUnknownChecks) {
            this.ignoreUnknownChecks = ignoreUnknownChecks;
        }

        void setDisableWarningsInGeneratedCode(boolean disableWarningsInGeneratedCode) {
            this.disableWarningsInGeneratedCode = disableWarningsInGeneratedCode;
        }

        void setDropErrorsToWarnings(boolean dropErrorsToWarnings) {
            this.severityMap.entrySet().stream().filter(e -> e.getValue() == Severity.ERROR).forEach(e -> e.setValue(Severity.WARN));
            this.dropErrorsToWarnings = dropErrorsToWarnings;
        }

        void setSuggestionsAsWarnings(boolean suggestionsAsWarnings) {
            this.suggestionsAsWarnings = suggestionsAsWarnings;
        }

        void setDisableAllWarnings(boolean disableAllWarnings) {
            this.severityMap.entrySet().stream().filter(e -> e.getValue() == Severity.WARN).forEach(e -> e.setValue(Severity.OFF));
            this.disableAllWarnings = disableAllWarnings;
        }

        void setEnableAllChecksAsWarnings(boolean enableAllChecksAsWarnings) {
            this.severityMap.entrySet().stream().filter(e -> e.getValue() == Severity.OFF).forEach(e -> e.setValue(Severity.WARN));
            this.enableAllChecksAsWarnings = enableAllChecksAsWarnings;
        }

        void setIgnoreLargeCodeGenerators(boolean ignoreLargeCodeGenerators) {
            this.ignoreLargeCodeGenerators = ignoreLargeCodeGenerators;
        }

        void setDisableAllChecks(boolean disableAllChecks) {
            this.severityMap.clear();
            this.disableAllChecks = disableAllChecks;
        }

        void setTestOnlyTarget(boolean isTestOnlyTarget) {
            this.isTestOnlyTarget = isTestOnlyTarget;
        }

        void setPubliclyVisibleTarget(boolean isPubliclyVisibleTarget) {
            this.isPubliclyVisibleTarget = isPubliclyVisibleTarget;
        }

        PatchingOptions.Builder patchingOptionsBuilder() {
            return this.patchingOptionsBuilder;
        }

        ErrorProneOptions build(ImmutableList<String> remainingArgs) {
            return new ErrorProneOptions((ImmutableMap<String, Severity>)ImmutableMap.copyOf(this.severityMap), remainingArgs, this.ignoreUnknownChecks, this.disableWarningsInGeneratedCode, this.disableAllWarnings, this.dropErrorsToWarnings, this.suggestionsAsWarnings, this.enableAllChecksAsWarnings, this.disableAllChecks, this.isTestOnlyTarget, this.isPubliclyVisibleTarget, this.flagsBuilder.build(), this.patchingOptionsBuilder.build(), this.excludedPattern, this.ignoreSuppressionAnnotations, this.ignoreLargeCodeGenerators);
        }

        void setExcludedPattern(Pattern excludedPattern) {
            this.excludedPattern = excludedPattern;
        }
    }

    public static enum Severity {
        DEFAULT,
        OFF,
        WARN,
        ERROR;

    }
}

