/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.ErrorProneTimings;
import com.google.errorprone.JavacInvocationInstance;
import com.google.errorprone.StatisticsCollector;
import com.google.errorprone.SuppressionInfo;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Suppressible;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Modules;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeMaker;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.util.Elements;
import org.jspecify.annotations.Nullable;

public class VisitorState {
    private final SharedState sharedState;
    public final Context context;
    private final TreePath path;
    private final SuppressionInfo.SuppressedState suppressedState;

    private static void nullListener(Description description) {
    }

    public static VisitorState createForUtilityPurposes(Context context) {
        return new VisitorState(context, VisitorState::nullListener, (Map<String, BugPattern.SeverityLevel>)ImmutableMap.of(), ErrorProneOptions.empty(), StatisticsCollector.createNoOpCollector(), null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    public static VisitorState createForCustomFindingCollection(Context context, DescriptionListener listener) {
        return new VisitorState(context, listener, (Map<String, BugPattern.SeverityLevel>)ImmutableMap.of(), ErrorProneOptions.empty(), StatisticsCollector.createCollector(), null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    public static VisitorState createConfiguredForCompilation(Context context, DescriptionListener listener, Map<String, BugPattern.SeverityLevel> severityMap, ErrorProneOptions errorProneOptions) {
        return new VisitorState(context, listener, severityMap, errorProneOptions, StatisticsCollector.createCollector(), null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    @Deprecated
    public VisitorState(Context context) {
        this(context, VisitorState::nullListener, (Map<String, BugPattern.SeverityLevel>)ImmutableMap.of(), ErrorProneOptions.empty(), StatisticsCollector.createNoOpCollector(), null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    @Deprecated
    public VisitorState(Context context, DescriptionListener listener) {
        this(context, listener, (Map<String, BugPattern.SeverityLevel>)ImmutableMap.of(), ErrorProneOptions.empty(), StatisticsCollector.createCollector(), null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    @Deprecated
    public VisitorState(Context context, DescriptionListener listener, Map<String, BugPattern.SeverityLevel> severityMap, ErrorProneOptions errorProneOptions) {
        this(context, listener, severityMap, errorProneOptions, StatisticsCollector.createCollector(), null, SuppressionInfo.SuppressedState.UNSUPPRESSED);
    }

    private VisitorState(Context context, DescriptionListener descriptionListener, Map<String, BugPattern.SeverityLevel> severityMap, ErrorProneOptions errorProneOptions, StatisticsCollector statisticsCollector, TreePath path, SuppressionInfo.SuppressedState suppressedState) {
        this.context = context;
        this.suppressedState = suppressedState;
        this.path = path;
        this.sharedState = new SharedState(context, descriptionListener, statisticsCollector, severityMap, errorProneOptions);
    }

    private VisitorState(Context context, TreePath path, SuppressionInfo.SuppressedState suppressedState, SharedState sharedState) {
        this.context = context;
        this.path = path;
        this.suppressedState = suppressedState;
        this.sharedState = sharedState;
    }

    public VisitorState withPath(TreePath path) {
        Preconditions.checkNotNull((Object)path);
        return new VisitorState(this.context, path, this.suppressedState, this.sharedState);
    }

    private VisitorState withNoPathForMemoization() {
        return new VisitorState(this.context, null, this.suppressedState, this.sharedState);
    }

    public VisitorState withSuppression(SuppressionInfo.SuppressedState suppressedState) {
        if (suppressedState == this.suppressedState) {
            return this;
        }
        return new VisitorState(this.context, this.path, suppressedState, this.sharedState);
    }

    public TreePath getPath() {
        if (this.path == null) {
            throw new UnsupportedOperationException("VisitorState.memoize Supplier implementations cannot access the TreePath: The result is cached across multiple CompilationUnitTree instances, which share none of the path. Alternatively, you've managed to call getPath() before the VisitorState's path was initialized.");
        }
        return this.path;
    }

    public TreeMaker getTreeMaker() {
        return this.sharedState.treeMaker;
    }

    public Types getTypes() {
        return this.sharedState.types;
    }

    public Elements getElements() {
        return JavacElements.instance(this.context);
    }

    public Symtab getSymtab() {
        return this.sharedState.symtab;
    }

    public Names getNames() {
        return this.sharedState.names;
    }

    public NullnessAnalysis getNullnessAnalysis() {
        return NullnessAnalysis.instance(this.context);
    }

    public ErrorProneOptions errorProneOptions() {
        return this.sharedState.errorProneOptions;
    }

    public Map<String, BugPattern.SeverityLevel> severityMap() {
        return this.sharedState.severityMap;
    }

    public void reportMatch(Description description) {
        Preconditions.checkNotNull((Object)description, (Object)"Use Description.NO_MATCH to denote an absent finding.");
        if (description == Description.NO_MATCH) {
            return;
        }
        BugPattern.SeverityLevel override = this.sharedState.severityMap.get(description.checkName);
        if (override != null) {
            description = description.applySeverityOverride(override);
        }
        this.sharedState.statisticsCollector.incrementCounter(this.statsKey(description.checkName + "-findings"));
        this.sharedState.descriptionListener.onDescribed(description);
    }

    private String statsKey(String key) {
        return this.suppressedState == SuppressionInfo.SuppressedState.SUPPRESSED ? key + "-suppressed" : key;
    }

    public void incrementCounter(BugChecker bugChecker, String key) {
        this.incrementCounter(bugChecker, key, 1);
    }

    public void incrementCounter(BugChecker bugChecker, String key, int count) {
        this.sharedState.statisticsCollector.incrementCounter(this.statsKey(bugChecker.canonicalName() + "-" + key), count);
    }

    public ImmutableMultiset<String> counters() {
        return this.sharedState.statisticsCollector.counters();
    }

    public Name getName(String nameStr) {
        return this.getNames().fromString(nameStr);
    }

    public @Nullable Type getTypeFromString(String typeStr) {
        return this.sharedState.typeCache.computeIfAbsent(typeStr, key -> Optional.ofNullable(this.getTypeFromStringInternal((String)key))).orElse(null);
    }

    private @Nullable Type getTypeFromStringInternal(String typeStr) {
        VisitorState.validateTypeStr(typeStr);
        Type primitiveOrVoidType = this.getPrimitiveOrVoidType(typeStr);
        if (primitiveOrVoidType != null) {
            return primitiveOrVoidType;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)this.getSymbolFromString(typeStr);
        if (classSymbol != null) {
            return classSymbol.asType();
        }
        return null;
    }

    public @Nullable Symbol getSymbolFromString(String symStr) {
        return this.getSymbolFromName(this.binaryNameFromClassname(symStr));
    }

    public Name binaryNameFromClassname(String className) {
        return this.getName(VisitorState.inferBinaryName(className));
    }

    public @Nullable Symbol.ClassSymbol getSymbolFromName(Name name) {
        boolean modular;
        boolean bl = modular = this.sharedState.modules.getDefaultModule() != this.getSymtab().noModule;
        if (!modular) {
            return this.getSymbolFromString(this.getSymtab().noModule, name);
        }
        for (Symbol.ModuleSymbol msym : this.sharedState.modules.allModules()) {
            Symbol.ClassSymbol result = this.getSymbolFromString(msym, name);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public @Nullable Symbol.ClassSymbol getSymbolFromString(Symbol.ModuleSymbol msym, Name name) {
        Symbol.ClassSymbol result = this.getSymtab().getClass(msym, name);
        if (result == null || result.kind == Kinds.Kind.ERR || !result.exists()) {
            return null;
        }
        try {
            result.complete();
        }
        catch (Symbol.CompletionFailure failure) {
            return null;
        }
        return result;
    }

    @VisibleForTesting
    static String inferBinaryName(String classname) {
        int len = classname.length();
        Preconditions.checkArgument((!classname.isEmpty() ? 1 : 0) != 0, (Object)"class name must be non-empty");
        Preconditions.checkArgument((classname.charAt(len - 1) != '.' ? 1 : 0) != 0, (String)"invalid class name: %s", (Object)classname);
        int lastPeriod = classname.lastIndexOf(46);
        if (lastPeriod == -1) {
            return classname;
        }
        int secondToLastPeriod = classname.lastIndexOf(46, lastPeriod - 1);
        if (secondToLastPeriod != -1 && !Character.isUpperCase(classname.charAt(secondToLastPeriod + 1))) {
            return classname;
        }
        StringBuilder sb = new StringBuilder(len);
        boolean foundUppercase = false;
        for (int i = 0; i < len; ++i) {
            char c = classname.charAt(i);
            boolean bl = foundUppercase = foundUppercase || Character.isUpperCase(c);
            if (c == '.') {
                sb.append(foundUppercase ? (char)'$' : '.');
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public Type getType(Type baseType, boolean isArray, java.util.List<Type> typeParams) {
        boolean isGeneric;
        boolean bl = isGeneric = typeParams != null && !typeParams.isEmpty();
        if (!isArray && !isGeneric) {
            return baseType;
        }
        if (isArray && !isGeneric) {
            Symbol.ClassSymbol arraySymbol = this.getSymtab().arrayClass;
            return new Type.ArrayType(baseType, arraySymbol);
        }
        if (!isArray && isGeneric) {
            List<Type> typeParamsCopy = List.from(typeParams);
            return new Type.ClassType(Type.noType, typeParamsCopy, baseType.tsym);
        }
        throw new IllegalArgumentException("Unsupported arguments to getType");
    }

    public Type arrayTypeForType(Type baseType) {
        return new Type.ArrayType(baseType, this.getSymtab().arrayClass);
    }

    @SafeVarargs
    public final @Nullable TreePath findPathToEnclosing(Class<? extends Tree> ... classes) {
        for (TreePath enclosingPath = this.getPath(); enclosingPath != null; enclosingPath = enclosingPath.getParentPath()) {
            for (Class<? extends Tree> clazz : classes) {
                if (!clazz.isInstance(enclosingPath.getLeaf())) continue;
                return enclosingPath;
            }
        }
        return null;
    }

    @SafeVarargs
    public final <T extends Tree> @Nullable T findEnclosing(Class<? extends T> ... classes) {
        TreePath pathToEnclosing = this.findPathToEnclosing(classes);
        return (T)(pathToEnclosing == null ? null : pathToEnclosing.getLeaf());
    }

    public @Nullable CharSequence getSourceCode() {
        try {
            return this.getPath().getCompilationUnit().getSourceFile().getCharContent(false);
        }
        catch (IOException e) {
            return null;
        }
    }

    public @Nullable String getSourceForNode(Tree tree) {
        int start = ASTHelpers.getStartPosition(tree);
        int end = this.getEndPosition(tree);
        CharSequence source = this.getSourceCode();
        if (!ASTHelpers.hasExplicitSource(tree, this)) {
            return null;
        }
        Preconditions.checkArgument((start >= 0 ? 1 : 0) != 0, (String)"invalid start position (%s) for: %s", (int)start, (Object)tree);
        Preconditions.checkArgument((start < end ? 1 : 0) != 0, (String)"invalid source positions (%s, %s) for: %s", (Object)start, (Object)end, (Object)tree);
        Preconditions.checkArgument((end <= source.length() ? 1 : 0) != 0, (String)"invalid end position (%s) for: %s", (int)end, (Object)tree);
        return source.subSequence(start, end).toString();
    }

    public ImmutableList<ErrorProneToken> getTokensForNode(Tree tree) {
        return ErrorProneTokens.getTokens(this.getSourceForNode(tree), this.context);
    }

    public ImmutableList<ErrorProneToken> getOffsetTokensForNode(Tree tree) {
        int start = ASTHelpers.getStartPosition(tree);
        return ErrorProneTokens.getTokens(this.getSourceForNode(tree), start, this.context);
    }

    public ImmutableList<ErrorProneToken> getOffsetTokens(int start, int end) {
        return ErrorProneTokens.getTokens(this.getSourceCode().subSequence(start, end).toString(), start, this.context);
    }

    public int getEndPosition(Tree node) {
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)this.getPath().getCompilationUnit();
        if (compilationUnit.endPositions == null) {
            return -1;
        }
        return ((JCTree)node).getEndPosition(compilationUnit.endPositions);
    }

    private static void validateTypeStr(String typeStr) {
        if (typeStr.contains("[") || typeStr.contains("]")) {
            throw new IllegalArgumentException(String.format("Cannot convert array types (%s), please build them using getType()", typeStr));
        }
        if (typeStr.contains("<") || typeStr.contains(">")) {
            throw new IllegalArgumentException(String.format("Cannot convert generic types (%s), please build them using getType()", typeStr));
        }
    }

    private @Nullable Type getPrimitiveOrVoidType(String typeStr) {
        return switch (typeStr) {
            case "byte" -> this.getSymtab().byteType;
            case "short" -> this.getSymtab().shortType;
            case "int" -> this.getSymtab().intType;
            case "long" -> this.getSymtab().longType;
            case "float" -> this.getSymtab().floatType;
            case "double" -> this.getSymtab().doubleType;
            case "boolean" -> this.getSymtab().booleanType;
            case "char" -> this.getSymtab().charType;
            case "void" -> this.getSymtab().voidType;
            default -> null;
        };
    }

    public boolean isAndroidCompatible() {
        return Options.instance(this.context).getBoolean("androidCompatible");
    }

    public AutoCloseable timingSpan(Suppressible suppressible) {
        return this.sharedState.timings.span(suppressible);
    }

    public static <T> Supplier<T> memoize(Supplier<T> f) {
        return new Cache<T>(f);
    }

    public String getConstantExpression(Object value) {
        String escaped = this.getElements().getConstantExpression(value);
        if (value instanceof String) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < escaped.length(); ++i) {
                char c = escaped.charAt(i);
                if (c == '\\' && i + 1 < escaped.length()) {
                    char next;
                    if ((next = escaped.charAt(++i)) != '\'') {
                        sb.append(c);
                    }
                    sb.append(next);
                    continue;
                }
                sb.append(c);
            }
            return sb.toString();
        }
        return escaped;
    }

    private static final class SharedState {
        private final Modules modules;
        private final Names names;
        private final Symtab symtab;
        private final ErrorProneTimings timings;
        private final Types types;
        private final TreeMaker treeMaker;
        private final JavacInvocationInstance javacInvocationInstance;
        private final DescriptionListener descriptionListener;
        private final StatisticsCollector statisticsCollector;
        private final Map<String, BugPattern.SeverityLevel> severityMap;
        private final ErrorProneOptions errorProneOptions;
        private final Map<String, Optional<Type>> typeCache = new HashMap<String, Optional<Type>>();

        SharedState(Context context, DescriptionListener descriptionListener, StatisticsCollector statisticsCollector, Map<String, BugPattern.SeverityLevel> severityMap, ErrorProneOptions errorProneOptions) {
            this.modules = Modules.instance(context);
            this.names = Names.instance(context);
            this.symtab = Symtab.instance(context);
            this.timings = ErrorProneTimings.instance(context);
            this.types = Types.instance(context);
            this.treeMaker = TreeMaker.instance(context);
            this.javacInvocationInstance = JavacInvocationInstance.instance(context);
            this.descriptionListener = descriptionListener;
            this.statisticsCollector = statisticsCollector;
            this.severityMap = severityMap;
            this.errorProneOptions = errorProneOptions;
        }
    }

    private static class Cache<T>
    implements Supplier<T> {
        private final Supplier<T> impl;
        private SoftReference<T> cache = new SoftReference<Object>(null);
        private JavacInvocationInstance provenance;

        private Cache(Supplier<T> impl) {
            this.impl = impl;
        }

        @Override
        public synchronized T get(VisitorState state) {
            state = state.withNoPathForMemoization();
            T value = this.cache.get();
            if (value == null) {
                value = this.impl.get(state);
                if (value != null) {
                    this.cache = new SoftReference<T>(value);
                    this.provenance = state.sharedState.javacInvocationInstance;
                }
            } else {
                JavacInvocationInstance current = state.sharedState.javacInvocationInstance;
                if (this.provenance != current) {
                    value = this.impl.get(state);
                    this.cache = new SoftReference<T>(value);
                    this.provenance = current;
                }
            }
            return value;
        }
    }
}

