/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.dataflow.nullnesspropagation;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.util.MoreAnnotations;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Name;
import javax.lang.model.element.Parameterizable;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.IntersectionType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVariable;
import org.jspecify.annotations.Nullable;

public class NullnessAnnotations {
    private static final Predicate<String> ANNOTATION_RELEVANT_TO_NULLNESS = Pattern.compile("(Recently)?NonNull(Decl|Type)?|NotNull|Nonnull|(Recently)?Nullable(Decl|Type)?|CheckForNull|PolyNull|MonotonicNonNull(Decl)?|ProtoMethodMayReturnNull|ProtoMethodAcceptsNullParameter|ProtoPassThroughNullness").asMatchPredicate();
    private static final Predicate<String> NULLABLE_ANNOTATION = Pattern.compile("(Recently)?Nullable(Decl|Type)?|CheckForNull|PolyNull|MonotonicNonNull(Decl)?|ProtoMethodMayReturnNull|ProtoMethodAcceptsNullParameter|ProtoPassThroughNullness").asMatchPredicate();

    private NullnessAnnotations() {
    }

    public static Optional<Nullness> fromAnnotationTrees(List<? extends AnnotationTree> annotations) {
        return NullnessAnnotations.fromAnnotationSimpleNames(annotations.stream().map(a -> NullnessAnnotations.simpleName(a)));
    }

    public static Optional<Nullness> fromAnnotationMirrors(List<? extends AnnotationMirror> annotations) {
        return NullnessAnnotations.fromAnnotationStream(annotations.stream());
    }

    public static boolean annotationsAreAmbiguous(Collection<? extends AnnotationMirror> annotations) {
        return NullnessAnnotations.annotationsRelevantToNullness(annotations).stream().map(a -> NULLABLE_ANNOTATION.test(NullnessAnnotations.simpleName(a).toString())).distinct().count() == 2L;
    }

    public static ImmutableList<AnnotationMirror> annotationsRelevantToNullness(Collection<? extends AnnotationMirror> annotations) {
        return (ImmutableList)annotations.stream().filter(a -> ANNOTATION_RELEVANT_TO_NULLNESS.test(NullnessAnnotations.simpleName(a).toString())).collect(ImmutableList.toImmutableList());
    }

    public static ImmutableList<AnnotationTree> annotationsRelevantToNullness(List<? extends AnnotationTree> annotations) {
        return (ImmutableList)annotations.stream().filter(a -> ANNOTATION_RELEVANT_TO_NULLNESS.test(NullnessAnnotations.simpleName(a))).collect(ImmutableList.toImmutableList());
    }

    private static String simpleName(AnnotationTree annotation) {
        Tree annotationType = annotation.getAnnotationType();
        if (annotationType instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)annotationType;
            return identifierTree.getName().toString();
        }
        if (annotationType instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)annotationType;
            return memberSelectTree.getIdentifier().toString();
        }
        throw new AssertionError((Object)annotationType.getKind());
    }

    private static Name simpleName(AnnotationMirror annotation) {
        return annotation.getAnnotationType().asElement().getSimpleName();
    }

    public static Optional<Nullness> fromAnnotationsOn(@Nullable Symbol sym) {
        if (sym == null) {
            return Optional.empty();
        }
        Type elementType = switch (sym.getKind()) {
            case ElementKind.METHOD -> ((ExecutableElement)((Object)sym)).getReturnType();
            case ElementKind.FIELD, ElementKind.PARAMETER -> sym.asType();
            default -> null;
        };
        Optional<Nullness> fromElement = NullnessAnnotations.fromAnnotationsOn(elementType);
        if (fromElement.isPresent()) {
            return fromElement;
        }
        return NullnessAnnotations.fromAnnotationStream(MoreAnnotations.getDeclarationAndTypeAttributes(sym));
    }

    public static Optional<Nullness> fromAnnotationsOn(@Nullable TypeMirror type) {
        if (type != null) {
            return NullnessAnnotations.fromAnnotationStream(type.getAnnotationMirrors().stream());
        }
        return Optional.empty();
    }

    public static Optional<Nullness> fromDefaultAnnotations(@Nullable Element sym) {
        while (sym != null) {
            if (sym.getAnnotationMirrors().stream().anyMatch(a -> NullnessAnnotations.simpleName(a).contentEquals("DefaultNotNull"))) {
                return Optional.of(Nullness.NONNULL);
            }
            sym = sym.getEnclosingElement();
        }
        return Optional.empty();
    }

    public static Optional<Nullness> getUpperBound(TypeVariable typeVar) {
        Element genericElt;
        Optional<Nullness> result;
        TypeMirror typeMirror = typeVar.getUpperBound();
        if (typeMirror instanceof IntersectionType) {
            IntersectionType intersectionType = (IntersectionType)typeMirror;
            result = NullnessAnnotations.fromAnnotationStream(intersectionType.getBounds().stream().flatMap(t -> t.getAnnotationMirrors().stream()));
        } else {
            result = NullnessAnnotations.fromAnnotationsOn(typeVar.getUpperBound());
        }
        if (result.isPresent()) {
            return result;
        }
        if (typeVar.asElement().getKind() == ElementKind.TYPE_PARAMETER && ((genericElt = ((TypeParameterElement)typeVar.asElement()).getGenericElement()).getKind().isClass() || genericElt.getKind().isInterface() || genericElt.getKind() == ElementKind.METHOD)) {
            result = ((Parameterizable)genericElt).getTypeParameters().stream().filter(typeParam -> typeParam.getSimpleName().equals(typeVar.asElement().getSimpleName())).findFirst().flatMap(decl -> NullnessAnnotations.fromAnnotationStream(decl.getAnnotationMirrors().stream()));
        }
        return result.or(() -> NullnessAnnotations.fromDefaultAnnotations(typeVar.asElement()));
    }

    private static Optional<Nullness> fromAnnotationStream(Stream<? extends AnnotationMirror> annotations) {
        return NullnessAnnotations.fromAnnotationSimpleNames(annotations.map(a -> NullnessAnnotations.simpleName(a).toString()));
    }

    private static Optional<Nullness> fromAnnotationSimpleNames(Stream<String> annotations) {
        return annotations.filter(ANNOTATION_RELEVANT_TO_NULLNESS).map(annot -> NULLABLE_ANNOTATION.test((String)annot) ? Nullness.NULLABLE : Nullness.NONNULL).reduce(Nullness::greatestLowerBound);
    }
}

