/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.io.CharStreams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.apply.DescriptionBasedDiff;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.SourceFile;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneComment;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.ParamTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocSourcePositions;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.BasicJavacTask;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.EndPosTable;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.net.JarURLConnection;
import java.net.URI;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.jspecify.annotations.Nullable;

public final class SuggestedFixes {
    private static final Splitter COMPONENT_SPLITTER = Splitter.on((char)'.');
    private static final ImmutableSet<String> SOURCE_TARGET_OPTIONS = ImmutableSet.of((Object)"-source", (Object)"--source", (Object)"-target", (Object)"--target");
    private static final ImmutableSet<Class<? extends Tree>> TREE_TYPE_UNKNOWN_ANNOTATION = ImmutableSet.of(ClassTree.class, MethodTree.class);

    private static @Nullable Modifier getTokModifierKind(ErrorProneToken tok) {
        return switch (tok.kind()) {
            case Tokens.TokenKind.PUBLIC -> Modifier.PUBLIC;
            case Tokens.TokenKind.PROTECTED -> Modifier.PROTECTED;
            case Tokens.TokenKind.PRIVATE -> Modifier.PRIVATE;
            case Tokens.TokenKind.ABSTRACT -> Modifier.ABSTRACT;
            case Tokens.TokenKind.STATIC -> Modifier.STATIC;
            case Tokens.TokenKind.FINAL -> Modifier.FINAL;
            case Tokens.TokenKind.TRANSIENT -> Modifier.TRANSIENT;
            case Tokens.TokenKind.VOLATILE -> Modifier.VOLATILE;
            case Tokens.TokenKind.SYNCHRONIZED -> Modifier.SYNCHRONIZED;
            case Tokens.TokenKind.NATIVE -> Modifier.NATIVE;
            case Tokens.TokenKind.STRICTFP -> Modifier.STRICTFP;
            case Tokens.TokenKind.DEFAULT -> Modifier.DEFAULT;
            default -> null;
        };
    }

    public static Optional<SuggestedFix> addModifiers(Tree tree, VisitorState state, Modifier ... modifiers) {
        ModifiersTree originalModifiers = ASTHelpers.getModifiers(tree);
        if (originalModifiers == null) {
            return Optional.empty();
        }
        return SuggestedFixes.addModifiers(tree, originalModifiers, state, new TreeSet<Modifier>(Arrays.asList(modifiers)));
    }

    public static Optional<SuggestedFix> addModifiers(Tree tree, ModifiersTree originalModifiers, VisitorState state, Set<Modifier> modifiers) {
        Sets.SetView toAdd = Sets.difference(modifiers, originalModifiers.getFlags());
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ArrayList<Modifier> modifiersToWrite = new ArrayList<Modifier>();
        if (!originalModifiers.getFlags().isEmpty()) {
            TreeMap<Modifier, Integer> modifierPositions = new TreeMap<Modifier, Integer>();
            for (Modifier mod2 : toAdd) {
                modifierPositions.put(mod2, -1);
            }
            ImmutableList<ErrorProneToken> tokens = state.getOffsetTokensForNode(originalModifiers);
            for (ErrorProneToken tok : tokens) {
                Modifier mod3 = SuggestedFixes.getTokModifierKind(tok);
                if (mod3 == null) continue;
                modifierPositions.put(mod3, tok.pos());
            }
            modifierPositions.forEach((mod, p) -> {
                if (p == -1) {
                    modifiersToWrite.add((Modifier)((Object)mod));
                } else if (!modifiersToWrite.isEmpty()) {
                    fix.replace((int)p, (int)p, Joiner.on((char)' ').join((Iterable)modifiersToWrite) + " ");
                    modifiersToWrite.clear();
                }
            });
        } else {
            modifiersToWrite.addAll((Collection<Modifier>)toAdd);
        }
        SuggestedFixes.addRemainingModifiers(tree, state, originalModifiers, modifiersToWrite, fix);
        return Optional.of(fix.build());
    }

    private static void addRemainingModifiers(Tree tree, VisitorState state, ModifiersTree originalModifiers, Collection<Modifier> toAdd, SuggestedFix.Builder fix) {
        int insertPos;
        if (toAdd.isEmpty()) {
            return;
        }
        if (tree.getKind() == Tree.Kind.ANNOTATION_TYPE) {
            int pos = ((ErrorProneToken)Streams.findLast(state.getOffsetTokensForNode(originalModifiers).stream().filter(tok -> tok.kind().equals(Tokens.TokenKind.MONKEYS_AT))).get()).pos();
            insertPos = state.getOffsetTokensForNode(tree).stream().mapToInt(ErrorProneToken::pos).filter(thisPos -> thisPos >= pos).findFirst().orElse(pos);
        } else {
            int pos = state.getEndPosition(originalModifiers) == -1 ? ASTHelpers.getStartPosition(tree) : state.getEndPosition(originalModifiers) + 1;
            insertPos = state.getOffsetTokensForNode(originalModifiers).stream().filter(t -> SuggestedFixes.getTokModifierKind(t) != null).mapToInt(t -> t.endPos() + 1).max().orElse(pos);
        }
        fix.replace(insertPos, insertPos, Joiner.on((char)' ').join(toAdd) + " ");
    }

    public static Optional<SuggestedFix> removeModifiers(Tree tree, VisitorState state, Modifier ... modifiers) {
        ImmutableSet toRemove = ImmutableSet.copyOf((Object[])modifiers);
        ModifiersTree originalModifiers = ASTHelpers.getModifiers(tree);
        if (originalModifiers == null) {
            return Optional.empty();
        }
        return SuggestedFixes.removeModifiers(originalModifiers, state, (Set<Modifier>)toRemove);
    }

    public static Optional<SuggestedFix> removeModifiers(ModifiersTree originalModifiers, VisitorState state, Set<Modifier> toRemove) {
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ImmutableList<ErrorProneToken> tokens = state.getOffsetTokensForNode(originalModifiers);
        boolean empty = true;
        for (ErrorProneToken tok : tokens) {
            Modifier mod = SuggestedFixes.getTokModifierKind(tok);
            if (!toRemove.contains((Object)mod)) continue;
            empty = false;
            fix.replace(tok.pos(), tok.endPos() + 1, "");
        }
        if (empty) {
            return Optional.empty();
        }
        return Optional.of(fix.build());
    }

    public static String qualifyType(VisitorState state, SuggestedFix.Builder fix, Symbol sym) {
        if (sym.getKind() == ElementKind.TYPE_PARAMETER) {
            return sym.getSimpleName().toString();
        }
        if (sym.getKind() == ElementKind.CLASS && sym.isDirectlyOrIndirectlyLocal()) {
            if (!sym.isAnonymous()) {
                return sym.getSimpleName().toString();
            }
            sym = ((Symbol.ClassSymbol)sym).getSuperclass().tsym;
        }
        if (SuggestedFixes.variableClashInScope(state, sym)) {
            return SuggestedFixes.qualifyType(state, fix, sym.owner) + "." + String.valueOf(sym.getSimpleName());
        }
        ArrayDeque<String> names = new ArrayDeque<String>();
        Symbol curr = sym;
        while (curr != null) {
            names.addFirst(curr.getSimpleName().toString());
            Symbol found = FindIdentifiers.findIdent(curr.getSimpleName().toString(), state, Kinds.KindSelector.VAL_TYP);
            if (found == curr) break;
            if (curr.owner != null && curr.owner.getKind() == ElementKind.PACKAGE) {
                if (found != null) {
                    names.addFirst(curr.owner.getQualifiedName().toString());
                    break;
                }
                fix.addImport(curr.getQualifiedName().toString());
                break;
            }
            curr = curr.owner;
        }
        return Joiner.on((char)'.').join(names);
    }

    private static boolean variableClashInScope(VisitorState state, final Symbol sym) {
        if (!sym.getKind().isField()) {
            return false;
        }
        MethodTree method = (MethodTree)state.findEnclosing(MethodTree.class);
        if (method == null) {
            return false;
        }
        final boolean[] result = new boolean[]{false};
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitVariable(VariableTree tree, Void unused) {
                if (tree.getName().contentEquals(sym.getSimpleName())) {
                    result[0] = true;
                }
                return (Void)super.visitVariable(tree, null);
            }
        }.scan(method, null);
        return result[0];
    }

    public static String qualifyType(final VisitorState state, SuggestedFix.Builder fix, TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<String, SuggestedFix.Builder>(){

            @Override
            protected String defaultAction(TypeMirror e, SuggestedFix.Builder builder) {
                return e.toString();
            }

            @Override
            public String visitArray(ArrayType t, SuggestedFix.Builder builder) {
                return t.getComponentType().accept(this, builder) + "[]";
            }

            @Override
            public String visitDeclared(DeclaredType t, SuggestedFix.Builder builder) {
                String baseType = SuggestedFixes.qualifyType(state, builder, ((Type)((Object)t)).tsym);
                if (t.getTypeArguments().isEmpty()) {
                    return baseType;
                }
                StringBuilder b = new StringBuilder(baseType);
                b.append('<');
                boolean started = false;
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    if (started) {
                        b.append(',');
                    }
                    b.append(typeMirror.accept(this, builder));
                    started = true;
                }
                b.append('>');
                return b.toString();
            }
        }, fix);
    }

    public static String qualifyType(VisitorState state, SuggestedFix.Builder fix, String typeName) {
        java.util.List components = COMPONENT_SPLITTER.splitToList((CharSequence)typeName);
        String simpleName = (String)Iterables.getLast((Iterable)components);
        Symbol simpleNameSymbol = FindIdentifiers.findIdent(simpleName, state, Kinds.KindSelector.VAL_TYP);
        if (simpleNameSymbol != null && !simpleNameSymbol.getKind().equals((Object)ElementKind.OTHER) && simpleNameSymbol.getQualifiedName().contentEquals(typeName)) {
            return simpleName;
        }
        for (int i = 0; i < components.size(); ++i) {
            String component = (String)components.get(i);
            if (!Character.isUpperCase(component.charAt(0))) continue;
            String qualifiedName = components.subList(0, i + 1).stream().collect(Collectors.joining("."));
            Symbol found = FindIdentifiers.findIdent(component, state, Kinds.KindSelector.VAL_TYP);
            if (found == null) {
                fix.addImport(qualifiedName);
                return components.subList(i, components.size()).stream().collect(Collectors.joining("."));
            }
            if (!found.getQualifiedName().contentEquals(qualifiedName)) continue;
            return components.subList(i, components.size()).stream().collect(Collectors.joining("."));
        }
        return typeName;
    }

    public static String qualifyStaticImport(final String qualifiedName, SuggestedFix.Builder fix, VisitorState state) {
        final String name = qualifiedName.substring(qualifiedName.lastIndexOf(".") + 1);
        final AtomicBoolean foundConflict = new AtomicBoolean(false);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitMethod(MethodTree method, Void unused) {
                this.process(method, method.getName());
                return (Void)super.visitMethod(method, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree ident, Void unused) {
                this.process(ident, ident.getName());
                return (Void)super.visitIdentifier(ident, null);
            }

            private void process(Tree tree, Name identifier) {
                if (!identifier.contentEquals(name)) {
                    return;
                }
                Symbol symbol = ASTHelpers.getSymbol(tree);
                if (symbol == null) {
                    return;
                }
                String identifierQualifiedName = String.valueOf(symbol.owner.getQualifiedName()) + "." + String.valueOf(symbol.getSimpleName());
                if (!qualifiedName.equals(identifierQualifiedName)) {
                    foundConflict.set(true);
                }
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        if (foundConflict.get()) {
            String className = qualifiedName.substring(0, qualifiedName.lastIndexOf("."));
            return SuggestedFixes.qualifyType(state, fix, className) + "." + name;
        }
        fix.addStaticImport(qualifiedName);
        return name;
    }

    public static void replaceDocTree(SuggestedFix.Builder fix, DocTreePath docPath, String replacement) {
        DocTree leaf = docPath.getLeaf();
        Preconditions.checkArgument((boolean)(leaf instanceof DCTree.DCEndPosTree), (String)"no end position information for %s", (Object)((Object)leaf.getKind()));
        DCTree.DCEndPosTree node = (DCTree.DCEndPosTree)leaf;
        DCTree.DCDocComment comment = (DCTree.DCDocComment)docPath.getDocComment();
        fix.replace(node.pos(comment).getStartPosition(), SuggestedFixes.endPosition(node, comment, docPath), replacement);
    }

    private static int endPosition(DCTree.DCEndPosTree<?> node, DCTree.DCDocComment comment, DocTreePath docPath) {
        JCDiagnostic.DiagnosticPosition pos = node.pos(comment);
        EndPosTable endPositions = ((JCTree.JCCompilationUnit)docPath.getTreePath().getCompilationUnit()).endPositions;
        return pos.getEndPosition(endPositions);
    }

    public static void qualifyDocReference(SuggestedFix.Builder fix, DocTreePath docPath, VisitorState state) {
        DocTree leaf = docPath.getLeaf();
        Preconditions.checkArgument((leaf.getKind() == DocTree.Kind.REFERENCE ? 1 : 0) != 0, (String)"expected a path to a reference, got %s instead", (Object)((Object)leaf.getKind()));
        DCTree.DCReference reference = (DCTree.DCReference)leaf;
        Symbol sym = (Symbol)JavacTrees.instance(state.context).getElement(docPath);
        if (sym == null) {
            return;
        }
        String refString = reference.toString();
        int idx = refString.indexOf(35);
        Object qualifiedName = idx >= 0 ? String.valueOf(sym.owner.getQualifiedName()) + refString.substring(idx, refString.length()) : sym.getQualifiedName().toString();
        SuggestedFixes.replaceDocTree(fix, docPath, (String)qualifiedName);
    }

    public static SuggestedFix removeElement(Tree tree, java.util.List<? extends Tree> trees, VisitorState state) {
        int indexOf = trees.indexOf(tree);
        Preconditions.checkArgument((indexOf != -1 ? 1 : 0) != 0, (Object)"trees must contain tree");
        if (trees.size() == 1) {
            return SuggestedFix.delete(tree);
        }
        int startPos = ASTHelpers.getStartPosition(tree);
        int endPos = state.getEndPosition(tree);
        if (indexOf == trees.size() - 1) {
            return SuggestedFix.replace(state.getEndPosition(trees.get(indexOf - 1)), endPos, "");
        }
        return SuggestedFix.replace(startPos, ASTHelpers.getStartPosition(trees.get(indexOf + 1)), "");
    }

    public static SuggestedFix addMembers(ClassTree classTree, VisitorState state, String firstMember, String ... otherMembers) {
        return SuggestedFixes.addMembers(classTree, state, AdditionPosition.LAST, firstMember, otherMembers);
    }

    public static SuggestedFix addMembers(ClassTree classTree, VisitorState state, AdditionPosition where, String firstMember, String ... otherMembers) {
        Preconditions.checkNotNull((Object)classTree);
        java.util.List members = Lists.asList((Object)firstMember, (Object[])otherMembers);
        return SuggestedFixes.addMembers(classTree, state, where, members).get();
    }

    public static Optional<SuggestedFix> addMembers(ClassTree classTree, VisitorState state, AdditionPosition where, Iterable<String> members) {
        Iterator<String> items = members.iterator();
        if (!items.hasNext()) {
            return Optional.empty();
        }
        StringBuilder stringBuilder = new StringBuilder();
        do {
            String item = items.next();
            stringBuilder.append("\n\n").append(item);
        } while (items.hasNext());
        stringBuilder.append('\n');
        int pos = where.pos(classTree, state);
        return Optional.of(SuggestedFix.replace(pos, pos, stringBuilder.toString()));
    }

    public static SuggestedFix renameVariable(VariableTree tree, String replacement, VisitorState state) {
        String name = tree.getName().toString();
        int typeEndPos = state.getEndPosition(tree.getType());
        int searchOffset = typeEndPos == -1 ? 0 : typeEndPos - ASTHelpers.getStartPosition(tree);
        int pos = ASTHelpers.getStartPosition(tree) + state.getSourceForNode(tree).indexOf(name, searchOffset);
        return SuggestedFix.builder().replace(pos, pos + name.length(), replacement).merge(SuggestedFixes.renameVariableUsages(tree, replacement, state)).build();
    }

    public static SuggestedFix renameVariableUsages(VariableTree tree, String replacement, VisitorState state) {
        return SuggestedFixes.renameSymbolOccurrences(ASTHelpers.getSymbol(tree), replacement, state);
    }

    public static SuggestedFix renameMethod(MethodTree tree, String replacement, VisitorState state) {
        int basePos = state.getEndPosition(tree.getReturnType());
        int endPos = tree.getBody() != null ? ASTHelpers.getStartPosition(tree.getBody()) : state.getEndPosition(tree);
        ImmutableList<ErrorProneToken> methodTokens = state.getOffsetTokens(basePos, endPos);
        for (ErrorProneToken token : methodTokens) {
            if (token.kind() != Tokens.TokenKind.IDENTIFIER || !token.name().equals(tree.getName())) continue;
            return SuggestedFix.replace(token.pos(), token.endPos(), replacement);
        }
        throw new AssertionError();
    }

    public static SuggestedFix renameMethodWithInvocations(MethodTree tree, String replacement, VisitorState state) {
        Symbol.MethodSymbol sym = ASTHelpers.getSymbol(tree);
        return SuggestedFix.merge(SuggestedFixes.renameMethod(tree, replacement, state), SuggestedFixes.renameSymbolOccurrences(sym, replacement, state), new SuggestedFix[0]);
    }

    public static SuggestedFix renameMethodInvocation(MethodInvocationTree tree, String replacement, VisitorState state) {
        int startPos;
        Name identifier;
        ExpressionTree methodSelect = tree.getMethodSelect();
        if (methodSelect instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)methodSelect;
            identifier = memberSelectTree.getIdentifier();
            startPos = state.getEndPosition(memberSelectTree.getExpression());
        } else if (methodSelect instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)methodSelect;
            identifier = identifierTree.getName();
            startPos = ASTHelpers.getStartPosition(tree);
        } else {
            throw SuggestedFixes.malformedMethodInvocationTree(tree);
        }
        int endPos = tree.getArguments().isEmpty() ? state.getEndPosition(tree) : ASTHelpers.getStartPosition(tree.getArguments().getFirst());
        ImmutableList<ErrorProneToken> tokens = state.getOffsetTokens(startPos, endPos);
        for (ErrorProneToken token : Lists.reverse(tokens)) {
            if (token.kind() != Tokens.TokenKind.IDENTIFIER || !token.name().equals(identifier)) continue;
            return SuggestedFix.replace(token.pos(), token.endPos(), replacement);
        }
        throw SuggestedFixes.malformedMethodInvocationTree(tree);
    }

    public static SuggestedFix renameClassWithUses(ClassTree tree, String replacement, VisitorState state) {
        return SuggestedFix.merge(SuggestedFixes.renameClass(tree, replacement, state), SuggestedFixes.renameSymbolOccurrences(ASTHelpers.getSymbol(tree), replacement, state), new SuggestedFix[0]);
    }

    private static SuggestedFix renameClass(ClassTree tree, String replacement, VisitorState state) {
        int basePos = ASTHelpers.getStartPosition(tree);
        int endPos = tree.getMembers().stream().map(state::getEndPosition).filter(p -> p != -1 && p != basePos).findFirst().orElse(state.getEndPosition(tree));
        ImmutableList<ErrorProneToken> tokens = state.getOffsetTokens(basePos, endPos);
        for (ErrorProneToken token : tokens) {
            if (token.kind() != Tokens.TokenKind.IDENTIFIER || !token.name().equals(tree.getSimpleName())) continue;
            return SuggestedFix.replace(token.pos(), token.endPos(), replacement);
        }
        throw new AssertionError();
    }

    private static SuggestedFix renameSymbolOccurrences(final Symbol sym, final String replacement, final VisitorState state) {
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (sym.equals(ASTHelpers.getSymbol(tree))) {
                    fix.replace(tree, replacement);
                }
                return (Void)super.visitIdentifier(tree, null);
            }

            @Override
            public Void visitMemberSelect(MemberSelectTree tree, Void unused) {
                if (sym.equals(ASTHelpers.getSymbol(tree))) {
                    fix.replace(state.getEndPosition(tree.getExpression()), state.getEndPosition(tree), "." + replacement);
                }
                return (Void)super.visitMemberSelect(tree, null);
            }

            @Override
            public Void visitMemberReference(MemberReferenceTree tree, Void unused) {
                if (sym.equals(ASTHelpers.getSymbol(tree))) {
                    fix.replace(state.getEndPosition(tree.getQualifierExpression()), state.getEndPosition(tree), "::" + replacement);
                }
                return (Void)super.visitMemberReference(tree, null);
            }
        }.scan(state.getPath().getCompilationUnit(), null);
        return fix.build();
    }

    private static IllegalStateException malformedMethodInvocationTree(MethodInvocationTree tree) {
        return new IllegalStateException(String.format("Couldn't replace the method name in %s.", tree));
    }

    public static SuggestedFix renameTypeParameter(TypeParameterTree typeParameter, Tree owningTree, final String typeVarReplacement, final VisitorState state) {
        final Symbol typeParameterSymbol = ASTHelpers.getSymbol(typeParameter);
        final String name = typeParameter.getName().toString();
        int pos = ASTHelpers.getStartPosition(typeParameter);
        final SuggestedFix.Builder fixBuilder = SuggestedFix.builder().replace(pos, pos + name.length(), typeVarReplacement);
        new TreeScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                Symbol identSym = ASTHelpers.getSymbol(tree);
                if (Objects.equal((Object)identSym, (Object)typeParameterSymbol) && Objects.equal((Object)state.getSourceForNode(tree), (Object)name)) {
                    fixBuilder.replace(tree, typeVarReplacement);
                }
                return (Void)super.visitIdentifier(tree, null);
            }
        }.scan(owningTree, null);
        final DCTree.DCDocComment docCommentTree = (DCTree.DCDocComment)JavacTrees.instance(state.context).getDocCommentTree(state.getPath());
        if (docCommentTree != null) {
            docCommentTree.accept(new DocTreeScanner<Void, Void>(){

                @Override
                public Void visitParam(ParamTree paramTree, Void unused) {
                    if (paramTree.isTypeParameter() && paramTree.getName().getName().contentEquals(name)) {
                        DocSourcePositions positions = JavacTrees.instance(state.context).getSourcePositions();
                        CompilationUnitTree compilationUnitTree = state.getPath().getCompilationUnit();
                        int startPos = (int)positions.getStartPosition(compilationUnitTree, docCommentTree, paramTree.getName());
                        int endPos = (int)positions.getEndPosition(compilationUnitTree, docCommentTree, paramTree.getName());
                        fixBuilder.replace(startPos, endPos, typeVarReplacement);
                    }
                    return (Void)super.visitParam(paramTree, null);
                }
            }, null);
        }
        return fixBuilder.build();
    }

    public static Fix deleteExceptions(MethodTree tree, VisitorState state, java.util.List<ExpressionTree> toDelete) {
        java.util.List<? extends ExpressionTree> trees = tree.getThrows();
        if (toDelete.size() == trees.size()) {
            return SuggestedFix.replace(SuggestedFixes.getThrowsPosition(tree, state) - 1, state.getEndPosition((Tree)Iterables.getLast(trees)), "");
        }
        String replacement = tree.getThrows().stream().filter(t -> !toDelete.contains(t)).map(state::getSourceForNode).collect(Collectors.joining(", "));
        return SuggestedFix.replace(ASTHelpers.getStartPosition(tree.getThrows().getFirst()), state.getEndPosition((Tree)Iterables.getLast(tree.getThrows())), replacement);
    }

    private static int getThrowsPosition(MethodTree tree, VisitorState state) {
        for (ErrorProneToken token : state.getOffsetTokensForNode(tree)) {
            if (token.kind() != Tokens.TokenKind.THROWS) continue;
            return token.pos();
        }
        throw new AssertionError();
    }

    public static SuggestedFix addSuppressWarnings(VisitorState state, String warningToSuppress) {
        return SuggestedFixes.addSuppressWarnings(state, warningToSuppress, null);
    }

    public static SuggestedFix addSuppressWarnings(VisitorState state, String warningToSuppress, @Nullable String lineComment) {
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        SuggestedFixes.addSuppressWarnings(fixBuilder, state, warningToSuppress, lineComment);
        if (fixBuilder.isEmpty()) {
            throw new IllegalArgumentException("Couldn't find a node to attach @SuppressWarnings.");
        }
        return fixBuilder.build();
    }

    public static void addSuppressWarnings(SuggestedFix.Builder fixBuilder, VisitorState state, String warningToSuppress) {
        SuggestedFixes.addSuppressWarnings(fixBuilder, state, warningToSuppress, null);
    }

    public static void addSuppressWarnings(SuggestedFix.Builder fixBuilder, VisitorState state, String warningToSuppress, @Nullable String lineComment) {
        SuggestedFixes.addSuppressWarnings(fixBuilder, state, warningToSuppress, lineComment, true);
    }

    public static void addSuppressWarnings(SuggestedFix.Builder fixBuilder, VisitorState state, String warningToSuppress, @Nullable String lineComment, boolean commentOnNewLine) {
        Tree suppressibleNode = SuggestedFixes.suppressibleNode(state.getPath(), state);
        if (suppressibleNode == null) {
            return;
        }
        SuppressWarnings existingAnnotation = ASTHelpers.getAnnotation(suppressibleNode, SuppressWarnings.class);
        String suppression = state.getTreeMaker().Literal(TypeTag.CLASS, warningToSuppress).toString();
        Optional<String> formattedLineComment = Optional.ofNullable(lineComment).map(s -> "// " + s + "\n");
        if (existingAnnotation != null) {
            String[] values = existingAnnotation.value();
            if (Arrays.asList(values).contains(warningToSuppress)) {
                return;
            }
            AnnotationTree suppressAnnotationTree = ASTHelpers.getAnnotationWithSimpleName(SuggestedFixes.findAnnotationsTree(suppressibleNode), SuppressWarnings.class.getSimpleName());
            if (suppressAnnotationTree == null) {
                return;
            }
            fixBuilder.merge(SuggestedFixes.addValuesToAnnotationArgument(suppressAnnotationTree, "value", (Collection<String>)ImmutableList.of((Object)suppression), state));
            formattedLineComment.ifPresent(lc -> fixBuilder.prefixWith(suppressAnnotationTree, (String)lc));
        } else {
            String replacement = commentOnNewLine ? formattedLineComment.orElse("") + "@SuppressWarnings(" + suppression + ") " : "@SuppressWarnings(" + suppression + ") " + formattedLineComment.orElse("");
            fixBuilder.prefixWith(suppressibleNode, replacement);
        }
    }

    public static void removeSuppressWarnings(SuggestedFix.Builder fixBuilder, VisitorState state, String warningToRemove) {
        Tree suppressibleNode = SuggestedFixes.suppressibleNode(state.getPath(), state);
        if (suppressibleNode == null) {
            return;
        }
        AnnotationTree suppressAnnotationTree = ASTHelpers.getAnnotationWithSimpleName(SuggestedFixes.findAnnotationsTree(suppressibleNode), SuppressWarnings.class.getSimpleName());
        if (suppressAnnotationTree == null) {
            return;
        }
        SuppressWarnings annotation = ASTHelpers.getAnnotation(suppressibleNode, SuppressWarnings.class);
        ImmutableSet warningsSuppressed = ImmutableSet.copyOf((Object[])annotation.value());
        ImmutableSet newWarningSet = (ImmutableSet)warningsSuppressed.stream().filter(warning -> !warning.equals(warningToRemove)).map(state::getConstantExpression).collect(ImmutableSet.toImmutableSet());
        if (newWarningSet.size() == warningsSuppressed.size()) {
            return;
        }
        if (newWarningSet.isEmpty()) {
            fixBuilder.delete(suppressAnnotationTree);
            return;
        }
        fixBuilder.merge(SuggestedFixes.updateAnnotationArgumentValues(suppressAnnotationTree, state, "value", (Collection<String>)newWarningSet));
    }

    private static java.util.List<? extends AnnotationTree> findAnnotationsTree(Tree tree) {
        ModifiersTree maybeModifiers = ASTHelpers.getModifiers(tree);
        return maybeModifiers == null ? ImmutableList.of() : maybeModifiers.getAnnotations();
    }

    private static @Nullable Tree suppressibleNode(TreePath path, VisitorState state) {
        return StreamSupport.stream(path.spliterator(), false).filter(tree -> {
            VariableTree variableTree;
            ClassTree classTree;
            return tree instanceof MethodTree || tree instanceof ClassTree && (classTree = (ClassTree)tree).getSimpleName().length() != 0 || tree instanceof VariableTree && !ASTHelpers.hasImplicitType(variableTree = (VariableTree)tree, state);
        }).findFirst().orElse(null);
    }

    public static SuggestedFix.Builder addValuesToAnnotationArgument(AnnotationTree annotation, String parameterName, Collection<String> newValues, VisitorState state) {
        if (annotation.getArguments().isEmpty()) {
            Object parameterPrefix = parameterName.equals("value") ? "" : parameterName + " = ";
            return SuggestedFix.builder().replace(annotation, annotation.toString().replaceFirst("\\(\\)", "(" + (String)parameterPrefix + SuggestedFixes.newArgument(newValues) + ")"));
        }
        Optional<ExpressionTree> maybeExistingArgument = SuggestedFixes.findArgument(annotation, parameterName);
        if (maybeExistingArgument.isEmpty()) {
            return SuggestedFix.builder().prefixWith(annotation.getArguments().getFirst(), parameterName + " = " + SuggestedFixes.newArgument(newValues) + ", ");
        }
        ExpressionTree existingArgument = maybeExistingArgument.get();
        if (!(existingArgument instanceof NewArrayTree)) {
            return SuggestedFix.builder().replace(existingArgument, SuggestedFixes.newArgument(state.getSourceForNode(existingArgument), newValues));
        }
        NewArrayTree newArray = (NewArrayTree)existingArgument;
        if (newArray.getInitializers().isEmpty()) {
            return SuggestedFix.builder().replace(newArray, SuggestedFixes.newArgument(newValues));
        }
        return SuggestedFix.builder().postfixWith((Tree)Iterables.getLast(newArray.getInitializers()), ", " + Joiner.on((String)", ").join(newValues));
    }

    @Deprecated
    public static SuggestedFix.Builder updateAnnotationArgumentValues(AnnotationTree annotation, String parameterName, Collection<String> newValues) {
        return SuggestedFixes.updateAnnotationArgumentValues(annotation, null, parameterName, newValues);
    }

    public static SuggestedFix.Builder updateAnnotationArgumentValues(AnnotationTree annotation, VisitorState state, String parameterName, Collection<String> newValues) {
        if (annotation.getArguments().isEmpty()) {
            Object parameterPrefix = parameterName.equals("value") ? "" : parameterName + " = ";
            return SuggestedFix.builder().replace(annotation, "@" + (state != null ? state.getSourceForNode(annotation.getAnnotationType()) : annotation.getAnnotationType().toString()) + "(" + (String)parameterPrefix + SuggestedFixes.newArgument(newValues) + ")");
        }
        Optional<ExpressionTree> maybeExistingArgument = SuggestedFixes.findArgument(annotation, parameterName);
        if (maybeExistingArgument.isEmpty()) {
            return SuggestedFix.builder().prefixWith(annotation.getArguments().getFirst(), parameterName + " = " + SuggestedFixes.newArgument(newValues) + ", ");
        }
        ExpressionTree existingArgument = maybeExistingArgument.get();
        return SuggestedFix.builder().replace(existingArgument, SuggestedFixes.newArgument(newValues));
    }

    private static String newArgument(String existingParameters, Collection<String> initializers) {
        return SuggestedFixes.newArgument((Collection<String>)ImmutableList.builder().add((Object)existingParameters).addAll(initializers).build());
    }

    private static String newArgument(Collection<String> initializers) {
        StringBuilder expression = new StringBuilder();
        if (initializers.isEmpty()) {
            return "{}";
        }
        if (initializers.size() > 1) {
            expression.append('{');
        }
        Joiner.on((String)", ").appendTo(expression, initializers);
        if (initializers.size() > 1) {
            expression.append('}');
        }
        return expression.toString();
    }

    private static Optional<ExpressionTree> findArgument(AnnotationTree annotation, String parameter) {
        for (ExpressionTree expressionTree : annotation.getArguments()) {
            AssignmentTree assignment;
            if (!(expressionTree instanceof AssignmentTree) || !(assignment = (AssignmentTree)expressionTree).getVariable().toString().equals(parameter)) continue;
            return Optional.of(ASTHelpers.stripParentheses(assignment.getExpression()));
        }
        return Optional.empty();
    }

    public static boolean compilesWithFix(Fix fix, VisitorState state) {
        return SuggestedFixes.compilesWithFix(fix, state, (ImmutableList<String>)ImmutableList.of(), false);
    }

    public static boolean compilesWithFix(Fix fix, VisitorState state, ImmutableList<String> extraOptions, boolean onlyInSameCompilationUnit) {
        ImmutableList.Builder extraOptionsBuilder = ImmutableList.builder().addAll(extraOptions);
        int maxErrors = SuggestedFixes.findOptionOrAppend((ImmutableList.Builder<String>)extraOptionsBuilder, extraOptions, "-Xmaxerrs", 100);
        int maxWarnings = SuggestedFixes.findOptionOrAppend((ImmutableList.Builder<String>)extraOptionsBuilder, extraOptions, "-Xmaxwarns", 100);
        return SuggestedFixes.compilesWithFix(fix, state, (ImmutableList<String>)extraOptionsBuilder.build(), onlyInSameCompilationUnit, maxErrors, maxWarnings);
    }

    private static int findOptionOrAppend(ImmutableList.Builder<String> newOptions, ImmutableList<String> extraOptions, String key, int defaultValue) {
        int value;
        int pos = extraOptions.lastIndexOf((Object)key);
        if (pos >= 0) {
            value = Integer.parseInt((String)extraOptions.get(pos + 1));
        } else {
            value = defaultValue;
            newOptions.add((Object)key).add((Object)("" + defaultValue));
        }
        return value;
    }

    private static boolean compilesWithFix(Fix fix, VisitorState state, ImmutableList<String> extraOptions, boolean onlyInSameCompilationUnit, int maxErrors, int maxWarnings) {
        FixCompiler fixCompiler;
        if (fix.isEmpty() && extraOptions.isEmpty()) {
            return true;
        }
        try {
            fixCompiler = FixCompiler.create(fix, state);
        }
        catch (IOException e) {
            return false;
        }
        FixCompiler.Result compilationResult = fixCompiler.compile(extraOptions);
        URI modifiedFileUri = FixCompiler.getModifiedFileUri(state);
        int countErrors = 0;
        int countWarnings = 0;
        boolean warningIsError = false;
        boolean warningInSameCompilationUnit = false;
        block6: for (Diagnostic<? extends JavaFileObject> diagnostic : compilationResult.diagnostics()) {
            warningIsError |= diagnostic.getCode().equals("compiler.err.warnings.and.werror");
            JavaFileObject diagnosticSource = diagnostic.getSource();
            boolean diagnosticInSameCompilationUnit = diagnosticSource == null || diagnosticSource.toUri().equals(modifiedFileUri);
            switch (diagnostic.getKind()) {
                case ERROR: {
                    ++countErrors;
                    if (onlyInSameCompilationUnit && !diagnosticInSameCompilationUnit) break;
                    return false;
                }
                case WARNING: {
                    ++countWarnings;
                    warningInSameCompilationUnit |= diagnosticInSameCompilationUnit;
                    break;
                }
                default: {
                    continue block6;
                }
            }
            if ((!warningIsError || !warningInSameCompilationUnit) && countErrors < maxErrors && countWarnings < maxWarnings) continue;
            return false;
        }
        return true;
    }

    @VisibleForTesting
    static URI sourceURI(URI uri) {
        if (!uri.getScheme().equals("jar")) {
            return uri;
        }
        try {
            return URI.create("file:/" + ((JarURLConnection)uri.toURL().openConnection()).getEntryName());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static String prettyType(Type type, @Nullable VisitorState state) {
        return SuggestedFixes.prettyType(state, null, type);
    }

    public static String prettyType(final @Nullable VisitorState state, @Nullable SuggestedFix.Builder existingFix, Type type) {
        final SuggestedFix.Builder fix = existingFix == null ? SuggestedFix.builder() : existingFix;
        return type.accept(new Types.DefaultTypeVisitor<String, Void>(){

            @Override
            public String visitWildcardType(Type.WildcardType t, Void unused) {
                StringBuilder sb = new StringBuilder();
                sb.append((Object)t.kind);
                if (t.kind != BoundKind.UNBOUND) {
                    sb.append(t.type.accept(this, null));
                }
                return sb.toString();
            }

            @Override
            public String visitClassType(Type.ClassType t, Void unused) {
                StringBuilder sb = new StringBuilder();
                if (state == null) {
                    sb.append(t.tsym.getSimpleName());
                } else {
                    sb.append(SuggestedFixes.qualifyType(state, fix, t.tsym));
                }
                if (((List)t.getTypeArguments()).nonEmpty()) {
                    sb.append('<');
                    sb.append(t.getTypeArguments().stream().map(a -> a.accept(this, null)).collect(Collectors.joining(", ")));
                    sb.append(">");
                }
                return sb.toString();
            }

            @Override
            public String visitCapturedType(Type.CapturedType t, Void unused) {
                return t.wildcard.accept(this, null);
            }

            @Override
            public String visitArrayType(Type.ArrayType t, Void unused) {
                return t.elemtype.accept(this, null) + "[]";
            }

            @Override
            public String visitType(Type t, Void unused) {
                return t.toString();
            }
        }, null);
    }

    public static Optional<SuggestedFix> suggestExemptingAnnotation(String exemptingAnnotation, TreePath where, VisitorState state) {
        String annotationName;
        ImmutableSet<Class<? extends Tree>> supportedExemptingAnnotationLocationTypes;
        if (exemptingAnnotation.equals("com.google.errorprone.annotations.DontSuggestFixes")) {
            return Optional.empty();
        }
        SuggestedFix.Builder builder = SuggestedFix.builder();
        Type exemptingAnnotationType = state.getTypeFromString(exemptingAnnotation);
        if (exemptingAnnotationType != null) {
            supportedExemptingAnnotationLocationTypes = SuggestedFixes.supportedTreeTypes(exemptingAnnotationType.asElement());
            annotationName = SuggestedFixes.qualifyType(state, builder, exemptingAnnotationType);
        } else {
            int idx = exemptingAnnotation.lastIndexOf(46);
            Verify.verify((idx > 0 && idx + 1 < exemptingAnnotation.length() ? 1 : 0) != 0);
            supportedExemptingAnnotationLocationTypes = TREE_TYPE_UNKNOWN_ANNOTATION;
            annotationName = exemptingAnnotation.substring(idx + 1);
            builder.addImport(exemptingAnnotation);
        }
        Optional<Tree> exemptingAnnotationLocation = Streams.stream((Iterable)where).filter(tree -> supportedExemptingAnnotationLocationTypes.stream().anyMatch(clazz -> clazz.isInstance(tree)) && !SuggestedFixes.isAnonymousClassTree(tree)).findFirst();
        return exemptingAnnotationLocation.map(location -> builder.prefixWith((Tree)location, "@" + annotationName + " ").build());
    }

    private static boolean isAnonymousClassTree(Tree t) {
        ClassTree classTree;
        return t instanceof ClassTree && (classTree = (ClassTree)t).getSimpleName().contentEquals("");
    }

    public static boolean suggestedExemptingAnnotationSupported(Element exemptingAnnotation) {
        return !SuggestedFixes.supportedTreeTypes(exemptingAnnotation).isEmpty();
    }

    private static ImmutableSet<Class<? extends Tree>> supportedTreeTypes(Element exemptingAnnotation) {
        Target targetAnnotation = exemptingAnnotation.getAnnotation(Target.class);
        if (targetAnnotation == null) {
            return TREE_TYPE_UNKNOWN_ANNOTATION;
        }
        return (ImmutableSet)Arrays.stream(targetAnnotation.value()).flatMap(t -> switch (t) {
            case ElementType.TYPE -> Stream.of(ClassTree.class);
            case ElementType.METHOD -> Stream.of(MethodTree.class);
            default -> Stream.empty();
        }).collect(ImmutableSet.toImmutableSet());
    }

    public static SuggestedFix replaceIncludingComments(TreePath path, String replacement, VisitorState state) {
        ErrorProneComment comment;
        int endOfCommentPos;
        CharSequence stringBetweenComments;
        Tree tree = path.getLeaf();
        Tree parent = path.getParentPath().getLeaf();
        if (!(parent instanceof ClassTree)) {
            return SuggestedFix.replace(tree, replacement);
        }
        ClassTree classTree = (ClassTree)parent;
        Tree previousMember = null;
        for (Tree tree2 : classTree.getMembers()) {
            MethodTree methodTree;
            if (tree2 instanceof MethodTree && ASTHelpers.isGeneratedConstructor(methodTree = (MethodTree)tree2) || tree2 instanceof VariableTree && ASTHelpers.isRecord(ASTHelpers.getSymbol(tree2))) continue;
            if (tree2.equals(tree)) break;
            previousMember = tree2;
        }
        int startTokenization = previousMember != null ? state.getEndPosition(previousMember) : (state.getEndPosition(classTree.getModifiers()) == -1 ? ASTHelpers.getStartPosition(classTree) : state.getEndPosition(classTree.getModifiers()));
        Object tokens = state.getOffsetTokens(startTokenization, state.getEndPosition(tree));
        if (previousMember == null) {
            tokens = SuggestedFixes.getTokensAfterOpeningBrace(tokens);
        }
        if (!tokens.isEmpty() && ((ErrorProneToken)tokens.getFirst()).kind() == Tokens.TokenKind.SEMI) {
            tokens = tokens.subList(1, tokens.size());
        }
        if (tokens.isEmpty()) {
            return SuggestedFix.replace(tree, replacement);
        }
        if (((ErrorProneToken)tokens.getFirst()).comments().isEmpty()) {
            return SuggestedFix.replace(((ErrorProneToken)tokens.getFirst()).pos(), state.getEndPosition(tree), replacement);
        }
        ImmutableList immutableList = ImmutableList.sortedCopyOf(Comparator.comparingInt(c -> c.getSourcePos(0)).reversed(), ((ErrorProneToken)tokens.getFirst()).comments());
        int startPos = ASTHelpers.getStartPosition(tree);
        if (startPos < startTokenization) {
            return SuggestedFix.emptyFix();
        }
        CharSequence sourceCode = state.getSourceCode();
        UnmodifiableIterator unmodifiableIterator = immutableList.iterator();
        while (unmodifiableIterator.hasNext() && (stringBetweenComments = sourceCode.subSequence(endOfCommentPos = (comment = (ErrorProneComment)unmodifiableIterator.next()).getSourcePos(comment.getText().length() - 1), startPos)).chars().filter(c -> c == 10).count() <= 1L) {
            startPos = comment.getSourcePos(0);
        }
        return SuggestedFix.replace(startPos, state.getEndPosition(tree), replacement);
    }

    private static java.util.List<ErrorProneToken> getTokensAfterOpeningBrace(java.util.List<ErrorProneToken> tokens) {
        for (int i = 0; i < tokens.size() - 1; ++i) {
            if (tokens.get(i).kind() != Tokens.TokenKind.LBRACE) continue;
            return tokens.subList(i + 1, tokens.size());
        }
        return ImmutableList.of();
    }

    public static String castTree(ExpressionTree expressionTree, String toType, VisitorState state) {
        boolean needsParentheses = expressionTree instanceof BinaryTree || expressionTree instanceof AssignmentTree || expressionTree instanceof CompoundAssignmentTree || expressionTree instanceof InstanceOfTree || expressionTree instanceof ConditionalExpressionTree;
        return "(" + toType + ") " + (needsParentheses ? "(" : "") + state.getSourceForNode(expressionTree) + (needsParentheses ? ")" : "");
    }

    private SuggestedFixes() {
    }

    public static enum AdditionPosition {
        FIRST{

            @Override
            int pos(ClassTree tree, VisitorState state) {
                int classStart = ASTHelpers.getStartPosition(tree);
                ImmutableList members = (ImmutableList)tree.getMembers().stream().filter(AdditionPosition::definedInSourceFile).filter(member -> ASTHelpers.getStartPosition(member) > classStart).collect(ImmutableList.toImmutableList());
                if (members.isEmpty()) {
                    return LAST.pos(tree, state);
                }
                JCTree firstMember = (JCTree)members.getFirst();
                int firstMemberStart = firstMember.getStartPosition();
                ImmutableList<ErrorProneToken> methodTokens = state.getOffsetTokens(classStart, firstMemberStart);
                ListIterator iter = methodTokens.listIterator(methodTokens.size());
                while (iter.hasPrevious()) {
                    ErrorProneToken token = (ErrorProneToken)iter.previous();
                    if (token.kind() != Tokens.TokenKind.LBRACE) continue;
                    return token.pos() + 1;
                }
                throw new AssertionError((Object)("Found no open brace for class " + String.valueOf(tree)));
            }
        }
        ,
        LAST{

            @Override
            int pos(ClassTree tree, VisitorState state) {
                return state.getEndPosition(tree) - 1;
            }
        };


        abstract int pos(ClassTree var1, VisitorState var2);

        private static boolean definedInSourceFile(Tree member) {
            MethodTree methodTree;
            Symbol sym = ASTHelpers.getSymbol(member);
            if (sym == null) {
                return false;
            }
            if (member instanceof MethodTree && ASTHelpers.isGeneratedConstructor(methodTree = (MethodTree)member)) {
                return false;
            }
            return (sym.flags() & 0x1000L) == 0L;
        }
    }

    public static final class FixCompiler {
        private final java.util.List<JavaFileObject> fileObjects;
        private final VisitorState state;
        private final BasicJavacTask javacTask;

        private FixCompiler(java.util.List<JavaFileObject> fileObjects, VisitorState state, BasicJavacTask javacTask) {
            this.fileObjects = fileObjects;
            this.state = state;
            this.javacTask = javacTask;
        }

        public Result compile(ImmutableList<String> extraOptions) {
            DiagnosticCollector diagnosticListener = new DiagnosticCollector();
            Context context = this.createContext();
            Arguments arguments = Arguments.instance(this.javacTask.getContext());
            JavacTask newTask = JavacTool.create().getTask(CharStreams.nullWriter(), this.state.context.get(JavaFileManager.class), diagnosticListener, (Iterable<String>)extraOptions, (Iterable<String>)arguments.getClassNames(), (Iterable<? extends JavaFileObject>)this.fileObjects, context);
            try {
                newTask.analyze();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return new Result(diagnosticListener.getDiagnostics());
        }

        private Context createContext() {
            Context context = new Context();
            Options options = Options.instance(context);
            Options originalOptions = Options.instance(this.javacTask.getContext());
            for (String key : originalOptions.keySet()) {
                String value = originalOptions.get(key);
                if (key.equals("-Xplugin:") && value.startsWith("ErrorProne") || SOURCE_TARGET_OPTIONS.contains((Object)key) && originalOptions.isSet("--release")) continue;
                options.put(key, value);
            }
            return context;
        }

        public static URI getModifiedFileUri(VisitorState state) {
            JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
            JavaFileObject modifiedFile = compilationUnit.getSourceFile();
            return modifiedFile.toUri();
        }

        public static FixCompiler create(Fix fix, VisitorState state) throws IOException {
            BasicJavacTask javacTask = (BasicJavacTask)state.context.get(JavacTask.class);
            if (javacTask == null) {
                throw new IllegalArgumentException("No JavacTask in context.");
            }
            Arguments arguments = Arguments.instance(javacTask.getContext());
            ArrayList<JavaFileObject> fileObjects = new ArrayList<JavaFileObject>(arguments.getFileObjects());
            FixCompiler.applyFix(fix, state, fileObjects);
            return new FixCompiler(fileObjects, state, javacTask);
        }

        private static void applyFix(Fix fix, VisitorState state, ArrayList<JavaFileObject> fileObjects) throws IOException {
            JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
            JavaFileObject modifiedFile = compilationUnit.getSourceFile();
            CharSequence modifiedFileContent = modifiedFile.getCharContent(false);
            URI modifiedFileUri = FixCompiler.getModifiedFileUri(state);
            IntStream.range(0, fileObjects.size()).filter(i -> ((JavaFileObject)fileObjects.get(i)).toUri().equals(modifiedFileUri)).findFirst().ifPresent(i -> {
                DescriptionBasedDiff diff = DescriptionBasedDiff.create(compilationUnit, ImportOrganizer.STATIC_FIRST_ORGANIZER);
                diff.handleFix(fix);
                final SourceFile fixSource = new SourceFile(modifiedFile.getName(), modifiedFileContent);
                diff.applyDifferences(fixSource);
                fileObjects.set(i, new SimpleJavaFileObject(SuggestedFixes.sourceURI(modifiedFile.toUri()), JavaFileObject.Kind.SOURCE){

                    @Override
                    public CharSequence getCharContent(boolean ignoreEncodingErrors) {
                        return fixSource.getAsSequence();
                    }
                });
            });
        }

        public record Result(java.util.List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        }
    }
}

