/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.fixes.Replacement;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Replacements {
    private static final Comparator<Range<Integer>> DESCENDING = Comparator.comparing(Range::lowerEndpoint).thenComparing(Range::upperEndpoint).reversed();
    private final TreeMap<Range<Integer>, Replacement> replacements = new TreeMap(DESCENDING);
    private final RangeMap<Integer, Replacement> overlaps = TreeRangeMap.create();
    private final TreeSet<Integer> zeroLengthRanges = new TreeSet();

    @CanIgnoreReturnValue
    public Replacements add(Replacement replacement) {
        return this.add(replacement, CoalescePolicy.REJECT);
    }

    @CanIgnoreReturnValue
    public Replacements add(Replacement replacement, CoalescePolicy coalescePolicy) {
        if (this.replacements.containsKey(replacement.range())) {
            Replacement existing = this.replacements.get(replacement.range());
            if (replacement.range().isEmpty()) {
                replacement = existing.equals(replacement) ? coalescePolicy.handleDuplicateInsertion(replacement) : replacement.withDifferentText(coalescePolicy.coalesce(replacement.replaceWith(), existing.replaceWith()));
            } else if (!existing.equals(replacement)) {
                throw new IllegalArgumentException(String.format("%s conflicts with existing replacement %s", replacement, existing));
            }
        } else {
            this.checkOverlaps(replacement);
        }
        this.replacements.put(replacement.range(), replacement);
        return this;
    }

    private void checkOverlaps(Replacement replacement) {
        Range<Integer> replacementRange = replacement.range();
        Collection overlap = this.overlaps.subRangeMap(replacementRange).asMapOfRanges().values();
        Preconditions.checkArgument((boolean)overlap.isEmpty(), (String)"%s overlaps with existing replacements: %s", (Object)replacement, (Object)Joiner.on((String)", ").join(overlap));
        NavigableSet<Integer> containedZeroLengthRangeStarts = this.zeroLengthRanges.subSet((Integer)replacementRange.lowerEndpoint(), false, (Integer)replacementRange.upperEndpoint(), false);
        Preconditions.checkArgument((boolean)containedZeroLengthRangeStarts.isEmpty(), (String)"%s overlaps with existing zero-length replacements: %s", (Object)replacement, (Object)Joiner.on((String)", ").join(containedZeroLengthRangeStarts));
        this.overlaps.put(replacementRange, (Object)replacement);
        if (replacementRange.isEmpty()) {
            this.zeroLengthRanges.add((Integer)replacementRange.lowerEndpoint());
        }
    }

    @Deprecated
    public Set<Replacement> descending() {
        return new LinkedHashSet<Replacement>(this.replacements.values());
    }

    public ImmutableSet<Replacement> ascending() {
        return ImmutableSet.copyOf(this.replacements.descendingMap().values());
    }

    public boolean isEmpty() {
        return this.replacements.isEmpty();
    }

    public static enum CoalescePolicy {
        REJECT(DuplicateInsertPolicy.DROP){

            @Override
            public String coalesce(String replacement, String existing) {
                throw new IllegalArgumentException(String.format("%s conflicts with existing replacement %s", replacement, existing));
            }
        }
        ,
        REPLACEMENT_FIRST(DuplicateInsertPolicy.DROP){

            @Override
            public String coalesce(String replacement, String existing) {
                return replacement + existing;
            }
        }
        ,
        EXISTING_FIRST(DuplicateInsertPolicy.DROP){

            @Override
            public String coalesce(String replacement, String existing) {
                return existing + replacement;
            }
        }
        ,
        KEEP_ONLY_IDENTICAL_INSERTS(DuplicateInsertPolicy.KEEP){

            @Override
            public String coalesce(String replacement, String existing) {
                return REJECT.coalesce(replacement, existing);
            }
        };

        private final DuplicateInsertPolicy duplicateInsertPolicy;

        private CoalescePolicy(DuplicateInsertPolicy duplicateInsertPolicy) {
            this.duplicateInsertPolicy = duplicateInsertPolicy;
        }

        public abstract String coalesce(String var1, String var2);

        private Replacement handleDuplicateInsertion(Replacement replacement) {
            return this.duplicateInsertPolicy.combineDuplicateInserts(replacement);
        }

        private static enum DuplicateInsertPolicy {
            KEEP{

                @Override
                Replacement combineDuplicateInserts(Replacement insertion) {
                    return insertion.withDifferentText(insertion.replaceWith() + insertion.replaceWith());
                }
            }
            ,
            DROP{

                @Override
                Replacement combineDuplicateInserts(Replacement insertion) {
                    return insertion;
                }
            };


            abstract Replacement combineDuplicateInserts(Replacement var1);
        }
    }
}

