/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.base.VerifyException;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.matchers.AnnotationDoesNotHaveArgument;
import com.google.errorprone.matchers.AnnotationHasArgumentWithValue;
import com.google.errorprone.matchers.AnnotationMatcher;
import com.google.errorprone.matchers.AnnotationType;
import com.google.errorprone.matchers.Asserts;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.CompoundAssignment;
import com.google.errorprone.matchers.ConstructorOfClass;
import com.google.errorprone.matchers.Contains;
import com.google.errorprone.matchers.Enclosing;
import com.google.errorprone.matchers.HasArguments;
import com.google.errorprone.matchers.HasIdentifier;
import com.google.errorprone.matchers.IsSameType;
import com.google.errorprone.matchers.IsSubtypeOf;
import com.google.errorprone.matchers.IsSymbol;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.MethodHasParameters;
import com.google.errorprone.matchers.MethodInvocation;
import com.google.errorprone.matchers.MethodInvocationArgument;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.matchers.NullnessMatcher;
import com.google.errorprone.matchers.Returns;
import com.google.errorprone.matchers.StringLiteral;
import com.google.errorprone.matchers.Throws;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.model.JavacElements;
import com.sun.tools.javac.model.JavacTypes;
import com.sun.tools.javac.tree.JCTree;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;

public class Matchers {
    private static final Supplier<ImmutableSet<Type>> CLASSES_CONSIDERED_THROWING = VisitorState.memoize(state -> (ImmutableSet)Stream.of("org.junit.function.ThrowingRunnable", "org.junit.jupiter.api.function.Executable", "org.assertj.core.api.ThrowableAssert$ThrowingCallable", "com.google.common.truth.ExpectFailure.AssertionCallback", "com.google.common.truth.ExpectFailure.DelegatedAssertionCallback", "com.google.common.truth.ExpectFailure.StandardSubjectBuilderCallback", "com.google.common.truth.ExpectFailure.SimpleSubjectBuilderCallback", "com.google.devtools.build.lib.testutil.MoreAsserts$ThrowingRunnable", "com.google.gerrit.testing.GerritJUnit$ThrowingRunnable").map(state::getTypeFromString).filter(Objects::nonNull).collect(ImmutableSet.toImmutableSet()));
    private static final Matcher<ExpressionTree> STATIC_EQUALS = Matchers.anyOf(Matchers.allOf(Matchers.staticMethod().onClass("android.support.v4.util.ObjectsCompat").named("equals").withParameters("java.lang.Object", "java.lang.Object"), Matchers::methodReturnsBoolean), Matchers.allOf(Matchers.staticMethod().onClass("androidx.v4.util.ObjectsCompat").named("equals").withParameters("java.lang.Object", "java.lang.Object"), Matchers::methodReturnsBoolean), Matchers.allOf(Matchers.staticMethod().onClass("java.util.Objects").named("equals").withParameters("java.lang.Object", "java.lang.Object"), Matchers::methodReturnsBoolean), Matchers.allOf(Matchers.staticMethod().onClass("com.google.common.base.Objects").named("equal").withParameters("java.lang.Object", "java.lang.Object"), Matchers::methodReturnsBoolean));
    public static final Matcher<ExpressionTree> INSTANCE_EQUALS = Matchers.allOf(Matchers.instanceMethod().anyClass().named("equals").withParameters("java.lang.Object", new String[0]), Matchers::methodReturnsBoolean);
    public static final Matcher<MethodTree> MAIN_METHOD = Matchers.allOf(Matchers.methodHasArity(1), Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.hasModifier(Modifier.STATIC), Matchers.methodReturns(Suppliers.VOID_TYPE), Matchers.methodIsNamed("main"), Matchers.methodHasParameters(Matchers.isSameType(Suppliers.arrayOf(Suppliers.STRING_TYPE))));
    private static final Matcher<ExpressionTree> INSTANCE_HASHCODE = Matchers.allOf(Matchers.instanceMethod().anyClass().named("hashCode").withNoParameters(), Matchers.isSameType(Suppliers.INT_TYPE));
    private static final Matcher<ExpressionTree> ASSERT_EQUALS = Matchers.staticMethod().onClassAny("org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase").named("assertEquals");
    private static final Matcher<ExpressionTree> ASSERT_NOT_EQUALS = Matchers.staticMethod().onClassAny("org.junit.Assert", "junit.framework.Assert", "junit.framework.TestCase").named("assertNotEquals");
    private static final Matcher<MethodTree> EQUALS_DECLARATION = Matchers.allOf(Matchers.methodIsNamed("equals"), Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.methodHasParameters(Matchers.variableType(Matchers.isSameType("java.lang.Object"))), Matchers.anyOf(Matchers.methodReturns(Suppliers.BOOLEAN_TYPE), Matchers.methodReturns(Suppliers.JAVA_LANG_BOOLEAN_TYPE)));
    private static final Matcher<MethodTree> TO_STRING_DECLARATION = Matchers.allOf(Matchers.methodIsNamed("toString"), Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.methodHasNoParameters(), Matchers.methodReturns(Suppliers.STRING_TYPE));
    private static final Matcher<MethodTree> HASH_CODE_DECLARATION = Matchers.allOf(Matchers.methodIsNamed("hashCode"), Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.methodHasNoParameters(), Matchers.methodReturns(Suppliers.INT_TYPE));
    private static final Matcher<MethodTree> COMPARABLE_METHOD_MATCHER = Matchers.allOf(Matchers.methodIsNamed("compareTo"), Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.methodReturns(Suppliers.INT_TYPE), Matchers.methodHasArity(1));
    public static final Matcher<MethodTree> SERIALIZATION_METHODS = Matchers.allOf((t, s) -> ASTHelpers.isSubtype(ASTHelpers.getSymbol((MethodTree)t).owner.type, s.getSymtab().serializableType, s), Matchers.anyOf(Matchers.allOf(Matchers.methodIsNamed("readObject"), Matchers.methodHasParameters(Matchers.isSameType("java.io.ObjectInputStream"))), Matchers.allOf(Matchers.methodIsNamed("writeObject"), Matchers.methodHasParameters(Matchers.isSameType("java.io.ObjectOutputStream"))), Matchers.allOf(Matchers.methodIsNamed("readObjectNoData"), Matchers.methodReturns(Matchers.isVoidType())), Matchers.allOf(Matchers.methodIsNamed("readResolve"), Matchers.methodReturns(Suppliers.typeFromString("java.lang.Object"))), Matchers.allOf(Matchers.methodIsNamed("writeReplace"), Matchers.methodReturns(Suppliers.typeFromString("java.lang.Object")))));
    public static final Matcher<Tree> IS_INTERFACE = (t, s) -> {
        Symbol symbol = ASTHelpers.getSymbol(t);
        return symbol instanceof Symbol.ClassSymbol && symbol.isInterface();
    };

    private Matchers() {
    }

    public static <T extends Tree> Matcher<T> anything() {
        return (t, state) -> true;
    }

    public static <T extends Tree> Matcher<T> nothing() {
        return (t, state) -> false;
    }

    public static <T extends Tree> Matcher<T> not(Matcher<T> matcher) {
        return (t, state) -> !matcher.matches(t, state);
    }

    @SafeVarargs
    public static <T extends Tree> Matcher<T> allOf(Matcher<? super T> ... matchers) {
        return (t, state) -> {
            for (Matcher matcher : matchers) {
                if (matcher.matches(t, state)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T extends Tree> Matcher<T> allOf(Iterable<? extends Matcher<? super T>> matchers) {
        return (t, state) -> {
            for (Matcher matcher : matchers) {
                if (matcher.matches(t, state)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T extends Tree> Matcher<T> anyOf(Iterable<? extends Matcher<? super T>> matchers) {
        return (t, state) -> {
            for (Matcher matcher : matchers) {
                if (!matcher.matches(t, state)) continue;
                return true;
            }
            return false;
        };
    }

    @SafeVarargs
    public static <T extends Tree> Matcher<T> anyOf(Matcher<? super T> ... matchers) {
        return Matchers.anyOf(Arrays.asList(matchers));
    }

    public static <T extends Tree> Matcher<T> isInstance(Class<?> klass) {
        return (t, state) -> klass.isInstance(t);
    }

    public static <T extends Tree> Matcher<T> kindIs(Tree.Kind kind) {
        return (tree, state) -> tree.getKind() == kind;
    }

    public static <T extends Tree> Matcher<T> kindAnyOf(Set<Tree.Kind> kinds) {
        return (tree, state) -> kinds.contains((Object)tree.getKind());
    }

    public static <T extends Tree> Matcher<T> isSame(Tree t) {
        return (tree, state) -> tree == t;
    }

    public static MethodMatchers.StaticMethodMatcher staticMethod() {
        return MethodMatchers.staticMethod();
    }

    public static MethodMatchers.InstanceMethodMatcher instanceMethod() {
        return MethodMatchers.instanceMethod();
    }

    public static MethodMatchers.AnyMethodMatcher anyMethod() {
        return MethodMatchers.anyMethod();
    }

    public static MethodMatchers.ConstructorMatcher constructor() {
        return MethodMatchers.constructor();
    }

    public static <T extends Tree> Matcher<T> symbolMatcher(BiPredicate<Symbol, VisitorState> pred) {
        return (tree, state) -> {
            Symbol sym = ASTHelpers.getSymbol(tree);
            return sym != null && pred.test(sym, state);
        };
    }

    public static Matcher<ExpressionTree> isInstanceField() {
        return Matchers.symbolMatcher((symbol, state) -> symbol.getKind() == ElementKind.FIELD && !ASTHelpers.isStatic(symbol));
    }

    public static Matcher<ExpressionTree> isVariable() {
        return Matchers.symbolMatcher((symbol, state) -> symbol.getKind() == ElementKind.LOCAL_VARIABLE || symbol.getKind() == ElementKind.PARAMETER);
    }

    public static CompoundAssignment compoundAssignment(Tree.Kind operator, Matcher<ExpressionTree> leftOperandMatcher, Matcher<ExpressionTree> rightOperandMatcher) {
        HashSet<Tree.Kind> operators = new HashSet<Tree.Kind>(1);
        operators.add(operator);
        return new CompoundAssignment(operators, leftOperandMatcher, rightOperandMatcher);
    }

    public static CompoundAssignment compoundAssignment(Set<Tree.Kind> operators, Matcher<ExpressionTree> receiverMatcher, Matcher<ExpressionTree> expressionMatcher) {
        return new CompoundAssignment(operators, receiverMatcher, expressionMatcher);
    }

    public static Matcher<? super MethodInvocationTree> receiverSameAsArgument(int argNum) {
        return (t, state) -> {
            List<? extends ExpressionTree> args = t.getArguments();
            if (args.size() <= argNum) {
                return false;
            }
            ExpressionTree arg = args.get(argNum);
            JCTree.JCExpression methodSelect = (JCTree.JCExpression)t.getMethodSelect();
            if (methodSelect instanceof JCTree.JCFieldAccess) {
                JCTree.JCFieldAccess fieldAccess = (JCTree.JCFieldAccess)methodSelect;
                return ASTHelpers.sameVariable(fieldAccess.getExpression(), arg);
            }
            if (methodSelect instanceof JCTree.JCIdent) {
                return arg.toString().equals("this");
            }
            return false;
        };
    }

    public static Matcher<MethodInvocationTree> receiverOfInvocation(Matcher<ExpressionTree> expressionTreeMatcher) {
        return (methodInvocationTree, state) -> {
            ExpressionTree receiver = ASTHelpers.getReceiver(methodInvocationTree);
            return receiver != null && expressionTreeMatcher.matches(receiver, state);
        };
    }

    public static <T extends Tree> MultiMatcher<T, AnnotationTree> annotations(ChildMultiMatcher.MatchType matchType, Matcher<AnnotationTree> annotationMatcher) {
        return new AnnotationMatcher(matchType, annotationMatcher);
    }

    public static MultiMatcher<ClassTree, MethodTree> constructor(ChildMultiMatcher.MatchType matchType, Matcher<MethodTree> constructorMatcher) {
        return new ConstructorOfClass(matchType, constructorMatcher);
    }

    public static Matcher<MethodInvocationTree> argument(int position, Matcher<ExpressionTree> argumentMatcher) {
        return new MethodInvocationArgument(position, argumentMatcher);
    }

    public static MultiMatcher<MethodInvocationTree, ExpressionTree> hasArguments(ChildMultiMatcher.MatchType matchType, Matcher<ExpressionTree> argumentMatcher) {
        return new HasArguments(matchType, argumentMatcher);
    }

    public static Matcher<ExpressionTree> methodInvocation(Matcher<ExpressionTree> methodSelectMatcher, ChildMultiMatcher.MatchType matchType, Matcher<ExpressionTree> methodArgumentMatcher) {
        return new MethodInvocation(methodSelectMatcher, matchType, methodArgumentMatcher);
    }

    public static Matcher<ExpressionTree> methodInvocation(Matcher<ExpressionTree> methodSelectMatcher) {
        return (expressionTree, state) -> {
            MethodInvocationTree tree;
            return expressionTree instanceof MethodInvocationTree && methodSelectMatcher.matches((tree = (MethodInvocationTree)expressionTree).getMethodSelect(), state);
        };
    }

    public static Matcher<MethodInvocationTree> argumentCount(int argumentCount) {
        return (t, state) -> t.getArguments().size() == argumentCount;
    }

    public static <T extends Tree> Matcher<T> parentNode(Matcher<Tree> treeMatcher) {
        return (tree, state) -> {
            TreePath parent = Objects.requireNonNull(state.getPath().getParentPath());
            return treeMatcher.matches(parent.getLeaf(), state.withPath(parent));
        };
    }

    public static <T extends Tree> Matcher<T> isSubtypeOf(String typeStr) {
        return new IsSubtypeOf(typeStr);
    }

    public static <T extends Tree> Matcher<T> isSubtypeOf(Supplier<Type> type) {
        return new IsSubtypeOf(type);
    }

    public static <T extends Tree> Matcher<T> isSubtypeOf(Class<?> clazz) {
        return new IsSubtypeOf(Suppliers.typeFromClass(clazz));
    }

    public static <T extends Tree> Matcher<T> isSameType(Supplier<Type> type) {
        return new IsSameType(type);
    }

    public static <T extends Tree> Matcher<T> isSameType(String typeString) {
        return new IsSameType(typeString);
    }

    public static <T extends Tree> Matcher<T> isSameType(Class<?> clazz) {
        return new IsSameType(Suppliers.typeFromClass(clazz));
    }

    public static <T extends Tree> Matcher<T> typePredicateMatcher(TypePredicate pred) {
        return (tree, state) -> {
            Type type = ASTHelpers.getType(tree);
            return type != null && pred.apply(type, state);
        };
    }

    public static <T extends Tree> Matcher<T> isArrayType() {
        return Matchers.typePredicateMatcher((type, state) -> state.getTypes().isArray(type));
    }

    public static <T extends Tree> Matcher<T> isPrimitiveArrayType() {
        return Matchers.typePredicateMatcher((type, state) -> state.getTypes().isArray(type) && state.getTypes().elemtype(type).isPrimitive());
    }

    public static <T extends Tree> Matcher<T> isPrimitiveType() {
        return Matchers.typePredicateMatcher((type, state) -> type.isPrimitive());
    }

    public static <T extends Tree> Matcher<T> isPrimitiveOrVoidType() {
        return Matchers.typePredicateMatcher((type, state) -> type.isPrimitiveOrVoid());
    }

    public static <T extends Tree> Matcher<T> isVoidType() {
        return Matchers.typePredicateMatcher((type, state) -> state.getTypes().isSameType(type, state.getSymtab().voidType));
    }

    public static <T extends Tree> Matcher<T> isPrimitiveOrBoxedPrimitiveType() {
        return Matchers.typePredicateMatcher((type, state) -> state.getTypes().unboxedTypeOrType(type).isPrimitive());
    }

    public static Matcher<ExpressionTree> isBoxedPrimitiveType() {
        return Matchers.typePredicateMatcher((type, state) -> !state.getTypes().isSameType(state.getTypes().unboxedType(type), Type.noType));
    }

    public static <T extends Tree> Enclosing.Block<T> enclosingBlock(Matcher<BlockTree> matcher) {
        return new Enclosing.Block(matcher);
    }

    public static <T extends Tree> Enclosing.Class<T> enclosingClass(Matcher<ClassTree> matcher) {
        return new Enclosing.Class(matcher);
    }

    public static <T extends Tree> Enclosing.Method<T> enclosingMethod(Matcher<MethodTree> matcher) {
        return new Enclosing.Method(matcher);
    }

    public static Matcher<Tree> enclosingNode(Matcher<Tree> matcher) {
        return (t, state) -> {
            for (TreePath path = state.getPath().getParentPath(); path != null; path = path.getParentPath()) {
                Tree node = path.getLeaf();
                if (!matcher.matches(node, state = state.withPath(path))) continue;
                return true;
            }
            return false;
        };
    }

    private static boolean siblingStatement(int offset, Matcher<StatementTree> matcher, StatementTree statement, VisitorState state) {
        TreePath blockPath = state.findPathToEnclosing(BlockTree.class);
        if (blockPath == null) {
            return false;
        }
        BlockTree block = (BlockTree)blockPath.getLeaf();
        List<? extends StatementTree> statements = block.getStatements();
        int idx = statements.indexOf(statement);
        if (idx == -1) {
            return false;
        }
        if ((idx += offset) < 0 || idx >= statements.size()) {
            return false;
        }
        StatementTree sibling = statements.get(idx);
        return matcher.matches(sibling, state.withPath(new TreePath(blockPath, sibling)));
    }

    public static <T extends StatementTree> Matcher<T> nextStatement(Matcher<StatementTree> matcher) {
        return (statement, state) -> Matchers.siblingStatement(1, matcher, statement, state);
    }

    public static <T extends StatementTree> Matcher<T> previousStatement(Matcher<StatementTree> matcher) {
        return (statement, state) -> Matchers.siblingStatement(-1, matcher, statement, state);
    }

    public static Matcher<StatementTree> isLastStatementInBlock() {
        return (statement, state) -> {
            TreePath blockPath = state.findPathToEnclosing(BlockTree.class);
            if (blockPath == null) {
                return false;
            }
            BlockTree block = (BlockTree)blockPath.getLeaf();
            return ((StatementTree)Iterables.getLast(block.getStatements())).equals(statement);
        };
    }

    public static Matcher<ExpressionTree> nullLiteral() {
        return (tree, state) -> tree.getKind() == Tree.Kind.NULL_LITERAL;
    }

    public static Matcher<ExpressionTree> nonNullLiteral() {
        return (tree, state) -> switch (tree.getKind()) {
            case Tree.Kind.MEMBER_SELECT -> ((MemberSelectTree)tree).getIdentifier().contentEquals("class");
            case Tree.Kind.INT_LITERAL, Tree.Kind.LONG_LITERAL, Tree.Kind.FLOAT_LITERAL, Tree.Kind.DOUBLE_LITERAL, Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.CHAR_LITERAL, Tree.Kind.STRING_LITERAL -> true;
            default -> false;
        };
    }

    public static Matcher<ExpressionTree> stringLiteral(String value) {
        return new StringLiteral(value);
    }

    public static Matcher<ExpressionTree> stringLiteral(Pattern pattern) {
        return new StringLiteral(pattern);
    }

    public static Matcher<ExpressionTree> booleanLiteral(boolean value) {
        return (tree, state) -> {
            Boolean bool;
            LiteralTree literalTree;
            Object patt0$temp;
            return tree instanceof LiteralTree && (patt0$temp = (literalTree = (LiteralTree)tree).getValue()) instanceof Boolean && (bool = (Boolean)patt0$temp) == value;
        };
    }

    public static Matcher<ExpressionTree> booleanConstant(boolean value) {
        return (expressionTree, state) -> {
            Symbol symbol;
            if (expressionTree instanceof JCTree.JCFieldAccess && ASTHelpers.isStatic(symbol = ASTHelpers.getSymbol(expressionTree)) && state.getTypes().unboxedTypeOrType(symbol.type).getTag() == TypeTag.BOOLEAN) {
                if (value) {
                    return symbol.getSimpleName().contentEquals("TRUE");
                }
                return symbol.getSimpleName().contentEquals("FALSE");
            }
            return false;
        };
    }

    public static Matcher<ExpressionTree> ignoreParens(Matcher<ExpressionTree> innerMatcher) {
        return (tree, state) -> innerMatcher.matches(ASTHelpers.stripParentheses(tree), state);
    }

    public static Matcher<ExpressionTree> intLiteral(int value) {
        return (tree, state) -> {
            Integer integer;
            LiteralTree literalTree;
            Object patt0$temp;
            return tree instanceof LiteralTree && (patt0$temp = (literalTree = (LiteralTree)tree).getValue()) instanceof Integer && (integer = (Integer)patt0$temp) == value;
        };
    }

    public static Matcher<ExpressionTree> classLiteral(Matcher<? super ExpressionTree> classMatcher) {
        return (tree, state) -> {
            MemberSelectTree select;
            return tree instanceof MemberSelectTree && (select = (MemberSelectTree)tree).getIdentifier().contentEquals("class") && classMatcher.matches(select.getExpression(), state);
        };
    }

    public static Matcher<AnnotationTree> hasArgumentWithValue(String argumentName, Matcher<ExpressionTree> valueMatcher) {
        return new AnnotationHasArgumentWithValue(argumentName, valueMatcher);
    }

    public static Matcher<AnnotationTree> doesNotHaveArgument(String argumentName) {
        return new AnnotationDoesNotHaveArgument(argumentName);
    }

    public static Matcher<AnnotationTree> isType(String annotationClassName) {
        return new AnnotationType(annotationClassName);
    }

    public static Matcher<? super MethodInvocationTree> sameArgument(int index1, int index2) {
        return (tree, state) -> {
            List<? extends ExpressionTree> args = tree.getArguments();
            return ASTHelpers.sameVariable(args.get(index1), args.get(index2));
        };
    }

    public static <T extends Tree> Matcher<T> hasAnnotation(String annotationClass) {
        Supplier<Set> name = VisitorState.memoize(state -> ImmutableSet.of((Object)state.binaryNameFromClassname(annotationClass)));
        return (tree, state) -> !ASTHelpers.annotationsAmong(ASTHelpers.getDeclaredSymbol(tree), (Set)name.get(state), state).isEmpty();
    }

    public static Matcher<Tree> hasAnnotation(TypeMirror annotationMirror) {
        String annotationName = annotationMirror.toString();
        return (tree, state) -> {
            TypeElement typeElem = (TypeElement)JavacTypes.instance(state.context).asElement(annotationMirror);
            String name = typeElem != null ? JavacElements.instance(state.context).getBinaryName(typeElem).toString() : annotationName;
            return ASTHelpers.hasAnnotation(ASTHelpers.getDeclaredSymbol(tree), name, state);
        };
    }

    public static <T extends Tree> Matcher<T> hasAnnotationWithSimpleName(String simpleName) {
        return (tree, state) -> ASTHelpers.hasDirectAnnotationWithSimpleName(ASTHelpers.getDeclaredSymbol(tree), simpleName);
    }

    public static <T extends Tree> Matcher<T> symbolHasAnnotation(String annotationClass) {
        return Matchers.symbolMatcher((symbol, state) -> ASTHelpers.hasAnnotation(symbol, annotationClass, state));
    }

    public static <T extends Tree> Matcher<T> hasAnnotation(Class<? extends Annotation> inputClass) {
        return (tree, state) -> ASTHelpers.hasAnnotation(ASTHelpers.getDeclaredSymbol(tree), inputClass, state);
    }

    public static <T extends Tree> Matcher<T> symbolHasAnnotation(Class<? extends Annotation> inputClass) {
        return (tree, state) -> ASTHelpers.hasAnnotation(ASTHelpers.getSymbol(tree), inputClass, state);
    }

    public static Matcher<MethodTree> hasAnnotationOnAnyOverriddenMethod(String annotationClass) {
        return (tree, state) -> {
            Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol(tree);
            if (methodSym == null) {
                return false;
            }
            if (ASTHelpers.hasAnnotation((Symbol)methodSym, annotationClass, state)) {
                return true;
            }
            for (Symbol.MethodSymbol method : ASTHelpers.findSuperMethods(methodSym, state.getTypes())) {
                if (!ASTHelpers.hasAnnotation((Symbol)method, annotationClass, state)) continue;
                return true;
            }
            return false;
        };
    }

    public static Matcher<ExpressionTree> methodReturnsNonNull() {
        return Matchers.anyOf(Matchers.instanceMethod().onDescendantOf("java.lang.Object").named("toString"), Matchers.instanceMethod().onExactClass("java.lang.String"), Matchers.staticMethod().onClass("java.lang.String"), Matchers.instanceMethod().onExactClass("java.util.StringTokenizer").named("nextToken"));
    }

    public static Matcher<MethodTree> methodReturns(Matcher<? super Tree> returnTypeMatcher) {
        return (methodTree, state) -> {
            Tree returnTree = methodTree.getReturnType();
            return returnTree != null && returnTypeMatcher.matches(returnTree, state);
        };
    }

    public static Matcher<MethodTree> methodReturns(Supplier<Type> returnType) {
        return Matchers.methodReturns(Matchers.isSameType(returnType));
    }

    public static Matcher<MethodTree> methodReturnsNonPrimitiveType() {
        return Matchers.methodReturns(Matchers.not(Matchers.isPrimitiveOrVoidType()));
    }

    public static Matcher<MethodTree> methodIsNamed(String methodName) {
        return (methodTree, state) -> methodTree.getName().contentEquals(methodName);
    }

    public static Matcher<MethodTree> methodNameStartsWith(String prefix) {
        return (methodTree, state) -> methodTree.getName().toString().startsWith(prefix);
    }

    public static Matcher<MethodTree> methodWithClassAndName(String className, String methodName) {
        return (methodTree, state) -> ((Symbol)ASTHelpers.getSymbol(methodTree).getEnclosingElement()).getQualifiedName().contentEquals(className) && methodTree.getName().contentEquals(methodName);
    }

    @SafeVarargs
    public static Matcher<MethodTree> methodHasParameters(Matcher<VariableTree> ... variableMatcher) {
        return Matchers.methodHasParameters((List<Matcher<VariableTree>>)ImmutableList.copyOf((Object[])variableMatcher));
    }

    public static Matcher<MethodTree> methodHasNoParameters() {
        return Matchers.methodHasParameters((List<Matcher<VariableTree>>)ImmutableList.of());
    }

    public static Matcher<MethodTree> methodHasParameters(List<Matcher<VariableTree>> variableMatcher) {
        return (methodTree, state) -> {
            if (methodTree.getParameters().size() != variableMatcher.size()) {
                return false;
            }
            int paramIndex = 0;
            for (Matcher eachVariableMatcher : variableMatcher) {
                if (eachVariableMatcher.matches(methodTree.getParameters().get(paramIndex++), state)) continue;
                return false;
            }
            return true;
        };
    }

    public static MultiMatcher<MethodTree, VariableTree> methodHasParameters(ChildMultiMatcher.MatchType matchType, Matcher<VariableTree> parameterMatcher) {
        return new MethodHasParameters(matchType, parameterMatcher);
    }

    public static Matcher<MethodTree> methodHasVisibility(MethodVisibility.Visibility visibility) {
        return new MethodVisibility(visibility);
    }

    public static Matcher<MethodTree> methodIsConstructor() {
        return (methodTree, state) -> ASTHelpers.getSymbol(methodTree).isConstructor();
    }

    public static Matcher<MethodTree> constructorOfClass(String className) {
        return (methodTree, state) -> {
            Symbol.MethodSymbol symbol = ASTHelpers.getSymbol(methodTree);
            return ((Symbol)symbol).getEnclosingElement().getQualifiedName().contentEquals(className) && symbol.isConstructor();
        };
    }

    public static Matcher<ClassTree> hasMethod(Matcher<MethodTree> methodMatcher) {
        return (t, state) -> {
            for (Tree tree : t.getMembers()) {
                MethodTree methodTree;
                if (!(tree instanceof MethodTree) || !methodMatcher.matches(methodTree = (MethodTree)tree, state)) continue;
                return true;
            }
            return false;
        };
    }

    public static Matcher<VariableTree> variableType(Matcher<Tree> treeMatcher) {
        return (variableTree, state) -> treeMatcher.matches(variableTree.getType(), state);
    }

    public static Matcher<VariableTree> variableInitializer(Matcher<ExpressionTree> expressionTreeMatcher) {
        return (variableTree, state) -> {
            ExpressionTree initializer = variableTree.getInitializer();
            return initializer != null && expressionTreeMatcher.matches(initializer, state);
        };
    }

    public static Matcher<VariableTree> isField() {
        return (variableTree, state) -> ASTHelpers.getSymbol(variableTree).getKind() == ElementKind.FIELD;
    }

    public static Matcher<ClassTree> isEnum() {
        return (classTree, state) -> ASTHelpers.getSymbol(classTree).getKind() == ElementKind.ENUM;
    }

    public static Matcher<ClassTree> isRecord() {
        return (classTree, state) -> ASTHelpers.getSymbol(classTree).getKind() == ElementKind.RECORD;
    }

    public static Matcher<ClassTree> nestingKind(NestingKind kind) {
        return (classTree, state) -> kind == ASTHelpers.getSymbol(classTree).getNestingKind();
    }

    public static Matcher<BinaryTree> binaryTree(Matcher<ExpressionTree> matcher1, Matcher<ExpressionTree> matcher2) {
        return (t, state) -> null != ASTHelpers.matchBinaryTree(t, Arrays.asList(matcher1, matcher2), state);
    }

    public static Matcher<Tree> hasIdentifier(Matcher<IdentifierTree> nodeMatcher) {
        return new HasIdentifier(nodeMatcher);
    }

    public static <T extends Tree> Matcher<T> hasModifier(Modifier modifier) {
        return (tree, state) -> {
            Symbol sym = ASTHelpers.getSymbol(tree);
            return sym != null && sym.getModifiers().contains((Object)modifier);
        };
    }

    public static Matcher<ExpressionTree> staticFieldAccess() {
        return Matchers.allOf(Matchers.isStatic(), Matchers.isSymbol(Symbol.VarSymbol.class));
    }

    public static <T extends Tree> Matcher<T> isStatic() {
        return (tree, state) -> {
            Symbol sym = ASTHelpers.getSymbol(tree);
            return sym != null && ASTHelpers.isStatic(sym);
        };
    }

    public static <T extends Tree> Matcher<T> isTransient() {
        return (tree, state) -> ASTHelpers.getSymbol(tree).getModifiers().contains((Object)Modifier.TRANSIENT);
    }

    public static Matcher<StatementTree> throwStatement(Matcher<? super ExpressionTree> thrownMatcher) {
        return new Throws(thrownMatcher);
    }

    public static Matcher<StatementTree> returnStatement(Matcher<? super ExpressionTree> returnedMatcher) {
        return new Returns(returnedMatcher);
    }

    public static Matcher<StatementTree> assertStatement(Matcher<ExpressionTree> conditionMatcher) {
        return new Asserts(conditionMatcher);
    }

    public static Matcher<StatementTree> continueStatement() {
        return (statementTree, state) -> statementTree instanceof ContinueTree;
    }

    public static Matcher<StatementTree> expressionStatement(Matcher<ExpressionTree> matcher) {
        return (statementTree, state) -> {
            ExpressionStatementTree expressionStatementTree;
            return statementTree instanceof ExpressionStatementTree && matcher.matches((expressionStatementTree = (ExpressionStatementTree)statementTree).getExpression(), state);
        };
    }

    static Matcher<Tree> isSymbol(Class<? extends Symbol> symbolClass) {
        return new IsSymbol(symbolClass);
    }

    public static <S extends T, T extends Tree> Matcher<T> toType(Class<S> type, Matcher<? super S> matcher) {
        return (tree, state) -> type.isInstance(tree) && matcher.matches((Object)((Tree)type.cast(tree)), state);
    }

    public static <T extends Tree> Matcher<T> inSynchronized() {
        return (tree, state) -> {
            SynchronizedTree synchronizedTree = ASTHelpers.findEnclosingNode(state.getPath(), SynchronizedTree.class);
            if (synchronizedTree != null) {
                return true;
            }
            MethodTree methodTree = ASTHelpers.findEnclosingNode(state.getPath(), MethodTree.class);
            return methodTree != null && methodTree.getModifiers().getFlags().contains((Object)Modifier.SYNCHRONIZED);
        };
    }

    public static Matcher<ExpressionTree> sameVariable(ExpressionTree expr) {
        return (tree, state) -> ASTHelpers.sameVariable(tree, expr);
    }

    public static Matcher<ExpressionTree> isNonNullUsingDataflow() {
        return new NullnessMatcher(Nullness.NONNULL);
    }

    @Deprecated
    public static Matcher<ExpressionTree> isNonNull() {
        return Matchers.isNonNullUsingDataflow();
    }

    public static Matcher<ExpressionTree> isNullUsingDataflow() {
        return new NullnessMatcher(Nullness.NULL);
    }

    @Deprecated
    public static Matcher<ExpressionTree> isNull() {
        return Matchers.isNullUsingDataflow();
    }

    public static Matcher<EnhancedForLoopTree> enhancedForLoop(Matcher<VariableTree> variableMatcher, Matcher<ExpressionTree> expressionMatcher, Matcher<StatementTree> statementMatcher) {
        return (t, state) -> variableMatcher.matches(t.getVariable(), state) && expressionMatcher.matches(t.getExpression(), state) && statementMatcher.matches(t.getStatement(), state);
    }

    public static <T extends Tree> Matcher<T> inLoop() {
        return (tree, state) -> {
            for (TreePath path = state.getPath().getParentPath(); path != null; path = path.getParentPath()) {
                Tree node = path.getLeaf();
                switch (node.getKind()) {
                    case METHOD: 
                    case CLASS: {
                        return false;
                    }
                    case WHILE_LOOP: 
                    case FOR_LOOP: 
                    case ENHANCED_FOR_LOOP: 
                    case DO_WHILE_LOOP: {
                        return true;
                    }
                }
            }
            return false;
        };
    }

    public static Matcher<AssignmentTree> assignment(Matcher<ExpressionTree> variableMatcher, Matcher<? super ExpressionTree> expressionMatcher) {
        return (t, state) -> variableMatcher.matches(t.getVariable(), state) && expressionMatcher.matches(t.getExpression(), state);
    }

    public static Matcher<TypeCastTree> typeCast(Matcher<Tree> typeMatcher, Matcher<ExpressionTree> expressionMatcher) {
        return (t, state) -> typeMatcher.matches(t.getType(), state) && expressionMatcher.matches(t.getExpression(), state);
    }

    public static Matcher<AssertTree> assertionWithCondition(Matcher<ExpressionTree> conditionMatcher) {
        return (tree, state) -> conditionMatcher.matches(tree.getCondition(), state);
    }

    public static Matcher<Tree> contains(Matcher<Tree> treeMatcher) {
        return new Contains(treeMatcher);
    }

    public static <T extends Tree, V extends Tree> Matcher<T> contains(Class<? extends V> clazz, Matcher<? super V> treeMatcher) {
        Contains contains = new Contains(Matchers.toType(clazz, treeMatcher));
        return contains::matches;
    }

    public static Matcher<MethodTree> methodHasArity(int arity) {
        return (methodTree, state) -> methodTree.getParameters().size() == arity;
    }

    public static Matcher<ClassTree> isDirectImplementationOf(String clazz) {
        Matcher<Tree> isProvidedType = Matchers.isSameType(clazz);
        return new IsDirectImplementationOf(isProvidedType);
    }

    public static Matcher<ClassTree> isExtensionOf(String clazz) {
        Matcher<Tree> isProvidedType = Matchers.isSameType(clazz);
        return new IsExtensionOf(isProvidedType);
    }

    @SafeVarargs
    public static Matcher<Tree> hasAnyAnnotation(Class<? extends Annotation> ... annotations) {
        ArrayList matchers = new ArrayList(annotations.length);
        for (Class<? extends Annotation> annotation : annotations) {
            matchers.add(Matchers.hasAnnotation(annotation));
        }
        return Matchers.anyOf(matchers);
    }

    public static Matcher<Tree> hasAnyAnnotation(List<? extends TypeMirror> mirrors) {
        ArrayList<Matcher<Tree>> matchers = new ArrayList<Matcher<Tree>>(mirrors.size());
        for (TypeMirror typeMirror : mirrors) {
            matchers.add(Matchers.hasAnnotation(typeMirror));
        }
        return Matchers.anyOf(matchers);
    }

    public static boolean methodCallInDeclarationOfThrowingRunnable(VisitorState state) {
        return Streams.stream((Iterable)state.getPath()).filter(t -> t instanceof LambdaExpressionTree || t instanceof ClassTree).findFirst().map(t -> Matchers.isThrowingFunctionalInterface(ASTHelpers.getType(t), state)).orElseThrow(VerifyException::new);
    }

    public static boolean isThrowingFunctionalInterface(Type clazzType, VisitorState state) {
        return CLASSES_CONSIDERED_THROWING.get(state).stream().anyMatch(t -> ASTHelpers.isSubtype(clazzType, t, state));
    }

    public static <T extends Tree> Matcher<T> packageMatches(Predicate<String> predicate) {
        return (tree, state) -> predicate.test(Matchers.getPackageFullName(state));
    }

    public static <T extends Tree> Matcher<T> packageMatches(Pattern pattern) {
        return Matchers.packageMatches(pattern.asPredicate());
    }

    public static <T extends Tree> Matcher<T> packageStartsWith(String prefix) {
        return Matchers.packageMatches((String s) -> s.startsWith(prefix));
    }

    private static String getPackageFullName(VisitorState state) {
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
        return compilationUnit.packge.fullname.toString();
    }

    public static <T extends ExpressionTree> Matcher<T> staticEqualsInvocation() {
        return STATIC_EQUALS;
    }

    private static boolean methodReturnsBoolean(ExpressionTree tree, VisitorState state) {
        return ASTHelpers.isSameType(ASTHelpers.getSymbol((Tree)tree).type.getReturnType(), state.getSymtab().booleanType, state);
    }

    public static <T extends ExpressionTree> Matcher<T> instanceEqualsInvocation() {
        return INSTANCE_EQUALS;
    }

    public static Matcher<ExpressionTree> instanceHashCodeInvocation() {
        return INSTANCE_HASHCODE;
    }

    public static Matcher<ExpressionTree> assertEqualsInvocation() {
        return ASSERT_EQUALS;
    }

    public static Matcher<ExpressionTree> assertNotEqualsInvocation() {
        return ASSERT_NOT_EQUALS;
    }

    public static Matcher<MethodTree> equalsMethodDeclaration() {
        return EQUALS_DECLARATION;
    }

    public static Matcher<MethodTree> toStringMethodDeclaration() {
        return TO_STRING_DECLARATION;
    }

    public static Matcher<MethodTree> hashCodeMethodDeclaration() {
        return HASH_CODE_DECLARATION;
    }

    public static Matcher<MethodTree> compareToMethodDeclaration() {
        return COMPARABLE_METHOD_MATCHER;
    }

    public static Matcher<StatementTree> matchExpressionReturn(Matcher<ExpressionTree> expressionTreeMatcher) {
        return (statement, state) -> {
            if (!(statement instanceof ReturnTree)) {
                return false;
            }
            ReturnTree returnTree = (ReturnTree)statement;
            ExpressionTree expression = returnTree.getExpression();
            if (expression == null) {
                return false;
            }
            return expressionTreeMatcher.matches(expression, state);
        };
    }

    public static Matcher<BlockTree> matchSingleStatementBlock(Matcher<StatementTree> statementMatcher) {
        return (blockTree, state) -> {
            if (blockTree == null) {
                return false;
            }
            List<? extends StatementTree> statements = blockTree.getStatements();
            if (statements.size() != 1) {
                return false;
            }
            return statementMatcher.matches((StatementTree)Iterables.getOnlyElement(statements), state);
        };
    }

    public static Matcher<MethodTree> singleStatementReturnMatcher(Matcher<ExpressionTree> expressionTreeMatcher) {
        Matcher<BlockTree> matcher = Matchers.matchSingleStatementBlock(Matchers.matchExpressionReturn(expressionTreeMatcher));
        return (methodTree, state) -> matcher.matches(methodTree.getBody(), state);
    }

    private static class IsDirectImplementationOf
    extends ChildMultiMatcher<ClassTree, Tree> {
        IsDirectImplementationOf(Matcher<Tree> classMatcher) {
            super(ChildMultiMatcher.MatchType.AT_LEAST_ONE, classMatcher);
        }

        @Override
        protected Iterable<? extends Tree> getChildNodes(ClassTree classTree, VisitorState state) {
            return classTree.getImplementsClause();
        }
    }

    private static class IsExtensionOf
    extends ChildMultiMatcher<ClassTree, Tree> {
        IsExtensionOf(Matcher<Tree> classMatcher) {
            super(ChildMultiMatcher.MatchType.AT_LEAST_ONE, classMatcher);
        }

        @Override
        protected Iterable<? extends Tree> getChildNodes(ClassTree classTree, VisitorState state) {
            ArrayList<Tree> matched = new ArrayList<Tree>();
            Tree extendsClause = classTree.getExtendsClause();
            if (extendsClause != null) {
                matched.add(extendsClause);
            }
            return matched;
        }
    }
}

