/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.SwitchExpressionTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.lang.runtime.SwitchBootstraps;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;

public record TargetType(Type type, TreePath path) {
    private static final @Nullable Class<?> CONSTANT_CASE_LABEL_TREE = TargetType.constantCaseLabelTree();

    public static @Nullable TargetType targetType(VisitorState state) {
        ExpressionTree current;
        if (!TargetType.canHaveTargetType(state.getPath().getLeaf())) {
            return null;
        }
        TreePath parent = state.getPath();
        do {
            current = (ExpressionTree)parent.getLeaf();
        } while ((parent = parent.getParentPath()) != null && parent.getLeaf().getKind() == Tree.Kind.PARENTHESIZED);
        if (parent == null) {
            return null;
        }
        Type type = (Type)new TargetTypeVisitor(current, state, parent).visit(parent.getLeaf(), null);
        if (type == null) {
            Tree actualTree = null;
            if (parent.getLeaf() instanceof YieldTree) {
                actualTree = parent.getParentPath().getParentPath().getParentPath().getLeaf();
            } else if (CONSTANT_CASE_LABEL_TREE != null && CONSTANT_CASE_LABEL_TREE.isAssignableFrom(parent.getLeaf().getClass())) {
                actualTree = parent.getParentPath().getParentPath().getLeaf();
            }
            type = ASTHelpers.getType(TargetTypeVisitor.getSwitchExpression(actualTree));
            if (type == null) {
                return null;
            }
        }
        return TargetType.create(type, parent);
    }

    static TargetType create(Type type, TreePath path) {
        return new TargetType(type, path);
    }

    private static @Nullable Class<?> constantCaseLabelTree() {
        try {
            return Class.forName("com.sun.source.tree.ConstantCaseLabelTree");
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    private static boolean canHaveTargetType(Tree tree) {
        if (!(tree instanceof ExpressionTree)) {
            return false;
        }
        switch (tree.getKind()) {
            case IDENTIFIER: 
            case MEMBER_SELECT: {
                if (ASTHelpers.getSymbol(tree) instanceof Symbol.VarSymbol) break;
                return false;
            }
            case PRIMITIVE_TYPE: 
            case ARRAY_TYPE: 
            case PARAMETERIZED_TYPE: 
            case EXTENDS_WILDCARD: 
            case SUPER_WILDCARD: 
            case UNBOUNDED_WILDCARD: 
            case ANNOTATED_TYPE: 
            case INTERSECTION_TYPE: 
            case TYPE_ANNOTATION: {
                return false;
            }
            case ANNOTATION: {
                return false;
            }
        }
        return true;
    }

    private static @Nullable Type unaryNumericPromotion(Type type, VisitorState state) {
        Type unboxed = TargetType.unboxAndEnsureNumeric(type, state);
        return switch (unboxed.getTag()) {
            case TypeTag.BYTE, TypeTag.SHORT, TypeTag.CHAR -> state.getSymtab().intType;
            case TypeTag.INT, TypeTag.LONG, TypeTag.FLOAT, TypeTag.DOUBLE -> unboxed;
            default -> throw new AssertionError((Object)("Should not reach here: " + String.valueOf(type)));
        };
    }

    private static @Nullable Type binaryNumericPromotion(Type leftType, Type rightType, VisitorState state) {
        Type unboxedLeft = TargetType.unboxAndEnsureNumeric(leftType, state);
        Type unboxedRight = TargetType.unboxAndEnsureNumeric(rightType, state);
        EnumSet<TypeTag> tags = EnumSet.of(unboxedLeft.getTag(), unboxedRight.getTag());
        if (tags.contains((Object)TypeTag.DOUBLE)) {
            return state.getSymtab().doubleType;
        }
        if (tags.contains((Object)TypeTag.FLOAT)) {
            return state.getSymtab().floatType;
        }
        if (tags.contains((Object)TypeTag.LONG)) {
            return state.getSymtab().longType;
        }
        return state.getSymtab().intType;
    }

    private static Type unboxAndEnsureNumeric(Type type, VisitorState state) {
        Type unboxed = state.getTypes().unboxedTypeOrType(type);
        Preconditions.checkArgument((boolean)unboxed.isNumeric(), (String)"[%s] is not numeric", (Object)type);
        return unboxed;
    }

    @VisibleForTesting
    static class TargetTypeVisitor
    extends SimpleTreeVisitor<Type, Void> {
        private final VisitorState state;
        private final TreePath parent;
        private final ExpressionTree current;

        private TargetTypeVisitor(ExpressionTree current, VisitorState state, TreePath parent) {
            this.current = current;
            this.state = state;
            this.parent = parent;
        }

        @Override
        public @Nullable Type visitArrayAccess(ArrayAccessTree node, Void unused) {
            if (this.current.equals(node.getIndex())) {
                return this.state.getSymtab().intType;
            }
            return ASTHelpers.getType(node.getExpression());
        }

        @Override
        public Type visitAssert(AssertTree node, Void unused) {
            return this.current.equals(node.getCondition()) ? this.state.getSymtab().booleanType : this.state.getSymtab().stringType;
        }

        @Override
        public @Nullable Type visitAssignment(AssignmentTree tree, Void unused) {
            return ASTHelpers.getType(tree.getVariable());
        }

        @Override
        public Type visitAnnotation(AnnotationTree tree, Void unused) {
            return null;
        }

        @Override
        public @Nullable Type visitCase(CaseTree tree, Void unused) {
            Tree switchTree = this.parent.getParentPath().getLeaf();
            if (tree.getBody() != null && tree.getBody().equals(this.current)) {
                return ASTHelpers.getType(switchTree);
            }
            return ASTHelpers.getType(TargetTypeVisitor.getSwitchExpression(switchTree));
        }

        private static @Nullable ExpressionTree getSwitchExpression(@Nullable Tree tree) {
            if (tree instanceof SwitchTree) {
                SwitchTree switchTree = (SwitchTree)tree;
                return switchTree.getExpression();
            }
            if (tree instanceof SwitchExpressionTree) {
                SwitchExpressionTree switchExpressionTree = (SwitchExpressionTree)tree;
                return switchExpressionTree.getExpression();
            }
            return null;
        }

        @Override
        public Type visitClass(ClassTree node, Void unused) {
            return null;
        }

        @Override
        public @Nullable Type visitCompoundAssignment(CompoundAssignmentTree tree, Void unused) {
            Type variableType = ASTHelpers.getType(tree.getVariable());
            Type expressionType = ASTHelpers.getType(tree.getExpression());
            Types types = this.state.getTypes();
            switch (tree.getKind()) {
                case LEFT_SHIFT_ASSIGNMENT: 
                case RIGHT_SHIFT_ASSIGNMENT: 
                case UNSIGNED_RIGHT_SHIFT_ASSIGNMENT: {
                    if (!tree.getExpression().equals(this.current)) break;
                    return TargetType.unaryNumericPromotion(expressionType, this.state);
                }
                case PLUS_ASSIGNMENT: {
                    Type stringType = this.state.getSymtab().stringType;
                    if (!types.isSuperType(variableType, stringType)) break;
                    return stringType;
                }
            }
            return types.unboxedTypeOrType(variableType).getTag() == TypeTag.BOOLEAN ? this.state.getSymtab().booleanType : TargetType.binaryNumericPromotion(variableType, expressionType, this.state);
        }

        @Override
        public Type visitEnhancedForLoop(EnhancedForLoopTree node, Void unused) {
            Type variableType = ASTHelpers.getType(node.getVariable());
            if (this.state.getTypes().isArray(ASTHelpers.getType(node.getExpression()))) {
                return this.state.getType(variableType, true, (List<Type>)ImmutableList.of());
            }
            variableType = this.state.getTypes().boxedTypeOrType(variableType);
            return this.state.getType(this.state.getSymtab().iterableType, false, (List<Type>)ImmutableList.of((Object)new Type.WildcardType(variableType, BoundKind.EXTENDS, variableType.tsym)));
        }

        @Override
        public Type visitInstanceOf(InstanceOfTree node, Void unused) {
            return this.state.getSymtab().objectType;
        }

        @Override
        public Type visitLambdaExpression(LambdaExpressionTree lambdaExpressionTree, Void unused) {
            return this.state.getTypes().findDescriptorType(ASTHelpers.getType(lambdaExpressionTree)).getReturnType();
        }

        @Override
        public Type visitMethod(MethodTree node, Void unused) {
            return null;
        }

        @Override
        public @Nullable Type visitReturn(ReturnTree tree, Void unused) {
            for (TreePath path = this.parent; path != null; path = path.getParentPath()) {
                Tree tree2;
                Tree enclosing = path.getLeaf();
                Objects.requireNonNull(enclosing);
                int n = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodTree.class, LambdaExpressionTree.class}, (Object)tree2, n)) {
                    case 0: {
                        MethodTree methodTree = (MethodTree)tree2;
                        return ASTHelpers.getType(methodTree.getReturnType());
                    }
                    case 1: {
                        LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree2;
                        return this.visitLambdaExpression(lambdaExpressionTree, null);
                    }
                }
            }
            throw new AssertionError((Object)"return not enclosed by method or lambda");
        }

        @Override
        public @Nullable Type visitSynchronized(SynchronizedTree node, Void unused) {
            return Objects.equals(this.current, node.getExpression()) ? this.state.getSymtab().objectType : null;
        }

        @Override
        public Type visitThrow(ThrowTree node, Void unused) {
            return ASTHelpers.getType(this.current);
        }

        @Override
        public Type visitTypeCast(TypeCastTree node, Void unused) {
            return ASTHelpers.getType(node.getType());
        }

        @Override
        public @Nullable Type visitVariable(VariableTree tree, Void unused) {
            return ASTHelpers.getType(tree.getType());
        }

        @Override
        public @Nullable Type visitUnary(UnaryTree tree, Void unused) {
            return ASTHelpers.getType(tree);
        }

        @Override
        public @Nullable Type visitBinary(BinaryTree tree, Void unused) {
            Type leftType = (Type)Preconditions.checkNotNull((Object)ASTHelpers.getType(tree.getLeftOperand()));
            Type rightType = (Type)Preconditions.checkNotNull((Object)ASTHelpers.getType(tree.getRightOperand()));
            switch (tree.getKind()) {
                case PLUS: {
                    Type stringType = this.state.getSymtab().stringType;
                    if (ASTHelpers.isSameType(stringType, leftType, this.state) || ASTHelpers.isSameType(stringType, rightType, this.state)) {
                        return stringType;
                    }
                }
                case MINUS: 
                case MULTIPLY: 
                case DIVIDE: 
                case REMAINDER: 
                case LESS_THAN: 
                case LESS_THAN_EQUAL: 
                case GREATER_THAN: 
                case GREATER_THAN_EQUAL: 
                case AND: 
                case XOR: 
                case OR: {
                    if (TargetTypeVisitor.typeIsBoolean(this.state.getTypes().unboxedTypeOrType(leftType)) && TargetTypeVisitor.typeIsBoolean(this.state.getTypes().unboxedTypeOrType(rightType))) {
                        return this.state.getSymtab().booleanType;
                    }
                    return TargetType.binaryNumericPromotion(leftType, rightType, this.state);
                }
                case EQUAL_TO: 
                case NOT_EQUAL_TO: {
                    return this.handleEqualityOperator(tree, leftType, rightType);
                }
                case LEFT_SHIFT: 
                case RIGHT_SHIFT: 
                case UNSIGNED_RIGHT_SHIFT: {
                    return TargetType.unaryNumericPromotion(ASTHelpers.getType(this.current), this.state);
                }
            }
            return ASTHelpers.getType(tree);
        }

        private @Nullable Type handleEqualityOperator(BinaryTree tree, Type leftType, Type rightType) {
            Type unboxedLeft = (Type)Preconditions.checkNotNull((Object)this.state.getTypes().unboxedTypeOrType(leftType));
            Type unboxedRight = (Type)Preconditions.checkNotNull((Object)this.state.getTypes().unboxedTypeOrType(rightType));
            if (leftType.isNumeric() && rightType.isNumeric() || leftType.isNumeric() != rightType.isNumeric() && (unboxedLeft.isNumeric() || unboxedRight.isNumeric())) {
                return TargetType.binaryNumericPromotion(unboxedLeft, unboxedRight, this.state);
            }
            boolean leftIsBoolean = TargetTypeVisitor.typeIsBoolean(leftType);
            boolean rightIsBoolean = TargetTypeVisitor.typeIsBoolean(rightType);
            if (leftIsBoolean && rightIsBoolean || leftIsBoolean != rightIsBoolean && (TargetTypeVisitor.typeIsBoolean(unboxedLeft) || TargetTypeVisitor.typeIsBoolean(unboxedRight))) {
                return this.state.getSymtab().booleanType;
            }
            return tree.getLeftOperand().equals(this.current) ? leftType : rightType;
        }

        private static boolean typeIsBoolean(Type type) {
            return type.getTag() == TypeTag.BOOLEAN;
        }

        @Override
        public @Nullable Type visitConditionalExpression(ConditionalExpressionTree tree, Void unused) {
            return tree.getCondition().equals(this.current) ? this.state.getSymtab().booleanType : ASTHelpers.getType(tree);
        }

        @Override
        public Type visitNewClass(NewClassTree tree, Void unused) {
            if (Objects.equals(this.current, tree.getEnclosingExpression())) {
                return ASTHelpers.getSymbol((Tree)tree.getIdentifier()).owner.type;
            }
            return this.visitMethodInvocationOrNewClass(tree.getArguments(), ASTHelpers.getSymbol(tree), ((JCTree.JCNewClass)tree).constructorType);
        }

        @Override
        public Type visitMethodInvocation(MethodInvocationTree tree, Void unused) {
            return this.visitMethodInvocationOrNewClass(tree.getArguments(), ASTHelpers.getSymbol(tree), ((JCTree.JCMethodInvocation)tree).meth.type);
        }

        private @Nullable Type visitMethodInvocationOrNewClass(List<? extends ExpressionTree> arguments, Symbol.MethodSymbol sym, Type type) {
            int idx = arguments.indexOf(this.current);
            if (idx == -1) {
                return null;
            }
            if (type.getParameterTypes().size() <= idx) {
                if (!sym.isVarArgs()) {
                    if ((sym.flags() & 0x2000000000L) != 0L) {
                        return null;
                    }
                    throw new IllegalStateException(String.format("saw %d formal parameters and %d actual parameters on non-varargs method %s\n", type.getParameterTypes().size(), arguments.size(), sym));
                }
                idx = type.getParameterTypes().size() - 1;
            }
            Type argType = type.getParameterTypes().get(idx);
            if (sym.isVarArgs() && idx == type.getParameterTypes().size() - 1) {
                argType = this.state.getTypes().elemtype(argType);
            }
            return argType;
        }

        @Override
        public Type visitIf(IfTree tree, Void unused) {
            return this.getConditionType(tree.getCondition());
        }

        @Override
        public Type visitWhileLoop(WhileLoopTree tree, Void unused) {
            return this.getConditionType(tree.getCondition());
        }

        @Override
        public Type visitDoWhileLoop(DoWhileLoopTree tree, Void unused) {
            return this.getConditionType(tree.getCondition());
        }

        @Override
        public Type visitForLoop(ForLoopTree tree, Void unused) {
            return this.getConditionType(tree.getCondition());
        }

        @Override
        public @Nullable Type visitSwitch(SwitchTree node, Void unused) {
            if (this.current == node.getExpression()) {
                return this.state.getTypes().unboxedTypeOrType(ASTHelpers.getType(this.current));
            }
            return null;
        }

        @Override
        public @Nullable Type visitNewArray(NewArrayTree node, Void unused) {
            if (Objects.equals(node.getType(), this.current)) {
                return null;
            }
            if (node.getDimensions().contains(this.current)) {
                return this.state.getSymtab().intType;
            }
            if (node.getInitializers() != null && node.getInitializers().contains(this.current)) {
                return this.state.getTypes().elemtype(ASTHelpers.getType(node));
            }
            return null;
        }

        @Override
        public @Nullable Type visitMemberSelect(MemberSelectTree node, Void unused) {
            if (!this.current.equals(node.getExpression())) {
                return null;
            }
            Symbol symbol = ASTHelpers.getSymbol(node);
            if (!(symbol instanceof Symbol.MethodSymbol)) {
                return ASTHelpers.getType(node.getExpression());
            }
            Symbol.MethodSymbol ms = (Symbol.MethodSymbol)symbol;
            Type typeDeclaringMethod = this.getEffectiveReceiverType(node, ms);
            return ASTHelpers.getType(node.getExpression()).isRaw() ? this.state.getTypes().erasure(typeDeclaringMethod) : typeDeclaringMethod;
        }

        private Type getEffectiveReceiverType(MemberSelectTree node, Symbol.MethodSymbol ms) {
            ImmutableSet superMethods = (ImmutableSet)Stream.concat(Stream.of(ms), ASTHelpers.streamSuperMethods(ms, this.state.getTypes())).collect(ImmutableSet.toImmutableSet());
            ImmutableSet superMethodReturnTypes = (ImmutableSet)superMethods.stream().map(sm -> this.state.getTypes().erasure(sm.getReturnType())).collect(ImmutableSet.toImmutableSet());
            if (superMethodReturnTypes.size() == 1) {
                return ((Symbol.MethodSymbol)Iterables.getLast((Iterable)superMethods)).owner.type;
            }
            TargetType invocationTarget = TargetType.targetType(this.state.withPath(this.parent.getParentPath()));
            return Streams.findLast(superMethods.stream().filter(sms -> invocationTarget == null || ASTHelpers.isSubtype(sms.getReturnType(), invocationTarget.type(), this.state))).map(m -> m.owner.type).orElse(ASTHelpers.getType(node.getExpression()));
        }

        @Override
        public Type visitMemberReference(MemberReferenceTree node, Void unused) {
            return this.state.getTypes().findDescriptorType(ASTHelpers.getType(node)).getReturnType();
        }

        private @Nullable Type getConditionType(Tree condition) {
            if (condition != null && condition.equals(this.current)) {
                return this.state.getSymtab().booleanType;
            }
            return null;
        }
    }
}

