/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Throwables;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;

public interface ErrorProneEndPosTable {
    public static final MethodHandle GET_END_POS_HANDLE = ErrorProneEndPosTable.getEndPosMethodHandle();

    private static MethodHandle getEndPosMethodHandle() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return MethodHandles.dropArguments(lookup.findVirtual(JCDiagnostic.DiagnosticPosition.class, "getEndPosition", MethodType.methodType(Integer.TYPE)), 1, new Class[]{JCTree.JCCompilationUnit.class});
        }
        catch (ReflectiveOperationException e1) {
            try {
                Class<?> endPosTableClass = Class.forName("com.sun.tools.javac.tree.EndPosTable");
                return MethodHandles.filterArguments(lookup.findVirtual(JCDiagnostic.DiagnosticPosition.class, "getEndPosition", MethodType.methodType(Integer.TYPE, endPosTableClass)), 1, lookup.findVarHandle(JCTree.JCCompilationUnit.class, "endPositions", endPosTableClass).toMethodHandle(VarHandle.AccessMode.GET));
            }
            catch (ReflectiveOperationException e2) {
                e2.addSuppressed(e1);
                throw new LinkageError(e2.getMessage(), e2);
            }
        }
    }

    public static ErrorProneEndPosTable create(CompilationUnitTree unit) {
        MethodHandle getEndPosition = MethodHandles.insertArguments(GET_END_POS_HANDLE, 1, unit);
        return pos -> {
            try {
                return getEndPosition.invokeExact(pos);
            }
            catch (Throwable e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new AssertionError((Object)e);
            }
        };
    }

    default public int getEndPosition(Tree tree) {
        return this.getEndPosition((JCDiagnostic.DiagnosticPosition)((Object)tree));
    }

    default public int getEndPosition(JCTree tree) {
        return this.getEndPosition((JCDiagnostic.DiagnosticPosition)tree);
    }

    public int getEndPosition(JCDiagnostic.DiagnosticPosition var1);

    public static int getEndPosition(Tree tree, CompilationUnitTree unit) {
        return ErrorProneEndPosTable.getEndPosition((JCDiagnostic.DiagnosticPosition)((Object)tree), unit);
    }

    public static int getEndPosition(JCTree tree, CompilationUnitTree unit) {
        return ErrorProneEndPosTable.getEndPosition((JCDiagnostic.DiagnosticPosition)tree, unit);
    }

    public static int getEndPosition(JCDiagnostic.DiagnosticPosition pos, CompilationUnitTree unit) {
        return ErrorProneEndPosTable.create(unit).getEndPosition(pos);
    }
}

