/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.names;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class NamingConventions {
    private static final Pattern ONLY_UNDERSCORES = Pattern.compile("^_+$");
    private static final String UNDERSCORE = "_";
    private static final String CASE_TRANSITION = "(?<=[a-z0-9])(?=[A-Z])";
    private static final String TRAILING_DIGITS = "(?<![0-9_])(?=[0-9]+$)";
    private static final Splitter TERM_SPLITTER = Splitter.onPattern((String)String.format("%s|%s|%s", "_", "(?<=[a-z0-9])(?=[A-Z])", "(?<![0-9_])(?=[0-9]+$)")).omitEmptyStrings();

    public static ImmutableList<String> splitToLowercaseTerms(String identifierName) {
        if (ONLY_UNDERSCORES.matcher(identifierName).matches()) {
            return ImmutableList.of((Object)identifierName);
        }
        return (ImmutableList)TERM_SPLITTER.splitToStream((CharSequence)identifierName).map(String::toLowerCase).collect(ImmutableList.toImmutableList());
    }

    public static String convertToLowerUnderscore(String identifierName) {
        return NamingConventions.splitToLowercaseTerms(identifierName).stream().collect(Collectors.joining(UNDERSCORE));
    }

    private NamingConventions() {
    }
}

