/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.SourcePositionException;
import com.google.errorprone.fixes.AppliedFix;
import com.google.errorprone.fixes.ErrorProneEndPosTable;
import com.google.errorprone.fixes.ErrorPronePosition;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ImportTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.Log;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.BiFunction;
import javax.tools.JavaFileObject;

public class JavacErrorDescriptionListener
implements DescriptionListener {
    private final Log log;
    private final JavaFileObject sourceFile;
    private final BiFunction<Description, Fix, AppliedFix> fixToAppliedFix;
    private final Context context;
    private final boolean dontUseErrors;
    private static final String MESSAGE_BUNDLE_KEY = "error.prone";
    private static final ImmutableSet<JCDiagnostic.DiagnosticFlag> DIAGNOSTIC_FLAGS = ImmutableSet.of((Object)((Object)JCDiagnostic.DiagnosticFlag.API));

    private JavacErrorDescriptionListener(Log log, ErrorProneEndPosTable endPositions, JavaFileObject sourceFile, Context context, boolean dontUseErrors) {
        this.log = log;
        this.sourceFile = sourceFile;
        this.context = context;
        this.dontUseErrors = dontUseErrors;
        Preconditions.checkNotNull((Object)endPositions);
        HashMap cache = new HashMap();
        try {
            CharSequence sourceFileContent = sourceFile.getCharContent(true);
            this.fixToAppliedFix = (description, fix) -> cache.computeIfAbsent(fix, f -> {
                try {
                    return AppliedFix.apply(sourceFileContent, endPositions, f);
                }
                catch (SourcePositionException e) {
                    throw e.toErrorProneError(description.checkName, sourceFile);
                }
            });
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDescribed(Description description) {
        ImmutableList appliedFixes = (ImmutableList)description.fixes.stream().filter(f -> !JavacErrorDescriptionListener.shouldSkipImportTreeFix(description.position, f)).map(f -> this.fixToAppliedFix.apply(description, (Fix)f)).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
        String message = JavacErrorDescriptionListener.messageForFixes(description, (List<AppliedFix>)appliedFixes);
        JavaFileObject originalSource = this.log.useSource(this.sourceFile);
        try {
            JCDiagnostic.Factory factory = JCDiagnostic.Factory.instance(this.context);
            JCDiagnostic.SimpleDiagnosticPosition pos = new JCDiagnostic.SimpleDiagnosticPosition(description.position.getPreferredPosition());
            JCDiagnostic.DiagnosticType type = switch (description.severity()) {
                default -> throw new MatchException(null, null);
                case BugPattern.SeverityLevel.ERROR -> {
                    if (this.dontUseErrors) {
                        yield JCDiagnostic.DiagnosticType.WARNING;
                    }
                    yield JCDiagnostic.DiagnosticType.ERROR;
                }
                case BugPattern.SeverityLevel.WARNING -> JCDiagnostic.DiagnosticType.WARNING;
                case BugPattern.SeverityLevel.SUGGESTION -> JCDiagnostic.DiagnosticType.NOTE;
            };
            this.log.report(factory.create(type, null, EnumSet.copyOf(DIAGNOSTIC_FLAGS), this.log.currentSource(), pos, MESSAGE_BUNDLE_KEY, message));
        }
        finally {
            if (originalSource != null) {
                this.log.useSource(originalSource);
            }
        }
    }

    private static boolean shouldSkipImportTreeFix(ErrorPronePosition position, Fix f) {
        if (position.getTree() != null && !(position.getTree() instanceof ImportTree)) {
            return false;
        }
        return !f.getImportsToAdd().isEmpty() || !f.getImportsToRemove().isEmpty();
    }

    private static String messageForFixes(Description description, List<AppliedFix> appliedFixes) {
        StringBuilder messageBuilder = new StringBuilder(description.getMessage());
        boolean first = true;
        for (AppliedFix appliedFix : appliedFixes) {
            if (first) {
                messageBuilder.append("\nDid you mean ");
            } else {
                messageBuilder.append(" or ");
            }
            if (appliedFix.isRemoveLine()) {
                messageBuilder.append("to remove this line");
            } else {
                messageBuilder.append("'").append((CharSequence)appliedFix.snippet()).append("'");
            }
            first = false;
        }
        if (!first) {
            messageBuilder.append("?");
        }
        return messageBuilder.toString();
    }

    static DescriptionListener.Factory provider(Context context) {
        return (log, compilation) -> new JavacErrorDescriptionListener(log, ErrorProneEndPosTable.create(compilation), compilation.getSourceFile(), context, false);
    }

    static DescriptionListener.Factory providerForRefactoring(Context context) {
        return (log, compilation) -> new JavacErrorDescriptionListener(log, ErrorProneEndPosTable.create(compilation), compilation.getSourceFile(), context, true);
    }
}

