/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.apply;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.AbstractService;
import com.google.errorprone.apply.Diff;
import com.google.errorprone.apply.FileDestination;
import com.google.errorprone.apply.FileSource;
import com.google.errorprone.apply.SourceFile;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jspecify.annotations.Nullable;

public class DiffApplier
extends AbstractService {
    private static final Logger logger = Logger.getLogger(DiffApplier.class.getName());
    private final ExecutorService workerService;
    private final Set<String> refactoredPaths;
    private final Set<String> diffsFailedPaths;
    private final FileSource source;
    private final FileDestination destination;
    private final AtomicInteger completedFiles;
    private final Stopwatch stopwatch;
    private final AtomicInteger runState = new AtomicInteger();

    public DiffApplier(int diffParallelism, FileSource source, FileDestination destination) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)destination);
        this.diffsFailedPaths = new ConcurrentSkipListSet<String>();
        this.refactoredPaths = Sets.newConcurrentHashSet();
        this.source = source;
        this.destination = destination;
        this.completedFiles = new AtomicInteger(0);
        this.stopwatch = Stopwatch.createUnstarted();
        this.workerService = new ThreadPoolExecutor(0, diffParallelism, 5L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(50), Thread.ofPlatform().name("DiffApplier.workerService").factory(), new ThreadPoolExecutor.CallerRunsPolicy());
    }

    protected void doStart() {
        this.stopwatch.start();
        this.runState.incrementAndGet();
        this.notifyStarted();
    }

    protected void doStop() {
        this.decrementTasks();
    }

    private final void decrementTasks() {
        if (this.runState.decrementAndGet() == 0) {
            this.workerService.shutdown();
            try {
                this.destination.flush();
                this.notifyStopped();
            }
            catch (Exception e) {
                this.notifyFailed(e);
            }
            logger.log(Level.INFO, String.format("Completed %d files in %s", this.completedFiles.get(), this.stopwatch));
            if (!this.diffsFailedPaths.isEmpty()) {
                logger.log(Level.SEVERE, String.format("Diffs failed to apply to %d files: %s", this.diffsFailedPaths.size(), Iterables.limit(this.diffsFailedPaths, (int)30)));
            }
        }
    }

    public @Nullable Future<?> put(Diff diff) {
        if (this.refactoredPaths.add(diff.getRelevantFileName())) {
            this.runState.incrementAndGet();
            return this.workerService.submit(new Task(diff));
        }
        return null;
    }

    private final class Task
    implements Runnable {
        private final Diff diff;

        Task(Diff diff) {
            this.diff = diff;
        }

        @Override
        public void run() {
            try {
                SourceFile file = DiffApplier.this.source.readFile(this.diff.getRelevantFileName());
                this.diff.applyDifferences(file);
                DiffApplier.this.destination.writeFile(file);
                int completed = DiffApplier.this.completedFiles.incrementAndGet();
                if (completed % 100 == 0) {
                    logger.log(Level.INFO, String.format("Completed %d files in %s", completed, DiffApplier.this.stopwatch));
                }
            }
            catch (IOException | RuntimeException e) {
                logger.log(Level.WARNING, "Failed to apply diff to file " + this.diff.getRelevantFileName(), e);
                DiffApplier.this.diffsFailedPaths.add(this.diff.getRelevantFileName());
            }
            finally {
                DiffApplier.this.decrementTasks();
            }
        }
    }
}

