/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Throwables;
import com.google.errorprone.SourcePositionException;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.VarHandle;
import org.jspecify.annotations.Nullable;

public interface ErrorProneEndPosTable {
    public static final @Nullable MethodHandle GET_END_POS_HANDLE = ErrorProneEndPosTable.getEndPosMethodHandle();
    public static final MethodHandle GET_END_POS_WITH_UNIT_HANDLE = ErrorProneEndPosTable.getEndPosWithUnitMethodHandle();

    private static @Nullable MethodHandle getEndPosMethodHandle() {
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            return lookup.findVirtual(JCDiagnostic.DiagnosticPosition.class, "getEndPosition", MethodType.methodType(Integer.TYPE));
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static MethodHandle getEndPosWithUnitMethodHandle() {
        if (GET_END_POS_HANDLE != null) {
            return MethodHandles.dropArguments(GET_END_POS_HANDLE, 1, new Class[]{JCTree.JCCompilationUnit.class});
        }
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            Class<?> endPosTableClass = Class.forName("com.sun.tools.javac.tree.EndPosTable");
            return MethodHandles.filterArguments(lookup.findVirtual(JCDiagnostic.DiagnosticPosition.class, "getEndPosition", MethodType.methodType(Integer.TYPE, endPosTableClass)), 1, lookup.findVarHandle(JCTree.JCCompilationUnit.class, "endPositions", endPosTableClass).toMethodHandle(VarHandle.AccessMode.GET));
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    public static void checkExplicitSource(Tree tree) {
        ErrorProneEndPosTable.checkExplicitSource((JCDiagnostic.DiagnosticPosition)((Object)tree));
    }

    public static void checkExplicitSource(JCTree tree) {
        ErrorProneEndPosTable.checkExplicitSource((JCDiagnostic.DiagnosticPosition)tree);
    }

    public static void checkExplicitSource(JCDiagnostic.DiagnosticPosition pos) {
        int end;
        if (pos == null) {
            return;
        }
        if (GET_END_POS_HANDLE == null) {
            return;
        }
        int start = pos.getStartPosition();
        try {
            end = GET_END_POS_HANDLE.invoke(pos);
        }
        catch (Throwable e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new AssertionError((Object)e);
        }
        if (start == -1 || end == -1 || start == end) {
            throw new SourcePositionException(start, end);
        }
    }

    public static ErrorProneEndPosTable create(CompilationUnitTree unit) {
        MethodHandle getEndPosition = MethodHandles.insertArguments(GET_END_POS_WITH_UNIT_HANDLE, 1, unit);
        return pos -> {
            try {
                return getEndPosition.invokeExact(pos);
            }
            catch (Throwable e) {
                Throwables.throwIfUnchecked((Throwable)e);
                throw new AssertionError((Object)e);
            }
        };
    }

    default public int getEndPosition(Tree tree) {
        return this.getEndPosition((JCDiagnostic.DiagnosticPosition)((Object)tree));
    }

    default public int getEndPosition(JCTree tree) {
        return this.getEndPosition((JCDiagnostic.DiagnosticPosition)tree);
    }

    public int getEndPosition(JCDiagnostic.DiagnosticPosition var1);

    public static int getEndPosition(Tree tree, CompilationUnitTree unit) {
        return ErrorProneEndPosTable.getEndPosition((JCDiagnostic.DiagnosticPosition)((Object)tree), unit);
    }

    public static int getEndPosition(JCTree tree, CompilationUnitTree unit) {
        return ErrorProneEndPosTable.getEndPosition((JCDiagnostic.DiagnosticPosition)tree, unit);
    }

    public static int getEndPosition(JCDiagnostic.DiagnosticPosition pos, CompilationUnitTree unit) {
        return ErrorProneEndPosTable.create(unit).getEndPosition(pos);
    }
}

