/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.collect.Range;
import com.google.errorprone.SourcePositionException;

public record Replacement(Range<Integer> range, String replaceWith) {
    public static Replacement create(int startPosition, int endPosition, String replaceWith) {
        if (startPosition < 0 || startPosition > endPosition) {
            throw new SourcePositionException(startPosition, endPosition);
        }
        return new Replacement((Range<Integer>)Range.closedOpen((Comparable)Integer.valueOf(startPosition), (Comparable)Integer.valueOf(endPosition)), replaceWith);
    }

    public int startPosition() {
        return (Integer)this.range().lowerEndpoint();
    }

    public int length() {
        return this.endPosition() - this.startPosition();
    }

    public int endPosition() {
        return (Integer)this.range().upperEndpoint();
    }

    Replacement withDifferentText(String replaceWith) {
        return new Replacement(this.range(), replaceWith);
    }
}

