/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.AnnotationType;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import java.util.Set;
import java.util.stream.Stream;

public final class InjectMatchers {
    public static final Matcher<Tree> INSIDE_GUICE_MODULE = Matchers.enclosingClass(Matchers.isSubtypeOf("com.google.inject.Module"));
    public static final String GUICE_PROVIDES_ANNOTATION = "com.google.inject.Provides";
    public static final String DAGGER_PROVIDES_ANNOTATION = "dagger.Provides";
    public static final ImmutableSet<String> PROVIDES_ANNOTATIONS = ImmutableSet.of((Object)"com.google.inject.Provides", (Object)"dagger.Provides");
    public static final ImmutableSet<String> MULTIBINDINGS_ANNOTATIONS = ImmutableSet.of((Object)"com.google.inject.multibindings.ProvidesIntoMap", (Object)"com.google.inject.multibindings.ProvidesIntoSet", (Object)"com.google.inject.multibindings.ProvidesIntoOptional");
    private static final Matcher<Tree> HAS_PROVIDES_ANNOTATION = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.anyOf((Iterable)Streams.concat((Stream[])new Stream[]{PROVIDES_ANNOTATIONS.stream(), MULTIBINDINGS_ANNOTATIONS.stream(), Stream.of("com.google.inject.throwingproviders.CheckedProvides", "dagger.producers.Produces")}).map(annotation -> Matchers.isType(annotation)).collect(ImmutableSet.toImmutableSet())));
    public static final String ASSISTED_ANNOTATION = "com.google.inject.assistedinject.Assisted";
    public static final String ASSISTED_INJECT_ANNOTATION = "com.google.inject.assistedinject.AssistedInject";
    public static final String GUICE_INJECT_ANNOTATION = "com.google.inject.Inject";
    public static final String JAVAX_INJECT_ANNOTATION = "javax.inject.Inject";
    public static final String JAKARTA_INJECT_ANNOTATION = "jakarta.inject.Inject";
    public static final ImmutableSet<String> INJECT_ANNOTATIONS = ImmutableSet.of((Object)"com.google.inject.Inject", (Object)"javax.inject.Inject", (Object)"jakarta.inject.Inject");
    public static final Matcher<AnnotationTree> IS_APPLICATION_OF_GUICE_INJECT = new AnnotationType("com.google.inject.Inject");
    public static final Matcher<AnnotationTree> IS_APPLICATION_OF_JAVAX_INJECT = new AnnotationType("javax.inject.Inject");
    public static final Matcher<AnnotationTree> IS_APPLICATION_OF_JAKARTA_INJECT = new AnnotationType("jakarta.inject.Inject");
    public static final Matcher<AnnotationTree> IS_APPLICATION_OF_AT_INJECT = Matchers.anyOf(IS_APPLICATION_OF_GUICE_INJECT, IS_APPLICATION_OF_JAVAX_INJECT, IS_APPLICATION_OF_JAKARTA_INJECT);
    public static final Matcher<Tree> HAS_INJECT_ANNOTATION = InjectMatchers.hasAnyOfAnnotations((ImmutableSet<String>)ImmutableSet.of((Object)"com.google.inject.Inject", (Object)"javax.inject.Inject", (Object)"jakarta.inject.Inject"));
    public static final String GUICE_SCOPE_ANNOTATION = "com.google.inject.ScopeAnnotation";
    public static final String JAVAX_SCOPE_ANNOTATION = "javax.inject.Scope";
    private static final String JAKARTA_SCOPE_ANNOTATION = "jakarta.inject.Scope";
    public static final ImmutableSet<String> SCOPE_ANNOTATIONS = ImmutableSet.of((Object)"com.google.inject.ScopeAnnotation", (Object)"javax.inject.Scope", (Object)"jakarta.inject.Scope");
    public static final Matcher<AnnotationTree> IS_SCOPING_ANNOTATION = Matchers.anyOf((Iterable)SCOPE_ANNOTATIONS.stream().map(annotation -> Matchers.symbolHasAnnotation(annotation)).collect(ImmutableSet.toImmutableSet()));
    public static final Matcher<ClassTree> HAS_SCOPE_ANNOTATION = InjectMatchers.hasAnyOfAnnotations(SCOPE_ANNOTATIONS);
    public static final String GUICE_BINDING_ANNOTATION = "com.google.inject.BindingAnnotation";
    public static final String JAVAX_QUALIFIER_ANNOTATION = "javax.inject.Qualifier";
    private static final String JAKARTA_QUALIFIER_ANNOTATION = "jakarta.inject.Qualifier";
    public static final ImmutableSet<String> QUALIFIER_ANNOTATIONS = ImmutableSet.of((Object)"com.google.inject.BindingAnnotation", (Object)"javax.inject.Qualifier", (Object)"jakarta.inject.Qualifier");
    public static final Matcher<AnnotationTree> IS_QUALIFIER_ANNOTATION = Matchers.anyOf((Iterable)QUALIFIER_ANNOTATIONS.stream().map(annotation -> Matchers.symbolHasAnnotation(annotation)).collect(ImmutableSet.toImmutableSet()));
    public static final Matcher<ClassTree> HAS_QUALIFIER_ANNOTATION = InjectMatchers.hasAnyOfAnnotations(QUALIFIER_ANNOTATIONS);
    public static final String GUICE_MAP_KEY_ANNOTATION = "com.google.inject.multibindings.MapKey";
    public static final String DAGGER_MAP_KEY_ANNOTATION = "dagger.MapKey";
    public static final Matcher<ClassTree> IS_DAGGER_COMPONENT = InjectMatchers.hasAnyOfAnnotations((ImmutableSet<String>)ImmutableSet.of((Object)"dagger.Component", (Object)"dagger.Subcomponent", (Object)"dagger.producers.ProductionComponent", (Object)"dagger.producers.ProductionSubcomponent", (Object)"dagger.hilt.DefineComponent"));
    public static final Matcher<ClassTree> IS_DAGGER_COMPONENT_OR_MODULE = Matchers.anyOf(IS_DAGGER_COMPONENT, Matchers.hasAnnotation("dagger.Module"));

    private InjectMatchers() {
    }

    public static <T extends Tree> Matcher<T> hasProvidesAnnotation() {
        return HAS_PROVIDES_ANNOTATION;
    }

    public static <T extends Tree> Matcher<T> hasInjectAnnotation() {
        return HAS_INJECT_ANNOTATION;
    }

    private static <T extends Tree> Matcher<T> hasAnyOfAnnotations(ImmutableSet<String> annotationClasses) {
        Supplier<ImmutableSet> name = VisitorState.memoize(state -> (ImmutableSet)annotationClasses.stream().map(state::binaryNameFromClassname).collect(ImmutableSet.toImmutableSet()));
        return (tree, state) -> !ASTHelpers.annotationsAmong(ASTHelpers.getDeclaredSymbol(tree), (Set)name.get(state), state).isEmpty();
    }
}

