/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.matchers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.errorprone.VisitorState;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MethodVisibility;
import com.google.errorprone.matchers.MultiMatcher;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.util.List;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;

public final class JUnitMatchers {
    public static final String JUNIT4_TEST_ANNOTATION = "org.junit.Test";
    public static final String JUNIT4_THEORY_ANNOTATION = "org.junit.experimental.theories.Theory";
    public static final String JUNIT_BEFORE_ANNOTATION = "org.junit.Before";
    public static final String JUNIT_AFTER_ANNOTATION = "org.junit.After";
    public static final String JUNIT_BEFORE_CLASS_ANNOTATION = "org.junit.BeforeClass";
    public static final String JUNIT_AFTER_CLASS_ANNOTATION = "org.junit.AfterClass";
    public static final String JUNIT4_RUN_WITH_ANNOTATION = "org.junit.runner.RunWith";
    private static final String JUNIT3_TEST_CASE_CLASS = "junit.framework.TestCase";
    private static final String JUNIT4_IGNORE_ANNOTATION = "org.junit.Ignore";
    public static final Matcher<MethodTree> hasJUnit4BeforeAnnotations = Matchers.anyOf(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Before"), Matchers.hasAnnotation("org.junit.BeforeClass"));
    public static final Matcher<MethodTree> hasJUnit4AfterAnnotations = Matchers.anyOf(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.After"), Matchers.hasAnnotation("org.junit.AfterClass"));
    public static final Matcher<ClassTree> isTestCaseDescendant = Matchers.isSubtypeOf("junit.framework.TestCase");
    public static final Matcher<ClassTree> isConcreteClassWithoutRunWith = Matchers.allOf(Matchers.not(Matchers.hasAnnotation("org.junit.runner.RunWith")), Matchers.not(Matchers.hasModifier(Modifier.ABSTRACT)), Matchers.nestingKind(NestingKind.TOP_LEVEL));
    public static final Matcher<ClassTree> hasJUnit4TestCases = Matchers.hasMethod(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Test"));
    public static final Matcher<ClassTree> isJUnit3TestClass = Matchers.allOf(isTestCaseDescendant, isConcreteClassWithoutRunWith, Matchers.not(hasJUnit4TestCases));
    public static final Matcher<MethodTree> isJunit3TestCase = Matchers.allOf(Matchers.methodNameStartsWith("test"), Matchers.methodHasNoParameters(), Matchers.hasModifier(Modifier.PUBLIC), Matchers.methodReturns(Suppliers.VOID_TYPE));
    private static final Matcher<MethodTree> looksLikeJUnitSetUpOrTearDown = Matchers.allOf(Matchers.methodHasNoParameters(), Matchers.anyOf(Matchers.methodHasVisibility(MethodVisibility.Visibility.PUBLIC), Matchers.methodHasVisibility(MethodVisibility.Visibility.PROTECTED)), Matchers.not(Matchers.hasModifier(Modifier.ABSTRACT)), Matchers.not(Matchers.hasModifier(Modifier.STATIC)), Matchers.methodReturns(Suppliers.VOID_TYPE));
    public static final Matcher<MethodTree> looksLikeJUnit3SetUp = Matchers.allOf(Matchers.methodIsNamed("setUp"), looksLikeJUnitSetUpOrTearDown);
    public static final Matcher<MethodTree> looksLikeJUnit4Before = Matchers.allOf(Matchers.hasAnnotationWithSimpleName("Before"), looksLikeJUnitSetUpOrTearDown);
    public static final Matcher<MethodTree> looksLikeJUnit3TearDown = Matchers.allOf(Matchers.methodIsNamed("tearDown"), looksLikeJUnitSetUpOrTearDown);
    public static final Matcher<MethodTree> looksLikeJUnit4After = Matchers.allOf(Matchers.hasAnnotationWithSimpleName("After"), looksLikeJUnitSetUpOrTearDown);
    public static final Matcher<MethodTree> wouldRunInJUnit4 = Matchers.allOf(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Test"), Matchers.not(Matchers.hasAnnotationOnAnyOverriddenMethod("org.junit.Ignore")));
    public static final Matcher<MethodTree> TEST_CASE = Matchers.anyOf(isJunit3TestCase, Matchers.hasAnnotation("org.junit.Test"), Matchers.hasAnnotation("org.junit.experimental.theories.Theory"));
    private static final ImmutableList<String> TEST_RUNNERS = ImmutableList.of((Object)"org.mockito.junit.MockitoJUnitRunner", (Object)"org.junit.runners.BlockJUnit4ClassRunner");
    public static final MultiMatcher<ClassTree, AnnotationTree> hasJUnit4TestRunner = Matchers.annotations(ChildMultiMatcher.MatchType.AT_LEAST_ONE, Matchers.hasArgumentWithValue("value", JUnitMatchers.isJUnit4TestRunnerOfType(TEST_RUNNERS)));
    public static final Matcher<ClassTree> isJUnit4TestClass = Matchers.allOf(Matchers.not(isTestCaseDescendant), Matchers.not(Matchers.enclosingClass(Matchers.hasModifier(Modifier.ABSTRACT))), Matchers.anyOf(hasJUnit4TestRunner, hasJUnit4TestCases));
    public static final Matcher<ClassTree> isAmbiguousJUnitVersion = Matchers.allOf(isTestCaseDescendant, Matchers.anyOf(hasJUnit4TestRunner, hasJUnit4TestCases));

    public static boolean hasJUnitAnnotation(MethodTree tree, VisitorState state) {
        Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol(tree);
        if (methodSym == null) {
            return false;
        }
        if (JUnitMatchers.hasJUnitAttr(methodSym)) {
            return true;
        }
        return ASTHelpers.streamSuperMethods(methodSym, state.getTypes()).anyMatch(JUnitMatchers::hasJUnitAttr);
    }

    private static boolean hasJUnitAttr(Symbol.MethodSymbol methodSym) {
        return methodSym.getRawAttributes().stream().anyMatch(attr -> attr.type.tsym.getQualifiedName().toString().startsWith("org.junit."));
    }

    public static Matcher<ExpressionTree> isJUnit4TestRunnerOfType(final Iterable<String> runnerTypes) {
        return new Matcher<ExpressionTree>(){

            @Override
            public boolean matches(ExpressionTree t, VisitorState state) {
                Type type = ASTHelpers.getType(t);
                if (!(type instanceof Type.ClassType)) {
                    return false;
                }
                List<Type> typeArgs = type.getTypeArguments();
                if (typeArgs.size() != 1) {
                    return false;
                }
                Type runnerType = (Type)Iterables.getOnlyElement(typeArgs);
                for (String testRunner : runnerTypes) {
                    Symbol parent = state.getSymbolFromString(testRunner);
                    if (parent == null || !runnerType.tsym.isSubClass(parent, state.getTypes())) continue;
                    return true;
                }
                return false;
            }
        };
    }

    private JUnitMatchers() {
    }
}

