/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.MoreCollectors;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Streams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.InlineMe;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.matchers.JUnitMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.TestNgMatchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ErrorProneLog;
import com.google.errorprone.util.MoreAnnotations;
import com.google.errorprone.util.TargetType;
import com.sun.source.tree.AnnotatedTypeTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.CaseLabelTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.LiteralTree;
import com.sun.source.tree.MemberReferenceTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.ModuleTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.PackageTree;
import com.sun.source.tree.ParameterizedTypeTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.tree.TypeParameterTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotations;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.parser.JavaTokenizer;
import com.sun.tools.javac.parser.ScannerFactory;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.runtime.SwitchBootstraps;
import java.net.JarURLConnection;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.TypeKind;
import org.jspecify.annotations.Nullable;

public class ASTHelpers {
    private static final long RECORD_FLAG = 0x2000000000000000L;
    private static final Supplier<Cache<Name, Boolean>> inheritedAnnotationCache = VisitorState.memoize(unusedState -> Caffeine.newBuilder().maximumSize(1000L).build());
    private static final ImmutableSet<String> ANNOTATIONS_CONSIDERED_KEEP = ImmutableSet.of((Object)"org.apache.beam.sdk.transforms.DoFn.ProcessElement", (Object)"org.junit.jupiter.api.Nested");
    private static final String USED_REFLECTIVELY = "UsedReflectively";
    private static final String KEEP = "Keep";
    private static final ImmutableSet<TypeTag> SUBTYPE_UNDEFINED = Sets.immutableEnumSet((Enum)TypeTag.METHOD, (Enum[])new TypeTag[]{TypeTag.PACKAGE, TypeTag.ERROR, TypeTag.FORALL});
    private static final CharMatcher BACKSLASH_MATCHER = CharMatcher.is((char)'\\');
    private static final Matcher<Tree> IS_BUGCHECKER = Matchers.isSubtypeOf("com.google.errorprone.bugpatterns.BugChecker");
    public static final long POTENTIALLY_AMBIGUOUS = 0x1000000000000L;
    private static final Supplier<Name> NULL_MARKED_NAME = VisitorState.memoize(state -> state.getName("org.jspecify.annotations.NullMarked"));

    public static boolean sameVariable(ExpressionTree expr1, ExpressionTree expr2) {
        Objects.requireNonNull(expr1);
        Objects.requireNonNull(expr2);
        if (!(expr1 instanceof IdentifierTree) && !(expr1 instanceof MemberSelectTree) || !(expr2 instanceof IdentifierTree) && !(expr2 instanceof MemberSelectTree)) {
            return false;
        }
        Symbol sym1 = ASTHelpers.getSymbol(expr1);
        Symbol sym2 = ASTHelpers.getSymbol(expr2);
        if (sym1 == null) {
            throw new IllegalStateException("Couldn't get symbol for " + String.valueOf(expr1));
        }
        if (sym2 == null) {
            throw new IllegalStateException("Couldn't get symbol for " + String.valueOf(expr2));
        }
        if (expr1 instanceof IdentifierTree && expr2 instanceof IdentifierTree) {
            return sym1.equals(sym2);
        }
        if (expr1 instanceof MemberSelectTree && expr2 instanceof MemberSelectTree) {
            return sym1.equals(sym2) && ASTHelpers.sameVariable(((JCTree.JCFieldAccess)expr1).selected, ((JCTree.JCFieldAccess)expr2).selected);
        }
        JCTree.JCExpression selected = expr1 instanceof IdentifierTree ? ((JCTree.JCFieldAccess)expr2).selected : ((JCTree.JCFieldAccess)expr1).selected;
        return ((Object)selected).toString().equals("this") && sym1.equals(sym2);
    }

    public static @Nullable Symbol getDeclaredSymbol(Tree tree) {
        if (tree instanceof PackageTree) {
            PackageTree packageTree = (PackageTree)tree;
            return ASTHelpers.getSymbol(packageTree);
        }
        if (tree instanceof TypeParameterTree) {
            Type type = ((JCTree.JCTypeParameter)tree).type;
            return type == null ? null : type.tsym;
        }
        if (tree instanceof ClassTree) {
            ClassTree classTree = (ClassTree)tree;
            return ASTHelpers.getSymbol(classTree);
        }
        if (tree instanceof MethodTree) {
            MethodTree methodTree = (MethodTree)tree;
            return ASTHelpers.getSymbol(methodTree);
        }
        if (tree instanceof VariableTree) {
            VariableTree variableTree = (VariableTree)tree;
            return ASTHelpers.getSymbol(variableTree);
        }
        return null;
    }

    public static @Nullable Symbol getSymbol(Tree tree) {
        if (tree instanceof AnnotationTree) {
            AnnotationTree annotationTree = (AnnotationTree)tree;
            return ASTHelpers.getSymbol(annotationTree.getAnnotationType());
        }
        if (tree instanceof JCTree.JCFieldAccess) {
            JCTree.JCFieldAccess jcFieldAccess = (JCTree.JCFieldAccess)tree;
            return jcFieldAccess.sym;
        }
        if (tree instanceof JCTree.JCIdent) {
            JCTree.JCIdent jcIdent = (JCTree.JCIdent)tree;
            return jcIdent.sym;
        }
        if (tree instanceof JCTree.JCMethodInvocation) {
            JCTree.JCMethodInvocation jcMethodInvocation = (JCTree.JCMethodInvocation)tree;
            return ASTHelpers.getSymbol(jcMethodInvocation);
        }
        if (tree instanceof JCTree.JCNewClass) {
            JCTree.JCNewClass jcNewClass = (JCTree.JCNewClass)tree;
            return ASTHelpers.getSymbol(jcNewClass);
        }
        if (tree instanceof MemberReferenceTree) {
            MemberReferenceTree memberReferenceTree = (MemberReferenceTree)tree;
            return ASTHelpers.getSymbol(memberReferenceTree);
        }
        if (tree instanceof JCTree.JCAnnotatedType) {
            JCTree.JCAnnotatedType jcAnnotatedType = (JCTree.JCAnnotatedType)tree;
            return ASTHelpers.getSymbol(jcAnnotatedType.underlyingType);
        }
        if (tree instanceof ParameterizedTypeTree) {
            ParameterizedTypeTree parameterizedTypeTree = (ParameterizedTypeTree)tree;
            return ASTHelpers.getSymbol(parameterizedTypeTree.getType());
        }
        if (tree instanceof ClassTree) {
            ClassTree classTree = (ClassTree)tree;
            return ASTHelpers.getSymbol(classTree);
        }
        return ASTHelpers.getDeclaredSymbol(tree);
    }

    public static Symbol.ClassSymbol getSymbol(ClassTree tree) {
        return (Symbol.ClassSymbol)Preconditions.checkNotNull((Object)((JCTree.JCClassDecl)tree).sym, (String)"%s had a null ClassSymbol", (Object)tree);
    }

    public static Symbol.PackageSymbol getSymbol(PackageTree tree) {
        return (Symbol.PackageSymbol)Preconditions.checkNotNull((Object)((JCTree.JCPackageDecl)tree).packge, (String)"%s had a null PackageSymbol", (Object)tree);
    }

    public static Symbol.MethodSymbol getSymbol(MethodTree tree) {
        return (Symbol.MethodSymbol)Preconditions.checkNotNull((Object)((JCTree.JCMethodDecl)tree).sym, (String)"%s had a null MethodSymbol", (Object)tree);
    }

    public static Symbol.MethodSymbol getSymbol(NewClassTree tree) {
        Symbol sym = ((JCTree.JCNewClass)tree).constructor;
        if (!(sym instanceof Symbol.MethodSymbol)) {
            throw new IllegalArgumentException(tree.toString());
        }
        Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)sym;
        return methodSymbol;
    }

    public static Symbol.VarSymbol getSymbol(VariableTree tree) {
        return (Symbol.VarSymbol)Preconditions.checkNotNull((Object)((JCTree.JCVariableDecl)tree).sym, (String)"%s had a null VariableTree", (Object)tree);
    }

    public static Symbol.MethodSymbol getSymbol(MethodInvocationTree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree.getMethodSelect());
        if (!(sym instanceof Symbol.MethodSymbol)) {
            throw new IllegalArgumentException(tree.toString());
        }
        return (Symbol.MethodSymbol)sym.baseSymbol();
    }

    public static Symbol.MethodSymbol getSymbol(MemberReferenceTree tree) {
        Symbol sym = ((JCTree.JCMemberReference)tree).sym;
        if (!(sym instanceof Symbol.MethodSymbol)) {
            throw new IllegalArgumentException(tree.toString());
        }
        return (Symbol.MethodSymbol)sym.baseSymbol();
    }

    public static boolean canBeRemoved(Symbol symbol, VisitorState state) {
        Symbol.MethodSymbol methodSymbol;
        if (symbol instanceof Symbol.MethodSymbol && !ASTHelpers.findSuperMethods(methodSymbol = (Symbol.MethodSymbol)symbol, state.getTypes()).isEmpty()) {
            return false;
        }
        return ASTHelpers.isEffectivelyPrivate(symbol);
    }

    public static boolean canBeRemoved(Symbol.VarSymbol symbol) {
        return ASTHelpers.isEffectivelyPrivate(symbol);
    }

    public static boolean canBeRemoved(Symbol.ClassSymbol symbol) {
        return ASTHelpers.isEffectivelyPrivate(symbol);
    }

    public static boolean isEffectivelyPrivate(Symbol symbol) {
        return ASTHelpers.enclosingElements(symbol).anyMatch(s -> {
            if (s.isPrivate()) {
                return true;
            }
            if (s instanceof Symbol.ClassSymbol) {
                if (s.isAnonymous()) {
                    return true;
                }
                if (s.owner instanceof Symbol.MethodSymbol) {
                    return true;
                }
            }
            return false;
        });
    }

    public static boolean requiresParentheses(ExpressionTree expression, VisitorState state) {
        switch (expression.getKind()) {
            case IDENTIFIER: 
            case MEMBER_SELECT: 
            case METHOD_INVOCATION: 
            case ARRAY_ACCESS: 
            case PARENTHESIZED: 
            case NEW_CLASS: 
            case MEMBER_REFERENCE: {
                return false;
            }
            case LAMBDA_EXPRESSION: {
                LambdaExpressionTree lambdaExpressionTree;
                Tree parent = state.getPath().getParentPath().getLeaf();
                return parent instanceof LambdaExpressionTree && ASTHelpers.stripParentheses((lambdaExpressionTree = (LambdaExpressionTree)parent).getBody()).equals(expression);
            }
        }
        if (expression instanceof LiteralTree) {
            if (!ASTHelpers.isSameType(ASTHelpers.getType(expression), state.getSymtab().stringType, state)) {
                return false;
            }
            return state.getOffsetTokensForNode(expression).stream().anyMatch(t -> t.kind() == Tokens.TokenKind.PLUS);
        }
        if (expression instanceof UnaryTree) {
            TypeCastTree castTree;
            UnaryTree unaryTree = (UnaryTree)expression;
            Tree parent = state.getPath().getParentPath().getLeaf();
            if (parent instanceof TypeCastTree && !(castTree = (TypeCastTree)parent).getType().getKind().equals((Object)Tree.Kind.PRIMITIVE_TYPE)) {
                switch (unaryTree.getKind()) {
                    case UNARY_PLUS: 
                    case UNARY_MINUS: {
                        return true;
                    }
                }
            }
            if (!(parent instanceof MemberSelectTree)) {
                return false;
            }
            MemberSelectTree memberSelectTree = (MemberSelectTree)parent;
            return ASTHelpers.stripParentheses(memberSelectTree.getExpression()).equals(expression);
        }
        return true;
    }

    public static Tree stripParentheses(Tree tree) {
        Tree tree2;
        if (tree instanceof ExpressionTree) {
            ExpressionTree expressionTree = (ExpressionTree)tree;
            tree2 = ASTHelpers.stripParentheses(expressionTree);
        } else {
            tree2 = tree;
        }
        return tree2;
    }

    public static ExpressionTree stripParentheses(ExpressionTree tree) {
        while (tree instanceof ParenthesizedTree) {
            ParenthesizedTree pt = (ParenthesizedTree)tree;
            tree = pt.getExpression();
        }
        return tree;
    }

    public static <T> @Nullable TreePath findPathFromEnclosingNodeToTopLevel(TreePath path, Class<T> klass) {
        if (path != null) {
            while ((path = path.getParentPath()) != null && !klass.isInstance(path.getLeaf())) {
            }
        }
        return path;
    }

    public static Stream<Symbol> enclosingElements(Symbol sym) {
        return Stream.iterate(sym, Symbol::getEnclosingElement).takeWhile(s -> s != null);
    }

    public static <T> @Nullable T findEnclosingNode(TreePath path, Class<T> klass) {
        return (path = ASTHelpers.findPathFromEnclosingNodeToTopLevel(path, klass)) == null ? null : (T)klass.cast(path.getLeaf());
    }

    public static @Nullable MethodTree findEnclosingMethod(VisitorState state) {
        for (Tree parent : state.getPath()) {
            switch (parent.getKind()) {
                case METHOD: {
                    return (MethodTree)parent;
                }
                case LAMBDA_EXPRESSION: 
                case CLASS: {
                    return null;
                }
            }
        }
        return null;
    }

    public static @Nullable ExpressionTree getRootAssignable(MethodInvocationTree methodInvocationTree) {
        if (!(methodInvocationTree instanceof JCTree.JCMethodInvocation)) {
            throw new IllegalArgumentException("Expected type to be JCMethodInvocation, but was " + String.valueOf(methodInvocationTree.getClass()));
        }
        JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)methodInvocationTree;
        if (jCMethodInvocation.getMethodSelect() instanceof JCTree.JCIdent) {
            return null;
        }
        ExpressionTree expr = methodInvocationTree;
        while (expr instanceof JCTree.JCMethodInvocation) {
            if (!((expr = ((JCTree.JCMethodInvocation)expr).getMethodSelect()) instanceof JCTree.JCFieldAccess)) continue;
            JCTree.JCFieldAccess jCFieldAccess = (JCTree.JCFieldAccess)expr;
            expr = jCFieldAccess.getExpression();
        }
        Symbol sym = ASTHelpers.getSymbol(expr);
        if (sym instanceof Symbol.VarSymbol) {
            return expr;
        }
        return null;
    }

    public static Type getReturnType(ExpressionTree expressionTree) {
        ExpressionTree expressionTree2 = expressionTree;
        Objects.requireNonNull(expressionTree2);
        ExpressionTree expressionTree3 = expressionTree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JCTree.JCFieldAccess.class, JCTree.JCIdent.class, JCTree.JCMethodInvocation.class, JCTree.JCMemberReference.class}, (Object)expressionTree3, n)) {
            case 0 -> {
                JCTree.JCFieldAccess methodCall = (JCTree.JCFieldAccess)expressionTree3;
                yield methodCall.type.getReturnType();
            }
            case 1 -> {
                JCTree.JCIdent methodCall = (JCTree.JCIdent)expressionTree3;
                yield methodCall.type.getReturnType();
            }
            case 2 -> {
                JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)expressionTree3;
                yield ASTHelpers.getReturnType(jCMethodInvocation.getMethodSelect());
            }
            case 3 -> {
                JCTree.JCMemberReference jCMemberReference = (JCTree.JCMemberReference)expressionTree3;
                yield jCMemberReference.sym.type.getReturnType();
            }
            default -> throw new IllegalArgumentException("Expected a JCFieldAccess or JCIdent");
        };
    }

    public static @Nullable Type getResultType(ExpressionTree expressionTree) {
        Type type = ASTHelpers.getType(expressionTree);
        return type == null ? null : (type.getReturnType() == null ? type : type.getReturnType());
    }

    public static Type getReceiverType(ExpressionTree expressionTree) {
        ExpressionTree expressionTree2 = expressionTree;
        Objects.requireNonNull(expressionTree2);
        ExpressionTree expressionTree3 = expressionTree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JCTree.JCFieldAccess.class, JCTree.JCIdent.class, JCTree.JCMethodInvocation.class, JCTree.JCMemberReference.class}, (Object)expressionTree3, n)) {
            case 0 -> {
                JCTree.JCFieldAccess methodSelectFieldAccess = (JCTree.JCFieldAccess)expressionTree3;
                yield methodSelectFieldAccess.selected.type;
            }
            case 1 -> {
                JCTree.JCIdent methodCall = (JCTree.JCIdent)expressionTree3;
                yield methodCall.sym.owner.type;
            }
            case 2 -> {
                JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)expressionTree3;
                yield ASTHelpers.getReceiverType(jCMethodInvocation.getMethodSelect());
            }
            case 3 -> {
                JCTree.JCMemberReference jCMemberReference = (JCTree.JCMemberReference)expressionTree3;
                yield jCMemberReference.getQualifierExpression().type;
            }
            default -> throw new IllegalArgumentException("Expected a JCFieldAccess or JCIdent from expression " + String.valueOf(expressionTree));
        };
    }

    public static @Nullable ExpressionTree getReceiver(ExpressionTree expressionTree) {
        ExpressionTree expressionTree2 = expressionTree;
        Objects.requireNonNull(expressionTree2);
        ExpressionTree expressionTree3 = expressionTree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodInvocationTree.class, MemberSelectTree.class, MemberReferenceTree.class}, (Object)expressionTree3, n)) {
            case 0 -> {
                MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expressionTree3;
                if (methodInvocationTree.getMethodSelect() instanceof IdentifierTree) {
                    yield null;
                }
                yield ASTHelpers.getReceiver(methodInvocationTree.getMethodSelect());
            }
            case 1 -> {
                MemberSelectTree memberSelectTree = (MemberSelectTree)expressionTree3;
                yield memberSelectTree.getExpression();
            }
            case 2 -> {
                MemberReferenceTree memberReferenceTree = (MemberReferenceTree)expressionTree3;
                yield memberReferenceTree.getQualifierExpression();
            }
            default -> throw new IllegalStateException(String.format("Expected expression '%s' to be a method invocation or field access, but was %s", new Object[]{expressionTree, expressionTree.getKind()}));
        };
    }

    public static Stream<ExpressionTree> streamReceivers(final ExpressionTree tree) {
        return Streams.stream((Iterator)new AbstractIterator<ExpressionTree>(){
            private ExpressionTree current;
            {
                this.current = tree;
            }

            protected ExpressionTree computeNext() {
                if (this.current instanceof MethodInvocationTree || this.current instanceof MemberSelectTree || this.current instanceof MemberReferenceTree) {
                    this.current = ASTHelpers.getReceiver(this.current);
                    return this.current == null ? (ExpressionTree)this.endOfData() : this.current;
                }
                return (ExpressionTree)this.endOfData();
            }
        });
    }

    public static @Nullable java.util.List<ExpressionTree> matchBinaryTree(BinaryTree tree, java.util.List<Matcher<ExpressionTree>> matchers, VisitorState state) {
        ExpressionTree leftOperand = tree.getLeftOperand();
        ExpressionTree rightOperand = tree.getRightOperand();
        if (matchers.get(0).matches(leftOperand, state) && matchers.get(1).matches(rightOperand, state)) {
            return Arrays.asList(leftOperand, rightOperand);
        }
        if (matchers.get(0).matches(rightOperand, state) && matchers.get(1).matches(leftOperand, state)) {
            return Arrays.asList(rightOperand, leftOperand);
        }
        return null;
    }

    public static @Nullable MethodTree findMethod(Symbol.MethodSymbol symbol, VisitorState state) {
        return JavacTrees.instance(state.context).getTree(symbol);
    }

    public static @Nullable ClassTree findClass(Symbol.ClassSymbol symbol, VisitorState state) {
        return JavacTrees.instance(state.context).getTree(symbol);
    }

    public static @Nullable Symbol.MethodSymbol findSuperMethodInType(Symbol.MethodSymbol methodSymbol, Type superType, Types types) {
        if (methodSymbol.isStatic() || superType.equals(methodSymbol.owner.type)) {
            return null;
        }
        Scope.WriteableScope scope = superType.tsym.members();
        for (Symbol sym : scope.getSymbolsByName(methodSymbol.name)) {
            if (sym == null || ASTHelpers.isStatic(sym) || (sym.flags() & 0x1000L) != 0L || !methodSymbol.overrides(sym, (Symbol.TypeSymbol)methodSymbol.owner, types, true)) continue;
            return (Symbol.MethodSymbol)sym;
        }
        return null;
    }

    public static Set<Symbol.MethodSymbol> findSuperMethods(Symbol.MethodSymbol methodSymbol, Types types) {
        return ASTHelpers.streamSuperMethods(methodSymbol, types).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    public static Stream<Symbol.MethodSymbol> streamSuperMethods(Symbol.MethodSymbol methodSymbol, Types types) {
        Symbol.TypeSymbol owner = (Symbol.TypeSymbol)methodSymbol.owner;
        return types.closure(owner.type).stream().map(type -> ASTHelpers.findSuperMethodInType(methodSymbol, type, types)).filter(Objects::nonNull);
    }

    public static Stream<Symbol.MethodSymbol> matchingMethods(Name name, Predicate<Symbol.MethodSymbol> predicate, Type startClass, Types types) {
        Predicate<Symbol> matchesMethodPredicate = sym -> {
            Symbol.MethodSymbol methodSymbol;
            return sym instanceof Symbol.MethodSymbol && predicate.test(methodSymbol = (Symbol.MethodSymbol)sym);
        };
        return types.closure(startClass).stream().flatMap(superClass -> {
            Symbol.TypeSymbol superClassSymbol = superClass.tsym;
            Scope.WriteableScope superClassSymbols = superClassSymbol.members();
            if (superClassSymbols == null) {
                return Stream.empty();
            }
            return Streams.stream(superClassSymbols.getSymbolsByName(name, matchesMethodPredicate, Scope.LookupKind.NON_RECURSIVE)).map(symbol -> (Symbol.MethodSymbol)symbol);
        });
    }

    public static ImmutableSet<Symbol.MethodSymbol> findMatchingMethods(Name name, Predicate<Symbol.MethodSymbol> predicate, Type startClass, Types types) {
        return (ImmutableSet)ASTHelpers.matchingMethods(name, predicate, startClass, types).collect(ImmutableSet.toImmutableSet());
    }

    public static boolean methodCanBeOverridden(Symbol.MethodSymbol methodSymbol) {
        if (methodSymbol.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            return true;
        }
        if (methodSymbol.isStatic() || methodSymbol.isPrivate() || ASTHelpers.isFinal(methodSymbol) || methodSymbol.isConstructor()) {
            return false;
        }
        Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)methodSymbol.owner;
        return !ASTHelpers.isFinal(classSymbol) && !classSymbol.isAnonymous();
    }

    private static boolean isFinal(Symbol symbol) {
        return (symbol.flags() & 0x10L) == 16L;
    }

    public static boolean isRecord(Symbol symbol) {
        return (symbol.flags() & 0x2000000000000000L) == 0x2000000000000000L;
    }

    public static Symbol.MethodSymbol canonicalConstructor(Symbol.ClassSymbol record, VisitorState state) {
        ImmutableList fieldTypes = (ImmutableList)record.getRecordComponents().stream().map(rc -> rc.type).collect(ImmutableList.toImmutableList());
        return (Symbol.MethodSymbol)Streams.stream(record.members().getSymbols(s -> s.getKind() == ElementKind.CONSTRUCTOR)).map(c -> (Symbol.MethodSymbol)c).filter(c -> ((List)c.getParameters()).size() == fieldTypes.size() && Streams.zip(c.getParameters().stream(), (Stream)fieldTypes.stream(), (a, b) -> ASTHelpers.isSameType(a.type, b, state)).allMatch(x -> x)).collect(MoreCollectors.onlyElement());
    }

    public static boolean hasAnnotation(Symbol sym, String annotationClass, VisitorState state) {
        if (sym == null) {
            return false;
        }
        Name annotationName = state.getName(annotationClass = annotationClass.replace('$', '.'));
        if (ASTHelpers.hasAttribute(sym, annotationName)) {
            return true;
        }
        if (sym instanceof Symbol.ClassSymbol) {
            Symbol.ClassSymbol cs = (Symbol.ClassSymbol)sym;
            if (ASTHelpers.isInherited(state, annotationClass)) {
                sym = cs.getSuperclass().tsym;
                while (sym instanceof Symbol.ClassSymbol) {
                    Symbol.ClassSymbol cs2 = (Symbol.ClassSymbol)sym;
                    if (ASTHelpers.hasAttribute(sym, annotationName)) {
                        return true;
                    }
                    sym = cs2.getSuperclass().tsym;
                }
            }
        }
        return false;
    }

    @Deprecated
    @InlineMe(replacement="ASTHelpers.hasAnnotation(sym, annotationClass.getName(), state)", imports={"com.google.errorprone.util.ASTHelpers"})
    public static boolean hasAnnotation(Symbol sym, Class<? extends Annotation> annotationClass, VisitorState state) {
        return ASTHelpers.hasAnnotation(sym, annotationClass.getName(), state);
    }

    public static boolean hasAnnotation(Tree tree, String annotationClass, VisitorState state) {
        Symbol sym = ASTHelpers.getDeclaredSymbol(tree);
        return ASTHelpers.hasAnnotation(sym, annotationClass, state);
    }

    @Deprecated
    @InlineMe(replacement="ASTHelpers.hasAnnotation(tree, annotationClass.getName(), state)", imports={"com.google.errorprone.util.ASTHelpers"})
    public static boolean hasAnnotation(Tree tree, Class<? extends Annotation> annotationClass, VisitorState state) {
        return ASTHelpers.hasAnnotation(tree, annotationClass.getName(), state);
    }

    private static boolean isInherited(VisitorState state, Name annotationName) {
        return (Boolean)inheritedAnnotationCache.get(state).get((Object)annotationName, name -> {
            if (name.equals(NULL_MARKED_NAME.get(state))) {
                return false;
            }
            Symbol.ClassSymbol annotationSym = state.getSymbolFromName(annotationName);
            if (annotationSym == null) {
                return false;
            }
            Symbol.TypeSymbol inheritedSym = state.getSymtab().inheritedType.tsym;
            return annotationSym.attribute(inheritedSym) != null;
        });
    }

    private static boolean isInherited(VisitorState state, String annotationName) {
        return ASTHelpers.isInherited(state, state.binaryNameFromClassname(annotationName));
    }

    private static boolean hasAttribute(Symbol sym, Name annotationName) {
        for (Attribute.Compound a : sym.getRawAttributes()) {
            if (!a.type.tsym.getQualifiedName().equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    public static Set<Name> annotationsAmong(Symbol sym, Set<? extends Name> annotationClasses, VisitorState state) {
        if (sym == null) {
            return ImmutableSet.of();
        }
        Set<Name> result = ASTHelpers.directAnnotationsAmong(sym, annotationClasses);
        if (!(sym instanceof Symbol.ClassSymbol)) {
            return result;
        }
        HashSet<Name> possibleInherited = new HashSet<Name>();
        for (Name name : annotationClasses) {
            if (result.contains(name) || !ASTHelpers.isInherited(state, name)) continue;
            possibleInherited.add(name);
        }
        sym = ((Symbol.ClassSymbol)sym).getSuperclass().tsym;
        while (sym instanceof Symbol.ClassSymbol && !possibleInherited.isEmpty()) {
            for (Name name : ASTHelpers.directAnnotationsAmong(sym, possibleInherited)) {
                result.add(name);
                possibleInherited.remove(name);
            }
            sym = ((Symbol.ClassSymbol)sym).getSuperclass().tsym;
        }
        return result;
    }

    private static Set<Name> directAnnotationsAmong(Symbol sym, Set<? extends Name> binaryAnnotationNames) {
        HashSet<Name> result = new HashSet<Name>();
        for (Attribute.Compound a : sym.getRawAttributes()) {
            Name annoName = a.type.tsym.flatName();
            if (!binaryAnnotationNames.contains(annoName)) continue;
            result.add(annoName);
        }
        return result;
    }

    public static boolean hasDirectAnnotationWithSimpleName(Symbol sym, String simpleName) {
        if (sym instanceof Symbol.MethodSymbol) {
            Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)sym;
            return ASTHelpers.hasDirectAnnotationWithSimpleName(methodSymbol, simpleName);
        }
        if (sym instanceof Symbol.VarSymbol) {
            Symbol.VarSymbol varSymbol = (Symbol.VarSymbol)sym;
            return ASTHelpers.hasDirectAnnotationWithSimpleName(varSymbol, simpleName);
        }
        return ASTHelpers.hasDirectAnnotation(sym.getAnnotationMirrors().stream(), (Element element) -> element.getSimpleName().contentEquals(simpleName));
    }

    public static boolean hasDirectAnnotationWithSimpleName(Symbol.MethodSymbol sym, String simpleName) {
        return ASTHelpers.hasDirectAnnotation(Streams.concat((Stream[])new Stream[]{sym.getAnnotationMirrors().stream(), sym.getReturnType().getAnnotationMirrors().stream()}), (Element element) -> element.getSimpleName().contentEquals(simpleName));
    }

    public static boolean hasDirectAnnotationWithSimpleName(Symbol.VarSymbol sym, String simpleName) {
        return ASTHelpers.hasDirectAnnotation(Streams.concat((Stream[])new Stream[]{sym.getAnnotationMirrors().stream(), ((Type)sym.asType()).getAnnotationMirrors().stream()}), (Element element) -> element.getSimpleName().contentEquals(simpleName));
    }

    public static boolean hasDirectAnnotation(Symbol.MethodSymbol sym, String qualifiedName) {
        return ASTHelpers.hasDirectAnnotation(Streams.concat((Stream[])new Stream[]{sym.getAnnotationMirrors().stream(), sym.getReturnType().getAnnotationMirrors().stream()}), (Element element) -> ((Symbol)element).getQualifiedName().contentEquals(qualifiedName));
    }

    private static boolean hasDirectAnnotation(Stream<? extends AnnotationMirror> annotations, Predicate<Element> matcher) {
        return annotations.anyMatch(annotation -> matcher.test(annotation.getAnnotationType().asElement()));
    }

    public static boolean hasDirectAnnotationWithSimpleName(Tree tree, String simpleName) {
        return ASTHelpers.hasDirectAnnotationWithSimpleName(ASTHelpers.getDeclaredSymbol(tree), simpleName);
    }

    @Deprecated
    public static boolean shouldKeep(Tree tree) {
        ModifiersTree modifiers = ASTHelpers.getModifiers(tree);
        if (modifiers == null) {
            return false;
        }
        for (AnnotationTree annotationTree : modifiers.getAnnotations()) {
            Type annotationType = ASTHelpers.getType(annotationTree);
            if (annotationType == null) continue;
            Symbol.TypeSymbol tsym = annotationType.tsym;
            if (((Name)tsym.getSimpleName()).contentEquals(USED_REFLECTIVELY) || ((Name)tsym.getSimpleName()).contentEquals(KEEP)) {
                return true;
            }
            if (ANNOTATIONS_CONSIDERED_KEEP.contains((Object)tsym.getQualifiedName().toString())) {
                return true;
            }
            if (!ASTHelpers.hasDirectAnnotationWithSimpleName(tsym, USED_REFLECTIVELY) && !ASTHelpers.hasDirectAnnotationWithSimpleName(tsym, KEEP)) continue;
            return true;
        }
        return false;
    }

    @Deprecated
    public static <T extends Annotation> @Nullable T getAnnotation(Tree tree, Class<T> annotationClass) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym == null ? null : (T)ASTHelpers.getAnnotation(sym, annotationClass);
    }

    @Deprecated
    public static <T extends Annotation> @Nullable T getAnnotation(Symbol sym, Class<T> annotationClass) {
        return sym == null ? null : (T)sym.getAnnotation(annotationClass);
    }

    public static LinkedHashSet<String> enumValues(Symbol.TypeSymbol enumType) {
        if (enumType.getKind() != ElementKind.ENUM) {
            throw new IllegalStateException();
        }
        Scope.WriteableScope scope = enumType.members();
        ArrayDeque<String> values = new ArrayDeque<String>();
        for (Symbol sym : scope.getSymbols()) {
            Symbol.VarSymbol var;
            if (!(sym instanceof Symbol.VarSymbol) || ((var = (Symbol.VarSymbol)sym).flags() & 0x4000L) == 0L) continue;
            values.push(sym.name.toString());
        }
        return new LinkedHashSet<String>(values);
    }

    public static boolean isEnumConstant(Tree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym != null && sym.getKind() == ElementKind.ENUM_CONSTANT;
    }

    public static boolean isGeneratedConstructor(MethodTree tree) {
        if (!(tree instanceof JCTree.JCMethodDecl)) {
            return false;
        }
        JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)tree;
        return (jCMethodDecl.mods.flags & 0x1000000000L) == 0x1000000000L;
    }

    public static java.util.List<MethodTree> getConstructors(ClassTree classTree) {
        ArrayList<MethodTree> constructors = new ArrayList<MethodTree>();
        for (Tree tree : classTree.getMembers()) {
            MethodTree methodTree;
            if (!(tree instanceof MethodTree) || !ASTHelpers.getSymbol(methodTree = (MethodTree)tree).isConstructor()) continue;
            constructors.add(methodTree);
        }
        return constructors;
    }

    public static java.util.List<Symbol> getEnclosedElements(Symbol symbol) {
        return symbol.getEnclosedElements();
    }

    public static ImmutableList<Symbol.MethodSymbol> getConstructors(Symbol.ClassSymbol classSymbol) {
        return (ImmutableList)ASTHelpers.getEnclosedElements(classSymbol).stream().filter(Symbol::isConstructor).map(e -> (Symbol.MethodSymbol)e).collect(ImmutableList.toImmutableList());
    }

    public static @Nullable Type getType(@Nullable Tree tree) {
        Type type;
        if (tree instanceof JCTree) {
            JCTree jCTree = (JCTree)tree;
            type = jCTree.type;
        } else {
            type = null;
        }
        return type;
    }

    public static @Nullable Type.ClassType getType(@Nullable ClassTree tree) {
        Type.ClassType classType;
        Type type = ASTHelpers.getType((Tree)tree);
        return type instanceof Type.ClassType ? (classType = (Type.ClassType)type) : null;
    }

    public static @Nullable String getAnnotationName(AnnotationTree tree) {
        Symbol sym = ASTHelpers.getSymbol(tree);
        return sym == null ? null : sym.name.toString();
    }

    public static Tree getErasedTypeTree(Tree tree) {
        return tree.accept(new SimpleTreeVisitor<Tree, Void>(){

            @Override
            public Tree visitIdentifier(IdentifierTree tree, Void unused) {
                return tree;
            }

            @Override
            public Tree visitParameterizedType(ParameterizedTypeTree tree, Void unused) {
                return tree.getType();
            }
        }, null);
    }

    public static @Nullable Symbol.ClassSymbol enclosingClass(Symbol sym) {
        return sym.owner == null ? null : sym.owner.enclClass();
    }

    public static @Nullable Symbol.PackageSymbol enclosingPackage(Symbol sym) {
        Symbol curr = sym;
        while (curr != null) {
            if (curr.getKind().equals((Object)ElementKind.PACKAGE)) {
                return (Symbol.PackageSymbol)curr;
            }
            curr = curr.owner;
        }
        return null;
    }

    public static boolean inSamePackage(Symbol targetSymbol, VisitorState state) {
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
        Symbol.PackageSymbol usePackage = compilationUnit.packge;
        Symbol.PackageSymbol targetPackage = ASTHelpers.enclosingPackage(targetSymbol);
        return targetPackage != null && usePackage != null && targetPackage.getQualifiedName().equals(usePackage.getQualifiedName());
    }

    public static Nullness getNullnessValue(ExpressionTree expr, VisitorState state, NullnessAnalysis nullnessAnalysis) {
        TreePath pathToExpr = new TreePath(state.getPath(), expr);
        return nullnessAnalysis.getNullness(pathToExpr, state.context);
    }

    public static @Nullable Object constValue(Tree tree) {
        Object value;
        if (tree == null) {
            return null;
        }
        tree = ASTHelpers.stripParentheses(tree);
        Type type = ASTHelpers.getType(tree);
        if (tree instanceof JCTree.JCLiteral) {
            JCTree.JCLiteral jCLiteral = (JCTree.JCLiteral)tree;
            value = jCLiteral.value;
        } else if (type != null) {
            value = type.constValue();
        } else {
            return null;
        }
        if (type.hasTag(TypeTag.BOOLEAN) && value instanceof Integer) {
            Integer integer = (Integer)value;
            return integer == 1;
        }
        if (type.hasTag(TypeTag.CHAR) && value instanceof Integer) {
            return Character.valueOf((char)((Integer)value).intValue());
        }
        return value;
    }

    public static <T> @Nullable T constValue(Tree tree, Class<? extends T> clazz) {
        Object value = ASTHelpers.constValue(tree);
        return clazz.isInstance(value) ? (T)clazz.cast(value) : null;
    }

    public static boolean isVoidType(Type type, VisitorState state) {
        if (type == null) {
            return false;
        }
        return type.getKind() == TypeKind.VOID || state.getTypes().isSameType(Suppliers.JAVA_LANG_VOID_TYPE.get(state), type);
    }

    public static boolean isSubtype(Type s, Type t, VisitorState state) {
        if (s == null || t == null) {
            return false;
        }
        if (SUBTYPE_UNDEFINED.contains((Object)s.getTag())) {
            return false;
        }
        if (t == state.getSymtab().unknownType) {
            return false;
        }
        Types types = state.getTypes();
        return types.isSubtype(types.erasure(s), types.erasure(t));
    }

    public static boolean isCheckedExceptionType(Type t, VisitorState state) {
        Symtab symtab = state.getSymtab();
        return ASTHelpers.isSubtype(t, symtab.throwableType, state) && !ASTHelpers.isSubtype(t, symtab.runtimeExceptionType, state) && !ASTHelpers.isSubtype(t, symtab.errorType, state);
    }

    public static boolean isCastable(Type s, Type t, VisitorState state) {
        if (s == null || t == null) {
            return false;
        }
        Types types = state.getTypes();
        return types.isCastable(types.erasure(s), types.erasure(t));
    }

    public static boolean isSameType(Type s, Type t, VisitorState state) {
        if (s == null || t == null) {
            return false;
        }
        Types types = state.getTypes();
        return types.isSameType(types.erasure(s), types.erasure(t));
    }

    public static @Nullable ModifiersTree getModifiers(Tree tree) {
        if (tree instanceof ClassTree) {
            ClassTree classTree = (ClassTree)tree;
            return classTree.getModifiers();
        }
        if (tree instanceof MethodTree) {
            MethodTree methodTree = (MethodTree)tree;
            return methodTree.getModifiers();
        }
        if (tree instanceof VariableTree) {
            VariableTree variableTree = (VariableTree)tree;
            return variableTree.getModifiers();
        }
        if (tree instanceof ModifiersTree) {
            ModifiersTree modifiersTree = (ModifiersTree)tree;
            return modifiersTree;
        }
        return null;
    }

    public static java.util.List<? extends AnnotationTree> getAnnotations(Tree tree) {
        if (tree instanceof TypeParameterTree) {
            TypeParameterTree typeParameterTree = (TypeParameterTree)tree;
            return typeParameterTree.getAnnotations();
        }
        if (tree instanceof ModuleTree) {
            ModuleTree moduleTree = (ModuleTree)tree;
            return moduleTree.getAnnotations();
        }
        if (tree instanceof PackageTree) {
            PackageTree packageTree = (PackageTree)tree;
            return packageTree.getAnnotations();
        }
        if (tree instanceof NewArrayTree) {
            NewArrayTree newArrayTree = (NewArrayTree)tree;
            return newArrayTree.getAnnotations();
        }
        if (tree instanceof AnnotatedTypeTree) {
            AnnotatedTypeTree annotatedTypeTree = (AnnotatedTypeTree)tree;
            return annotatedTypeTree.getAnnotations();
        }
        if (tree instanceof ModifiersTree) {
            ModifiersTree modifiersTree = (ModifiersTree)tree;
            return modifiersTree.getAnnotations();
        }
        ModifiersTree modifiersTree = ASTHelpers.getModifiers(tree);
        return modifiersTree == null ? ImmutableList.of() : modifiersTree.getAnnotations();
    }

    public static Type getUpperBound(Type type, Types types) {
        if (type.hasTag(TypeTag.WILDCARD)) {
            return types.wildUpperBound(type);
        }
        if (type.hasTag(TypeTag.TYPEVAR) && ((Type.TypeVar)type).isCaptured()) {
            return types.cvarUpperBound(type);
        }
        if (type.getUpperBound() != null) {
            return type.getUpperBound();
        }
        return type;
    }

    public static boolean isJUnitTestCode(VisitorState state) {
        for (Tree ancestor : state.getPath()) {
            ClassTree classTree;
            MethodTree methodTree;
            if (ancestor instanceof MethodTree && JUnitMatchers.hasJUnitAnnotation(methodTree = (MethodTree)ancestor, state)) {
                return true;
            }
            if (!(ancestor instanceof ClassTree) || !JUnitMatchers.isTestCaseDescendant.matches(classTree = (ClassTree)ancestor, state) && !ASTHelpers.hasAnnotation(ASTHelpers.getSymbol(ancestor), "org.junit.runner.RunWith", state)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTestNgTestCode(VisitorState state) {
        for (Tree ancestor : state.getPath()) {
            ClassTree classTree;
            MethodTree methodTree;
            if (ancestor instanceof MethodTree && TestNgMatchers.hasTestNgAnnotation(methodTree = (MethodTree)ancestor, state)) {
                return true;
            }
            if (!(ancestor instanceof ClassTree) || !TestNgMatchers.hasTestNgAnnotation(classTree = (ClassTree)ancestor)) continue;
            return true;
        }
        return false;
    }

    public static @Nullable AnnotationTree getAnnotationWithSimpleName(java.util.List<? extends AnnotationTree> annotations, String name) {
        for (AnnotationTree annotationTree : annotations) {
            if (!ASTHelpers.hasSimpleName(annotationTree, name)) continue;
            return annotationTree;
        }
        return null;
    }

    public static java.util.List<AnnotationTree> getAnnotationsWithSimpleName(java.util.List<? extends AnnotationTree> annotations, String name) {
        ArrayList<AnnotationTree> matches = new ArrayList<AnnotationTree>();
        for (AnnotationTree annotationTree : annotations) {
            if (!ASTHelpers.hasSimpleName(annotationTree, name)) continue;
            matches.add(annotationTree);
        }
        return matches;
    }

    private static boolean hasSimpleName(AnnotationTree annotation, String name) {
        javax.lang.model.element.Name simpleName;
        Tree annotationType = annotation.getAnnotationType();
        if (annotationType instanceof IdentifierTree) {
            IdentifierTree identifierTree = (IdentifierTree)annotationType;
            simpleName = identifierTree.getName();
        } else if (annotationType instanceof MemberSelectTree) {
            MemberSelectTree memberSelectTree = (MemberSelectTree)annotationType;
            simpleName = memberSelectTree.getIdentifier();
        } else {
            return false;
        }
        return simpleName.contentEquals(name);
    }

    public static @Nullable TypeAnnotations.AnnotationType getAnnotationType(AnnotationTree anno, @Nullable Symbol target, VisitorState state) {
        if (target == null) {
            return null;
        }
        Symbol annoSymbol = ASTHelpers.getSymbol(anno);
        if (annoSymbol == null) {
            return null;
        }
        Attribute.Compound compound = target.attribute(annoSymbol);
        if (compound == null) {
            for (Attribute.TypeCompound typeCompound : target.getRawTypeAttributes()) {
                if (!typeCompound.type.tsym.equals(annoSymbol)) continue;
                compound = typeCompound;
                break;
            }
        }
        if (compound == null) {
            return null;
        }
        return TypeAnnotations.instance(state.context).annotationTargetType((JCTree)((Object)anno), compound, target);
    }

    public static @Nullable String getFileName(CompilationUnitTree tree) {
        return ASTHelpers.getFileNameFromUri(tree.getSourceFile().toUri());
    }

    public static @Nullable String getFileNameFromUri(URI uri) {
        if (!uri.getScheme().equals("jar")) {
            return uri.getPath();
        }
        try {
            Object jarEntryFileName = ((JarURLConnection)uri.toURL().openConnection()).getEntryName();
            jarEntryFileName = BACKSLASH_MATCHER.replaceFrom((CharSequence)jarEntryFileName, '/');
            if (!((String)jarEntryFileName).startsWith("/")) {
                jarEntryFileName = "/" + (String)jarEntryFileName;
            }
            return jarEntryFileName;
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static @Nullable Symbol.MethodSymbol resolveExistingMethod(VisitorState state, Symbol.TypeSymbol base, Name name, Iterable<Type> argTypes, Iterable<Type> tyargTypes) {
        Resolve resolve = Resolve.instance(state.context);
        Enter enter = Enter.instance(state.context);
        Log log = Log.instance(state.context);
        Log.DeferredDiagnosticHandler handler = ErrorProneLog.deferredDiagnosticHandler(log);
        try {
            Symbol.MethodSymbol methodSymbol = resolve.resolveInternalMethod(null, enter.getEnv(base), base.type, name, List.from(argTypes), List.from(tyargTypes));
            return methodSymbol;
        }
        catch (FatalError e) {
            Symbol.MethodSymbol methodSymbol = null;
            return methodSymbol;
        }
        finally {
            log.popDiagnosticHandler(handler);
        }
    }

    public static ImmutableSet<String> getGeneratedBy(VisitorState state) {
        return (ImmutableSet)Streams.stream((Iterable)state.getPath()).filter(ClassTree.class::isInstance).flatMap(enclosing -> ASTHelpers.getGeneratedBy(ASTHelpers.getSymbol(enclosing)).stream()).collect(ImmutableSet.toImmutableSet());
    }

    public static ImmutableSet<String> getGeneratedBy(Symbol symbol) {
        Preconditions.checkNotNull((Object)symbol);
        return (ImmutableSet)symbol.getRawAttributes().stream().filter(attribute -> ((Name)attribute.type.tsym.getSimpleName()).contentEquals("Generated")).flatMap(ASTHelpers::generatedValues).collect(ImmutableSet.toImmutableSet());
    }

    @Deprecated
    public static ImmutableSet<String> getGeneratedBy(Symbol symbol, VisitorState state) {
        return ASTHelpers.getGeneratedBy(symbol);
    }

    private static Stream<String> generatedValues(Attribute.Compound attribute) {
        return attribute.getElementValues().entrySet().stream().filter(e -> ((Name)((Symbol.MethodSymbol)e.getKey()).getSimpleName()).contentEquals("value")).findFirst().map(e -> MoreAnnotations.asStrings((AnnotationValue)e.getValue())).orElseGet(() -> Stream.of(attribute.type.tsym.getQualifiedName().toString()));
    }

    public static boolean isSuper(Tree tree) {
        Tree tree2 = tree;
        Objects.requireNonNull(tree2);
        Tree tree3 = tree2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IdentifierTree.class, MemberSelectTree.class}, (Object)tree3, n)) {
            case 0 -> {
                IdentifierTree identifierTree = (IdentifierTree)tree3;
                yield identifierTree.getName().contentEquals("super");
            }
            case 1 -> {
                MemberSelectTree memberSelectTree = (MemberSelectTree)tree3;
                yield memberSelectTree.getIdentifier().contentEquals("super");
            }
            default -> false;
        };
    }

    public static boolean isInStaticInitializer(VisitorState state) {
        return Streams.stream((Iterable)state.getPath()).anyMatch(tree -> {
            Symbol.VarSymbol varSymbol;
            AssignmentTree assignmentTree;
            Symbol patt0$temp;
            return tree instanceof VariableTree && ASTHelpers.variableIsStaticFinal((Symbol.VarSymbol)ASTHelpers.getSymbol(tree)) || tree instanceof AssignmentTree && (patt0$temp = ASTHelpers.getSymbol((assignmentTree = (AssignmentTree)tree).getVariable())) instanceof Symbol.VarSymbol && ASTHelpers.variableIsStaticFinal(varSymbol = (Symbol.VarSymbol)patt0$temp);
        });
    }

    @Deprecated
    public static @Nullable TargetType targetType(VisitorState state) {
        return TargetType.targetType(state);
    }

    public static boolean variableIsStaticFinal(Symbol.VarSymbol var) {
        return (var.isStatic() || var.owner.isEnum()) && var.getModifiers().contains((Object)Modifier.FINAL);
    }

    public static AnnotationMirror getAnnotationMirror(AnnotationTree annotationTree) {
        return ((JCTree.JCAnnotation)annotationTree).attribute;
    }

    public static boolean containsComments(Tree tree, VisitorState state) {
        return state.getOffsetTokensForNode(tree).stream().anyMatch(t -> !t.comments().isEmpty());
    }

    public static @Nullable Symbol.ClassSymbol outermostClass(Symbol symbol) {
        Symbol.ClassSymbol encl;
        Symbol.ClassSymbol curr = symbol.enclClass();
        while (curr != null && curr.owner != null && (encl = curr.owner.enclClass()) != null) {
            curr = encl;
        }
        return curr;
    }

    public static boolean isConsideredFinal(Symbol symbol) {
        return (symbol.flags() & 0x20000000010L) != 0L;
    }

    public static ImmutableSet<Type> getThrownExceptions(Tree tree, VisitorState state) {
        ScanThrownTypes scanner = new ScanThrownTypes(state);
        scanner.scan(tree, null);
        return ImmutableSet.copyOf(scanner.getThrownTypes());
    }

    public static int getStartPosition(Tree tree) {
        return ((JCTree)tree).getStartPosition();
    }

    public static String createPrivateConstructor(ClassTree classTree) {
        return "private " + String.valueOf(classTree.getSimpleName()) + "() {}";
    }

    public static boolean isBugCheckerCode(VisitorState state) {
        for (Tree ancestor : state.getPath()) {
            if (!IS_BUGCHECKER.matches(ancestor, state)) continue;
            return true;
        }
        return false;
    }

    public static boolean isStatic(Symbol symbol) {
        return switch (symbol.getKind()) {
            case ElementKind.MODULE -> false;
            default -> symbol.isStatic();
        };
    }

    public static boolean methodIsPublicAndNotAnOverride(Symbol.MethodSymbol method, VisitorState state) {
        Symbol symbol = method;
        while (symbol != null && !(symbol instanceof Symbol.PackageSymbol)) {
            if (!((Symbol)symbol).getModifiers().contains((Object)Modifier.PUBLIC)) {
                return false;
            }
            symbol = symbol.owner;
        }
        return ASTHelpers.findSuperMethods(method, state.getTypes()).isEmpty();
    }

    public static boolean isAbstract(Symbol.MethodSymbol method) {
        return method.getModifiers().contains((Object)Modifier.ABSTRACT);
    }

    public static ImmutableSet<String> asFlagSet(long flags) {
        return (ImmutableSet)Flags.asFlagSet(flags &= 0xFDFEFFFFFFFFFFFFL).stream().map(Object::toString).collect(ImmutableSet.toImmutableSet());
    }

    public static boolean stringContainsComments(CharSequence source, Context context) {
        JavaTokenizer tokenizer = new JavaTokenizer(ScannerFactory.instance(context), CharBuffer.wrap(source)){};
        Tokens.Token token = tokenizer.readToken();
        while (token.kind != Tokens.TokenKind.EOF) {
            if (token.comments != null && !token.comments.isEmpty()) {
                return true;
            }
            token = tokenizer.readToken();
        }
        return false;
    }

    public static ImmutableListMultimap<Symbol.TypeVariableSymbol, Type> getTypeSubstitution(Type type, Symbol sym) {
        ImmutableListMultimap.Builder result = ImmutableListMultimap.builder();
        class Visitor
        extends Types.DefaultTypeVisitor<Void, Type> {
            final /* synthetic */ ImmutableListMultimap.Builder val$result;

            Visitor(ImmutableListMultimap.Builder builder) {
                this.val$result = builder;
            }

            @Override
            public Void visitMethodType(Type.MethodType t, Type other) {
                this.scan(t.getParameterTypes(), other.getParameterTypes());
                this.scan(t.getThrownTypes(), other.getThrownTypes());
                this.scan(t.getReturnType(), other.getReturnType());
                return null;
            }

            @Override
            public Void visitClassType(Type.ClassType t, Type other) {
                this.scan(t.getTypeArguments(), other.getTypeArguments());
                return null;
            }

            @Override
            public Void visitTypeVar(Type.TypeVar t, Type other) {
                this.val$result.put((Object)((Symbol.TypeVariableSymbol)t.asElement()), (Object)other);
                return null;
            }

            @Override
            public Void visitForAll(Type.ForAll t, Type other) {
                this.scan(t.getParameterTypes(), other.getParameterTypes());
                this.scan(t.getThrownTypes(), other.getThrownTypes());
                this.scan((Type)t.getReturnType(), other.getReturnType());
                return null;
            }

            @Override
            public Void visitWildcardType(Type.WildcardType t, Type type) {
                if (type instanceof Type.WildcardType) {
                    Type.WildcardType other = (Type.WildcardType)type;
                    this.scan(t.getExtendsBound(), other.getExtendsBound());
                    this.scan(t.getSuperBound(), other.getSuperBound());
                }
                return null;
            }

            @Override
            public Void visitArrayType(Type.ArrayType t, Type type) {
                if (type instanceof Type.ArrayType) {
                    Type.ArrayType other = (Type.ArrayType)type;
                    this.scan(t.getComponentType(), other.getComponentType());
                }
                return null;
            }

            @Override
            public Void visitType(Type t, Type other) {
                return null;
            }

            private void scan(Collection<Type> from, Collection<Type> to) {
                Streams.forEachPair(from.stream(), to.stream(), this::scan);
            }

            private void scan(Type from, Type to) {
                if (from != null) {
                    from.accept(this, to);
                }
            }
        }
        sym.asType().accept(new Visitor(result), type);
        return result.build();
    }

    public static boolean hasImplicitType(VariableTree tree, VisitorState state) {
        JCTree.JCVariableDecl varDecl = (JCTree.JCVariableDecl)tree;
        if (varDecl.declaredUsingVar()) {
            return true;
        }
        return !ASTHelpers.hasExplicitSource(tree.getType(), state);
    }

    public static boolean hasExplicitSource(Tree tree, VisitorState state) {
        int pos = ASTHelpers.getStartPosition(tree);
        int endPos = state.getEndPosition(tree);
        return pos != -1 && endPos != -1 && pos != endPos;
    }

    public static boolean isKotlin(Symbol symbol, VisitorState state) {
        return ASTHelpers.hasAnnotation((Symbol)symbol.enclClass(), "kotlin.Metadata", state);
    }

    public static boolean hasOverloadWithOnlyOneParameter(Symbol.MethodSymbol existingMethod, Name targetMethodName, Type onlyParameterType, VisitorState state) {
        @Nullable MethodTree t = (MethodTree)state.findEnclosing(MethodTree.class);
        @Nullable Symbol.MethodSymbol enclosingMethod = t == null ? null : ASTHelpers.getSymbol(t);
        return ASTHelpers.hasMatchingMethods(targetMethodName, input -> !input.equals(existingMethod) && !input.equals(enclosingMethod) && (enclosingMethod == null || !enclosingMethod.overrides((Symbol)input, (Symbol.TypeSymbol)input.owner, state.getTypes(), true)) && input.isStatic() == existingMethod.isStatic() && ((List)input.getParameters()).size() == 1 && ASTHelpers.isSameType((Type)((Symbol.VarSymbol)((List)input.getParameters()).get(0)).asType(), onlyParameterType, state) && ASTHelpers.isSameType(input.getReturnType(), existingMethod.getReturnType(), state), (Type)ASTHelpers.enclosingClass(existingMethod).asType(), state.getTypes());
    }

    private static boolean hasMatchingMethods(Name name, Predicate<Symbol.MethodSymbol> predicate, Type startClass, Types types) {
        Predicate<Symbol> matchesMethodPredicate = sym -> {
            Symbol.MethodSymbol methodSymbol;
            return sym instanceof Symbol.MethodSymbol && predicate.test(methodSymbol = (Symbol.MethodSymbol)sym);
        };
        for (Type superClass : types.closure(startClass)) {
            Symbol.TypeSymbol superClassSymbol = superClass.tsym;
            Scope.WriteableScope superClassSymbols = superClassSymbol.members();
            if (superClassSymbols == null || Iterables.isEmpty(superClassSymbols.getSymbolsByName(name, matchesMethodPredicate, Scope.LookupKind.NON_RECURSIVE))) continue;
            return true;
        }
        return false;
    }

    public static Optional<? extends CaseTree> getSwitchDefault(SwitchTree switchTree) {
        return switchTree.getCases().stream().filter(c -> ASTHelpers.isSwitchDefault(c)).findFirst();
    }

    public static boolean isSwitchDefault(CaseTree caseTree) {
        java.util.List<? extends CaseLabelTree> labels = caseTree.getLabels();
        if (!caseTree.getExpressions().isEmpty() && labels.isEmpty()) {
            return false;
        }
        return labels.isEmpty() || labels.stream().anyMatch(label -> label.getKind().name().equals("DEFAULT_CASE_LABEL"));
    }

    private ASTHelpers() {
    }

    public static final class ScanThrownTypes
    extends TreeScanner<Void, Void> {
        ArrayDeque<Set<Type>> thrownTypes = new ArrayDeque();
        SetMultimap<Symbol.VarSymbol, Type> thrownTypesByVariable = HashMultimap.create();
        private final VisitorState state;
        private final Types types;
        private static final Supplier<Type> AUTOCLOSEABLE = Suppliers.typeFromString("java.lang.AutoCloseable");
        private static final Supplier<Name> CLOSE = VisitorState.memoize(state -> state.getName("close"));

        public ScanThrownTypes(VisitorState state) {
            this.state = state;
            this.types = state.getTypes();
            this.thrownTypes.push(new HashSet());
        }

        public Set<Type> getThrownTypes() {
            return this.thrownTypes.peek();
        }

        @Override
        public Void visitMethodInvocation(MethodInvocationTree invocation, Void unused) {
            Type type = ASTHelpers.getType(invocation.getMethodSelect());
            if (type != null) {
                this.getThrownTypes().addAll(type.getThrownTypes());
            }
            return (Void)super.visitMethodInvocation(invocation, null);
        }

        @Override
        public Void visitTry(TryTree tree, Void unused) {
            this.thrownTypes.push(new HashSet());
            this.scanResources(tree);
            this.scan(tree.getBlock(), null);
            for (CatchTree catchTree : tree.getCatches()) {
                Type type = ASTHelpers.getType(catchTree.getParameter());
                HashSet<Type> caughtTypes = new HashSet<Type>();
                HashSet<Type> capturedTypes = new HashSet<Type>();
                for (Type unionMember : ScanThrownTypes.extractTypes(type)) {
                    for (Type thrownType : this.getThrownTypes()) {
                        if (this.types.isSubtype(thrownType, unionMember)) {
                            caughtTypes.add(thrownType);
                            capturedTypes.add(thrownType);
                        }
                        if (!this.types.isSubtype(unionMember, thrownType)) continue;
                        capturedTypes.add(unionMember);
                    }
                }
                this.getThrownTypes().removeAll(caughtTypes);
                this.thrownTypesByVariable.putAll((Object)ASTHelpers.getSymbol(catchTree.getParameter()), capturedTypes);
            }
            for (CatchTree catchTree : tree.getCatches()) {
                this.scan(catchTree.getBlock(), null);
            }
            this.scan(tree.getFinallyBlock(), null);
            Set<Type> fromBlock = this.thrownTypes.pop();
            this.getThrownTypes().addAll(fromBlock);
            return null;
        }

        public void scanResources(TryTree tree) {
            for (Tree tree2 : tree.getResources()) {
                Symbol.TypeSymbol symbol = ASTHelpers.getType((Tree)tree2).tsym;
                if (!(symbol instanceof Symbol.ClassSymbol)) continue;
                Symbol.ClassSymbol classSymbol = (Symbol.ClassSymbol)symbol;
                ScanThrownTypes.getCloseMethod(classSymbol, this.state).ifPresent(methodSymbol -> this.getThrownTypes().addAll(methodSymbol.getThrownTypes()));
            }
            this.scan(tree.getResources(), null);
        }

        @Override
        public Void visitThrow(ThrowTree tree, Void unused) {
            Symbol symbol;
            if (tree.getExpression() instanceof IdentifierTree && this.thrownTypesByVariable.containsKey((Object)(symbol = ASTHelpers.getSymbol(tree.getExpression())))) {
                this.getThrownTypes().addAll(this.thrownTypesByVariable.get((Object)((Symbol.VarSymbol)symbol)));
                return (Void)super.visitThrow(tree, null);
            }
            this.getThrownTypes().addAll((Collection<Type>)ScanThrownTypes.extractTypes(ASTHelpers.getType(tree.getExpression())));
            return (Void)super.visitThrow(tree, null);
        }

        @Override
        public Void visitNewClass(NewClassTree tree, Void unused) {
            this.getThrownTypes().addAll(ASTHelpers.getSymbol(tree).getThrownTypes());
            return (Void)super.visitNewClass(tree, null);
        }

        @Override
        public Void visitVariable(VariableTree tree, Void unused) {
            return (Void)super.visitVariable(tree, null);
        }

        @Override
        public Void visitLambdaExpression(LambdaExpressionTree tree, Void unused) {
            return null;
        }

        @Override
        public Void visitClass(ClassTree tree, Void unused) {
            return null;
        }

        @Override
        public Void visitMethod(MethodTree tree, Void unused) {
            return null;
        }

        private static Optional<Symbol.MethodSymbol> getCloseMethod(Symbol.ClassSymbol symbol, VisitorState state) {
            Types types = state.getTypes();
            if (!types.isAssignable(symbol.type, AUTOCLOSEABLE.get(state))) {
                return Optional.empty();
            }
            Type.JCVoidType voidType = state.getSymtab().voidType;
            Optional<Symbol.MethodSymbol> declaredCloseMethod = ASTHelpers.matchingMethods(CLOSE.get(state), s -> !s.isConstructor() && s.params.isEmpty() && types.isSameType(s.getReturnType(), voidType), symbol.type, types).findFirst();
            Verify.verify((boolean)declaredCloseMethod.isPresent(), (String)"%s implements AutoCloseable but no method named close() exists, even inherited", (Object)symbol);
            return declaredCloseMethod;
        }

        private static ImmutableList<Type> extractTypes(@Nullable Type type) {
            if (type == null) {
                return ImmutableList.of();
            }
            if (type.isUnion()) {
                Type.UnionClassType unionType = (Type.UnionClassType)type;
                return ImmutableList.copyOf(unionType.getAlternativeTypes());
            }
            return ImmutableList.of((Object)type);
        }
    }
}

