/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.errorprone.VisitorState;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Reachability;
import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.ImportTree;
import com.sun.source.tree.InstanceOfTree;
import com.sun.source.tree.LambdaExpressionTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.ParenthesizedTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.UnaryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreeScanner;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Enter;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.MemberEnter;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.StreamSupport;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import org.jspecify.annotations.Nullable;

public final class FindIdentifiers {
    public static Symbol findIdent(String name, VisitorState state) {
        return FindIdentifiers.findIdent(name, state, Kinds.KindSelector.VAR);
    }

    public static @Nullable Symbol findIdent(String name, VisitorState state, Kinds.KindSelector kind) {
        Env<AttrContext> env;
        Type.ClassType enclosingClass = ASTHelpers.getType(FindIdentifiers.getEnclosingClass(state.getPath()));
        if (enclosingClass == null || enclosingClass.tsym == null) {
            env = Enter.instance(state.context).getTopLevelEnv((JCTree.JCCompilationUnit)state.getPath().getCompilationUnit());
        } else {
            env = Enter.instance(state.context).getClassEnv(enclosingClass.tsym);
            MethodTree enclosingMethod = (MethodTree)state.findEnclosing(MethodTree.class);
            if (enclosingMethod != null) {
                env = MemberEnter.instance(state.context).getMethodEnv((JCTree.JCMethodDecl)enclosingMethod, env);
            }
        }
        try {
            Symbol result = FindIdentifiers.findIdent(name, state, kind, env);
            return result.exists() ? result : null;
        }
        catch (ReflectiveOperationException e) {
            throw new LinkageError(e.getMessage(), e);
        }
    }

    private static Symbol findIdent(String name, VisitorState state, Kinds.KindSelector kind, Env<AttrContext> env) throws NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Method method = Resolve.class.getDeclaredMethod("findIdent", JCDiagnostic.DiagnosticPosition.class, Env.class, Name.class, Kinds.KindSelector.class);
        method.setAccessible(true);
        return (Symbol)method.invoke((Object)Resolve.instance(state.context), null, env, state.getName(name), kind);
    }

    private static @Nullable ClassTree getEnclosingClass(TreePath treePath) {
        if (treePath.getLeaf() instanceof ClassTree) {
            return (ClassTree)treePath.getLeaf();
        }
        TreePath parent;
        while ((parent = treePath.getParentPath()) != null) {
            ClassTree classTree;
            Tree leaf = parent.getLeaf();
            if (leaf instanceof ClassTree && (classTree = (ClassTree)leaf).getMembers().contains(treePath.getLeaf())) {
                return classTree;
            }
            treePath = parent;
        }
        return null;
    }

    public static ImmutableSet<Symbol.VarSymbol> findAllIdents(VisitorState state) {
        ImmutableSet.Builder result = new ImmutableSet.Builder();
        Tree prev = state.getPath().getLeaf();
        block17: for (Tree curr : state.getPath().getParentPath()) {
            switch (curr.getKind()) {
                case CONDITIONAL_AND: {
                    BinaryTree binaryTree = (BinaryTree)curr;
                    if (prev != binaryTree.getRightOperand()) break;
                    FindIdentifiers.findBindingVariables(binaryTree.getLeftOperand(), (ImmutableSet.Builder<Symbol.VarSymbol>)result, false);
                    break;
                }
                case CONDITIONAL_OR: {
                    BinaryTree binaryTree = (BinaryTree)curr;
                    if (prev != binaryTree.getRightOperand()) break;
                    FindIdentifiers.findBindingVariables(binaryTree.getLeftOperand(), (ImmutableSet.Builder<Symbol.VarSymbol>)result, true);
                    break;
                }
                default: {
                    if (!(curr instanceof ExpressionTree)) break block17;
                }
            }
            prev = curr;
        }
        prev = state.getPath().getLeaf();
        for (Tree curr : state.getPath().getParentPath()) {
            Tree tree;
            Objects.requireNonNull(curr);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockTree.class, LambdaExpressionTree.class, MethodTree.class, CatchTree.class, ClassTree.class, ForLoopTree.class, EnhancedForLoopTree.class, TryTree.class, IfTree.class, ConditionalExpressionTree.class, CompilationUnitTree.class}, (Object)tree, n)) {
                case 0: {
                    BlockTree blockTree = (BlockTree)tree;
                    for (StatementTree statementTree : blockTree.getStatements()) {
                        IfTree ifTree;
                        if (statementTree.equals(prev)) break;
                        FindIdentifiers.addIfVariable(statementTree, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                        if (!(statementTree instanceof IfTree) || Reachability.canCompleteNormally((ifTree = (IfTree)statementTree).getThenStatement())) continue;
                        FindIdentifiers.findBindingVariables(ifTree.getCondition(), (ImmutableSet.Builder<Symbol.VarSymbol>)result, true);
                    }
                    break;
                }
                case 1: {
                    LambdaExpressionTree lambdaExpressionTree = (LambdaExpressionTree)tree;
                    for (Object param : lambdaExpressionTree.getParameters()) {
                        result.add((Object)ASTHelpers.getSymbol((VariableTree)param));
                    }
                    break;
                }
                case 2: {
                    Object param;
                    MethodTree methodTree = (MethodTree)tree;
                    param = methodTree.getParameters().iterator();
                    while (param.hasNext()) {
                        VariableTree variableTree = param.next();
                        result.add((Object)ASTHelpers.getSymbol(variableTree));
                    }
                    break;
                }
                case 3: {
                    CatchTree catchTree = (CatchTree)tree;
                    result.add((Object)ASTHelpers.getSymbol(catchTree.getParameter()));
                    break;
                }
                case 4: {
                    ClassTree classTree = (ClassTree)tree;
                    for (Tree tree2 : classTree.getMembers()) {
                        if (tree2.equals(prev)) break;
                        FindIdentifiers.addIfVariable(tree2, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    }
                    Type classType = ASTHelpers.getType(curr);
                    List<Type> list = state.getTypes().closure(classType);
                    java.util.List<Object> superTypes = list.size() <= 1 ? Collections.emptyList() : list.subList(1, list.size());
                    for (Object type : superTypes) {
                        Scope.WriteableScope writeableScope = ((Type)type).tsym.members();
                        ImmutableList.Builder varsList = ImmutableList.builder();
                        for (Symbol var : writeableScope.getSymbols(Symbol.VarSymbol.class::isInstance)) {
                            varsList.add((Object)((Symbol.VarSymbol)var));
                        }
                        result.addAll((Iterable)varsList.build().reverse());
                    }
                    break;
                }
                case 5: {
                    ForLoopTree forLoopTree = (ForLoopTree)tree;
                    FindIdentifiers.addAllIfVariable(forLoopTree.getInitializer(), (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    break;
                }
                case 6: {
                    EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)tree;
                    result.add((Object)ASTHelpers.getSymbol(enhancedForLoopTree.getVariable()));
                    break;
                }
                case 7: {
                    TryTree tryTree = (TryTree)tree;
                    boolean inResources = false;
                    for (Tree tree3 : tryTree.getResources()) {
                        if (!tree3.equals(prev)) continue;
                        inResources = true;
                        break;
                    }
                    if (inResources) {
                        for (Tree tree4 : tryTree.getResources()) {
                            if (tree4.equals(prev)) break;
                            FindIdentifiers.addIfVariable(tree4, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                        }
                        break;
                    }
                    if (!tryTree.getBlock().equals(prev)) break;
                    FindIdentifiers.addAllIfVariable(tryTree.getResources(), (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                    break;
                }
                case 8: {
                    IfTree ifTree = (IfTree)tree;
                    if (prev == ifTree.getThenStatement()) {
                        FindIdentifiers.findBindingVariables(ifTree.getCondition(), (ImmutableSet.Builder<Symbol.VarSymbol>)result, false);
                    }
                    if (prev != ifTree.getElseStatement()) break;
                    FindIdentifiers.findBindingVariables(ifTree.getCondition(), (ImmutableSet.Builder<Symbol.VarSymbol>)result, true);
                    break;
                }
                case 9: {
                    ConditionalExpressionTree conditionalExpressionTree = (ConditionalExpressionTree)tree;
                    if (prev == conditionalExpressionTree.getTrueExpression()) {
                        FindIdentifiers.findBindingVariables(conditionalExpressionTree.getCondition(), (ImmutableSet.Builder<Symbol.VarSymbol>)result, false);
                    }
                    if (prev != conditionalExpressionTree.getFalseExpression()) break;
                    FindIdentifiers.findBindingVariables(conditionalExpressionTree.getCondition(), (ImmutableSet.Builder<Symbol.VarSymbol>)result, true);
                    break;
                }
                case 10: {
                    CompilationUnitTree compilationUnitTree = (CompilationUnitTree)tree;
                    for (ImportTree importTree : compilationUnitTree.getImports()) {
                        Tree tree5;
                        if (!importTree.isStatic() || !((tree5 = importTree.getQualifiedIdentifier()) instanceof MemberSelectTree)) continue;
                        MemberSelectTree memberSelectTree = (MemberSelectTree)tree5;
                        Scope.CompoundScope scope = state.getTypes().membersClosure(ASTHelpers.getType(memberSelectTree.getExpression()), false);
                        for (Symbol var : scope.getSymbols(sym -> sym instanceof Symbol.VarSymbol && sym.getSimpleName().equals(memberSelectTree.getIdentifier()))) {
                            result.add((Object)((Symbol.VarSymbol)var));
                        }
                    }
                    break;
                }
            }
            prev = curr;
        }
        return (ImmutableSet)result.build().stream().filter(variable -> FindIdentifiers.isVisible(variable, state.getPath())).collect(ImmutableSet.toImmutableSet());
    }

    private static void findBindingVariables(Tree tree, final ImmutableSet.Builder<Symbol.VarSymbol> result, final boolean startNegated) {
        new SimpleTreeVisitor<Void, Void>(){
            boolean negated;
            {
                this.negated = startNegated;
            }

            @Override
            public Void visitInstanceOf(InstanceOfTree node, Void unused) {
                if (!this.negated) {
                    new TreeScanner<Void, Void>(){

                        @Override
                        public Void visitVariable(VariableTree node, Void unused) {
                            FindIdentifiers.addIfVariable(node, (ImmutableSet.Builder<Symbol.VarSymbol>)result);
                            return (Void)super.visitVariable(node, null);
                        }
                    }.scan(node.getPattern(), null);
                }
                return null;
            }

            @Override
            public Void visitParenthesized(ParenthesizedTree node, Void unused) {
                return (Void)this.visit(node.getExpression(), null);
            }

            @Override
            public Void visitUnary(UnaryTree node, Void unused) {
                if (node.getKind().equals((Object)Tree.Kind.LOGICAL_COMPLEMENT)) {
                    this.negated = !this.negated;
                    return (Void)this.visit(node.getExpression(), null);
                }
                return null;
            }

            @Override
            public Void visitBinary(BinaryTree node, Void unused) {
                if (node.getKind().equals((Object)Tree.Kind.CONDITIONAL_AND) && !this.negated) {
                    this.visit(node.getLeftOperand(), null);
                    this.visit(node.getRightOperand(), null);
                }
                if (node.getKind().equals((Object)Tree.Kind.CONDITIONAL_OR) && this.negated) {
                    this.visit(node.getLeftOperand(), null);
                    this.visit(node.getRightOperand(), null);
                }
                return null;
            }
        }.visit(tree, null);
    }

    public static ImmutableSet<Symbol.VarSymbol> findUnusedIdentifiers(VisitorState state) {
        ImmutableSet.Builder definedVariables = ImmutableSet.builder();
        ImmutableSet.Builder usedSymbols = ImmutableSet.builder();
        Tree prev = state.getPath().getLeaf();
        for (Tree curr : state.getPath().getParentPath()) {
            Tree tree;
            FindIdentifiers.createFindIdentifiersScanner((ImmutableSet.Builder<Symbol>)usedSymbols, prev).scan(curr, null);
            Objects.requireNonNull(curr);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockTree.class, ForLoopTree.class, EnhancedForLoopTree.class}, (Object)tree, n)) {
                case 0: {
                    BlockTree blockTree = (BlockTree)tree;
                    for (StatementTree statementTree : blockTree.getStatements()) {
                        if (statementTree.equals(prev)) break;
                        FindIdentifiers.addIfVariable(statementTree, (ImmutableSet.Builder<Symbol.VarSymbol>)definedVariables);
                    }
                    break;
                }
                case 1: {
                    ForLoopTree forLoop = (ForLoopTree)tree;
                    forLoop.getInitializer().stream().forEach(t -> FindIdentifiers.addIfVariable(t, (ImmutableSet.Builder<Symbol.VarSymbol>)definedVariables));
                    break;
                }
                case 2: {
                    EnhancedForLoopTree enhancedForLoopTree = (EnhancedForLoopTree)tree;
                    FindIdentifiers.addIfVariable(enhancedForLoopTree.getVariable(), (ImmutableSet.Builder<Symbol.VarSymbol>)definedVariables);
                    break;
                }
            }
            prev = curr;
        }
        return ImmutableSet.copyOf((Collection)Sets.difference((Set)definedVariables.build(), (Set)usedSymbols.build()));
    }

    public static ImmutableSet<Symbol> findReferencedIdentifiers(Tree tree) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        FindIdentifiers.createFindIdentifiersScanner((ImmutableSet.Builder<Symbol>)builder, null).scan(tree, null);
        return builder.build();
    }

    public static ImmutableList<Symbol.VarSymbol> findAllFields(Type classType, VisitorState state) {
        return (ImmutableList)state.getTypes().closure(classType).stream().flatMap(type -> {
            Symbol.TypeSymbol tsym = type.tsym;
            if (tsym == null) {
                return ImmutableList.of().stream();
            }
            Scope.WriteableScope scope = tsym.members();
            if (scope == null) {
                return ImmutableList.of().stream();
            }
            return ImmutableList.copyOf(scope.getSymbols(Symbol.VarSymbol.class::isInstance)).reverse().stream().map(v -> (Symbol.VarSymbol)v).filter(v -> FindIdentifiers.isVisible(v, state.getPath()));
        }).collect(ImmutableList.toImmutableList());
    }

    private static TreeScanner<Void, Void> createFindIdentifiersScanner(final ImmutableSet.Builder<Symbol> builder, final @Nullable Tree stoppingPoint) {
        return new TreeScanner<Void, Void>(){

            @Override
            public Void scan(Tree tree, Void unused) {
                return Objects.equals(stoppingPoint, tree) ? null : (Void)super.scan(tree, null);
            }

            @Override
            public Void scan(Iterable<? extends Tree> iterable, Void unused) {
                if (stoppingPoint != null && iterable != null) {
                    ImmutableList.Builder builder2 = ImmutableList.builder();
                    for (Tree t : iterable) {
                        if (stoppingPoint.equals(t)) break;
                        builder2.add((Object)t);
                    }
                    iterable = builder2.build();
                }
                return (Void)super.scan((Iterable<? extends Tree>)iterable, null);
            }

            @Override
            public Void visitIdentifier(IdentifierTree identifierTree, Void unused) {
                Symbol symbol = ASTHelpers.getSymbol(identifierTree);
                if (symbol != null) {
                    builder.add((Object)symbol);
                }
                return null;
            }
        };
    }

    private static boolean isVisible(Symbol.VarSymbol var, TreePath path) {
        switch (var.getKind()) {
            case ENUM_CONSTANT: 
            case FIELD: {
                ImmutableList enclosingClasses = (ImmutableList)StreamSupport.stream(path.spliterator(), false).filter(ClassTree.class::isInstance).map(ClassTree.class::cast).map(ASTHelpers::getSymbol).collect(ImmutableList.toImmutableList());
                if (!var.isStatic()) {
                    if (FindIdentifiers.inStaticContext(path)) {
                        return false;
                    }
                    if (FindIdentifiers.lowerThan(path, (curr, unused) -> {
                        Symbol sym = ASTHelpers.getSymbol(curr);
                        return sym != null && ASTHelpers.isStatic(sym);
                    }, (curr, unused) -> curr instanceof ClassTree && ASTHelpers.getSymbol(curr).equals(var.owner))) {
                        return false;
                    }
                }
                if (enclosingClasses.contains((Object)ASTHelpers.enclosingClass(var))) {
                    return true;
                }
                Symbol.PackageSymbol enclosingPackage = ((JCTree.JCCompilationUnit)path.getCompilationUnit()).packge;
                Set<Modifier> modifiers = var.getModifiers();
                if (Objects.equals(enclosingPackage, ASTHelpers.enclosingPackage(var))) {
                    return !modifiers.contains((Object)Modifier.PRIVATE);
                }
                return modifiers.contains((Object)Modifier.PUBLIC) || modifiers.contains((Object)Modifier.PROTECTED);
            }
            case PARAMETER: 
            case LOCAL_VARIABLE: 
            case BINDING_VARIABLE: {
                return !FindIdentifiers.lowerThan(path, (curr, parent) -> {
                    NewClassTree newClassTree;
                    return curr instanceof LambdaExpressionTree || curr instanceof NewClassTree && (newClassTree = (NewClassTree)curr).getClassBody() != null || curr.getKind() == Tree.Kind.CLASS && parent instanceof BlockTree;
                }, (curr, unused) -> Objects.equals(var.owner, ASTHelpers.getSymbol(curr))) || ASTHelpers.isConsideredFinal(var);
            }
            case EXCEPTION_PARAMETER: 
            case RESOURCE_VARIABLE: {
                return true;
            }
        }
        throw new IllegalArgumentException("Unexpected variable type: " + String.valueOf((Object)var.getKind()));
    }

    private static boolean inStaticContext(TreePath path) {
        Symbol.ClassSymbol enclosingClass = ASTHelpers.getSymbol(ASTHelpers.findEnclosingNode(path, ClassTree.class));
        Symbol.ClassSymbol directSuperClass = (Symbol.ClassSymbol)enclosingClass.getSuperclass().tsym;
        Tree prev = path.getLeaf();
        path = path.getParentPath();
        for (Tree tree : path) {
            Tree tree2;
            Objects.requireNonNull(tree);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{MethodTree.class, BlockTree.class, VariableTree.class, MethodInvocationTree.class}, (Object)tree2, n)) {
                case 0: {
                    MethodTree methodTree = (MethodTree)tree2;
                    return ASTHelpers.isStatic(ASTHelpers.getSymbol(tree));
                }
                case 1: {
                    BlockTree blockTree = (BlockTree)tree2;
                    if (!blockTree.isStatic()) break;
                    return true;
                }
                case 2: {
                    VariableTree variableTree = (VariableTree)tree2;
                    Symbol.VarSymbol variableSym = ASTHelpers.getSymbol(variableTree);
                    if (variableSym.getKind() != ElementKind.FIELD) break;
                    return Objects.equals(variableTree.getInitializer(), prev) && variableSym.isStatic();
                }
                case 3: {
                    MethodInvocationTree methodInvocationTree = (MethodInvocationTree)tree2;
                    Symbol.MethodSymbol methodSym = ASTHelpers.getSymbol(methodInvocationTree);
                    if (!methodSym.isConstructor() || !Objects.equals(methodSym.owner, enclosingClass) && !Objects.equals(methodSym.owner, directSuperClass)) break;
                    return true;
                }
            }
            prev = tree;
        }
        return false;
    }

    private static void addIfVariable(Tree tree, ImmutableSet.Builder<Symbol.VarSymbol> setBuilder) {
        if (tree instanceof VariableTree) {
            VariableTree variableTree = (VariableTree)tree;
            setBuilder.add((Object)ASTHelpers.getSymbol(variableTree));
        }
    }

    private static void addAllIfVariable(java.util.List<? extends Tree> list, ImmutableSet.Builder<Symbol.VarSymbol> setBuilder) {
        for (Tree tree : list) {
            FindIdentifiers.addIfVariable(tree, setBuilder);
        }
    }

    private static boolean lowerThan(TreePath path, BiPredicate<Tree, Tree> predicate1, BiPredicate<Tree, Tree> predicate2) {
        int index1 = -1;
        int index2 = -1;
        int count = 0;
        path = path.getParentPath();
        while (path != null) {
            Tree curr = path.getLeaf();
            TreePath parentPath = path.getParentPath();
            if (index1 < 0 && predicate1.test(curr, parentPath == null ? null : parentPath.getLeaf())) {
                index1 = count;
            }
            if (index2 < 0 && predicate2.test(curr, parentPath == null ? null : parentPath.getLeaf())) {
                index2 = count;
            }
            if (index1 >= 0 && index2 >= 0) break;
            path = parentPath;
            ++count;
        }
        return index1 >= 0 && index1 < index2;
    }

    private FindIdentifiers() {
    }
}

