/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.util;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AssertTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.BreakTree;
import com.sun.source.tree.CaseTree;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ContinueTree;
import com.sun.source.tree.DoWhileLoopTree;
import com.sun.source.tree.EmptyStatementTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.ForLoopTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.LabeledStatementTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.ReturnTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.SwitchTree;
import com.sun.source.tree.SynchronizedTree;
import com.sun.source.tree.ThrowTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.source.tree.VariableTree;
import com.sun.source.tree.WhileLoopTree;
import com.sun.source.tree.YieldTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Name;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class Reachability {
    public static boolean canCompleteNormally(StatementTree statement) {
        return new CanCompleteNormallyVisitor((ImmutableMap<Tree, Boolean>)ImmutableMap.of()).scan(statement);
    }

    public static boolean canCompleteNormally(StatementTree statement, ImmutableMap<Tree, Boolean> patches) {
        return new CanCompleteNormallyVisitor(patches).scan(statement);
    }

    public static boolean canFallThrough(CaseTree caseTree) {
        return switch (caseTree.getCaseKind()) {
            default -> throw new MatchException(null, null);
            case CaseTree.CaseKind.STATEMENT -> {
                List<? extends StatementTree> statements = caseTree.getStatements();
                if (statements.isEmpty()) {
                    yield true;
                }
                yield Reachability.canCompleteNormally((StatementTree)Iterables.getLast(statements));
            }
            case CaseTree.CaseKind.RULE -> false;
        };
    }

    private static class CanCompleteNormallyVisitor
    extends SimpleTreeVisitor<Boolean, Void> {
        private final Set<Tree> breaks = new HashSet<Tree>();
        private final Set<Tree> continues = new HashSet<Tree>();
        private final ImmutableMap<Tree, Boolean> patches;

        CanCompleteNormallyVisitor(ImmutableMap<Tree, Boolean> patches) {
            this.patches = patches;
        }

        boolean scan(List<? extends StatementTree> trees) {
            boolean completes = true;
            for (StatementTree statementTree : trees) {
                completes = this.scan(statementTree);
            }
            return completes;
        }

        @CanIgnoreReturnValue
        private boolean scan(Tree tree) {
            if (this.patches.containsKey((Object)tree)) {
                return (Boolean)this.patches.get((Object)tree);
            }
            return tree.accept(this, null);
        }

        @Override
        public Boolean visitBreak(BreakTree tree, Void unused) {
            this.breaks.add(CanCompleteNormallyVisitor.skipLabel(Objects.requireNonNull(((JCTree.JCBreak)tree).target)));
            return false;
        }

        @Override
        public Boolean visitContinue(ContinueTree tree, Void unused) {
            this.continues.add(CanCompleteNormallyVisitor.skipLabel(Objects.requireNonNull(((JCTree.JCContinue)tree).target)));
            return false;
        }

        private static Tree skipLabel(JCTree tree) {
            return tree.hasTag(JCTree.Tag.LABELLED) ? ((JCTree.JCLabeledStatement)tree).body : tree;
        }

        @Override
        public Boolean visitBlock(BlockTree tree, Void unused) {
            return this.scan(tree.getStatements());
        }

        @Override
        public Boolean visitClass(ClassTree tree, Void unused) {
            return true;
        }

        @Override
        public Boolean visitVariable(VariableTree tree, Void unused) {
            return true;
        }

        @Override
        public Boolean visitEmptyStatement(EmptyStatementTree tree, Void unused) {
            return true;
        }

        @Override
        public Boolean visitLabeledStatement(LabeledStatementTree tree, Void unused) {
            return this.scan(tree.getStatement());
        }

        @Override
        public Boolean visitExpressionStatement(ExpressionStatementTree tree, Void unused) {
            if (CanCompleteNormallyVisitor.isSystemExit(tree.getExpression())) {
                return false;
            }
            return true;
        }

        private static boolean isSystemExit(ExpressionTree expression) {
            if (!(expression instanceof MethodInvocationTree)) {
                return false;
            }
            MethodInvocationTree methodInvocationTree = (MethodInvocationTree)expression;
            Symbol.MethodSymbol sym = ASTHelpers.getSymbol(methodInvocationTree);
            return sym.owner.getQualifiedName().contentEquals("java.lang.System") && ((Name)sym.getSimpleName()).contentEquals("exit");
        }

        @Override
        public Boolean visitIf(IfTree tree, Void unused) {
            boolean thenCompletes = this.scan(tree.getThenStatement());
            boolean elseCompletes = tree.getElseStatement() == null || this.scan(tree.getElseStatement());
            return thenCompletes || elseCompletes;
        }

        @Override
        public Boolean visitAssert(AssertTree tree, Void unused) {
            return true;
        }

        @Override
        public Boolean visitSwitch(SwitchTree tree, Void unused) {
            if (tree.getCases().stream().noneMatch(c -> ASTHelpers.isSwitchDefault(c))) {
                return true;
            }
            if (tree.getCases().stream().anyMatch(c -> c.getCaseKind().equals((Object)CaseTree.CaseKind.RULE))) {
                if (tree.getCases().stream().anyMatch(c -> this.scan(c.getBody()))) {
                    return true;
                }
                if (this.breaks.contains(tree)) {
                    return true;
                }
                return false;
            }
            if (tree.getCases().stream().allMatch(c -> c.getStatements().isEmpty())) {
                return true;
            }
            boolean lastCompletes = true;
            for (CaseTree caseTree : tree.getCases()) {
                lastCompletes = this.scan(caseTree.getStatements());
            }
            if (lastCompletes) {
                return true;
            }
            if (((CaseTree)Iterables.getLast(tree.getCases())).getStatements().isEmpty()) {
                return true;
            }
            if (this.breaks.contains(tree)) {
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitWhileLoop(WhileLoopTree tree, Void unused) {
            Boolean condValue = ASTHelpers.constValue(tree.getCondition(), Boolean.class);
            if (!Objects.equals(condValue, false)) {
                this.scan(tree.getStatement());
            }
            if (!Objects.equals(condValue, true)) {
                return true;
            }
            if (this.breaks.contains(tree)) {
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitDoWhileLoop(DoWhileLoopTree that, Void unused) {
            boolean completes = this.scan(that.getStatement());
            boolean conditionIsAlwaysTrue = (Boolean)MoreObjects.firstNonNull((Object)ASTHelpers.constValue(that.getCondition(), Boolean.class), (Object)false);
            if (completes && !conditionIsAlwaysTrue) {
                return true;
            }
            if (this.continues.contains(that) && !conditionIsAlwaysTrue) {
                return true;
            }
            if (this.breaks.contains(that)) {
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitForLoop(ForLoopTree that, Void unused) {
            Boolean condValue = ASTHelpers.constValue(that.getCondition(), Boolean.class);
            if (!Objects.equals(condValue, false)) {
                this.scan(that.getStatement());
            }
            if (that.getCondition() != null && !Objects.equals(condValue, true)) {
                return true;
            }
            if (this.breaks.contains(that)) {
                return true;
            }
            return false;
        }

        @Override
        public Boolean visitEnhancedForLoop(EnhancedForLoopTree that, Void unused) {
            this.scan(that.getStatement());
            return true;
        }

        @Override
        public Boolean visitReturn(ReturnTree tree, Void unused) {
            return false;
        }

        @Override
        public Boolean visitYield(YieldTree tree, Void unused) {
            return false;
        }

        @Override
        public Boolean visitThrow(ThrowTree tree, Void unused) {
            return false;
        }

        @Override
        public Boolean visitSynchronized(SynchronizedTree tree, Void unused) {
            return this.scan(tree.getBlock());
        }

        @Override
        public Boolean visitTry(TryTree that, Void unused) {
            boolean completes = this.scan(that.getBlock());
            for (CatchTree catchTree : that.getCatches()) {
                completes |= this.scan(catchTree.getBlock());
            }
            if (that.getFinallyBlock() != null && !this.scan(that.getFinallyBlock())) {
                completes = false;
            }
            return completes;
        }

        @Override
        protected Boolean defaultAction(Tree tree, Void unused) {
            throw new IllegalStateException(tree.getKind().toString());
        }
    }
}

