/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.io.CharStreams;
import com.google.common.truth.Subject;
import com.google.common.truth.Truth;
import com.google.errorprone.DescriptionListener;
import com.google.errorprone.ErrorProneInMemoryFileManager;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.ImportOrderParser;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.apply.DescriptionBasedDiff;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.SourceFile;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.scanner.ErrorProneScanner;
import com.google.errorprone.scanner.ErrorProneScannerTransformer;
import com.google.errorprone.scanner.Scanner;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import com.google.testing.compile.JavaFileObjects;
import com.google.testing.compile.JavaSourceSubjectFactory;
import com.google.testing.compile.JavaSourcesSubject;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Context;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileObject;
import org.junit.Assert;

public class BugCheckerRefactoringTestHelper {
    private final Map<JavaFileObject, JavaFileObject> sources = new HashMap<JavaFileObject, JavaFileObject>();
    private final BugChecker refactoringBugChecker;
    private final ErrorProneInMemoryFileManager fileManager;
    private FixChooser fixChooser = FixChoosers.FIRST;
    private List<String> options = ImmutableList.of();
    private boolean allowBreakingChanges = false;
    private String importOrder = "static-first";

    private BugCheckerRefactoringTestHelper(BugChecker refactoringBugChecker, Class<?> clazz) {
        this.refactoringBugChecker = refactoringBugChecker;
        this.fileManager = new ErrorProneInMemoryFileManager(clazz);
    }

    @CheckReturnValue
    public static BugCheckerRefactoringTestHelper newInstance(BugChecker refactoringBugChecker, Class<?> clazz) {
        return new BugCheckerRefactoringTestHelper(refactoringBugChecker, clazz);
    }

    @CheckReturnValue
    public ExpectOutput addInput(String inputFilename) {
        return new ExpectOutput(this.fileManager.forResource(inputFilename));
    }

    @CheckReturnValue
    public ExpectOutput addInputLines(String path, String ... input) {
        String inputPath = this.getPath("in/", path);
        Truth.assertThat((Boolean)this.fileManager.exists(inputPath)).isFalse();
        return new ExpectOutput(this.fileManager.forSourceLines(inputPath, input));
    }

    @CheckReturnValue
    public BugCheckerRefactoringTestHelper setFixChooser(FixChooser chooser) {
        this.fixChooser = chooser;
        return this;
    }

    @CheckReturnValue
    public BugCheckerRefactoringTestHelper setArgs(String ... args) {
        this.options = ImmutableList.copyOf((Object[])args);
        return this;
    }

    @CheckReturnValue
    public BugCheckerRefactoringTestHelper allowBreakingChanges() {
        this.allowBreakingChanges = true;
        return this;
    }

    @CheckReturnValue
    public BugCheckerRefactoringTestHelper setImportOrder(String importOrder) {
        this.importOrder = importOrder;
        return this;
    }

    public void doTest() {
        this.doTest(TestMode.AST_MATCH);
    }

    public void doTest(TestMode testMode) {
        for (Map.Entry<JavaFileObject, JavaFileObject> entry : this.sources.entrySet()) {
            try {
                this.runTestOnPair(entry.getKey(), entry.getValue(), testMode);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    private BugCheckerRefactoringTestHelper addInputAndOutput(JavaFileObject input, JavaFileObject output) {
        this.sources.put(input, output);
        return this;
    }

    private void runTestOnPair(JavaFileObject input, JavaFileObject output, TestMode testMode) throws IOException {
        Context context = new Context();
        JCTree.JCCompilationUnit tree = this.doCompile(input, this.sources.keySet(), context);
        JavaFileObject transformed = this.applyDiff(input, context, tree);
        testMode.verifyMatch(transformed, output);
        if (!this.allowBreakingChanges) {
            this.doCompile(output, this.sources.values(), new Context());
        }
    }

    private JCTree.JCCompilationUnit doCompile(JavaFileObject input, Iterable<JavaFileObject> files, Context context) throws IOException {
        ErrorProneOptions errorProneOptions;
        JavacTool tool = JavacTool.create();
        DiagnosticCollector diagnosticsCollector = new DiagnosticCollector();
        try {
            errorProneOptions = ErrorProneOptions.processArgs(this.options);
        }
        catch (InvalidCommandLineOptionException e) {
            throw new IllegalArgumentException("Exception during argument processing: " + (Object)((Object)e));
        }
        context.put(ErrorProneOptions.class, errorProneOptions);
        JavacTaskImpl task = (JavacTaskImpl)tool.getTask(CharStreams.nullWriter(), this.fileManager, diagnosticsCollector, (Iterable<String>)ImmutableList.copyOf((Object[])errorProneOptions.getRemainingArgs()), null, files, context);
        Iterable<? extends CompilationUnitTree> trees = task.parse();
        task.analyze();
        JCTree.JCCompilationUnit tree = (JCTree.JCCompilationUnit)Iterables.getOnlyElement((Iterable)Iterables.filter((Iterable)Iterables.filter(trees, JCTree.JCCompilationUnit.class), compilationUnit -> compilationUnit.getSourceFile() == input));
        Iterable errorDiagnostics = Iterables.filter(diagnosticsCollector.getDiagnostics(), d -> d.getKind() == Diagnostic.Kind.ERROR);
        if (!Iterables.isEmpty((Iterable)errorDiagnostics)) {
            Assert.fail((String)("compilation failed unexpectedly: " + errorDiagnostics));
        }
        return tree;
    }

    private JavaFileObject applyDiff(JavaFileObject sourceFileObject, Context context, JCTree.JCCompilationUnit tree) throws IOException {
        ImportOrganizer importOrganizer = ImportOrderParser.getImportOrganizer((String)this.importOrder);
        final DescriptionBasedDiff diff = DescriptionBasedDiff.create((JCTree.JCCompilationUnit)tree, (ImportOrganizer)importOrganizer);
        this.transformer(this.refactoringBugChecker).apply(new TreePath(tree), context, new DescriptionListener(){

            public void onDescribed(Description description) {
                if (!description.fixes.isEmpty()) {
                    diff.handleFix(BugCheckerRefactoringTestHelper.this.fixChooser.choose(description.fixes));
                }
            }
        });
        SourceFile sourceFile = SourceFile.create((JavaFileObject)sourceFileObject);
        diff.applyDifferences(sourceFile);
        JavaFileObject transformed = JavaFileObjects.forSourceString((String)BugCheckerRefactoringTestHelper.getFullyQualifiedName(tree), (String)sourceFile.getSourceText());
        return transformed;
    }

    private static String getFullyQualifiedName(JCTree.JCCompilationUnit tree) {
        Iterator types = Iterables.filter((Iterable)tree.getTypeDecls(), JCTree.JCClassDecl.class).iterator();
        if (types.hasNext()) {
            return ((JCTree.JCClassDecl)Iterators.getOnlyElement(types)).sym.getQualifiedName().toString();
        }
        return tree.getPackage().packge.package_info.toString();
    }

    private ErrorProneScannerTransformer transformer(BugChecker bugChecker) {
        ErrorProneScanner scanner = new ErrorProneScanner(new BugChecker[]{bugChecker});
        return ErrorProneScannerTransformer.create((Scanner)scanner);
    }

    private String getPath(String prefix, String path) {
        int insertAt = path.lastIndexOf(47);
        insertAt = insertAt == -1 ? 0 : insertAt + 1;
        return new StringBuilder(path).insert(insertAt, prefix + "/").toString();
    }

    public class ExpectOutput {
        private final JavaFileObject input;

        public ExpectOutput(JavaFileObject input) {
            this.input = input;
        }

        @CheckReturnValue
        public BugCheckerRefactoringTestHelper addOutputLines(String path, String ... output) {
            String outputPath = BugCheckerRefactoringTestHelper.this.getPath("out/", path);
            if (BugCheckerRefactoringTestHelper.this.fileManager.exists(outputPath)) {
                throw new UncheckedIOException(new FileAlreadyExistsException(outputPath));
            }
            return BugCheckerRefactoringTestHelper.this.addInputAndOutput(this.input, BugCheckerRefactoringTestHelper.this.fileManager.forSourceLines(outputPath, output));
        }

        @CheckReturnValue
        public BugCheckerRefactoringTestHelper addOutput(String outputFilename) {
            return BugCheckerRefactoringTestHelper.this.addInputAndOutput(this.input, BugCheckerRefactoringTestHelper.this.fileManager.forResource(outputFilename));
        }

        @CheckReturnValue
        public BugCheckerRefactoringTestHelper expectUnchanged() {
            return BugCheckerRefactoringTestHelper.this.addInputAndOutput(this.input, this.input);
        }
    }

    public static enum FixChoosers implements FixChooser
    {
        FIRST{

            @Override
            public Fix choose(List<Fix> fixes) {
                return fixes.get(0);
            }
        }
        ,
        SECOND{

            @Override
            public Fix choose(List<Fix> fixes) {
                return fixes.get(1);
            }
        }
        ,
        THIRD{

            @Override
            public Fix choose(List<Fix> fixes) {
                return fixes.get(2);
            }
        }
        ,
        FOURTH{

            @Override
            public Fix choose(List<Fix> fixes) {
                return fixes.get(3);
            }
        };

    }

    public static interface FixChooser {
        public Fix choose(List<Fix> var1);
    }

    public static enum TestMode {
        TEXT_MATCH{

            @Override
            void verifyMatch(JavaFileObject refactoredSource, JavaFileObject expectedSource) throws IOException {
                Truth.assertThat((String)this.maybeFormat(refactoredSource.getCharContent(false).toString())).isEqualTo((Object)this.maybeFormat(expectedSource.getCharContent(false).toString()));
            }

            private String maybeFormat(String input) {
                try {
                    return new Formatter().formatSource(input);
                }
                catch (FormatterException e) {
                    return input;
                }
            }
        }
        ,
        AST_MATCH{

            @Override
            void verifyMatch(JavaFileObject refactoredSource, JavaFileObject expectedSource) {
                ((JavaSourcesSubject.SingleSourceAdapter)Truth.assertAbout((Subject.Factory)JavaSourceSubjectFactory.javaSource()).that((Object)refactoredSource)).parsesAs(expectedSource, new JavaFileObject[0]);
            }
        };


        abstract void verifyMatch(JavaFileObject var1, JavaFileObject var2) throws IOException;
    }
}

