/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteStreams;
import com.google.common.truth.Truth;
import com.google.errorprone.BaseErrorProneJavaCompiler;
import com.google.errorprone.BugPattern;
import com.google.errorprone.DiagnosticTestHelper;
import com.google.errorprone.ErrorProneInMemoryFileManager;
import com.google.errorprone.ErrorProneOptions;
import com.google.errorprone.InvalidCommandLineOptionException;
import com.google.errorprone.annotations.CheckReturnValue;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.scanner.ScannerSupplier;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.main.Main;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.annotation.Nullable;
import javax.tools.Diagnostic;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.junit.Assert;

public class CompilationTestHelper {
    private static final ImmutableList<String> DEFAULT_ARGS = ImmutableList.of((Object)"-encoding", (Object)"UTF-8", (Object)"-XDdev", (Object)"-parameters", (Object)"-XDcompilePolicy=simple");
    private final DiagnosticTestHelper diagnosticHelper;
    private final BaseErrorProneJavaCompiler compiler;
    private final ByteArrayOutputStream outputStream;
    private final ErrorProneInMemoryFileManager fileManager;
    private final List<JavaFileObject> sources = new ArrayList<JavaFileObject>();
    private ImmutableList<String> extraArgs = ImmutableList.of();
    @Nullable
    private ImmutableList<Class<?>> overrideClasspath;
    private boolean expectNoDiagnostics = false;
    private Optional<Main.Result> expectedResult = Optional.empty();
    private boolean checkWellFormed = true;
    private DiagnosticTestHelper.LookForCheckNameInDiagnostic lookForCheckNameInDiagnostic = DiagnosticTestHelper.LookForCheckNameInDiagnostic.YES;

    private CompilationTestHelper(ScannerSupplier scannerSupplier, String checkName, Class<?> clazz) {
        this.fileManager = new ErrorProneInMemoryFileManager(clazz);
        try {
            this.fileManager.setLocation(StandardLocation.SOURCE_PATH, Collections.emptyList());
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        this.diagnosticHelper = new DiagnosticTestHelper(checkName);
        this.outputStream = new ByteArrayOutputStream();
        this.compiler = new BaseErrorProneJavaCompiler((JavaCompiler)JavacTool.create(), scannerSupplier);
    }

    @CheckReturnValue
    public static CompilationTestHelper newInstance(ScannerSupplier scannerSupplier, Class<?> clazz) {
        return new CompilationTestHelper(scannerSupplier, null, clazz);
    }

    @CheckReturnValue
    public static CompilationTestHelper newInstance(Class<? extends BugChecker> checker, Class<?> clazz) {
        ScannerSupplier scannerSupplier = ScannerSupplier.fromBugCheckerClasses((Class[])new Class[]{checker});
        String checkName = checker.getAnnotation(BugPattern.class).name();
        return new CompilationTestHelper(scannerSupplier, checkName, clazz);
    }

    static List<String> disableImplicitProcessing(List<String> args) {
        if (args.contains("-processor") || args.contains("-processorpath")) {
            return args;
        }
        return ImmutableList.builder().addAll(args).add((Object)"-proc:none").build();
    }

    private static List<String> buildArguments(@Nullable List<Class<?>> overrideClasspath, List<String> extraArgs) {
        ImmutableList.Builder result = ImmutableList.builder().addAll(DEFAULT_ARGS);
        CompilationTestHelper.getOverrideClasspath(overrideClasspath).ifPresent(jar -> result.add((Object)"-cp").add((Object)jar.toString()));
        return result.addAll(CompilationTestHelper.disableImplicitProcessing(extraArgs)).build();
    }

    private static Optional<Path> getOverrideClasspath(@Nullable List<Class<?>> overrideClasspath) {
        if (overrideClasspath == null) {
            return Optional.empty();
        }
        try {
            Path tempJarFile = Files.createTempFile(null, ".jar", new FileAttribute[0]);
            try (OutputStream os = Files.newOutputStream(tempJarFile, new OpenOption[0]);
                 JarOutputStream jos = new JarOutputStream(os);){
                for (Class<?> clazz : overrideClasspath) {
                    String entryPath = clazz.getName().replace('.', '/') + ".class";
                    jos.putNextEntry(new JarEntry(entryPath));
                    InputStream is = clazz.getClassLoader().getResourceAsStream(entryPath);
                    Throwable throwable = null;
                    try {
                        ByteStreams.copy((InputStream)is, (OutputStream)jos);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
            }
            return Optional.of(tempJarFile);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @CheckReturnValue
    public CompilationTestHelper addSourceLines(String path, String ... lines) {
        this.sources.add(this.fileManager.forSourceLines(path, lines));
        return this;
    }

    @CheckReturnValue
    public CompilationTestHelper addSourceFile(String path) {
        this.sources.add(this.fileManager.forResource(path));
        return this;
    }

    @CheckReturnValue
    public CompilationTestHelper withClasspath(Class<?> ... classes) {
        this.overrideClasspath = ImmutableList.copyOf((Object[])classes);
        return this;
    }

    @CheckReturnValue
    public CompilationTestHelper setArgs(List<String> args) {
        this.extraArgs = ImmutableList.copyOf(args);
        return this;
    }

    @CheckReturnValue
    public CompilationTestHelper expectNoDiagnostics() {
        this.expectNoDiagnostics = true;
        return this;
    }

    @CheckReturnValue
    public CompilationTestHelper ignoreJavacErrors() {
        this.checkWellFormed = false;
        return this;
    }

    @CheckReturnValue
    public CompilationTestHelper matchAllDiagnostics() {
        this.lookForCheckNameInDiagnostic = DiagnosticTestHelper.LookForCheckNameInDiagnostic.NO;
        return this;
    }

    @CheckReturnValue
    public CompilationTestHelper expectResult(Main.Result result) {
        this.expectedResult = Optional.of(result);
        return this;
    }

    @CheckReturnValue
    public CompilationTestHelper expectErrorMessage(String key, Predicate<? super String> matcher) {
        this.diagnosticHelper.expectErrorMessage(key, matcher);
        return this;
    }

    public void doTest() {
        Preconditions.checkState((!this.sources.isEmpty() ? 1 : 0) != 0, (Object)"No source files to compile");
        Main.Result result = this.compile();
        for (Diagnostic<? extends JavaFileObject> diagnostic : this.diagnosticHelper.getDiagnostics()) {
            if (!diagnostic.getCode().contains("error.prone.crash")) continue;
            Assert.fail((String)diagnostic.getMessage(Locale.ENGLISH));
        }
        if (this.expectNoDiagnostics) {
            List<Diagnostic<? extends JavaFileObject>> diagnostics = this.diagnosticHelper.getDiagnostics();
            Truth.assertWithMessage((String)String.format("Expected no diagnostics produced, but found %d: %s", diagnostics.size(), diagnostics)).that(Integer.valueOf(diagnostics.size())).isEqualTo((Object)0);
            Truth.assertWithMessage((String)String.format("Expected compilation result to be " + (Object)((Object)this.expectedResult.orElse(Main.Result.OK)) + ", but was %s. No diagnostics were emitted. OutputStream from Compiler follows.\n\n%s", new Object[]{result, this.outputStream})).that((Comparable)((Object)result)).isEqualTo((Object)this.expectedResult.orElse(Main.Result.OK));
        } else {
            for (JavaFileObject source : this.sources) {
                try {
                    this.diagnosticHelper.assertHasDiagnosticOnAllMatchingLines(source, this.lookForCheckNameInDiagnostic);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            Truth.assertWithMessage((String)("Unused error keys: " + this.diagnosticHelper.getUnusedLookupKeys())).that(Boolean.valueOf(this.diagnosticHelper.getUnusedLookupKeys().isEmpty())).isTrue();
        }
        if (this.expectedResult.isPresent()) {
            Truth.assertWithMessage((String)String.format("Expected compilation result %s, but was %s\n%s\n%s", new Object[]{this.expectedResult.get(), result, Joiner.on((char)'\n').join(this.diagnosticHelper.getDiagnostics()), this.outputStream})).that((Comparable)((Object)result)).isEqualTo((Object)this.expectedResult.get());
        }
    }

    private Main.Result compile() {
        List<String> processedArgs = CompilationTestHelper.buildArguments(this.overrideClasspath, this.extraArgs);
        if (this.checkWellFormed) {
            this.checkWellFormed(this.sources, processedArgs);
        }
        CompilationTestHelper.createAndInstallTempFolderForOutput(this.fileManager);
        return this.compiler.getTask((Writer)new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)this.outputStream, StandardCharsets.UTF_8)), true), (JavaFileManager)this.fileManager, this.diagnosticHelper.collector, (Iterable)ImmutableList.copyOf(processedArgs), (Iterable)ImmutableList.of(), this.sources).call() != false ? Main.Result.OK : Main.Result.ERROR;
    }

    private static void createAndInstallTempFolderForOutput(ErrorProneInMemoryFileManager fileManager) {
        Path tempDirectory;
        try {
            tempDirectory = Files.createTempDirectory(fileManager.fileSystem().getRootDirectories().iterator().next(), "", new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Arrays.stream(StandardLocation.values()).filter(StandardLocation::isOutputLocation).forEach(outputLocation -> {
            try {
                fileManager.setLocationFromPaths((JavaFileManager.Location)outputLocation, (Collection<? extends Path>)ImmutableList.of((Object)tempDirectory));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        });
    }

    private void checkWellFormed(Iterable<JavaFileObject> sources, List<String> args) {
        CompilationTestHelper.createAndInstallTempFolderForOutput(this.fileManager);
        JavacTool compiler = JavacTool.create();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        List<String> remainingArgs = null;
        try {
            remainingArgs = Arrays.asList(ErrorProneOptions.processArgs(args).getRemainingArgs());
        }
        catch (InvalidCommandLineOptionException e) {
            Assert.fail((String)("Exception during argument processing: " + (Object)((Object)e)));
        }
        JavaCompiler.CompilationTask task = compiler.getTask((Writer)new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter((OutputStream)outputStream, StandardCharsets.UTF_8)), true), (JavaFileManager)this.fileManager, null, remainingArgs, null, sources);
        boolean result = task.call();
        Truth.assertWithMessage((String)String.format("Test program failed to compile with non Error Prone error: %s", outputStream)).that(Boolean.valueOf(result)).isTrue();
    }
}

