/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.List;
import java.util.EnumMap;
import java.util.HashSet;

public class TypeMetadata {
    public static final TypeMetadata EMPTY = new TypeMetadata();
    private final EnumMap<Entry.Kind, Entry> contents;

    private TypeMetadata() {
        this.contents = new EnumMap(Entry.Kind.class);
    }

    public TypeMetadata(Entry elem) {
        this();
        Assert.checkNonNull(elem);
        this.contents.put(elem.kind(), elem);
    }

    public TypeMetadata(TypeMetadata other) {
        Assert.checkNonNull(other);
        this.contents = other.contents.clone();
    }

    public TypeMetadata combine(Entry elem) {
        Assert.checkNonNull(elem);
        TypeMetadata out = new TypeMetadata(this);
        Entry.Kind key = elem.kind();
        if (this.contents.containsKey((Object)key)) {
            out.add(key, this.contents.get((Object)key).combine(elem));
        } else {
            out.add(key, elem);
        }
        return out;
    }

    public TypeMetadata combineAll(TypeMetadata other) {
        Assert.checkNonNull(other);
        TypeMetadata out = new TypeMetadata();
        HashSet<Entry.Kind> keys = new HashSet<Entry.Kind>(this.contents.keySet());
        keys.addAll(other.contents.keySet());
        for (Entry.Kind key : keys) {
            if (this.contents.containsKey((Object)key)) {
                if (other.contents.containsKey((Object)key)) {
                    out.add(key, this.contents.get((Object)key).combine(other.contents.get((Object)key)));
                    continue;
                }
                out.add(key, this.contents.get((Object)key));
                continue;
            }
            if (!other.contents.containsKey((Object)key)) continue;
            out.add(key, other.contents.get((Object)key));
        }
        return out;
    }

    public TypeMetadata without(Entry.Kind kind) {
        if (this == EMPTY || this.contents.get((Object)kind) == null) {
            return this;
        }
        TypeMetadata out = new TypeMetadata(this);
        out.contents.remove((Object)kind);
        return out.contents.isEmpty() ? EMPTY : out;
    }

    public Entry get(Entry.Kind kind) {
        return this.contents.get((Object)kind);
    }

    private void add(Entry.Kind kind, Entry elem) {
        this.contents.put(kind, elem);
    }

    public static class Annotations
    implements Entry {
        private List<Attribute.TypeCompound> annos;
        public static final List<Attribute.TypeCompound> TO_BE_SET = List.nil();

        public Annotations(List<Attribute.TypeCompound> annos) {
            this.annos = annos;
        }

        public List<Attribute.TypeCompound> getAnnotations() {
            return this.annos;
        }

        @Override
        public Annotations combine(Entry other) {
            Assert.check(this.annos == TO_BE_SET);
            this.annos = ((Annotations)other).annos;
            return this;
        }

        @Override
        public Entry.Kind kind() {
            return Entry.Kind.ANNOTATIONS;
        }

        public String toString() {
            return "ANNOTATIONS [ " + this.annos + " ]";
        }
    }

    public static interface Entry {
        public Kind kind();

        public Entry combine(Entry var1);

        public static enum Kind {
            ANNOTATIONS;

        }
    }
}

