/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.internal.doclets.formats.html.ConfigurationImpl;
import jdk.javadoc.internal.doclets.formats.html.HtmlDocletWriter;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.DocletAbortException;
import jdk.javadoc.internal.doclets.toolkit.util.IndexBuilder;

public class AllClassesFrameWriter
extends HtmlDocletWriter {
    protected IndexBuilder indexbuilder;
    final HtmlTree BR = new HtmlTree(HtmlTag.BR);

    public AllClassesFrameWriter(ConfigurationImpl configuration, DocPath filename, IndexBuilder indexbuilder) throws IOException {
        super(configuration, filename);
        this.indexbuilder = indexbuilder;
    }

    public static void generate(ConfigurationImpl configuration, IndexBuilder indexbuilder) {
        DocPath filename = DocPaths.ALLCLASSES_FRAME;
        try {
            AllClassesFrameWriter allclassgen = new AllClassesFrameWriter(configuration, filename, indexbuilder);
            allclassgen.buildAllClassesFile(true);
            allclassgen.close();
            filename = DocPaths.ALLCLASSES_NOFRAME;
            allclassgen = new AllClassesFrameWriter(configuration, filename, indexbuilder);
            allclassgen.buildAllClassesFile(false);
            allclassgen.close();
        }
        catch (IOException exc) {
            configuration.standardmessage.error("doclet.exception_encountered", exc.toString(), filename);
            throw new DocletAbortException(exc);
        }
    }

    protected void buildAllClassesFile(boolean wantFrames) throws IOException {
        String label = this.configuration.getText("doclet.All_Classes");
        HtmlTree body = this.getBody(false, this.getWindowTitle(label));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.TITLE_HEADING, HtmlStyle.bar, this.allclassesLabel);
        ((Content)body).addContent(heading);
        HtmlTree ul = new HtmlTree(HtmlTag.UL);
        this.addAllClasses(ul, wantFrames);
        HtmlTree htmlTree = this.configuration.allowTag(HtmlTag.MAIN) ? HtmlTree.MAIN(HtmlStyle.indexContainer, ul) : HtmlTree.DIV(HtmlStyle.indexContainer, ul);
        ((Content)body).addContent(htmlTree);
        this.printHtmlDocument(null, false, body);
    }

    protected void addAllClasses(Content content, boolean wantFrames) {
        for (Character unicode : this.indexbuilder.index()) {
            this.addContents(this.indexbuilder.getMemberList(unicode), wantFrames, content);
        }
    }

    protected void addContents(Iterable<? extends Element> classlist, boolean wantFrames, Content content) {
        for (Element element : classlist) {
            TypeElement typeElement = (TypeElement)element;
            if (!this.utils.isCoreClass(typeElement)) continue;
            Content label = this.interfaceName(typeElement, false);
            Content linkContent = wantFrames ? this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.ALL_CLASSES_FRAME, typeElement).label(label).target("classFrame")) : this.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.DEFAULT, typeElement).label(label));
            HtmlTree li = HtmlTree.LI(linkContent);
            content.addContent(li);
        }
    }
}

