/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import com.sun.source.util.DocTreePath;
import com.sun.tools.doclint.DocLint;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import javax.lang.model.element.Element;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import jdk.javadoc.doclet.Doclet;
import jdk.javadoc.doclet.DocletEnvironment;
import jdk.javadoc.internal.doclets.formats.html.SearchIndexItem;
import jdk.javadoc.internal.doclets.formats.html.WriterFactoryImpl;
import jdk.javadoc.internal.doclets.formats.html.markup.ContentBuilder;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlVersion;
import jdk.javadoc.internal.doclets.toolkit.Configuration;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.WriterFactory;
import jdk.javadoc.internal.doclets.toolkit.util.DocFile;
import jdk.javadoc.internal.doclets.toolkit.util.DocPath;
import jdk.javadoc.internal.doclets.toolkit.util.DocPaths;
import jdk.javadoc.internal.doclets.toolkit.util.MessageRetriever;
import jdk.javadoc.internal.doclets.toolkit.util.Utils;

public class ConfigurationImpl
extends Configuration {
    public static final String BUILD_DATE = System.getProperty("java.version");
    public String header = "";
    public String packagesheader = "";
    public String footer = "";
    public String doctitle = "";
    public String windowtitle = "";
    public String top = "";
    public String bottom = "";
    public String helpfile = "";
    public String stylesheetfile = "";
    public String docrootparent = "";
    public boolean sortedMethodDetails = false;
    public boolean nohelp = false;
    public boolean splitindex = false;
    public boolean createindex = true;
    public boolean classuse = false;
    public boolean createtree = true;
    public boolean nodeprecatedlist = false;
    public boolean nonavbar = false;
    private boolean nooverview = false;
    public String overviewpath = null;
    public boolean createoverview = false;
    public HtmlVersion htmlVersion = HtmlVersion.HTML4;
    public Map<Doclet.Option, String> doclintOpts = new LinkedHashMap<Doclet.Option, String>();
    public final MessageRetriever standardmessage;
    public DocPath topFile = DocPath.empty;
    public TypeElement currentTypeElement = null;
    protected List<SearchIndexItem> memberSearchIndex = new ArrayList<SearchIndexItem>();
    protected List<SearchIndexItem> packageSearchIndex = new ArrayList<SearchIndexItem>();
    protected List<SearchIndexItem> tagSearchIndex = new ArrayList<SearchIndexItem>();
    protected List<SearchIndexItem> typeSearchIndex = new ArrayList<SearchIndexItem>();
    protected Map<Character, List<SearchIndexItem>> tagSearchIndexMap = new HashMap<Character, List<SearchIndexItem>>();
    protected Set<Character> tagSearchIndexKeys;
    private final String versionRBName = "jdk.javadoc.internal.tool.resources.version";
    private ResourceBundle versionRB;

    public ConfigurationImpl() {
        this.standardmessage = new MessageRetriever(this, "jdk.javadoc.internal.doclets.formats.html.resources.standard");
    }

    @Override
    public String getDocletSpecificBuildDate() {
        if (this.versionRB == null) {
            try {
                this.versionRB = ResourceBundle.getBundle("jdk.javadoc.internal.tool.resources.version", this.getLocale());
            }
            catch (MissingResourceException e) {
                return BUILD_DATE;
            }
        }
        try {
            return this.versionRB.getString("release");
        }
        catch (MissingResourceException e) {
            return BUILD_DATE;
        }
    }

    protected boolean validateOptions() {
        if (!this.generalValidOptions()) {
            return false;
        }
        boolean helpfileSeen = false;
        for (Doclet.Option opt : this.optionsProcessed) {
            String dopt;
            Object help;
            if (opt.matches("-helpfile")) {
                if (this.nohelp) {
                    this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_conflict", "-helpfile", "-nohelp"));
                    return false;
                }
                if (helpfileSeen) {
                    this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_reuse", "-helpfile"));
                    return false;
                }
                helpfileSeen = true;
                help = DocFile.createFileForInput(this, this.helpfile);
                if (((DocFile)help).exists()) continue;
                this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.File_not_found", this.helpfile));
                return false;
            }
            if (opt.matches("-nohelp")) {
                if (!helpfileSeen) continue;
                this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_conflict", "-nohelp", "-helpfile"));
                return false;
            }
            if (opt.matches("-xdocrootparent")) {
                try {
                    help = new URL(this.docrootparent);
                    continue;
                }
                catch (MalformedURLException e) {
                    this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.MalformedURL", this.docrootparent));
                    return false;
                }
            }
            if (opt.matches("-overview")) {
                if (!this.nooverview) continue;
                this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_conflict", "-overview", "-nooverview"));
                return false;
            }
            if (opt.matches("-nooverview")) {
                if (this.overviewpath == null) continue;
                this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_conflict", "-nooverview", "-overview"));
                return false;
            }
            if (opt.matches("-splitindex")) {
                if (this.createindex) continue;
                this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_conflict", "-splitindex", "-noindex"));
                return false;
            }
            if (opt.matches("-noindex")) {
                if (!this.splitindex) continue;
                this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_conflict", "-noindex", "-splitindex"));
                return false;
            }
            if (opt.matches("-xdoclint:")) {
                dopt = this.doclintOpts.get(opt);
                if (dopt == null) continue;
                if (dopt.contains("/")) {
                    this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_doclint_no_qualifiers"));
                    return false;
                }
                if (DocLint.isValidOption(dopt)) continue;
                this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_doclint_invalid_arg"));
                return false;
            }
            if (!opt.matches("-xdoclint/package:") || DocLint.isValidOption(dopt = this.doclintOpts.get(opt))) continue;
            this.reporter.print(Diagnostic.Kind.ERROR, this.getText("doclet.Option_doclint_package_invalid_arg"));
            return false;
        }
        return true;
    }

    @Override
    public boolean finishOptionSettings() {
        if (!this.validateOptions()) {
            return false;
        }
        if (!this.root.getSpecifiedElements().isEmpty()) {
            HashMap<String, PackageElement> map = new HashMap<String, PackageElement>();
            ArrayList<TypeElement> classes = new ArrayList<TypeElement>(this.root.getIncludedClasses());
            for (TypeElement aClass : classes) {
                PackageElement pkg = this.utils.containingPackage(aClass);
                if (map.containsKey(this.utils.getPackageName(pkg))) continue;
                map.put(this.utils.getPackageName(pkg), pkg);
            }
        }
        this.setCreateOverview();
        this.setTopFile(this.root);
        this.workArounds.initDocLint(this.doclintOpts.values(), this.tagletManager.getCustomTagNames(), Utils.toLowerCase(this.htmlVersion.name()));
        return true;
    }

    public boolean isOutputHtml5() {
        return this.htmlVersion == HtmlVersion.HTML5;
    }

    public boolean allowTag(HtmlTag htmlTag) {
        return htmlTag.allowTag(this.htmlVersion);
    }

    @Override
    public MessageRetriever getDocletSpecificMsg() {
        return this.standardmessage;
    }

    protected void setTopFile(DocletEnvironment root) {
        if (!this.checkForDeprecation(root)) {
            return;
        }
        if (this.createoverview) {
            this.topFile = DocPaths.OVERVIEW_SUMMARY;
        } else if (this.packages.size() == 1 && ((PackageElement)this.packages.first()).isUnnamed()) {
            if (!root.getIncludedClasses().isEmpty()) {
                ArrayList<TypeElement> classes = new ArrayList<TypeElement>(root.getIncludedClasses());
                TypeElement te = this.getValidClass(classes);
                this.topFile = DocPath.forClass(this.utils, te);
            }
        } else if (!this.packages.isEmpty()) {
            this.topFile = DocPath.forPackage((PackageElement)this.packages.first()).resolve(DocPaths.PACKAGE_SUMMARY);
        }
    }

    protected TypeElement getValidClass(List<TypeElement> classes) {
        if (!this.nodeprecated) {
            return classes.get(0);
        }
        for (TypeElement te : classes) {
            if (this.utils.isDeprecated(te)) continue;
            return te;
        }
        return null;
    }

    protected boolean checkForDeprecation(DocletEnvironment root) {
        for (TypeElement te : root.getIncludedClasses()) {
            if (!this.isGeneratedDoc(te)) continue;
            return true;
        }
        return false;
    }

    protected void setCreateOverview() {
        if (!(this.overviewpath == null && this.packages.size() <= 1 || this.nooverview)) {
            this.createoverview = true;
        }
    }

    @Override
    public WriterFactory getWriterFactory() {
        return new WriterFactoryImpl(this);
    }

    @Override
    public Locale getLocale() {
        if (this.locale == null) {
            return Locale.getDefault();
        }
        return this.locale;
    }

    @Override
    public JavaFileObject getOverviewPath() {
        if (this.overviewpath != null && this.getFileManager() instanceof StandardJavaFileManager) {
            StandardJavaFileManager fm = (StandardJavaFileManager)this.getFileManager();
            return fm.getJavaFileObjects(this.overviewpath).iterator().next();
        }
        return null;
    }

    @Override
    public JavaFileManager getFileManager() {
        return this.root.getJavaFileManager();
    }

    @Override
    public boolean showMessage(DocTreePath path, String key) {
        return path == null || this.workArounds.haveDocLint();
    }

    @Override
    public boolean showMessage(Element e, String key) {
        return e == null || this.workArounds.haveDocLint();
    }

    @Override
    public Content newContent() {
        return new ContentBuilder();
    }

    protected void buildSearchTagIndex() {
        for (SearchIndexItem sii : this.tagSearchIndex) {
            String tagLabel = sii.getLabel();
            Character unicode = Character.valueOf(tagLabel.length() == 0 ? (char)'*' : Character.toUpperCase(tagLabel.charAt(0)));
            List<SearchIndexItem> list = this.tagSearchIndexMap.get(unicode);
            if (list == null) {
                list = new ArrayList<SearchIndexItem>();
                this.tagSearchIndexMap.put(unicode, list);
            }
            list.add(sii);
        }
        this.tagSearchIndexKeys = this.tagSearchIndexMap.keySet();
    }

    @Override
    public Set<Doclet.Option> getSupportedOptions() {
        Doclet.Option[] options = new Doclet.Option[]{new Configuration.Option((Configuration)this, "bottom", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.bottom = args.next();
                return true;
            }
        }, new Configuration.Option((Configuration)this, "charset", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.charset = args.next();
                return true;
            }
        }, new Configuration.Option((Configuration)this, "doctitle", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.doctitle = args.next();
                return true;
            }
        }, new Configuration.Option((Configuration)this, "footer", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.footer = args.next();
                return true;
            }
        }, new Configuration.Option((Configuration)this, "header", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.header = args.next();
                return true;
            }
        }, new Configuration.Option((Configuration)this, "helpfile", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.helpfile = args.next();
                return true;
            }
        }, new Configuration.Option(this, "html4"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.htmlVersion = HtmlVersion.HTML4;
                return true;
            }
        }, new Configuration.Option(this, "html5"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.htmlVersion = HtmlVersion.HTML5;
                return true;
            }
        }, new Configuration.Option(this, "nohelp"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.nohelp = true;
                return true;
            }
        }, new Configuration.Option(this, "nodeprecatedlist"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.nodeprecatedlist = true;
                return true;
            }
        }, new Configuration.Option(this, "noindex"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.createindex = false;
                return true;
            }
        }, new Configuration.Option(this, "nonavbar"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.nonavbar = true;
                return true;
            }
        }, new Configuration.Hidden((Configuration)this, "nooverview"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.nooverview = true;
                return true;
            }
        }, new Configuration.Option(this, "notree"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.createtree = false;
                return true;
            }
        }, new Configuration.Hidden((Configuration)this, "overview", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.overviewpath = args.next();
                return true;
            }
        }, new Configuration.Hidden((Configuration)this, "packagesheader", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.packagesheader = args.next();
                return true;
            }
        }, new Configuration.Option(this, "splitindex"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.splitindex = true;
                return true;
            }
        }, new Configuration.Option((Configuration)this, "stylesheetfile", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.stylesheetfile = args.next();
                return true;
            }
        }, new Configuration.Option((Configuration)this, "top", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.top = args.next();
                return true;
            }
        }, new Configuration.Option(this, "use"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.classuse = true;
                return true;
            }
        }, new Configuration.Option((Configuration)this, "windowtitle", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.windowtitle = args.next().replaceAll("\\<.*?>", "");
                return true;
            }
        }, new Configuration.XOption((Configuration)this, "xdoclint"){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.doclintOpts.put(this, "-Xmsgs");
                return true;
            }
        }, new Configuration.XOption((Configuration)this, "Xdocrootparent", 1){

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.docrootparent = args.next();
                return true;
            }
        }, new Configuration.XOption((Configuration)this, "doclet.xusage.xdoclint-extended.", "Xdoclint:", 0){

            @Override
            public boolean matches(String option) {
                String opt = option.startsWith("-") ? option.substring(1) : option;
                return opt.toLowerCase().startsWith(this.getName().toLowerCase());
            }

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.doclintOpts.put(this, opt.replace("-Xdoclint:", "-Xmsgs:"));
                return true;
            }
        }, new Configuration.XOption((Configuration)this, "doclet.xusage.xdoclint-package.", "Xdoclint/package:", 0){

            @Override
            public boolean matches(String option) {
                String opt = option.startsWith("-") ? option.substring(1) : option;
                return opt.toLowerCase().startsWith(this.getName().toLowerCase());
            }

            @Override
            public boolean process(String opt, ListIterator<String> args) {
                ConfigurationImpl.this.optionsProcessed.add(this);
                ConfigurationImpl.this.doclintOpts.put(this, opt.replace("-Xdoclint/package:", "-XcheckPackage:"));
                return true;
            }
        }};
        TreeSet<Doclet.Option> oset = new TreeSet<Doclet.Option>();
        oset.addAll(Arrays.asList(options));
        oset.addAll(super.getSupportedOptions());
        return oset;
    }
}

