/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import jdk.javadoc.internal.doclets.formats.html.AbstractMemberWriter;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.formats.html.SectionName;
import jdk.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTag;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.FieldWriter;
import jdk.javadoc.internal.doclets.toolkit.MemberSummaryWriter;

public class FieldWriterImpl
extends AbstractMemberWriter
implements FieldWriter,
MemberSummaryWriter {
    public FieldWriterImpl(SubWriterHolderWriter writer, TypeElement typeElement) {
        super(writer, typeElement);
    }

    public FieldWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    @Override
    public Content getMemberSummaryHeader(TypeElement typeElement, Content memberSummaryTree) {
        memberSummaryTree.addContent(HtmlConstants.START_OF_FIELD_SUMMARY);
        Content memberTree = this.writer.getMemberTreeHeader();
        this.writer.addSummaryHeader(this, typeElement, memberTree);
        return memberTree;
    }

    @Override
    public void addMemberTree(Content memberSummaryTree, Content memberTree) {
        this.writer.addMemberTree(memberSummaryTree, memberTree);
    }

    @Override
    public Content getFieldDetailsTreeHeader(TypeElement typeElement, Content memberDetailsTree) {
        memberDetailsTree.addContent(HtmlConstants.START_OF_FIELD_DETAILS);
        Content fieldDetailsTree = this.writer.getMemberTreeHeader();
        fieldDetailsTree.addContent(this.writer.getMarkerAnchor(SectionName.FIELD_DETAIL));
        HtmlTree heading = HtmlTree.HEADING(HtmlConstants.DETAILS_HEADING, this.writer.fieldDetailsLabel);
        fieldDetailsTree.addContent(heading);
        return fieldDetailsTree;
    }

    @Override
    public Content getFieldDocTreeHeader(VariableElement field, Content fieldDetailsTree) {
        fieldDetailsTree.addContent(this.writer.getMarkerAnchor(this.name(field)));
        Content fieldTree = this.writer.getMemberTreeHeader();
        HtmlTree heading = new HtmlTree(HtmlConstants.MEMBER_HEADING);
        ((Content)heading).addContent(this.name(field));
        fieldTree.addContent(heading);
        return fieldTree;
    }

    @Override
    public Content getSignature(VariableElement field) {
        HtmlTree pre = new HtmlTree(HtmlTag.PRE);
        this.writer.addAnnotationInfo(field, (Content)pre);
        this.addModifiers(field, pre);
        Content fieldlink = this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, field.asType()));
        ((Content)pre).addContent(fieldlink);
        ((Content)pre).addContent(" ");
        if (this.configuration.linksource) {
            StringContent fieldName = new StringContent(this.name(field));
            this.writer.addSrcLink(field, fieldName, pre);
        } else {
            this.addName(this.name(field), pre);
        }
        return pre;
    }

    @Override
    public void addDeprecated(VariableElement field, Content fieldTree) {
        this.addDeprecatedInfo(field, fieldTree);
    }

    @Override
    public void addComments(VariableElement field, Content fieldTree) {
        if (!this.utils.getBody(field).isEmpty()) {
            this.writer.addInlineComment(field, fieldTree);
        }
    }

    @Override
    public void addTags(VariableElement field, Content fieldTree) {
        this.writer.addTagsInfo(field, fieldTree);
    }

    @Override
    public Content getFieldDetails(Content fieldDetailsTree) {
        if (this.configuration.allowTag(HtmlTag.SECTION)) {
            HtmlTree htmlTree = HtmlTree.SECTION(this.getMemberTree(fieldDetailsTree));
            return htmlTree;
        }
        return this.getMemberTree(fieldDetailsTree);
    }

    @Override
    public Content getFieldDoc(Content fieldTree, boolean isLastContent) {
        return this.getMemberTree(fieldTree, isLastContent);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void addSummaryLabel(Content memberTree) {
        HtmlTree label = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, this.writer.getResource("doclet.Field_Summary"));
        memberTree.addContent(label);
    }

    @Override
    public String getTableSummary() {
        return this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Field_Summary"), this.configuration.getText("doclet.fields"));
    }

    @Override
    public Content getCaption() {
        return this.configuration.getResource("doclet.Fields");
    }

    @Override
    public List<String> getSummaryTableHeader(Element member) {
        List<String> header = Arrays.asList(this.writer.getModifierTypeHeader(), this.configuration.getText("doclet.0_and_1", this.configuration.getText("doclet.Field"), this.configuration.getText("doclet.Description")));
        return header;
    }

    @Override
    public void addSummaryAnchor(TypeElement typeElement, Content memberTree) {
        memberTree.addContent(this.writer.getMarkerAnchor(SectionName.FIELD_SUMMARY));
    }

    @Override
    public void addInheritedSummaryAnchor(TypeElement typeElement, Content inheritedTree) {
        inheritedTree.addContent(this.writer.getMarkerAnchor(SectionName.FIELDS_INHERITANCE, this.configuration.getClassName(typeElement)));
    }

    @Override
    public void addInheritedSummaryLabel(TypeElement typeElement, Content inheritedTree) {
        Content classLink = this.writer.getPreQualifiedClassLink(LinkInfoImpl.Kind.MEMBER, typeElement, false);
        StringContent label = new StringContent(this.utils.isClass(typeElement) ? this.configuration.getText("doclet.Fields_Inherited_From_Class") : this.configuration.getText("doclet.Fields_Inherited_From_Interface"));
        HtmlTree labelHeading = HtmlTree.HEADING(HtmlConstants.INHERITED_SUMMARY_HEADING, label);
        ((Content)labelHeading).addContent(this.writer.getSpace());
        ((Content)labelHeading).addContent(classLink);
        inheritedTree.addContent(labelHeading);
    }

    @Override
    protected void addSummaryLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element member, Content tdSummary) {
        HtmlTree memberLink = HtmlTree.SPAN(HtmlStyle.memberNameLink, this.writer.getDocLink(context, typeElement, member, this.name(member), false));
        HtmlTree code = HtmlTree.CODE(memberLink);
        tdSummary.addContent(code);
    }

    @Override
    protected void addInheritedSummaryLink(TypeElement typeElement, Element member, Content linksTree) {
        linksTree.addContent(this.writer.getDocLink(LinkInfoImpl.Kind.MEMBER, typeElement, member, this.name(member), false));
    }

    @Override
    protected void addSummaryType(Element member, Content tdSummaryType) {
        this.addModifierAndType(member, member.asType(), tdSummaryType);
    }

    @Override
    protected Content getDeprecatedLink(Element member) {
        String name = this.utils.getFullyQualifiedName(member) + "." + member.getSimpleName();
        return this.writer.getDocLink(LinkInfoImpl.Kind.MEMBER, member, name);
    }

    @Override
    protected Content getNavSummaryLink(TypeElement typeElement, boolean link) {
        if (link) {
            if (typeElement == null) {
                return this.writer.getHyperLink(SectionName.FIELD_SUMMARY, this.writer.getResource("doclet.navField"));
            }
            return this.writer.getHyperLink(SectionName.FIELDS_INHERITANCE, this.configuration.getClassName(typeElement), this.writer.getResource("doclet.navField"));
        }
        return this.writer.getResource("doclet.navField");
    }

    @Override
    protected void addNavDetailLink(boolean link, Content liNav) {
        if (link) {
            liNav.addContent(this.writer.getHyperLink(SectionName.FIELD_DETAIL, this.writer.getResource("doclet.navField")));
        } else {
            liNav.addContent(this.writer.getResource("doclet.navField"));
        }
    }
}

