/*
 * Decompiled with CFR 0.152.
 */
package jdk.javadoc.internal.doclets.formats.html;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import jdk.javadoc.internal.doclets.formats.html.AbstractMemberWriter;
import jdk.javadoc.internal.doclets.formats.html.LinkInfoImpl;
import jdk.javadoc.internal.doclets.formats.html.SectionName;
import jdk.javadoc.internal.doclets.formats.html.SubWriterHolderWriter;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlConstants;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlStyle;
import jdk.javadoc.internal.doclets.formats.html.markup.HtmlTree;
import jdk.javadoc.internal.doclets.formats.html.markup.StringContent;
import jdk.javadoc.internal.doclets.toolkit.Content;
import jdk.javadoc.internal.doclets.toolkit.MemberSummaryWriter;

public class NestedClassWriterImpl
extends AbstractMemberWriter
implements MemberSummaryWriter {
    public NestedClassWriterImpl(SubWriterHolderWriter writer, TypeElement typeElement) {
        super(writer, typeElement);
    }

    public NestedClassWriterImpl(SubWriterHolderWriter writer) {
        super(writer);
    }

    @Override
    public Content getMemberSummaryHeader(TypeElement typeElement, Content memberSummaryTree) {
        memberSummaryTree.addContent(HtmlConstants.START_OF_NESTED_CLASS_SUMMARY);
        Content memberTree = this.writer.getMemberTreeHeader();
        this.writer.addSummaryHeader(this, typeElement, memberTree);
        return memberTree;
    }

    @Override
    public void addMemberTree(Content memberSummaryTree, Content memberTree) {
        this.writer.addMemberTree(memberSummaryTree, memberTree);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public void addSummaryLabel(Content memberTree) {
        HtmlTree label = HtmlTree.HEADING(HtmlConstants.SUMMARY_HEADING, this.writer.getResource("doclet.Nested_Class_Summary"));
        memberTree.addContent(label);
    }

    @Override
    public String getTableSummary() {
        return this.configuration.getText("doclet.Member_Table_Summary", this.configuration.getText("doclet.Nested_Class_Summary"), this.configuration.getText("doclet.nested_classes"));
    }

    @Override
    public Content getCaption() {
        return this.configuration.getResource("doclet.Nested_Classes");
    }

    @Override
    public List<String> getSummaryTableHeader(Element member) {
        if (this.utils.isInterface(member)) {
            return Arrays.asList(this.writer.getModifierTypeHeader(), this.configuration.getText("doclet.0_and_1", this.configuration.getText("doclet.Interface"), this.configuration.getText("doclet.Description")));
        }
        return Arrays.asList(this.writer.getModifierTypeHeader(), this.configuration.getText("doclet.0_and_1", this.configuration.getText("doclet.Class"), this.configuration.getText("doclet.Description")));
    }

    @Override
    public void addSummaryAnchor(TypeElement typeElement, Content memberTree) {
        memberTree.addContent(this.writer.getMarkerAnchor(SectionName.NESTED_CLASS_SUMMARY));
    }

    @Override
    public void addInheritedSummaryAnchor(TypeElement typeElement, Content inheritedTree) {
        inheritedTree.addContent(this.writer.getMarkerAnchor(SectionName.NESTED_CLASSES_INHERITANCE, this.utils.getFullyQualifiedName(typeElement)));
    }

    @Override
    public void addInheritedSummaryLabel(TypeElement typeElement, Content inheritedTree) {
        Content classLink = this.writer.getPreQualifiedClassLink(LinkInfoImpl.Kind.MEMBER, typeElement, false);
        StringContent label = new StringContent(this.utils.isInterface(typeElement) ? this.configuration.getText("doclet.Nested_Classes_Interface_Inherited_From_Interface") : this.configuration.getText("doclet.Nested_Classes_Interfaces_Inherited_From_Class"));
        HtmlTree labelHeading = HtmlTree.HEADING(HtmlConstants.INHERITED_SUMMARY_HEADING, label);
        ((Content)labelHeading).addContent(this.writer.getSpace());
        ((Content)labelHeading).addContent(classLink);
        inheritedTree.addContent(labelHeading);
    }

    @Override
    protected void addSummaryLink(LinkInfoImpl.Kind context, TypeElement typeElement, Element member, Content tdSummary) {
        HtmlTree memberLink = HtmlTree.SPAN(HtmlStyle.memberNameLink, this.writer.getLink(new LinkInfoImpl(this.configuration, context, (TypeElement)member)));
        HtmlTree code = HtmlTree.CODE(memberLink);
        tdSummary.addContent(code);
    }

    @Override
    protected void addInheritedSummaryLink(TypeElement typeElement, Element member, Content linksTree) {
        linksTree.addContent(this.writer.getLink(new LinkInfoImpl(this.configuration, LinkInfoImpl.Kind.MEMBER, (TypeElement)member)));
    }

    @Override
    protected void addSummaryType(Element member, Content tdSummaryType) {
        this.addModifierAndType(member, null, tdSummaryType);
    }

    @Override
    protected Content getDeprecatedLink(Element member) {
        return this.writer.getQualifiedClassLink(LinkInfoImpl.Kind.MEMBER, member);
    }

    @Override
    protected Content getNavSummaryLink(TypeElement typeElement, boolean link) {
        if (link) {
            if (typeElement == null) {
                return this.writer.getHyperLink(SectionName.NESTED_CLASS_SUMMARY, this.writer.getResource("doclet.navNested"));
            }
            return this.writer.getHyperLink(SectionName.NESTED_CLASSES_INHERITANCE, this.utils.getFullyQualifiedName(typeElement), this.writer.getResource("doclet.navNested"));
        }
        return this.writer.getResource("doclet.navNested");
    }

    @Override
    protected void addNavDetailLink(boolean link, Content liNav) {
    }
}

